/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.config.scheduler;

import com.penpower.worldcard.team.scheduler.job.CleanOutOBoundNoticesPerUserJob;
import com.penpower.worldcard.team.scheduler.job.DailyCheckRegisterJob;
import com.penpower.worldcard.team.scheduler.job.DailyCheckSubscriptionnJob;
import com.penpower.worldcard.team.scheduler.job.DailyStorageSpaceMonitor;
import com.penpower.worldcard.team.scheduler.job.DeadLockAccountInheritorJobChecker;
import com.penpower.worldcard.team.scheduler.job.DeleteContactsDeeplyJob;
import com.penpower.worldcard.team.scheduler.job.ExportContactsOfAccountsToCrmJob;
import com.penpower.worldcard.team.scheduler.job.LocalStorageSpaceMonitor;
import com.penpower.worldcard.team.scheduler.job.SimpleJob;
import com.penpower.worldcard.team.scheduler.job.SyncContactsOfAccountsWithSalesforceJob;
import com.penpower.worldcard.team.scheduler.job.SystemPerformanceMonitorJob;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.quartz.CronTriggerFactoryBean;
import org.springframework.scheduling.quartz.JobDetailFactoryBean;

@Configuration
@ComponentScan(value={"com.penpower.worldcard.team.scheduler.job"})
public class SchedulerConfig {
    private String DEFAULT_GROUP_NAME = "wct_scheculer_group";
    private long JOB_START_DELAY_MILLISECONDS = 1000L;

    @Bean(name={"exportAllContactsJobBean"})
    public JobDetailFactoryBean exportAllContactsJobDetailFactoryBean() {
        JobDetailFactoryBean factory = new JobDetailFactoryBean();
        factory.setJobClass(ExportContactsOfAccountsToCrmJob.class);
        factory.setDurability(true);
        factory.setName("exportAllContactsJob");
        factory.setGroup(this.DEFAULT_GROUP_NAME);
        return factory;
    }

    @Bean(name={"exportAllContactsJobTrigger"})
    public CronTriggerFactoryBean exportAllContactsJobTriggerFactoryBean() {
        CronTriggerFactoryBean stFactory = new CronTriggerFactoryBean();
        stFactory.setJobDetail(this.exportAllContactsJobDetailFactoryBean().getObject());
        stFactory.setStartDelay(this.JOB_START_DELAY_MILLISECONDS);
        stFactory.setCronExpression("0 0/10 * * * ?");
        return stFactory;
    }

    @Bean(name={"deleteContactsDeeplyJobBean"})
    public JobDetailFactoryBean deleteContactsDeeplyJobDetailFactoryBean() {
        JobDetailFactoryBean factory = new JobDetailFactoryBean();
        factory.setJobClass(DeleteContactsDeeplyJob.class);
        factory.setDurability(true);
        factory.setName("deleteContactsDeeplyJob");
        factory.setGroup(this.DEFAULT_GROUP_NAME);
        return factory;
    }

    @Bean(name={"deleteContactsDeeplyJobTrigger"})
    public CronTriggerFactoryBean deleteContactsDeeplyJobTriggerFactoryBean() {
        CronTriggerFactoryBean stFactory = new CronTriggerFactoryBean();
        stFactory.setJobDetail(this.deleteContactsDeeplyJobDetailFactoryBean().getObject());
        stFactory.setStartDelay(this.JOB_START_DELAY_MILLISECONDS);
        stFactory.setCronExpression("0 0 0 * * ?");
        return stFactory;
    }

    @Bean(name={"syncAllContactsWithCrmJobBean"})
    public JobDetailFactoryBean syncAllContactsWithCrmJobDetailFactoryBean() {
        JobDetailFactoryBean factory = new JobDetailFactoryBean();
        factory.setJobClass(SyncContactsOfAccountsWithSalesforceJob.class);
        factory.setDurability(true);
        factory.setName("syncAllContactsWithCrmJob");
        factory.setGroup(this.DEFAULT_GROUP_NAME);
        return factory;
    }

    @Bean(name={"syncAllContactsWithCrmJobTrigger"})
    public CronTriggerFactoryBean syncAllContactsWithCrmJobTriggerFactoryBean() {
        CronTriggerFactoryBean stFactory = new CronTriggerFactoryBean();
        stFactory.setJobDetail(this.syncAllContactsWithCrmJobDetailFactoryBean().getObject());
        stFactory.setStartDelay(this.JOB_START_DELAY_MILLISECONDS);
        stFactory.setCronExpression("0 0/10 * * * ?");
        return stFactory;
    }

    @Bean(name={"localStorageSpaceMonitorJob"})
    public JobDetailFactoryBean localStorageSpaceMonitorJobDetailFactoryBean() {
        JobDetailFactoryBean factory = new JobDetailFactoryBean();
        factory.setJobClass(LocalStorageSpaceMonitor.class);
        factory.setDurability(true);
        factory.setName("LocalStorageSpaceMonitor");
        factory.setGroup(this.DEFAULT_GROUP_NAME);
        return factory;
    }

    @Bean(name={"localStorageSpaceMonitorJobTrigger"})
    public CronTriggerFactoryBean localStorageSpaceMonitorCronTriggerFactoryBean() {
        CronTriggerFactoryBean stFactory = new CronTriggerFactoryBean();
        stFactory.setJobDetail(this.localStorageSpaceMonitorJobDetailFactoryBean().getObject());
        stFactory.setStartDelay(this.JOB_START_DELAY_MILLISECONDS);
        stFactory.setCronExpression("0 0/1 * * * ?");
        return stFactory;
    }

    @Bean(name={"dailyStorageSpaceMonitor"})
    public JobDetailFactoryBean dailyStorageSpaceMonitor() {
        JobDetailFactoryBean factory = new JobDetailFactoryBean();
        factory.setJobClass(DailyStorageSpaceMonitor.class);
        factory.setDurability(true);
        factory.setName("DailyStorageSpaceMonitor");
        factory.setGroup(this.DEFAULT_GROUP_NAME);
        return factory;
    }

    @Bean(name={"dailyStorageSpaceMonitorJobTrigger"})
    public CronTriggerFactoryBean dailyStorageSpaceMonitorJobTriggerFactoryBean() {
        CronTriggerFactoryBean stFactory = new CronTriggerFactoryBean();
        stFactory.setJobDetail(this.dailyStorageSpaceMonitor().getObject());
        stFactory.setStartDelay(this.JOB_START_DELAY_MILLISECONDS);
        stFactory.setCronExpression("0 0 0/8 * * ?");
        return stFactory;
    }

    @Bean(name={"deadLockAccountInheritorJobChecker"})
    public JobDetailFactoryBean deadLockAccountInheritorJobChecker() {
        JobDetailFactoryBean factory = new JobDetailFactoryBean();
        factory.setJobClass(DeadLockAccountInheritorJobChecker.class);
        factory.setDurability(true);
        factory.setName("deadLockAccountInheritorJobChecker");
        factory.setGroup(this.DEFAULT_GROUP_NAME);
        return factory;
    }

    @Bean(name={"deadLockAccountInheritorJobCheckerTrigger"})
    public CronTriggerFactoryBean deadLockAccountInheritorJobCheckerTriggerFactoryBean() {
        CronTriggerFactoryBean stFactory = new CronTriggerFactoryBean();
        stFactory.setJobDetail(this.deadLockAccountInheritorJobChecker().getObject());
        stFactory.setStartDelay(this.JOB_START_DELAY_MILLISECONDS);
        stFactory.setCronExpression("0 0 0/1 * * ?");
        return stFactory;
    }

    @Bean(name={"cleanOutOBoundNoticesPerUserJob"})
    public JobDetailFactoryBean cleanOutOBoundNoticesPerUserJob() {
        JobDetailFactoryBean factory = new JobDetailFactoryBean();
        factory.setJobClass(CleanOutOBoundNoticesPerUserJob.class);
        factory.setDurability(true);
        factory.setName("cleanOutOBoundNoticesPerUserJob");
        factory.setGroup(this.DEFAULT_GROUP_NAME);
        return factory;
    }

    @Bean(name={"cleanOutOBoundNoticesPerUserJobTrigger"})
    public CronTriggerFactoryBean cleanOutOBoundNoticesPerUserJobTriggerFactoryBean() {
        CronTriggerFactoryBean stFactory = new CronTriggerFactoryBean();
        stFactory.setJobDetail(this.cleanOutOBoundNoticesPerUserJob().getObject());
        stFactory.setStartDelay(this.JOB_START_DELAY_MILLISECONDS);
        stFactory.setCronExpression("0 0 0 * * ?");
        return stFactory;
    }

    @Bean(name={"simpleJobBean"})
    public JobDetailFactoryBean simpleJobDetailFactoryBean() {
        JobDetailFactoryBean factory = new JobDetailFactoryBean();
        factory.setJobClass(SimpleJob.class);
        factory.setDurability(true);
        factory.setName("simpleJob");
        factory.setGroup(this.DEFAULT_GROUP_NAME);
        return factory;
    }

    @Bean(name={"simpleJobTrigger"})
    public CronTriggerFactoryBean cronTriggerFactoryBean() {
        CronTriggerFactoryBean stFactory = new CronTriggerFactoryBean();
        stFactory.setJobDetail(this.simpleJobDetailFactoryBean().getObject());
        stFactory.setStartDelay(this.JOB_START_DELAY_MILLISECONDS);
        stFactory.setCronExpression("*/5 * * * * ?");
        return stFactory;
    }

    @Bean(name={"dailyCheckRegisterJob"})
    public JobDetailFactoryBean dailyCheckRegisterJob() {
        JobDetailFactoryBean factory = new JobDetailFactoryBean();
        factory.setJobClass(DailyCheckRegisterJob.class);
        factory.setDurability(true);
        factory.setName("DailyCheckRegisterJob");
        factory.setGroup(this.DEFAULT_GROUP_NAME);
        return factory;
    }

    @Bean(name={"dailyCheckRegisterJobTrigger"})
    public CronTriggerFactoryBean dailyCheckRegisterJobTriggerFactoryBean() {
        CronTriggerFactoryBean stFactory = new CronTriggerFactoryBean();
        stFactory.setJobDetail(this.dailyCheckRegisterJob().getObject());
        stFactory.setStartDelay(this.JOB_START_DELAY_MILLISECONDS);
        stFactory.setCronExpression("0 0 7,11,15,19 * * ?");
        return stFactory;
    }

    @Bean(name={"dailyCheckSubscriptionnJob"})
    public JobDetailFactoryBean dailyCheckSubscriptionnJob() {
        JobDetailFactoryBean factory = new JobDetailFactoryBean();
        factory.setJobClass(DailyCheckSubscriptionnJob.class);
        factory.setDurability(true);
        factory.setName("DailyCheckSubscriptionnJob");
        factory.setGroup(this.DEFAULT_GROUP_NAME);
        return factory;
    }

    @Bean(name={"dailyCheckSubscriptionnJobTrigger"})
    public CronTriggerFactoryBean dailyCheckSubscriptionnJobTriggerFactoryBean() {
        CronTriggerFactoryBean stFactory = new CronTriggerFactoryBean();
        stFactory.setJobDetail(this.dailyCheckSubscriptionnJob().getObject());
        stFactory.setStartDelay(this.JOB_START_DELAY_MILLISECONDS);
        stFactory.setCronExpression("0 0 2,7,8,11,16,19,23 * * ?");
        return stFactory;
    }

    @Bean(name={"systemPerformanceMonitorJob"})
    public JobDetailFactoryBean systemPerformanceMonitorJob() {
        JobDetailFactoryBean factory = new JobDetailFactoryBean();
        factory.setJobClass(SystemPerformanceMonitorJob.class);
        factory.setDurability(true);
        factory.setName("DailyCheckSystemPerformanceJob");
        factory.setGroup(this.DEFAULT_GROUP_NAME);
        return factory;
    }

    @Bean(name={"systemPerformanceMonitorJobTrigger"})
    public CronTriggerFactoryBean systemPerformanceMonitorJobTriggerFactoryBean() {
        CronTriggerFactoryBean stFactory = new CronTriggerFactoryBean();
        stFactory.setJobDetail(this.systemPerformanceMonitorJob().getObject());
        stFactory.setStartDelay(this.JOB_START_DELAY_MILLISECONDS);
        stFactory.setCronExpression("0 0/1 * * * ?");
        return stFactory;
    }
}

