/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.config.property;

import com.penpower.worldcard.team.config.property.PropertiesLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationProperties {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationProperties.class);
    private final Map<String, String> localPropertiesMap;
    private final List<PropertiesLoader> propertiesLoaders = new ArrayList();

    public ApplicationProperties(PropertiesLoader ... propertiesLoader) {
        for (PropertiesLoader loader : propertiesLoader) {
            this.propertiesLoaders.add(loader);
        }
        this.localPropertiesMap = new ConcurrentHashMap();
        this.loadProperties();
    }

    private final void loadProperties() {
        this.localPropertiesMap.clear();
        for (PropertiesLoader loader : this.propertiesLoaders) {
            this.localPropertiesMap.putAll(loader.loadPorperties());
        }
    }

    public void refresh() {
        this.loadProperties();
    }

    public String getProperty(String key) {
        return (String)this.localPropertiesMap.get(key);
    }

    public boolean getBooleanProperty(String key) {
        String value = (String)this.localPropertiesMap.get(key);
        return Boolean.parseBoolean(value);
    }

    public void updateProperty(String key, String value) {
        this.localPropertiesMap.put(key, value);
    }

    public void printAllProperties() {
        this.localPropertiesMap.entrySet().stream().forEach(set -> LOG.debug("Print properties ----  [Key : {} , value : {}]", set.getKey(), set.getValue()));
    }
}

