/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.config.jpa;

import com.penpower.worldcard.team.config.jpa.DatabaseConfigurator;
import com.penpower.worldcard.team.config.jpa.JpaConfig;
import com.zaxxer.hikari.HikariConfig;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.postgresql.Driver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class UnitTestSqlConfigurator
implements DatabaseConfigurator {
    private static final Logger LOG = LoggerFactory.getLogger(JpaConfig.class);
    private static final String POSTGRESQL_JDBC_CONNECTION_URL_PREFIX_VAL = "jdbc:postgresql://";
    private static final String POSTGRESQL_DEFAULT_CONNECTION_URL_PARAMS = "?autoReconnect=true&useSSL=false";
    private String jdbcUrl = null;
    private String rootUrl = null;
    private String databaseName = null;
    private String username = null;
    private String password = null;
    private String driver = null;
    private String serverIpAddress = null;
    private String serverPort = null;

    public UnitTestSqlConfigurator(boolean developmentEnv, boolean softwareVersion, Environment env) {
        String rootUrlFormat = "%s%s:%s/";
        String jdbcUrlFormat = "%s%s%s";
        this.serverIpAddress = env.getProperty("dataSource.dev.test.postgresql.ip");
        this.serverPort = env.getProperty("dataSource.dev.test.postgresql.port");
        this.databaseName = env.getProperty("dataSource.dev.test.postgresql.databaseName");
        this.username = env.getProperty("dataSource.dev.test.postgresql.username");
        this.password = env.getProperty("dataSource.dev.test.postgresql.password");
        this.rootUrl = String.format(rootUrlFormat, POSTGRESQL_JDBC_CONNECTION_URL_PREFIX_VAL, this.serverIpAddress, this.serverPort);
        this.jdbcUrl = String.format(jdbcUrlFormat, this.rootUrl, this.databaseName, POSTGRESQL_DEFAULT_CONNECTION_URL_PARAMS);
        this.driver = Driver.class.getName().toString();
    }

    public void createDatabase() {
        block36: {
            try {
                Class.forName(this.driver);
                try (Connection connection = DriverManager.getConnection(this.rootUrl, this.username, this.password);){
                    try (Statement statement = connection.createStatement();){
                        try {
                            String dropDb = "DROP DATABASE IF EXISTS worldcardteam;";
                            statement.executeUpdate(dropDb);
                        }
                        catch (Exception ex) {
                            LOG.error("fail top drop database.....", (Throwable)ex);
                        }
                        LOG.debug("try to change template database encoding to UTF-8");
                        try {
                            String pg01 = "UPDATE pg_database SET datistemplate = FALSE WHERE datname = 'template1';";
                            statement.executeUpdate(pg01);
                            String pg02 = "DROP DATABASE template1;";
                            statement.executeUpdate(pg02);
                        }
                        catch (Exception pg01) {
                            // empty catch block
                        }
                        try {
                            String pg03 = "CREATE DATABASE template1 WITH owner=postgres template=template0 encoding='UTF8' LC_COLLATE = 'C' LC_CTYPE = 'C';";
                            statement.executeUpdate(pg03);
                        }
                        catch (Exception pg03) {
                            // empty catch block
                        }
                        String pg04 = "UPDATE pg_database SET datistemplate=TRUE WHERE datname='template1';";
                        statement.executeUpdate(pg04);
                        LOG.debug("Create a new worldcardteam database with template1 and UTF-8 encoding");
                        String postgreSql = String.format("CREATE DATABASE %s WITH TEMPLATE template1 OWNER = postgres ENCODING = 'UTF8' LC_COLLATE = 'C' LC_CTYPE = 'C';", this.databaseName);
                        statement.executeUpdate(postgreSql);
                    }
                    LOG.debug("database[{}] created successfully.", (Object)this.databaseName);
                }
                catch (SQLException sqlException) {
                    if (sqlException.getErrorCode() == 1007) {
                        LOG.debug("Database {} created failed.", (Object)this.databaseName);
                        break block36;
                    }
                    LOG.error("failed to create datatbase", (Throwable)sqlException);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public HikariConfig createHikariConfig() {
        HikariConfig config = new HikariConfig();
        config.setDriverClassName(this.driver);
        config.setJdbcUrl(this.jdbcUrl);
        config.setUsername(this.username);
        config.setPassword(this.password);
        return config;
    }

    public String toString() {
        return "PostgreSqlConfigurator [jdbcUrl=" + this.jdbcUrl + ", rootUrl=" + this.rootUrl + ", databaseName=" + this.databaseName + ", username=" + this.username + ", password=" + this.password + ", driver=" + this.driver + ", serverIpAddress=" + this.serverIpAddress + ", serverPort=" + this.serverPort + "]";
    }
}

