/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.config.jpa;

import com.google.gson.Gson;
import com.penpower.worldcard.team.auth.TokenInfo;
import com.penpower.worldcard.team.auth.TokenManager;
import com.penpower.worldcard.team.config.jpa.UnitTestJpaConfig;
import com.penpower.worldcard.team.config.jpa.UnitTestSqlConfigurator;
import com.penpower.worldcard.team.dto.WctInfo;
import com.penpower.worldcard.team.enums.DatabaseType;
import com.penpower.worldcard.team.enums.Platform;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import javax.persistence.EntityManagerFactory;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.flywaydb.core.Flyway;
import org.hibernate.FlushMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.Environment;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@Profile(value={"Test"})
@EnableTransactionManagement
@EnableJpaRepositories(basePackages={"com.penpower.worldcard.team.dao"})
public class UnitTestJpaConfig {
    private static final Logger LOG = LoggerFactory.getLogger(UnitTestJpaConfig.class);
    private static final String DEFAULT_PERSISTENCE_UNITNAME = "WorldCardTeamJpaContext";
    private static final String DEFAULT_ENTITY_SCAN_PACKAGE = "com.penpower.worldcard.team.entity";
    public static final AtomicReference<String> CLOUD_VERSION_DB_NAME = new AtomicReference<String>("");
    @Autowired
    private ServletContext context;
    @Autowired
    private Environment env;
    @Autowired
    private TokenManager tokenManager;

    @Bean(name={"databaseName"})
    public String databaseName() {
        String cloudDatabaseName = this.getCloudDbName();
        CLOUD_VERSION_DB_NAME.set(cloudDatabaseName);
        LOG.info("get databaseName from wct_info.json:{}", (Object)cloudDatabaseName);
        return cloudDatabaseName;
    }

    @Bean(name={"searchEngineIndex"})
    @DependsOn(value={"databaseName"})
    public String searchEngineIndex() {
        if (((String)CLOUD_VERSION_DB_NAME.get()).equals("worldcardteam")) {
            return "contact";
        }
        return (String)CLOUD_VERSION_DB_NAME.get();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getCloudDbName() {
        Path wctServerInfoPath = Paths.get(this.context.getRealPath(""), new String[0]).getParent();
        Gson gson = new Gson();
        if (!Files.exists(wctServerInfoPath, new LinkOption[0])) return "worldcardteam";
        Path wctInfoFile = wctServerInfoPath.resolve("wct_info.json");
        try (FileReader fr = new FileReader(wctInfoFile.toFile());){
            WctInfo wctInfo = (WctInfo)gson.fromJson((Reader)fr, WctInfo.class);
            String string = wctInfo.getDatabaseName();
            return string;
        }
        catch (IOException ex) {
            return "worldcardteam";
        }
    }

    @Bean
    public DataSource dataSource() {
        TokenInfo tokenInfo = new TokenInfo("c96f7c19-929b-4971-8e57-168c4cb9efc8", "c96f7c19-929b-4971-8e57-168c4cb9efc8", Platform.WEB);
        this.tokenManager.putToken(tokenInfo);
        LOG.info("hardcode token : {}", (Object)tokenInfo);
        Object authenticationWithToken = null;
        UnitTestSqlConfigurator configurator = new UnitTestSqlConfigurator(false, false, this.env);
        configurator.createDatabase();
        HikariConfig config = configurator.createHikariConfig();
        String connectionTestQuery = this.env.getProperty("dataSource.connectionTestQuery");
        String connectionTimeout = this.env.getProperty("dataSource.connectionTimeout");
        String idleTimeout = this.env.getProperty("dataSource.idleTimeout");
        String maxLifetime = this.env.getProperty("dataSource.maxLifetime");
        String maximumPoolSize = this.env.getProperty("dataSource.maximumPoolSize");
        String minimumIdle = this.env.getProperty("dataSource.minimumIdle");
        config.setAutoCommit(false);
        config.setConnectionTestQuery(connectionTestQuery);
        config.setConnectionTimeout(Long.parseLong(connectionTimeout));
        config.setIdleTimeout(Long.parseLong(idleTimeout));
        config.setMaxLifetime(Long.parseLong(maxLifetime));
        config.setMaximumPoolSize(Integer.parseInt(maximumPoolSize));
        config.setMinimumIdle(Integer.parseInt(minimumIdle));
        config.addDataSourceProperty("cachePrepStmts", (Object)"true");
        config.addDataSourceProperty("useServerPrepStmts", (Object)"true");
        config.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
        config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
        config.addDataSourceProperty("useUnicode", (Object)"true");
        config.addDataSourceProperty("characterEncoding", (Object)"utf8");
        return new HikariDataSource(config);
    }

    private DatabaseType getDatabaseType() {
        DatabaseType type = DatabaseType.POSTGRESQL;
        return type;
    }

    @Bean(initMethod="migrate")
    Flyway flyway() {
        LOG.debug("flyway migration start.......");
        DatabaseType type = this.getDatabaseType();
        LOG.info("type : {} ", (Object)type);
        Flyway flyway = new Flyway();
        if (DatabaseType.MYSQL.equals((Object)type)) {
            flyway.setLocations(new String[]{"classpath:db/migrations/mysql"});
        } else if (DatabaseType.MSSQL.equals((Object)type)) {
            flyway.setLocations(new String[]{"classpath:db/migrations/sqlserver"});
        } else {
            flyway.setLocations(new String[]{"classpath:db/migrations/test/postgresql"});
        }
        flyway.setDataSource(this.dataSource());
        return flyway;
    }

    @Bean
    @DependsOn(value={"flyway"})
    public EntityManagerFactory entityManagerFactory() {
        String dialect = this.getHibernateDialect();
        LOG.info("hibernate dialect : {}", (Object)dialect);
        String hbm2ddlAuto = this.env.getProperty("hibernate.hbm2ddl.auto");
        String showSql = this.env.getProperty("hibernate.show_sql");
        String formatSql = this.env.getProperty("hibernate.format_sql");
        LocalContainerEntityManagerFactoryBean entityManagerFactoryBean = new LocalContainerEntityManagerFactoryBean();
        entityManagerFactoryBean.setDataSource(this.dataSource());
        entityManagerFactoryBean.setPersistenceUnitName(DEFAULT_PERSISTENCE_UNITNAME);
        entityManagerFactoryBean.setPackagesToScan(new String[]{DEFAULT_ENTITY_SCAN_PACKAGE});
        entityManagerFactoryBean.setJpaVendorAdapter((JpaVendorAdapter)new HibernateJpaVendorAdapter());
        Properties jpaProperties = new Properties();
        jpaProperties.put("hibernate.dialect", dialect);
        jpaProperties.put("hibernate.hbm2ddl.auto", hbm2ddlAuto);
        jpaProperties.put("hibernate.show_sql", showSql);
        jpaProperties.put("hibernate.format_sql", formatSql);
        jpaProperties.put("hibernate.query.plan_cache_max_size", "128");
        jpaProperties.put("hibernate.query.plan_parameter_metadata_max_size", "16");
        jpaProperties.put("hibernate.flushMode", FlushMode.ALWAYS);
        jpaProperties.put("org.hibernate.flushMode", FlushMode.ALWAYS);
        jpaProperties.put("jadira.usertype.autoRegisterUserTypes", "true");
        entityManagerFactoryBean.setJpaProperties(jpaProperties);
        entityManagerFactoryBean.afterPropertiesSet();
        return entityManagerFactoryBean.getObject();
    }

    private String getHibernateDialect() {
        DatabaseType type = this.getDatabaseType();
        LOG.info("db type : {} ", (Object)type);
        switch (1.$SwitchMap$com$penpower$worldcard$team$enums$DatabaseType[type.ordinal()]) {
            case 1: {
                String version = "2005";
                if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{version})) {
                    return "org.hibernate.dialect.SQLServer2012Dialect";
                }
                switch (version) {
                    case "2005": {
                        return "org.hibernate.dialect.SQLServer2005Dialect";
                    }
                    case "2008": {
                        return "org.hibernate.dialect.SQLServer2008Dialect";
                    }
                }
                return "org.hibernate.dialect.SQLServer2012Dialect";
            }
            case 2: {
                return "org.hibernate.dialect.MySQLDialect";
            }
        }
        return "org.hibernate.dialect.PostgreSQL82Dialect";
    }

    @Bean
    public PlatformTransactionManager transactionManager() {
        JpaTransactionManager txManager = new JpaTransactionManager();
        txManager.setEntityManagerFactory(this.entityManagerFactory());
        return txManager;
    }
}

