/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.config.jpa;

import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import com.penpower.worldcard.team.config.jpa.DatabaseConfigurator;
import com.penpower.worldcard.team.config.jpa.JpaConfig;
import com.zaxxer.hikari.HikariConfig;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class SqlServerConfigurator
implements DatabaseConfigurator {
    private static final Logger LOG = LoggerFactory.getLogger(JpaConfig.class);
    public static final String SQLSERVER_JDBC_CONNECTION_URL_PREFIX_VAL = "jdbc:sqlserver://";
    private static final String ROOT_URL_FORMAT = "%s%s";
    private static final String ROOT_URL_SERVENAME_WITH_INSTANCENAME_FORMAT = "%s\\%s";
    private static final String ROOT_URL_SERVENAME_WITH_EMPTY_INSTANCENAME_FORMAT = "%s";
    private static final String ROOT_URL_SERVENAME_WITH_IP_AND_PORT_FORMAT = "%s:%s";
    private static final String JDBC_URL_FORMAT = "%s;databaseName=%s;%s";
    private static final String SQLSERVER_DEFAULT_CONNECTION_URL_PARAMS = "";
    private String jdbcUrl = null;
    private String rootUrl = null;
    private String databaseName = null;
    private String username = null;
    private String password = null;
    private String driver = null;
    private String serverIpAddress = null;
    private String serverPort = null;
    private String serverInstanceName = null;
    private String version = null;
    private boolean instanceNameUsed = false;

    public SqlServerConfigurator(boolean developmentEnv, boolean softwareVersion, Environment env) {
        String instanceNameValue;
        if (softwareVersion) {
            this.serverIpAddress = env.getProperty("dataSource.software.ip");
            this.serverPort = env.getProperty("dataSource.software.port");
            this.databaseName = env.getProperty("dataSource.software.databaseName");
            this.username = env.getProperty("dataSource.software.username");
            this.password = env.getProperty("dataSource.software.password");
            this.version = env.getProperty("dataSource.software.sqlserver.version");
            this.serverInstanceName = env.getProperty("dataSource.software.instanceName");
            instanceNameValue = env.getProperty("dataSource.software.instanceName.enable");
            this.instanceNameUsed = Boolean.valueOf(instanceNameValue);
        } else {
            this.serverIpAddress = env.getProperty("dataSource.dev.sqlserver.ip");
            this.serverPort = env.getProperty("dataSource.dev.sqlserver.port");
            this.databaseName = env.getProperty("dataSource.dev.sqlserver.databaseName");
            this.username = env.getProperty("dataSource.dev.sqlserver.username");
            this.password = env.getProperty("dataSource.dev.sqlserver.password");
            this.version = env.getProperty("dataSource.dev.sqlserver.version");
            this.serverInstanceName = env.getProperty("dataSource.dev.instanceName");
            instanceNameValue = env.getProperty("dataSource.dev.instanceName.enable");
            this.instanceNameUsed = Boolean.valueOf(instanceNameValue);
        }
        if (this.instanceNameUsed) {
            String serverNameWithInstanceName;
            if (StringUtils.isNotBlank((CharSequence)this.serverInstanceName)) {
                serverNameWithInstanceName = String.format(ROOT_URL_SERVENAME_WITH_INSTANCENAME_FORMAT, this.serverIpAddress, this.serverInstanceName);
                this.rootUrl = String.format(ROOT_URL_FORMAT, SQLSERVER_JDBC_CONNECTION_URL_PREFIX_VAL, serverNameWithInstanceName);
                this.jdbcUrl = String.format(JDBC_URL_FORMAT, this.rootUrl, this.databaseName, SQLSERVER_DEFAULT_CONNECTION_URL_PARAMS);
            } else {
                serverNameWithInstanceName = String.format(ROOT_URL_SERVENAME_WITH_EMPTY_INSTANCENAME_FORMAT, this.serverIpAddress);
                this.rootUrl = String.format(ROOT_URL_FORMAT, SQLSERVER_JDBC_CONNECTION_URL_PREFIX_VAL, serverNameWithInstanceName);
                this.jdbcUrl = String.format(JDBC_URL_FORMAT, this.rootUrl, this.databaseName, SQLSERVER_DEFAULT_CONNECTION_URL_PARAMS);
            }
        } else {
            String serverNameWithIpAndPort = String.format(ROOT_URL_SERVENAME_WITH_IP_AND_PORT_FORMAT, this.serverIpAddress, this.serverPort);
            this.rootUrl = String.format(ROOT_URL_FORMAT, SQLSERVER_JDBC_CONNECTION_URL_PREFIX_VAL, serverNameWithIpAndPort);
            this.jdbcUrl = String.format(JDBC_URL_FORMAT, this.rootUrl, this.databaseName, SQLSERVER_DEFAULT_CONNECTION_URL_PARAMS);
        }
        this.jdbcUrl = this.jdbcUrl + "SelectMethod=cursor";
        this.rootUrl = this.rootUrl + ";SelectMethod=cursor";
        LOG.info("rootUrl : {} ", (Object)this.rootUrl);
        LOG.info("jdbcUrl : {} ", (Object)this.jdbcUrl);
        this.driver = SQLServerDriver.class.getName().toString();
    }

    public void createDatabase() {
        block32: {
            try {
                Class.forName(this.driver);
                try (Connection connection = DriverManager.getConnection(this.rootUrl, this.username, this.password);){
                    try (Statement statement = connection.createStatement();){
                        try {
                            String createDatabaseSql = String.format("CREATE database %s;", this.databaseName);
                            statement.executeUpdate(createDatabaseSql);
                            String alertDatabaseSnapshotSql = "ALTER DATABASE worldcardteam SET READ_COMMITTED_SNAPSHOT ON WITH ROLLBACK IMMEDIATE; ";
                            statement.executeUpdate(alertDatabaseSnapshotSql);
                            String alertDatabaseAllSnapshotSql = "ALTER DATABASE worldcardteam SET ALLOW_SNAPSHOT_ISOLATION ON;";
                            statement.executeUpdate(alertDatabaseAllSnapshotSql);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    LOG.debug("database[{}] created successfully.", (Object)this.databaseName);
                }
                catch (SQLException sqlException) {
                    if (sqlException.getErrorCode() == 1007) {
                        LOG.debug("Database {} created failed.", (Object)this.databaseName);
                        break block32;
                    }
                    LOG.error("failed to create datatbase", (Throwable)sqlException);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public HikariConfig createHikariConfig() {
        HikariConfig config = new HikariConfig();
        config.setDriverClassName(this.driver);
        config.setJdbcUrl(this.jdbcUrl);
        config.setUsername(this.username);
        config.setPassword(this.password);
        return config;
    }
}

