/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.config.jpa;

import com.penpower.worldcard.team.config.jpa.DatabaseConfigurator;
import com.penpower.worldcard.team.config.jpa.JpaConfig;
import com.penpower.worldcard.team.enums.ServerType;
import com.zaxxer.hikari.HikariConfig;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.lang3.StringUtils;
import org.postgresql.Driver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class PostgreSqlConfigurator
implements DatabaseConfigurator {
    private static final Logger LOG = LoggerFactory.getLogger(JpaConfig.class);
    public static final String POSTGRESQL_JDBC_CONNECTION_URL_PREFIX_VAL = "jdbc:postgresql://";
    public static final String POSTGRESQL_DEFAULT_CONNECTION_URL_PARAMS = "?autoReconnect=true&useSSL=false";
    public static final String SERVER_TYPE_LINUX_SERVER_CLOUD_SERVER_IP_ADDRESS = "10.10.15.99";
    private String jdbcUrl = null;
    private String postgresUrl = null;
    private String rootUrl = null;
    private String databaseName = null;
    private String username = null;
    private String password = null;
    private String driver = null;
    private String serverIpAddress = null;
    private String serverPort = null;

    public PostgreSqlConfigurator(boolean developmentEnv, boolean softwareVersion, Environment env) {
        String postgresUrlFormat = "%s%s:%s/%s";
        String rootUrlFormat = "%s%s:%s/";
        String jdbcUrlFormat = "%s%s%s";
        ServerType serverType = ServerType.ASUSTOR_NAS;
        try {
            String svrType = env.getProperty("Servertype");
            if (StringUtils.isNotEmpty((CharSequence)svrType)) {
                serverType = ServerType.valueOf((String)svrType);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (softwareVersion) {
            this.serverIpAddress = env.getProperty("dataSource.software.ip");
            this.serverPort = env.getProperty("dataSource.software.port");
            this.databaseName = env.getProperty("dataSource.software.databaseName");
            this.username = env.getProperty("dataSource.software.username");
            this.password = env.getProperty("dataSource.software.password");
        } else if (developmentEnv) {
            this.serverIpAddress = env.getProperty("dataSource.dev.postgresql.ip");
            this.serverPort = env.getProperty("dataSource.dev.postgresql.port");
            this.databaseName = env.getProperty("dataSource.dev.postgresql.databaseName");
            this.username = env.getProperty("dataSource.dev.postgresql.username");
            this.password = env.getProperty("dataSource.dev.postgresql.password");
        } else if (serverType == ServerType.ASUSTOR_NAS) {
            this.serverIpAddress = env.getProperty("dataSource.nas.ip");
            this.serverPort = env.getProperty("dataSource.nas.port");
            this.databaseName = env.getProperty("dataSource.nas.databaseName");
            this.username = env.getProperty("dataSource.nas.username");
            this.password = env.getProperty("dataSource.nas.password");
        } else {
            this.serverIpAddress = env.getProperty("dataSource.synology_nas.ip");
            this.serverPort = env.getProperty("dataSource.synology_nas.port");
            this.databaseName = env.getProperty("dataSource.synology_nas.databaseName");
            this.username = env.getProperty("dataSource.synology_nas.username");
            this.password = env.getProperty("dataSource.synology_nas.password");
        }
        if (JpaConfig.CLOUD_VERSION_DB_NAME.get() != "") {
            this.databaseName = (String)JpaConfig.CLOUD_VERSION_DB_NAME.get();
            if (serverType.equals((Object)ServerType.Linux_Server_Cloud)) {
                this.serverIpAddress = SERVER_TYPE_LINUX_SERVER_CLOUD_SERVER_IP_ADDRESS;
            }
        }
        this.rootUrl = String.format(rootUrlFormat, POSTGRESQL_JDBC_CONNECTION_URL_PREFIX_VAL, this.serverIpAddress, this.serverPort);
        this.jdbcUrl = String.format(jdbcUrlFormat, this.rootUrl, this.databaseName, POSTGRESQL_DEFAULT_CONNECTION_URL_PARAMS);
        this.postgresUrl = String.format(postgresUrlFormat, POSTGRESQL_JDBC_CONNECTION_URL_PREFIX_VAL, this.serverIpAddress, this.serverPort, this.databaseName);
        this.driver = Driver.class.getName().toString();
    }

    public void createDatabase() {
        block37: {
            try {
                Class.forName(this.driver);
                LOG.info("createDatabase rootUrl={} username ={} ", (Object)this.postgresUrl, (Object)this.username);
                try (Connection connection = DriverManager.getConnection(this.postgresUrl, this.username, this.password);){
                    block36: {
                        try (Statement statement = connection.createStatement();){
                            LOG.debug("try to change template database encoding to UTF-8");
                            Boolean bDataBaseExist = false;
                            try {
                                String checkDBExist = "SELECT 1 FROM pg_database WHERE datname= '" + this.databaseName + "';";
                                ResultSet resultSet = statement.executeQuery(checkDBExist);
                                while (resultSet.next()) {
                                    bDataBaseExist = true;
                                    LOG.info("DatabaseExist");
                                }
                            }
                            catch (Exception checkDBExist) {
                                // empty catch block
                            }
                            if (bDataBaseExist.booleanValue()) break block36;
                            LOG.info("DatabaseExist not exist");
                            try {
                                String pg01 = "UPDATE pg_database SET datistemplate = FALSE WHERE datname = 'template1';";
                                statement.executeUpdate(pg01);
                                String pg02 = "DROP DATABASE template1;";
                                statement.executeUpdate(pg02);
                            }
                            catch (Exception pg01) {
                                // empty catch block
                            }
                            try {
                                String pg03 = "CREATE DATABASE template1 WITH owner=postgres template=template0 encoding='UTF8' LC_COLLATE = 'C' LC_CTYPE = 'C';";
                                statement.executeUpdate(pg03);
                            }
                            catch (Exception pg03) {
                                // empty catch block
                            }
                            String pg04 = "UPDATE pg_database SET datistemplate=TRUE WHERE datname='template1';";
                            statement.executeUpdate(pg04);
                            LOG.debug("Create a new worldcardteam database with template1 and UTF-8 encoding");
                            String postgreSql = String.format("CREATE DATABASE %s WITH TEMPLATE template1 OWNER = postgres ENCODING = 'UTF8' LC_COLLATE = 'C' LC_CTYPE = 'C';", this.databaseName);
                            statement.executeUpdate(postgreSql);
                        }
                    }
                    LOG.debug("database[{}] created successfully.", (Object)this.databaseName);
                }
                catch (SQLException sqlException) {
                    if (sqlException.getErrorCode() == 1007) {
                        LOG.debug("Database {} created failed.", (Object)this.databaseName);
                        break block37;
                    }
                    LOG.error("failed to create datatbase", (Throwable)sqlException);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public HikariConfig createHikariConfig() {
        HikariConfig config = new HikariConfig();
        config.setDriverClassName(this.driver);
        config.setJdbcUrl(this.jdbcUrl);
        config.setUsername(this.username);
        config.setPassword(this.password);
        return config;
    }

    public String toString() {
        return "PostgreSqlConfigurator [jdbcUrl=" + this.jdbcUrl + ", rootUrl=" + this.rootUrl + ", databaseName=" + this.databaseName + ", username=" + this.username + ", password=" + this.password + ", driver=" + this.driver + ", serverIpAddress=" + this.serverIpAddress + ", serverPort=" + this.serverPort + "]";
    }
}

