/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.config.jpa;

import com.mysql.jdbc.Driver;
import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.config.jpa.DatabaseConfigurator;
import com.penpower.worldcard.team.config.jpa.JpaConfig;
import com.penpower.worldcard.team.enums.ServerType;
import com.zaxxer.hikari.HikariConfig;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;

public class MySqlConfigurator
implements DatabaseConfigurator {
    private static final Logger LOG = LoggerFactory.getLogger(JpaConfig.class);
    private static final String MYSQL_JDBC_CONNECTION_URL_PREFIX_VAL = "jdbc:mysql://";
    private static final String MYSQL_DEFAULT_CONNECTION_URL_PARAMS = "?autoReconnect=true&useSSL=false";
    private String jdbcUrl = null;
    private String rootUrl = null;
    private String databaseName = null;
    private String username = null;
    private String password = null;
    private String driver = null;
    private String serverIpAddress = null;
    private String serverPort = null;
    @Value(value="${Servertype}")
    private String serverType;

    public ServerType GetServerType() {
        LOG.debug("JpaConfig ServerType={}", (Object)this.serverType);
        ServerType svrType = ServerType.valueOf((String)this.serverType);
        LOG.debug("JpaConfig ServerTypeA={}", (Object)svrType);
        GlobalUtils.setServerType((ServerType)svrType);
        return svrType;
    }

    public MySqlConfigurator(boolean developmentEnv, boolean softwareVersion, Environment env) {
        String rootUrlFormat = "%s%s:%s/";
        String jdbcUrlFormat = "%s%s%s";
        if (softwareVersion) {
            this.serverIpAddress = env.getProperty("dataSource.software.ip");
            this.serverPort = env.getProperty("dataSource.software.port");
            this.databaseName = env.getProperty("dataSource.software.databaseName");
            this.username = env.getProperty("dataSource.software.username");
            this.password = env.getProperty("dataSource.software.password");
        } else if (developmentEnv) {
            this.serverIpAddress = env.getProperty("dataSource.dev.postgresql.ip");
            this.serverPort = env.getProperty("dataSource.dev.postgresql.port");
            this.databaseName = env.getProperty("dataSource.dev.postgresql.databaseName");
            this.username = env.getProperty("dataSource.dev.postgresql.username");
            this.password = env.getProperty("dataSource.dev.postgresql.password");
        } else if (this.GetServerType() == ServerType.ASUSTOR_NAS) {
            this.serverIpAddress = env.getProperty("dataSource.nas.ip");
            this.serverPort = env.getProperty("dataSource.nas.port");
            this.databaseName = env.getProperty("dataSource.nas.databaseName");
            this.username = env.getProperty("dataSource.nas.username");
            this.password = env.getProperty("dataSource.nas.password");
        } else {
            this.serverIpAddress = env.getProperty("dataSource.synology_nas.ip");
            this.serverPort = env.getProperty("dataSource.synology_nas.port");
            this.databaseName = env.getProperty("dataSource.synology_nas.databaseName");
            this.username = env.getProperty("dataSource.synology_nas.username");
            this.password = env.getProperty("dataSource.synology_nas.password");
        }
        this.rootUrl = String.format(rootUrlFormat, MYSQL_JDBC_CONNECTION_URL_PREFIX_VAL, this.serverIpAddress, this.serverPort);
        this.jdbcUrl = String.format(jdbcUrlFormat, this.rootUrl, this.databaseName, MYSQL_DEFAULT_CONNECTION_URL_PARAMS);
        this.driver = Driver.class.getName().toString();
    }

    public void createDatabase() {
        block32: {
            try {
                Class.forName(this.driver);
                try (Connection connection = DriverManager.getConnection(this.rootUrl, this.username, this.password);){
                    try (Statement statement = connection.createStatement();){
                        try {
                            String updateSql = String.format("CREATE SCHEMA IF NOT EXISTS %s DEFAULT CHARACTER SET utf8 ;", this.databaseName);
                            statement.executeUpdate(updateSql);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    LOG.debug("database[{}] created successfully.", (Object)this.databaseName);
                }
                catch (SQLException sqlException) {
                    if (sqlException.getErrorCode() == 1007) {
                        LOG.debug("Database {} created failed.", (Object)this.databaseName);
                        break block32;
                    }
                    LOG.error("failed to create datatbase", (Throwable)sqlException);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public HikariConfig createHikariConfig() {
        HikariConfig config = new HikariConfig();
        config.setDriverClassName(this.driver);
        config.setJdbcUrl(this.jdbcUrl);
        config.setUsername(this.username);
        config.setPassword(this.password);
        return config;
    }
}

