/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.config.jpa;

import com.penpower.worldcard.team.Utils.DatabaseCreationTime;
import com.penpower.worldcard.team.Utils.DatabaseCreationTimeUtil;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.FlywayException;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlywayDecorator
extends Flyway {
    private static final Logger LOG = LoggerFactory.getLogger(FlywayDecorator.class);
    private DatabaseCreationTimeUtil databaseCreationTimeUtil;

    public FlywayDecorator(DatabaseCreationTimeUtil databaseCreationTimeUtil) {
        this.databaseCreationTimeUtil = databaseCreationTimeUtil;
    }

    public int migrate() throws FlywayException {
        int value = super.migrate();
        LOG.debug("migrate value : {}", (Object)value);
        if (!this.databaseCreationTimeUtil.IsSettingFileExist()) {
            DatabaseCreationTime databaseCreationTime = new DatabaseCreationTime();
            databaseCreationTime.setCreationTime(DateTime.now());
            LOG.debug("databaseCreationTime : {} ", (Object)databaseCreationTime);
            this.databaseCreationTimeUtil.writeCreationTime(databaseCreationTime);
        }
        return value;
    }
}

