/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.config.elasticsearch;

import com.penpower.worldcard.team.Utils.CollectionUtil;
import java.io.IOException;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;

public class ElasticSearchProperties {
    private static final int MAX_RESULT_WINDOW = 10000000;
    private static final String CUSTOM_TOKENIZER = "my_tokenizer";
    private static final String CUSTOM_AUTOCOMPLETE_TOKENIZER = "my_autocomplete_tokenizer";
    private static final String CUSTOM_ANALYZER = "my_analyzer";
    private static final String CUSTOM_AUTOCOMPLETE_ANALYZER = "my_autocomplete_analyzer";
    private static final String KEYWORD_LOWERCASE_NORMALIZER = "keyword_lowercase_normalizer";
    private static final int NUMBER_OF_REPLICAS = 0;
    private static final int NUMBER_OF_SHARDS = 1;
    public static final String INDEX = "contact";
    public static final String CURRENT_VERSION = "v_1.0.0";
    public static final String RELATION_PARENT = "contactinfo";
    public static final String RELATION_CHILD = "contactvisibility";
    public static final String KEYWORD_FIELD_SUFFIX = "keywordfield";
    public static final String AUTOCOMPLETE_SUFFIX = "autocomplete";

    public static final HttpEntity getIndexInitialSetting() throws IOException {
        String indexInitialSetting = XContentFactory.jsonBuilder().startObject().field("number_of_shards", 1).field("number_of_replicas", 0).field("index.max_result_window", 10000000).startObject("analysis").startObject("analyzer").startObject(CUSTOM_ANALYZER).field("tokenizer", CUSTOM_TOKENIZER).field("filter", "lowercase").endObject().startObject(CUSTOM_AUTOCOMPLETE_ANALYZER).field("tokenizer", CUSTOM_AUTOCOMPLETE_TOKENIZER).field("filter", "lowercase").endObject().endObject().startObject("normalizer").startObject(KEYWORD_LOWERCASE_NORMALIZER).field("type", "custom").field("filter", "lowercase").endObject().endObject().startObject("tokenizer").startObject(CUSTOM_TOKENIZER).field("type", "nGram").field("min_gram", "1").field("max_gram", "1").field("token_chars", "whitespace,letter,digit,symbol,punctuation").endObject().startObject(CUSTOM_AUTOCOMPLETE_TOKENIZER).field("type", "edge_ngram").field("min_gram", "1").field("max_gram", "20").field("token_chars", "whitespace,letter,digit,symbol,punctuation").endObject().endObject().endObject().endObject().string();
        return new StringEntity(indexInitialSetting, ContentType.APPLICATION_JSON);
    }

    public static final HttpEntity getIndexMappingSetting() throws IOException {
        String indexMappingSetting = XContentFactory.jsonBuilder().startObject().startObject(CURRENT_VERSION).startObject("properties").startObject("joinfield").field("type", "join").startObject("relations").field(RELATION_PARENT, RELATION_CHILD).endObject().endObject().startObject("guid").field("type", "keyword").field("eager_global_ordinals", true).endObject().startObject("fullname").field("type", "text").field("analyzer", CUSTOM_ANALYZER).field("eager_global_ordinals", true).endObject().startObject("fullnameeastfirstwestfirst").field("type", "keyword").field("eager_global_ordinals", true).endObject().startObject("fullnameeastfirstwestlast").field("type", "keyword").field("eager_global_ordinals", true).endObject().startObject("fullnameeastlastwestfirst").field("type", "keyword").field("eager_global_ordinals", true).endObject().startObject("fullnameeastlastwestlast").field("type", "keyword").field("eager_global_ordinals", true).endObject().startObject("autocompleteField").field("type", "text").field("analyzer", CUSTOM_AUTOCOMPLETE_ANALYZER).field("eager_global_ordinals", true).startObject("fields").startObject(KEYWORD_FIELD_SUFFIX).field("type", "keyword").field("normalizer", KEYWORD_LOWERCASE_NORMALIZER).field("eager_global_ordinals", true).endObject().endObject().endObject().startObject("company").field("type", "text").field("analyzer", CUSTOM_ANALYZER).field("eager_global_ordinals", true).startObject("fields").startObject(KEYWORD_FIELD_SUFFIX).field("type", "keyword").field("eager_global_ordinals", true).endObject().endObject().endObject().startObject("department").field("type", "text").field("analyzer", CUSTOM_ANALYZER).field("eager_global_ordinals", true).startObject("fields").startObject(KEYWORD_FIELD_SUFFIX).field("type", "keyword").field("eager_global_ordinals", true).endObject().endObject().endObject().startObject("jobTitle").field("type", "text").field("analyzer", CUSTOM_ANALYZER).field("eager_global_ordinals", true).startObject("fields").startObject(KEYWORD_FIELD_SUFFIX).field("type", "keyword").field("eager_global_ordinals", true).endObject().endObject().endObject().startObject("phoneNumber").field("type", "text").field("analyzer", CUSTOM_ANALYZER).field("eager_global_ordinals", true).endObject().startObject("fullAddress").field("type", "text").field("analyzer", CUSTOM_ANALYZER).field("eager_global_ordinals", true).endObject().startObject("instantMessage").field("type", "text").field("analyzer", CUSTOM_ANALYZER).field("eager_global_ordinals", true).endObject().startObject("socialNetwork").field("type", "text").field("analyzer", CUSTOM_ANALYZER).field("eager_global_ordinals", true).endObject().startObject("email").field("type", "text").field("analyzer", CUSTOM_ANALYZER).field("eager_global_ordinals", true).endObject().startObject("url").field("type", "text").field("analyzer", CUSTOM_ANALYZER).field("eager_global_ordinals", true).endObject().startObject("note").field("type", "text").field("analyzer", CUSTOM_ANALYZER).field("eager_global_ordinals", true).endObject().startObject("uniformNumber").field("type", "text").field("analyzer", CUSTOM_ANALYZER).field("eager_global_ordinals", true).endObject().startObject("ownerGuid").field("type", "keyword").field("eager_global_ordinals", true).endObject().startObject("creatorGuid").field("type", "keyword").field("eager_global_ordinals", true).endObject().startObject("editorGuid").field("type", "keyword").field("eager_global_ordinals", true).endObject().startObject("beSharedAndOwnerAccountGuids").field("type", "keyword").field("eager_global_ordinals", true).endObject().startObject("belongCategories").field("type", "keyword").field("eager_global_ordinals", true).endObject().startObject("totalContent").field("type", "text").field("analyzer", CUSTOM_ANALYZER).field("eager_global_ordinals", true).endObject().endObject().endObject().endObject().string();
        return new StringEntity(indexMappingSetting, ContentType.APPLICATION_JSON);
    }

    public static final HttpEntity getCustomFieldMappingSetting(List<String> textTypefieldNames, List<String> numberTypeFieldNames) throws IOException {
        XContentBuilder cb = XContentFactory.jsonBuilder();
        cb.startObject();
        cb.startObject(CURRENT_VERSION);
        cb.startObject("properties");
        if (!CollectionUtil.collectionEmpty(textTypefieldNames)) {
            for (String textTypefieldName : textTypefieldNames) {
                cb.startObject(textTypefieldName);
                cb.field("type", "text");
                cb.field("analyzer", CUSTOM_ANALYZER);
                cb.field("eager_global_ordinals", true);
                cb.startObject("fields");
                cb.startObject(KEYWORD_FIELD_SUFFIX);
                cb.field("type", "keyword");
                cb.field("eager_global_ordinals", true);
                cb.endObject();
                cb.endObject();
                cb.endObject();
            }
        }
        if (!CollectionUtil.collectionEmpty(numberTypeFieldNames)) {
            for (String numberTypeFieldName : numberTypeFieldNames) {
                cb.startObject(numberTypeFieldName);
                cb.field("type", "double");
                cb.endObject();
            }
        }
        cb.endObject();
        cb.endObject();
        cb.endObject();
        return new StringEntity(cb.string(), ContentType.APPLICATION_JSON);
    }

    public static final HttpEntity getReadOnlyCancelSetting() throws IOException {
        String readOnlyCancelSetting = XContentFactory.jsonBuilder().startObject().field("index.blocks.read_only_allow_delete", "false").endObject().string();
        return new StringEntity(readOnlyCancelSetting, ContentType.APPLICATION_JSON);
    }
}

