/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.auth;

import com.penpower.worldcard.team.auth.AuthenticationWithToken;
import com.penpower.worldcard.team.auth.TokenInfo;
import com.penpower.worldcard.team.auth.TokenManager;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.enums.TokenStatus;
import com.penpower.worldcard.team.exception.TokenNotFoundException;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.TokenService;
import java.util.Collection;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class TokenAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(TokenAuthenticationProvider.class);
    private TokenManager tokenManager;
    private AccountService accountService;
    private TokenService tokenService;

    public TokenAuthenticationProvider(TokenManager tokenManager, AccountService accountService, TokenService tokenService) {
        this.tokenManager = tokenManager;
        this.accountService = accountService;
        this.tokenService = tokenService;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        LOG.debug("*** TokenAuthenticationProvider authenticate start......");
        Optional token = (Optional)authentication.getPrincipal();
        if (!token.isPresent() || ((String)token.get()).isEmpty()) {
            throw new BadCredentialsException("Invalid token");
        }
        String authToken = (String)token.get();
        TokenInfo tokenInfo = null;
        AuthenticationWithToken authenticationWithToken = null;
        try {
            tokenInfo = this.tokenService.getTokenInfo(authToken);
            LOG.debug("*** check current tokeninfo : {} ", (Object)tokenInfo);
            TokenStatus tokenStatus = this.tokenService.getTokenStatus(tokenInfo.getToken());
            LOG.debug("*** check  tokenStatus : {} ", (Object)tokenStatus);
            if (TokenStatus.INVALID.equals((Object)tokenStatus)) {
                LOG.warn("Token[{}] is invalid , remove it.", (Object)authToken);
                this.tokenService.removeToken(tokenInfo.getToken());
                throw new BadCredentialsException("Invalid token.");
            }
            if (TokenStatus.EXPIRED.equals((Object)tokenStatus)) {
                throw new BadCredentialsException("Token expired.");
            }
            String guid = this.tokenService.getUserGuid(authToken);
            if ("NONE".equals(guid)) {
                throw new BadCredentialsException("Invalid token.");
            }
            AccountInfo accountInfo = this.accountService.getAccountInfo(guid, null);
            if (accountInfo == null) {
                throw new BadCredentialsException("Token was found , but account not exists.");
            }
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
            LOG.debug("*** check request method : {}  , request URL : {} ", (Object)request.getMethod(), (Object)request.getRequestURI());
            String requestURI = request.getRequestURI();
            if (this.fromWebsocketRequestURI(requestURI)) {
                LOG.debug("*** websocket URI found... will not refresh the token... : {} ", (Object)tokenInfo);
                authenticationWithToken = new AuthenticationWithToken((Object)accountInfo, null, (Collection)AuthorityUtils.commaSeparatedStringToAuthorityList((String)accountInfo.getRole().toString()));
                authenticationWithToken.setToken(tokenInfo);
            } else if (requestURI.compareTo("/WorldCardTeam/api/notice/get_unviewed_notice_count") != 0) {
                TokenInfo newRefreshToken = this.tokenService.refreshTokenWithIpAndDeviceId(tokenInfo.getToken(), guid, tokenInfo.getHostname());
                LOG.debug("*** check  new newRefreshToken : {} ", (Object)newRefreshToken);
                authenticationWithToken = new AuthenticationWithToken((Object)accountInfo, null, (Collection)AuthorityUtils.commaSeparatedStringToAuthorityList((String)accountInfo.getRole().toString()));
                authenticationWithToken.setToken(newRefreshToken);
            } else {
                LOG.debug("*** /get_unviewed_notice_count URI found... will not refresh the token... : {} ", (Object)tokenInfo);
                authenticationWithToken = new AuthenticationWithToken((Object)accountInfo, null, (Collection)AuthorityUtils.commaSeparatedStringToAuthorityList((String)accountInfo.getRole().toString()));
                authenticationWithToken.setToken(tokenInfo);
            }
        }
        catch (TokenNotFoundException ex) {
            LOG.debug("authenciate failed...", (Throwable)ex);
            throw new BadCredentialsException("Invalid token , token not found.");
        }
        return authenticationWithToken;
    }

    private boolean fromWebsocketRequestURI(String requestURI) {
        return StringUtils.isNotEmpty((CharSequence)requestURI) && requestURI.indexOf("/webSocket") >= 0;
    }

    public boolean supports(Class<?> authentication) {
        return authentication.equals(PreAuthenticatedAuthenticationToken.class);
    }
}

