/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.auth;

import com.google.gson.Gson;
import com.penpower.worldcard.team.Utils.NetworkUtil;
import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.auth.ReadOnlyStatusManager;
import com.penpower.worldcard.team.auth.TokenInfo;
import com.penpower.worldcard.team.config.property.ApplicationProperties;
import com.penpower.worldcard.team.enums.ReadOnlyType;
import com.penpower.worldcard.team.exception.RequestArgumentNotValidException;
import com.penpower.worldcard.team.exception.StorageSpaceNotEnoughException;
import com.penpower.worldcard.team.exception.SubscriptionOutOfTSubscripException;
import com.penpower.worldcard.team.exception.SystemBackupException;
import com.penpower.worldcard.team.service.TokenService;
import com.penpower.worldcard.team.web.api.vo.response.ErrorResponseInfoResult;
import java.io.IOException;
import java.net.URL;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.web.filter.GenericFilterBean;
import org.springframework.web.util.UrlPathHelper;

public final class TokenAuthenticationFilter
extends GenericFilterBean {
    private static final Logger LOG = LoggerFactory.getLogger(TokenAuthenticationFilter.class);
    private AuthenticationManager authenticationManager;
    private ApplicationProperties applicationProperties;
    private TokenService tokenService;

    public TokenAuthenticationFilter(AuthenticationManager authenticationManager, ApplicationProperties applicationProperties, TokenService tokenService) {
        this.authenticationManager = authenticationManager;
        this.applicationProperties = applicationProperties;
        this.tokenService = tokenService;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Throwable throwable;
        ServletOutputStream ServletOutputStream2;
        String errorMessage;
        String message;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String remoteAddr = NetworkUtil.getClientIp((HttpServletRequest)httpRequest);
        LOG.debug("check remote ipaddresss : {}", (Object)remoteAddr);
        Optional<String> token = Optional.ofNullable(httpRequest.getHeader("X-Auth-Token"));
        Optional<String> Referer = Optional.ofNullable(httpRequest.getHeader("Referer"));
        LOG.debug("TokenAuthenticationFilter  Referer = {}", Referer);
        if (Referer.isPresent()) {
            TokenInfo tokenInfo;
            URL aURL = new URL(Referer.get());
            String hostName = aURL.getHost();
            LOG.debug("TokenAuthenticationFilter  hostName = {}", (Object)hostName);
            if (token.isPresent() && !StringUtil.IsStringNullorEmpty((String)hostName) && (tokenInfo = this.tokenService.getTokenInfo(token.get())) != null && !StringUtil.IsStringNullorEmpty((String)tokenInfo.getHostname())) {
                LOG.debug("TokenAuthenticationFilter  tokenInfo.gethostname = {}", (Object)tokenInfo.getHostname());
                if (hostName.compareToIgnoreCase(tokenInfo.getHostname()) != 0) {
                    LOG.debug("TokenAuthenticationFilter  difference");
                    String message2 = "access denied";
                    int errorCode = 403;
                    String errorMessage2 = "access denied";
                    ErrorResponseInfoResult result = new ErrorResponseInfoResult(message2, errorCode, errorMessage2, null);
                    Gson gson = new Gson();
                    String unAuthorizedMessage = gson.toJson((Object)result);
                    try (ServletOutputStream ServletOutputStream3 = response.getOutputStream();){
                        ServletOutputStream3.println(unAuthorizedMessage);
                        return;
                    }
                }
            }
        }
        LOG.debug("*** check request method : {}  , request URL : {} ", (Object)httpRequest.getMethod(), (Object)httpRequest.getRequestURI());
        LOG.debug("Check system READ_ONLY_STATUS : {} ", (Object)ReadOnlyStatusManager.READ_ONLY_STATUS.get());
        if (ReadOnlyStatusManager.READ_ONLY_STATUS.get()) {
            httpResponse.setContentType("application/json;charset=UTF-8");
            httpResponse.setStatus(200);
            ReadOnlyType readOnlyType = (ReadOnlyType)ReadOnlyStatusManager.READ_ONLY_TYPE.get();
            boolean backupReadOnlyType = ReadOnlyType.BACKUP.equals((Object)readOnlyType);
            boolean restoreReadOnlyType = ReadOnlyType.RESTORE.equals((Object)readOnlyType);
            LOG.debug("backupReadOnlyType : {} ", (Object)backupReadOnlyType);
            LOG.debug("restoreReadOnlyType : {} ", (Object)restoreReadOnlyType);
            if (backupReadOnlyType || restoreReadOnlyType) {
                String path = new UrlPathHelper().getPathWithinApplication(httpRequest);
                LOG.debug("path : {} ", (Object)path);
                if (backupReadOnlyType) {
                    boolean needToCheckReadOnlyApiPath = ReadOnlyStatusManager.NEED_TO_CHECK_READONLY_API_PATHS.contains(path);
                    LOG.debug("needToCheckReadOnlyApiPath : {} ", (Object)needToCheckReadOnlyApiPath);
                    if (needToCheckReadOnlyApiPath) {
                        String message3 = "System is running backup mode now....";
                        int errorCode = 499;
                        String errorMessage3 = "";
                        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message3, errorCode, errorMessage3, null);
                        Gson gson = new Gson();
                        String unAuthorizedMessage = gson.toJson((Object)result);
                        try (ServletOutputStream ServletOutputStream4 = response.getOutputStream();){
                            ServletOutputStream4.println(unAuthorizedMessage);
                        }
                    }
                } else if (restoreReadOnlyType && !ReadOnlyStatusManager.RESTORE_API_PATHS.contains(path)) {
                    LOG.debug("restore mode on , reject all request api.....");
                    String message4 = "System is running restore mode now....";
                    int errorCode = 498;
                    String errorMessage4 = "";
                    ErrorResponseInfoResult result = new ErrorResponseInfoResult(message4, errorCode, errorMessage4, null);
                    Gson gson = new Gson();
                    String unAuthorizedMessage = gson.toJson((Object)result);
                    try (ServletOutputStream ServletOutputStream5 = response.getOutputStream();){
                        ServletOutputStream5.println(unAuthorizedMessage);
                    }
                }
            }
        }
        LOG.debug("*** check authentication >>>>>>>>>>> {}", (Object)SecurityContextHolder.getContext().getAuthentication());
        try {
            if (!token.isPresent()) {
                token = Optional.ofNullable(httpRequest.getParameter("X-Auth-Token"));
            }
            if (token.isPresent()) {
                LOG.debug("*** Token is present... try to authenticate with toke [{}]...", (Object)token.get());
                PreAuthenticatedAuthenticationToken requestAuthentication = new PreAuthenticatedAuthenticationToken(token, null);
                Authentication responseAuthentication = this.authenticationManager.authenticate((Authentication)requestAuthentication);
                if (responseAuthentication == null || !responseAuthentication.isAuthenticated()) {
                    throw new InternalAuthenticationServiceException("Unable to authenticate User for provided credentials");
                }
                LOG.debug("responseAuthentication : {} ", (Object)responseAuthentication);
                SecurityContextHolder.getContext().setAuthentication(responseAuthentication);
            }
            chain.doFilter(request, response);
        }
        catch (InternalAuthenticationServiceException internalAuthenticationServiceException) {
            SecurityContextHolder.clearContext();
            httpResponse.setContentType("application/json;charset=UTF-8");
            httpResponse.setStatus(200);
            message = "Authentication failed.<BR>";
            int errorCode = 500;
            errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)internalAuthenticationServiceException);
            ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
            Gson gson = new Gson();
            String unAuthorizedMessage = gson.toJson((Object)result);
            ServletOutputStream2 = response.getOutputStream();
            throwable = null;
            try {
                ServletOutputStream2.println(unAuthorizedMessage);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ServletOutputStream2 != null) {
                    if (throwable != null) {
                        try {
                            ServletOutputStream2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ServletOutputStream2.close();
                    }
                }
            }
        }
        catch (AuthenticationException authenticationException) {
            SecurityContextHolder.clearContext();
            httpResponse.setContentType("application/json;charset=UTF-8");
            httpResponse.setStatus(200);
            message = "Authentication failed.<BR>";
            int errorCode = 401;
            errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)authenticationException);
            ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
            Gson gson = new Gson();
            String unAuthorizedMessage = gson.toJson((Object)result);
            ServletOutputStream2 = response.getOutputStream();
            throwable = null;
            try {
                ServletOutputStream2.println(unAuthorizedMessage);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (ServletOutputStream2 != null) {
                    if (throwable != null) {
                        try {
                            ServletOutputStream2.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ServletOutputStream2.close();
                    }
                }
            }
        }
        catch (StorageSpaceNotEnoughException ex) {
            SecurityContextHolder.clearContext();
            httpResponse.setContentType("application/json;charset=UTF-8");
            httpResponse.setStatus(200);
            message = "Local storage limit exceeded. All api is READ ONLY.";
            int errorCode = 431;
            errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)ex);
            ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
            Gson gson = new Gson();
            String unAuthorizedMessage = gson.toJson((Object)result);
            ServletOutputStream2 = response.getOutputStream();
            throwable = null;
            try {
                ServletOutputStream2.println(unAuthorizedMessage);
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (ServletOutputStream2 != null) {
                    if (throwable != null) {
                        try {
                            ServletOutputStream2.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        ServletOutputStream2.close();
                    }
                }
            }
        }
        catch (SubscriptionOutOfTSubscripException ex) {
            SecurityContextHolder.clearContext();
            httpResponse.setContentType("application/json;charset=UTF-8");
            httpResponse.setStatus(200);
            message = "Server is locked ";
            int errorCode = 486;
            errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)ex);
            ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
            Gson gson = new Gson();
            String unAuthorizedMessage = gson.toJson((Object)result);
            ServletOutputStream2 = response.getOutputStream();
            throwable = null;
            try {
                ServletOutputStream2.println(unAuthorizedMessage);
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            finally {
                if (ServletOutputStream2 != null) {
                    if (throwable != null) {
                        try {
                            ServletOutputStream2.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                    } else {
                        ServletOutputStream2.close();
                    }
                }
            }
        }
        catch (RequestArgumentNotValidException | IllegalArgumentException ex) {
            SecurityContextHolder.clearContext();
            httpResponse.setContentType("application/json;charset=UTF-8");
            httpResponse.setStatus(200);
            message = "Request required parameters not valid. <BR>";
            int errorCode = 422;
            errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)ex);
            ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
            Gson gson = new Gson();
            String unAuthorizedMessage = gson.toJson((Object)result);
            ServletOutputStream2 = response.getOutputStream();
            throwable = null;
            try {
                ServletOutputStream2.println(unAuthorizedMessage);
            }
            catch (Throwable throwable10) {
                throwable = throwable10;
                throw throwable10;
            }
            finally {
                if (ServletOutputStream2 != null) {
                    if (throwable != null) {
                        try {
                            ServletOutputStream2.close();
                        }
                        catch (Throwable throwable11) {
                            throwable.addSuppressed(throwable11);
                        }
                    } else {
                        ServletOutputStream2.close();
                    }
                }
            }
        }
        catch (SystemBackupException ex) {
            SecurityContextHolder.clearContext();
            httpResponse.setContentType("application/json;charset=UTF-8");
            httpResponse.setStatus(200);
            message = "System is running backup mode now....";
            int errorCode = 499;
            errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)ex);
            ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
            Gson gson = new Gson();
            String unAuthorizedMessage = gson.toJson((Object)result);
            ServletOutputStream2 = response.getOutputStream();
            throwable = null;
            try {
                ServletOutputStream2.println(unAuthorizedMessage);
            }
            catch (Throwable throwable12) {
                throwable = throwable12;
                throw throwable12;
            }
            finally {
                if (ServletOutputStream2 != null) {
                    if (throwable != null) {
                        try {
                            ServletOutputStream2.close();
                        }
                        catch (Throwable throwable13) {
                            throwable.addSuppressed(throwable13);
                        }
                    } else {
                        ServletOutputStream2.close();
                    }
                }
            }
        }
    }
}

