/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.auth;

import com.penpower.worldcard.team.Utils.SecurityUtils;
import com.penpower.worldcard.team.auth.ReadOnlyStatusManager;
import com.penpower.worldcard.team.config.property.ApplicationProperties;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.enums.LicenseMode;
import com.penpower.worldcard.team.enums.ServerRegisterStatus;
import com.penpower.worldcard.team.enums.SubscriptionStatus;
import com.penpower.worldcard.team.exception.SubscriptionOutOfTSubscripException;
import com.penpower.worldcard.team.service.RegistryService;
import com.penpower.worldcard.team.service.SubscriptionService;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.util.UrlPathHelper;

public class SubscriptionAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(SubscriptionAuthenticationProvider.class);
    private ApplicationProperties applicationProperties;
    @Autowired
    private SubscriptionService subscriptionService;
    @Autowired
    private RegistryService registryService;

    public SubscriptionAuthenticationProvider(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        AccountInfo currentLoginAccount = null;
        try {
            currentLoginAccount = SecurityUtils.getCurrentLoginUser();
        }
        catch (Exception ex) {
            return null;
        }
        boolean IsNeedLockServer = false;
        LOG.debug("SubscriptionAuthenticationProvider check auth currentLoginAccount={}", (Object)currentLoginAccount);
        if (this.subscriptionService.getLicenseMode(currentLoginAccount.getCompanyGuid()) != LicenseMode.SUBSCRIPTION) {
            if (this.registryService.GetRegisterStatus(currentLoginAccount.getCompanyGuid()) == ServerRegisterStatus.TRIAL_EXPIRED) {
                LOG.debug("SubscriptionAuthenticationProvider ServerRegisterStatus =  TRIAL_EXPIRED");
                IsNeedLockServer = true;
            }
        } else {
            SubscriptionStatus subscriptionStatus = this.subscriptionService.getSubScriptionStatus(currentLoginAccount.getCompanyGuid());
            if (subscriptionStatus == SubscriptionStatus.LOCK) {
                LOG.debug("SubscriptionAuthenticationProvider SubscriptionStatus =  LOCK");
                IsNeedLockServer = true;
            }
        }
        if (IsNeedLockServer) {
            ServletRequestAttributes attr = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
            HttpServletRequest httpRequest = attr.getRequest();
            String path = new UrlPathHelper().getPathWithinApplication(httpRequest);
            LOG.debug("path : {} ", (Object)path);
            if (!ReadOnlyStatusManager.SUBSCRIPTION_LOCK_ADMIN_CAN_ACCESS_PATHS.contains(path)) {
                LOG.error("SubscriptionAuthenticationProvider IsNeedLockServer api ");
                throw new SubscriptionOutOfTSubscripException("Subscription LockServer");
            }
        }
        return null;
    }

    public boolean supports(Class<?> authentication) {
        return authentication.equals(PreAuthenticatedAuthenticationToken.class);
    }
}

