/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.auth;

import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.auth.MemoryMapHelper;
import com.penpower.worldcard.team.auth.NullTokenInfo;
import com.penpower.worldcard.team.auth.TokenInfo;
import com.penpower.worldcard.team.auth.TokenManagerWithPlatform;
import com.penpower.worldcard.team.enums.Platform;
import com.penpower.worldcard.team.enums.PlatformCategory;
import com.penpower.worldcard.team.enums.TokenStatus;
import com.penpower.worldcard.team.exception.TokenNotFoundException;
import java.util.List;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="memoryMapTokenManager")
public class MemoryMapTokenManager
implements TokenManagerWithPlatform {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryMapTokenManager.class);

    public TokenInfo createNewTokenWithPlatformAndIpAndDeviceId(String userGuid, Platform platform, String remoteIpaddress, String deviceId) {
        TokenInfo tokenInfo = new TokenInfo(UUIDGenerator.getRandomUUID(), userGuid, platform, remoteIpaddress, deviceId);
        String tokenKey = tokenInfo.getToken();
        MemoryMapHelper.put((String)tokenKey, (TokenInfo)tokenInfo);
        return tokenInfo;
    }

    public TokenInfo createNewToken(String userGuid) {
        LOG.debug("create new token by user : {} ", (Object)userGuid);
        TokenInfo tokenInfo = new TokenInfo(UUIDGenerator.getRandomUUID(), userGuid);
        String tokenKey = tokenInfo.getToken();
        MemoryMapHelper.put((String)tokenKey, (TokenInfo)tokenInfo);
        return tokenInfo;
    }

    public TokenInfo getTokenInfo(String token) {
        LOG.debug("try to get tokenInfo , token  : {} ", (Object)token);
        TokenInfo tokenInfo = MemoryMapHelper.getTokenInfo((String)token);
        LOG.debug("token info : {} ", (Object)tokenInfo);
        if (tokenInfo instanceof NullTokenInfo) {
            throw new TokenNotFoundException(String.format("Token<%s> was not found.", token));
        }
        return tokenInfo;
    }

    public void removeToken(String token) {
        MemoryMapHelper.removeToken((String)token);
    }

    public String getUserGuid(String token) {
        return MemoryMapHelper.getUserGuid((String)token);
    }

    public TokenInfo refreshTokenWithIpAndDeviceId(String token, String userGuid) {
        LOG.debug("refresh tokoen : {} , userGuid:{}", (Object)token, (Object)userGuid);
        TokenInfo oldToken = MemoryMapHelper.getTokenInfo((String)token);
        TokenInfo newToken = new TokenInfo(token, userGuid, oldToken.getPlatform(), oldToken.getIp(), oldToken.getDeviceId());
        MemoryMapHelper.replace((String)token, (TokenInfo)newToken);
        return newToken;
    }

    public void cleanTokens() {
        LOG.debug("Clean all user tokens in memory.");
        MemoryMapHelper.clear();
    }

    public void replaceToken(TokenInfo tokenInfo) {
        MemoryMapHelper.replace((String)tokenInfo.getToken(), (TokenInfo)tokenInfo);
    }

    public void putToken(TokenInfo tokenInfo) {
        MemoryMapHelper.put((String)tokenInfo.getToken(), (TokenInfo)tokenInfo);
    }

    public boolean expired(String token) {
        TokenInfo tokenInfo = this.getTokenInfo(token);
        DateTime expiredTime = new DateTime((Object)tokenInfo.getExpiredTime());
        return expiredTime.isBeforeNow();
    }

    public TokenStatus getTokenStatus(String token) {
        TokenInfo tokenInfo = this.getTokenInfo(token);
        DateTime expiredTime = new DateTime((Object)tokenInfo.getExpiredTime());
        DateTime invalidTime = new DateTime((Object)tokenInfo.getInvalidTime());
        LOG.debug(">>>> tokenInfo : {}", (Object)tokenInfo);
        LOG.debug(">>>> expiredTime : {}", (Object)expiredTime);
        LOG.debug(">>>> invalidTime : {}", (Object)invalidTime);
        if (invalidTime.isBeforeNow()) {
            return TokenStatus.INVALID;
        }
        if (expiredTime.isBeforeNow()) {
            return TokenStatus.EXPIRED;
        }
        return TokenStatus.VALID;
    }

    public void setUserTokensExipred(String userGuid, String currentToken) {
        List tokenKeys = MemoryMapHelper.getAllTokenByUserGuid((String)userGuid);
        tokenKeys.stream().filter(token -> !token.equals(currentToken)).forEach(token -> this.setToExpired(token));
    }

    public void setToExpired(String token) throws TokenNotFoundException {
        LOG.debug("set to expired..... token : {} ", (Object)token);
        TokenInfo tokenInfo = this.getTokenInfo(token);
        DateTime createTime = tokenInfo.getCreatedTime();
        TokenInfo newToken = new TokenInfo(tokenInfo.getToken(), createTime, createTime, tokenInfo.getInvalidTime(), tokenInfo.getUserGuid(), tokenInfo.getPlatform());
        MemoryMapHelper.replace((String)token, (TokenInfo)newToken);
    }

    public void printAllTokenLog() {
        MemoryMapHelper.printLog();
    }

    public void setToInvalid(String token) throws TokenNotFoundException {
        MemoryMapHelper.removeToken((String)token);
    }

    public void setTokensInvalid(String userGuid) {
        LOG.debug("***** userGuid : {}", (Object)userGuid);
        List tokenKeys = MemoryMapHelper.getAllTokenByUserGuid((String)userGuid);
        LOG.debug("tokenKeys : {}", (Object)tokenKeys);
        tokenKeys.stream().forEach(token -> this.setToInvalid(token));
    }

    public void setUserTokensInvalid(String userGuid, String currentToken) {
        LOG.debug("***** userGuid : {}", (Object)userGuid);
        LOG.debug("***** currentToken : {}", (Object)currentToken);
        List tokenKeys = MemoryMapHelper.getAllTokenByUserGuid((String)userGuid);
        LOG.debug("tokenKeys : {}", (Object)tokenKeys);
        tokenKeys.stream().forEach(token -> this.setToInvalid(token));
    }

    public void setAllTokenIvalidate() {
        MemoryMapHelper.clear();
    }

    public List<String> getUserTokensByPlatformCagetory(String userGuid, PlatformCategory platformCategory) {
        List userAllTokens = MemoryMapHelper.getAllTokenByUserGuid((String)userGuid);
        List<String> result = userAllTokens.stream().map(token -> MemoryMapHelper.getTokenInfo((String)token)).filter(tokenInfo -> tokenInfo.getPlatformCategory().equals((Object)platformCategory)).map(tokenInfo -> tokenInfo.getToken()).collect(Collectors.toList());
        return result;
    }

    public List<TokenInfo> getAllTokenInfoByUserGuid(String userGuid) {
        List userAllTokens = MemoryMapHelper.getAllTokenByUserGuid((String)userGuid);
        return userAllTokens.stream().map(token -> this.getTokenInfo(token)).collect(Collectors.toList());
    }
}

