/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.auth;

import com.penpower.worldcard.team.auth.NullTokenInfo;
import com.penpower.worldcard.team.auth.TokenInfo;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
final class MemoryMapHelper {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryMapHelper.class);
    private static final Map<String, TokenInfo> tokens = new ConcurrentHashMap();

    MemoryMapHelper() {
    }

    static final void put(String tokenKey, TokenInfo tokenInfo) {
        tokens.put(tokenKey, tokenInfo);
    }

    static final void replace(String tokenKey, TokenInfo tokenInfo) {
        TokenInfo replacedToken = tokens.replace(tokenKey, tokenInfo);
        LOG.debug("***** after token replace by key : {} , \n replacedToken(original) : {}  \n new : {}", new Object[]{tokenKey, replacedToken, tokenInfo});
    }

    static final TokenInfo getTokenInfo(String tokenKey) {
        TokenInfo tokenInfo = (TokenInfo)tokens.get(tokenKey);
        LOG.debug("***** get token by key : {} , token is : {}", (Object)tokenKey, (Object)tokenInfo);
        return Optional.ofNullable(tokenInfo).orElse((TokenInfo)new NullTokenInfo());
    }

    static final void removeToken(String token) {
        LOG.debug("***** remove token : {} ", (Object)token);
        tokens.remove(token);
    }

    static final String getUserGuid(String token) {
        TokenInfo tokenInfo = MemoryMapHelper.getTokenInfo((String)token);
        return tokenInfo.getUserGuid();
    }

    static final void clear() {
        tokens.clear();
    }

    static final List<String> getAllTokenByUserGuid(String userGuid) {
        List<String> allUserTokenKeys = tokens.entrySet().stream().filter(entry -> ((TokenInfo)entry.getValue()).getUserGuid().equals(userGuid)).map(entry -> (String)entry.getKey()).collect(Collectors.toList());
        return allUserTokenKeys;
    }

    static final void printLog() {
        tokens.entrySet().stream().forEach(entry -> LOG.info("******** token key : {} , value : {}", entry.getKey(), entry.getValue()));
    }
}

