/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.auth;

import com.google.gson.Gson;
import com.penpower.worldcard.team.Utils.DiskInfos;
import com.penpower.worldcard.team.Utils.FileSystemUtil;
import com.penpower.worldcard.team.Utils.HardwareIdUtil;
import com.penpower.worldcard.team.auth.LocalStorageSpaceAuthenticationProvider;
import com.penpower.worldcard.team.auth.ReadOnlyStatusManager;
import com.penpower.worldcard.team.config.property.ApplicationProperties;
import com.penpower.worldcard.team.enums.ReadOnlyType;
import com.penpower.worldcard.team.exception.StorageSpaceNotEnoughException;
import com.penpower.worldcard.team.service.RegistryService;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.util.UrlPathHelper;

public class LocalStorageSpaceAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(LocalStorageSpaceAuthenticationProvider.class);
    private ApplicationProperties applicationProperties;
    private RegistryService registryService;

    public LocalStorageSpaceAuthenticationProvider(ApplicationProperties applicationProperties, RegistryService registryService) {
        this.applicationProperties = applicationProperties;
        this.registryService = registryService;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        switch (1.$SwitchMap$com$penpower$worldcard$team$enums$ServerType[this.registryService.GetServerType().ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                LOG.debug(String.format("serverType:%s, skip the storage check", this.registryService.GetServerType()));
                return null;
            }
        }
        if (!HardwareIdUtil.linuxSystem()) {
            LOG.debug("Windows system detected! , skip the storage check.....");
            return null;
        }
        LOG.debug("********** ReadOnly Status :[ {} ] ", (Object)ReadOnlyStatusManager.READ_ONLY_STATUS.get());
        ReadOnlyType readOnlyType = (ReadOnlyType)ReadOnlyStatusManager.READ_ONLY_TYPE.get();
        boolean backupReadOnly = ReadOnlyType.BACKUP.equals((Object)readOnlyType);
        boolean restoreReadOnly = ReadOnlyType.RESTORE.equals((Object)readOnlyType);
        LOG.debug("backupReadOnly : {}", (Object)backupReadOnly);
        LOG.debug("restoreReadOnly : {}", (Object)restoreReadOnly);
        if (backupReadOnly || restoreReadOnly) {
            return null;
        }
        if (ReadOnlyStatusManager.READ_ONLY_STATUS.get()) {
            ServletRequestAttributes attr = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
            HttpServletRequest httpRequest = attr.getRequest();
            String path = new UrlPathHelper().getPathWithinApplication(httpRequest);
            LOG.debug("path : {} ", (Object)path);
            if (ReadOnlyStatusManager.NEED_TO_CHECK_READONLY_API_PATHS.contains(path)) {
                String fileSystemRootPath = this.applicationProperties.getProperty("FILE_SYSTEM_ROOT_PATH");
                Path fileSystemRoot = Paths.get(fileSystemRootPath, new String[0]);
                DiskInfos diskInfos = FileSystemUtil.getDiskInfos((Path)fileSystemRoot);
                boolean storageReadOnlyLimitExceeded = FileSystemUtil.storageLessThan50GReadOnlyMode((DiskInfos)diskInfos);
                LOG.debug("storageReadOnlyLimitExceeded : {} ", (Object)storageReadOnlyLimitExceeded);
                if (storageReadOnlyLimitExceeded) {
                    ReadOnlyStatusManager.changeTheReadOnlyStatus((boolean)true, (ReadOnlyType)ReadOnlyType.STORAGE_NOT_ENOUGH);
                    Gson gson = new Gson();
                    String diskInfo = gson.toJson((Object)diskInfos);
                    throw new StorageSpaceNotEnoughException("Storage Read-Only space limit exceeded. (" + diskInfo + ")");
                }
                ReadOnlyStatusManager.changeTheReadOnlyStatus((boolean)false, (ReadOnlyType)ReadOnlyType.NONE);
            }
        }
        return null;
    }

    public boolean supports(Class<?> authentication) {
        return authentication.equals(PreAuthenticatedAuthenticationToken.class);
    }
}

