/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.Utils;

import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.dto.SSLInfo;
import com.penpower.worldcard.team.enums.SSLFileType;
import com.penpower.worldcard.team.exception.IncorrectRegistrationInformationException;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.exception.UpdateToResignedException;
import com.penpower.worldcard.team.exception.UploadFileException;
import com.penpower.worldcard.team.web.api.vo.SSLDetailInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class SSLUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SSLUtil.class);

    private static String SaveFileToHD(MultipartFile multipartFile) {
        String tomcatRoot = System.getProperty("catalina.base");
        Path tomcatRootPath = Paths.get(tomcatRoot, new String[0]);
        String sslGuid = UUIDGenerator.getRandomUUID();
        Path uploadPath = Paths.get(tomcatRootPath.getParent().toString(), "etc", "sslupload", sslGuid);
        try {
            block17: {
                Files.createDirectories(uploadPath, new FileAttribute[0]);
                Path filedPath = Paths.get(uploadPath.toString(), multipartFile.getOriginalFilename());
                try (InputStream inStream = multipartFile.getInputStream();){
                    OutputStream outStream = Files.newOutputStream(filedPath, StandardOpenOption.CREATE);
                    if (outStream != null) {
                        IOUtils.copy((InputStream)inStream, (OutputStream)outStream);
                        break block17;
                    }
                    throw new UploadFileException("Save to file fail ,can't create stream ");
                }
                catch (IOException e) {
                    throw new UploadFileException("Save to file fail error = " + e.toString());
                }
            }
            return sslGuid;
        }
        catch (IOException e) {
            throw new UploadFileException("Save to file fail and error = " + e.toString());
        }
    }

    private static boolean CheckSSLFileValidate(String uploadFile, String passWord) {
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            LOG.debug("upload file ={}  passWord ={}", (Object)uploadFile, (Object)passWord);
            keyStore.load(new FileInputStream(uploadFile), passWord.toCharArray());
            LOG.debug("keyStore=" + keyStore.toString());
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                String alias = enumeration.nextElement();
                LOG.debug("alias name: " + alias);
                Certificate certificate = keyStore.getCertificate(alias);
                LOG.debug("Certificate type: " + certificate.getType());
                LOG.debug("Certificate getPublicKey: " + certificate.getPublicKey().toString());
                LOG.debug("Certificate getEncoded: " + certificate.getEncoded().toString());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public static SSLDetailInfo GetCurrentSSLFileDetail() {
        String tomcatRoot = System.getProperty("catalina.base");
        Path tomcatconfFile = Paths.get(tomcatRoot, "conf", "server.xml");
        String sslFile = "";
        String password = "";
        try {
            LOG.debug("GetCurrentSSLFileDetail ");
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(tomcatconfFile.toString());
            LOG.debug("GetCurrentSSLFileDetail 2");
            Node company = doc.getFirstChild();
            NodeList serverList = doc.getElementsByTagName("Service");
            boolean bGeted = false;
            block4: for (int i = 0; i < serverList.getLength(); ++i) {
                LOG.debug("GetCurrentSSLFileDetail 2a");
                Node serverNode = serverList.item(i);
                Node NodeNameAttr = serverNode.getAttributes().getNamedItem("name");
                LOG.debug("GetCurrentSSLFileDetail 2b" + NodeNameAttr.getNodeValue());
                if (NodeNameAttr.getNodeValue().compareToIgnoreCase("Catalina") != 0) continue;
                LOG.debug("GetCurrentSSLFileDetail 3");
                NodeList connectorList = serverNode.getChildNodes();
                LOG.debug("GetCurrentSSLFileDetail 3a");
                for (int j = 0; j < connectorList.getLength(); ++j) {
                    Node connectorNode = connectorList.item(j);
                    if (connectorNode == null || connectorNode.getAttributes() == null) continue;
                    LOG.debug("GetCurrentSSLFileDetail 3e");
                    Node connectorNodePortAttr = connectorNode.getAttributes().getNamedItem("scheme");
                    if (connectorNodePortAttr == null) continue;
                    LOG.debug("GetCurrentSSLFileDetail 3f" + connectorNodePortAttr.getNodeValue());
                    if (connectorNodePortAttr.getNodeValue().compareToIgnoreCase("https") != 0) continue;
                    LOG.debug("GetCurrentSSLFileDetail 4");
                    Node keystoreFileAttr = connectorNode.getAttributes().getNamedItem("keystoreFile");
                    Node keystorePassAttr = connectorNode.getAttributes().getNamedItem("keystorePass");
                    if (keystoreFileAttr == null || keystorePassAttr == null) break block4;
                    sslFile = keystoreFileAttr.getNodeValue();
                    password = keystorePassAttr.getNodeValue();
                    bGeted = true;
                    break block4;
                }
                break;
            }
            if (bGeted) {
                return SSLUtil.GetSSLFileDetail((String)sslFile, (String)password);
            }
            throw new ItemNotFoundException("can not find ssl file setting from tomcat configure file");
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (SAXException sae) {
            sae.printStackTrace();
        }
        throw new ItemNotFoundException("Get tomcat setting exception ");
    }

    private static boolean UpdateTomcatSetting(String uploadFile, String passWord, SSLFileType sslFileType) {
        String tomcatRoot = System.getProperty("catalina.base");
        Path tomcatconfFile = Paths.get(tomcatRoot, "conf", "server.xml");
        try {
            LOG.debug("UpdateTomcatSetting configurefile=" + tomcatconfFile + "sslfile=" + uploadFile + " password=" + passWord);
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(tomcatconfFile.toString());
            LOG.debug("UpdateTomcatSetting 2");
            Node company = doc.getFirstChild();
            NodeList serverList = doc.getElementsByTagName("Service");
            boolean bModify = false;
            block5: for (int i = 0; i < serverList.getLength(); ++i) {
                LOG.debug("UpdateTomcatSetting 2a");
                Node serverNode = serverList.item(i);
                Node NodeNameAttr = serverNode.getAttributes().getNamedItem("name");
                LOG.debug("UpdateTomcatSetting 2b" + NodeNameAttr.getNodeValue());
                if (NodeNameAttr.getNodeValue().compareToIgnoreCase("Catalina") != 0) continue;
                LOG.debug("UpdateTomcatSetting 3");
                NodeList connectorList = serverNode.getChildNodes();
                LOG.debug("UpdateTomcatSetting 3a");
                for (int j = 0; j < connectorList.getLength(); ++j) {
                    Node connectorNode = connectorList.item(j);
                    if (connectorNode == null || connectorNode.getAttributes() == null) continue;
                    LOG.debug("UpdateTomcatSetting 3e");
                    Node connectorNodePortAttr = connectorNode.getAttributes().getNamedItem("scheme");
                    if (connectorNodePortAttr == null) continue;
                    LOG.debug("UpdateTomcatSetting 3f" + connectorNodePortAttr.getNodeValue());
                    if (connectorNodePortAttr.getNodeValue().compareToIgnoreCase("https") != 0) continue;
                    LOG.debug("UpdateTomcatSetting 4");
                    Node keystoreFileAttr = connectorNode.getAttributes().getNamedItem("keystoreFile");
                    Node keystorePassAttr = connectorNode.getAttributes().getNamedItem("keystorePass");
                    Node keystoreTypeAttr = connectorNode.getAttributes().getNamedItem("keystoreType");
                    if (keystoreFileAttr == null || keystorePassAttr == null) break block5;
                    keystoreFileAttr.setNodeValue(uploadFile);
                    keystorePassAttr.setNodeValue(passWord);
                    if (sslFileType == SSLFileType.PFX) {
                        if (keystoreTypeAttr == null) {
                            Attr att = doc.createAttribute("keystoreType");
                            att.setValue("PKCS12");
                            connectorNode.getAttributes().setNamedItem(att);
                        } else {
                            keystoreTypeAttr.setNodeValue("PKCS12");
                        }
                    } else if (keystoreTypeAttr != null) {
                        connectorNode.getAttributes().removeNamedItem("keystoreType");
                    }
                    bModify = true;
                    break block5;
                }
                break;
            }
            if (bModify) {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                DOMSource source = new DOMSource(doc);
                StreamResult result = new StreamResult(new File(tomcatconfFile.toString()));
                transformer.transform(source, result);
                return true;
            }
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (TransformerException tfe) {
            tfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (SAXException sae) {
            sae.printStackTrace();
        }
        return false;
    }

    private static String GetSSLFile(String sslGuid) {
        String tomcatRoot = System.getProperty("catalina.base");
        Path tomcatRootPath = Paths.get(tomcatRoot, new String[0]);
        Path uploadPath = Paths.get(tomcatRootPath.getParent().toString(), "etc", "sslupload", sslGuid);
        String sslFile = "";
        File folder = new File(uploadPath.toString());
        File[] listOfFiles = folder.listFiles();
        for (int i = 0; i < listOfFiles.length; ++i) {
            if (!listOfFiles[i].isFile()) continue;
            sslFile = Paths.get(folder.toString(), listOfFiles[i].getName()).toString();
            break;
        }
        if (StringUtil.IsStringNullorEmpty((String)sslFile)) {
            throw new ItemNotFoundException("SSL File not found");
        }
        return sslFile;
    }

    private static SSLDetailInfo GetSSLFileDetail(String uploadFile, String passWord) {
        LOG.debug("GetSSLFileDetail file={} password={}", (Object)uploadFile, (Object)passWord);
        SSLDetailInfo sslDetailInfo = new SSLDetailInfo();
        try {
            LOG.debug("GetSSLFileDetail ");
            KeyStore keyStore = KeyStore.getInstance("JKS");
            LOG.debug("GetSSLFileDetail 1");
            keyStore.load(new FileInputStream(uploadFile), passWord.toCharArray());
            LOG.debug("GetSSLFileDetail 2");
            Enumeration<String> enumeration = keyStore.aliases();
            LOG.debug("GetSSLFileDetail 3");
            while (enumeration.hasMoreElements()) {
                LOG.debug("GetSSLFileDetail 4");
                String alias = enumeration.nextElement();
                LOG.debug("GetSSLFileDetail alias =" + alias);
                Certificate certificate = keyStore.getCertificate(alias);
                LOG.debug("GetSSLFileDetail 5");
                if (certificate instanceof X509Certificate) {
                    LOG.debug("GetSSLFileDetail 6");
                    sslDetailInfo.setIssuerDN(((X509Certificate)certificate).getIssuerDN().toString());
                    LOG.debug("GetSSLFileDetail 8");
                    sslDetailInfo.setSubjectDN(((X509Certificate)certificate).getSubjectDN().toString());
                    LOG.debug("GetSSLFileDetail 9");
                    sslDetailInfo.setNotAfter(((X509Certificate)certificate).getNotAfter().toString());
                    LOG.debug("GetSSLFileDetail 10");
                    sslDetailInfo.setNotBefore(((X509Certificate)certificate).getNotBefore().toString());
                    LOG.debug("GetSSLFileDetail 11");
                    if (StringUtil.Compare((String)alias, (String)"tomcat") == 0) break;
                }
                System.out.println("Certificate type: " + certificate.getType());
                System.out.println("Certificate getPublicKey: " + certificate.getPublicKey().toString());
                System.out.println("Certificate getEncoded: " + certificate.getEncoded().toString());
            }
        }
        catch (Exception ex) {
            LOG.debug("GetSSLFileDetail ex={}", (Throwable)ex);
            throw new IncorrectRegistrationInformationException("GetSSLFileDetail");
        }
        return sslDetailInfo;
    }

    public static String UploadSSL(MultipartFile sslfile) {
        String uploadFileID = SSLUtil.SaveFileToHD((MultipartFile)sslfile);
        return uploadFileID;
    }

    public static SSLDetailInfo GetUploadedSSLDetail(SSLInfo sslInfo) {
        LOG.debug("ReplaceSSL password={}", (Object)sslInfo.getPassWord());
        String uploadFile = SSLUtil.GetSSLFile((String)sslInfo.getUploadGuid());
        SSLDetailInfo sslDetailInfo = SSLUtil.GetSSLFileDetail((String)uploadFile, (String)sslInfo.getPassWord());
        sslDetailInfo.setIsNeedToRestartWCT(false);
        return sslDetailInfo;
    }

    public static void ReplaceSSL(SSLInfo sslInfo) {
        LOG.debug("ReplaceSSL password={}", (Object)sslInfo.getPassWord());
        String uploadFile = SSLUtil.GetSSLFile((String)sslInfo.getUploadGuid());
        if (!SSLUtil.CheckSSLFileValidate((String)uploadFile, (String)sslInfo.getPassWord())) {
            throw new UpdateToResignedException("SSL File is not valid");
        }
        if (!SSLUtil.UpdateTomcatSetting((String)uploadFile, (String)sslInfo.getPassWord(), (SSLFileType)sslInfo.getSSLFileType())) {
            throw new IncorrectRegistrationInformationException("update tomcat setting fail");
        }
    }

    public static void ResetDefaultSSL() {
        String tomcatRoot = System.getProperty("catalina.base");
        Path tomcatPath = Paths.get(tomcatRoot, new String[0]);
        Path defaultSSLPath = Paths.get(tomcatPath.getParent().toString(), "etc/keystore.jks");
        if (!SSLUtil.UpdateTomcatSetting((String)defaultSSLPath.toString(), (String)"penpower", (SSLFileType)SSLFileType.JKS)) {
            throw new IncorrectRegistrationInformationException("update tomcat setting fail");
        }
    }
}

