/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.Utils;

import com.google.gson.Gson;
import com.penpower.worldcard.team.Utils.ApplicationContextProvider;
import com.penpower.worldcard.team.Utils.CollectionUtil;
import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.entity.Globalinfo;
import com.penpower.worldcard.team.entity.Globalinfocompany;
import com.penpower.worldcard.team.enums.ContactField;
import com.penpower.worldcard.team.enums.CrmTargetType;
import com.penpower.worldcard.team.enums.NameDisplayOrderSettingType;
import com.penpower.worldcard.team.enums.Platform;
import com.penpower.worldcard.team.enums.PlatformCategory;
import com.penpower.worldcard.team.enums.PlatformForDevice;
import com.penpower.worldcard.team.enums.PlatformForSecurity;
import com.penpower.worldcard.team.enums.ServerType;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.exception.RequestArgumentNotValidException;
import com.penpower.worldcard.team.service.CRMOperationService;
import com.penpower.worldcard.team.service.CompanyGlobalInfoService;
import com.penpower.worldcard.team.service.GlobalInfoService;
import com.penpower.worldcard.team.web.api.vo.IntervalFilter;
import com.penpower.worldcard.team.web.api.vo.ItemBasicVo;
import com.penpower.worldcard.team.web.api.vo.PageInfo;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import net.markenwerk.utils.mail.dkim.Canonicalization;
import net.markenwerk.utils.mail.dkim.DkimException;
import net.markenwerk.utils.mail.dkim.DkimMessage;
import net.markenwerk.utils.mail.dkim.DkimSigner;
import net.markenwerk.utils.mail.dkim.SigningAlgorithm;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.tika.Tika;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Sort;

/*
 * Exception performing whole class analysis ignored.
 */
public class GlobalUtils {
    public static final String CHECK_STRING_CONTAINS_KEYWORD_PATTERN = "[\\u3000-\\u303F]+|[\\u9FA6-\\u9FBB]+|[\\u3400-\\u4DB5]+|[\\u4E00-\\u9FA5]+|[\\uF900-\\uFA2D]+|[\\uFA30-\\uFA6A]+|[\\uFA70-\\uFAD9]+|[\\uFF00-\\uFFEF]+|[\\u2E80-\\u2EFF]+|[\\u31C0-\\u31EF]+";
    private static ServerType serverType = ServerType.Google_Linux_Server_Cloud;
    private static final Logger LOG = LoggerFactory.getLogger(GlobalUtils.class);
    private static String FIELD_NAME_NAME_EAST_FL_WEST_FL = "fullnameeastfirstwestfirst";
    private static String FIELD_NAME_NAME_EAST_FL_WEST_LF = "fullnameeastfirstwestlast";
    private static String FIELD_NAME_NAME_EAST_LF_WEST_FL = "fullnameeastlastwestfirst";
    private static String FIELD_NAME_NAME_EAST_LF_WEST_LF = "fullnameeastlastwestlast";
    private static String FIELD_NAME_COMPANY = "company";
    private static String FIELD_NAME_DEPARTMENT = "department";
    private static String FIELD_NAME_JOBTITLE = "jobtitle";
    private static String FIELD_NAME_CREATED_TIME = "createtime";
    private static String FIELD_NAME_GUID = "guid";

    public static final PlatformCategory getPlatformCategory(Platform platform) {
        if (Platform.ANDROID.equals((Object)platform) || Platform.IOS.equals((Object)platform)) {
            return PlatformCategory.MOBILE_PHONES;
        }
        if (Platform.ANDROID_TABLET.equals((Object)platform) || Platform.IPAD.equals((Object)platform)) {
            return PlatformCategory.TABLET_IPADS;
        }
        if (Platform.PC.equals((Object)platform) || Platform.MAC.equals((Object)platform)) {
            return PlatformCategory.PC;
        }
        if (Platform.WEB.equals((Object)platform)) {
            return PlatformCategory.WEB;
        }
        return PlatformCategory.SCANNER;
    }

    public static boolean IsCloudServerType(ServerType svrType) {
        return svrType == ServerType.Google_Linux_Server_Cloud || svrType == ServerType.ASUSTOR_NAS_Cloud || svrType == ServerType.ASUSTOR_NAS_AUTOMATION;
    }

    public static final PlatformForSecurity getPlatformForSecurity(Platform platform) {
        switch (1.$SwitchMap$com$penpower$worldcard$team$enums$Platform[platform.ordinal()]) {
            case 1: 
            case 2: {
                return PlatformForSecurity.IOS;
            }
            case 3: 
            case 4: {
                return PlatformForSecurity.ANDROID;
            }
            case 5: {
                return PlatformForSecurity.WINDOWS;
            }
            case 6: {
                return PlatformForSecurity.MAC;
            }
            case 7: {
                return PlatformForSecurity.WEB;
            }
            case 8: {
                return PlatformForSecurity.SCANNER;
            }
        }
        return null;
    }

    public static ServerType getServerType() {
        return serverType;
    }

    public static void setServerType(ServerType svrtype) {
        serverType = svrtype;
    }

    public static final PlatformForDevice getPlatformForDevice(Platform platform) {
        if (platform != Platform.WEB) {
            PlatformForSecurity platformForSecurtiy = GlobalUtils.getPlatformForSecurity((Platform)platform);
            return PlatformForDevice.valueOf((String)platformForSecurtiy.toString());
        }
        return null;
    }

    public static final List<Platform> getPlatformByPlatformForSecurity(PlatformForDevice platformForDevice) {
        ArrayList<Platform> platforms = new ArrayList<Platform>();
        switch (1.$SwitchMap$com$penpower$worldcard$team$enums$PlatformForDevice[platformForDevice.ordinal()]) {
            case 1: {
                platforms.add(Platform.IOS);
                platforms.add(Platform.IPAD);
                break;
            }
            case 2: {
                platforms.add(Platform.ANDROID);
                platforms.add(Platform.ANDROID_TABLET);
                break;
            }
            case 3: {
                platforms.add(Platform.PC);
                break;
            }
            case 4: {
                platforms.add(Platform.MAC);
                break;
            }
            case 5: {
                platforms.add(Platform.SCANNER);
            }
        }
        return platforms;
    }

    public static final void setProperty(CompanyGlobalInfoService globalInfoService, String ConfigureKey, String value, String companyGuid) {
        Globalinfocompany gObject = globalInfoService.getPropertiesByKey(ConfigureKey, companyGuid);
        if (gObject == null) {
            globalInfoService.createNewProperties(ConfigureKey, value, companyGuid);
        } else {
            globalInfoService.updatePropertyValue(gObject.getGuid(), value);
        }
    }

    public static final String getProperty(CompanyGlobalInfoService globalInfoService, String ConfigureKey, String companyGuid) {
        Globalinfocompany gObject = globalInfoService.getPropertiesByKey(ConfigureKey, companyGuid);
        if (gObject != null) {
            return gObject.getConfigValue();
        }
        return "";
    }

    public static final void setProperty(GlobalInfoService globalInfoService, String ConfigureKey, String value) {
        Globalinfo gObject = globalInfoService.getPropertiesByKey(ConfigureKey);
        if (gObject == null) {
            globalInfoService.createNewProperties(ConfigureKey, value);
        } else {
            globalInfoService.updatePropertyValue(gObject.getGuid(), value);
        }
    }

    public static final String getProperty(GlobalInfoService globalInfoService, String ConfigureKey) {
        Globalinfo gObject = globalInfoService.getPropertiesByKey(ConfigureKey);
        if (gObject != null) {
            return gObject.getConfigValue();
        }
        return "";
    }

    public static final boolean stringContainsChineseWord(String keyWord) {
        try {
            Pattern pattern = Pattern.compile("[\\u3000-\\u303F]+|[\\u9FA6-\\u9FBB]+|[\\u3400-\\u4DB5]+|[\\u4E00-\\u9FA5]+|[\\uF900-\\uFA2D]+|[\\uFA30-\\uFA6A]+|[\\uFA70-\\uFAD9]+|[\\uFF00-\\uFFEF]+|[\\u2E80-\\u2EFF]+|[\\u31C0-\\u31EF]+");
            Matcher matcher = pattern.matcher(keyWord);
            return matcher.find();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static final boolean collectionEmpty(Collection<?> collection) {
        return CollectionUtil.collectionEmpty(collection);
    }

    public static final String getFileContent(Path file) {
        Tika tika = new Tika();
        try {
            String fileContent = tika.detect(file);
            return fileContent;
        }
        catch (IOException e) {
            return "application/octet-stream";
        }
    }

    public static final String getFileContent(byte[] content) {
        Tika tika = new Tika();
        String fileContent = tika.detect(content);
        return fileContent;
    }

    private static String getFieldName(PageInfo<ContactField> pageInfo, NameDisplayOrderSettingType nameDisplayOrderSettingType) {
        String fieldName;
        ContactField field = (ContactField)pageInfo.getFieldOrderBy();
        switch (1.$SwitchMap$com$penpower$worldcard$team$enums$ContactField[field.ordinal()]) {
            case 1: {
                if (NameDisplayOrderSettingType.EAST_FL_WEST_FL.equals((Object)nameDisplayOrderSettingType)) {
                    fieldName = FIELD_NAME_NAME_EAST_FL_WEST_FL;
                    break;
                }
                if (NameDisplayOrderSettingType.EAST_FL_WEST_LF.equals((Object)nameDisplayOrderSettingType)) {
                    fieldName = FIELD_NAME_NAME_EAST_FL_WEST_LF;
                    break;
                }
                if (NameDisplayOrderSettingType.EAST_LF_WEST_FL.equals((Object)nameDisplayOrderSettingType)) {
                    fieldName = FIELD_NAME_NAME_EAST_LF_WEST_FL;
                    break;
                }
                fieldName = FIELD_NAME_NAME_EAST_LF_WEST_LF;
                break;
            }
            case 2: {
                fieldName = FIELD_NAME_COMPANY;
                break;
            }
            case 3: {
                fieldName = FIELD_NAME_DEPARTMENT;
                break;
            }
            case 4: {
                fieldName = FIELD_NAME_JOBTITLE;
                break;
            }
            case 5: {
                fieldName = FIELD_NAME_CREATED_TIME;
                break;
            }
            default: {
                fieldName = FIELD_NAME_CREATED_TIME;
            }
        }
        return fieldName;
    }

    public static final String getSortString(PageInfo<ContactField> pageInfo, NameDisplayOrderSettingType nameDisplayOrderSettingType) {
        String fieldName = GlobalUtils.getFieldName(pageInfo, (NameDisplayOrderSettingType)nameDisplayOrderSettingType);
        if (pageInfo.isAscendingOrder()) {
            return fieldName + " " + Sort.Direction.ASC.toString();
        }
        return fieldName + " " + Sort.Direction.DESC.toString();
    }

    public static final Sort getSortProperty(PageInfo<ContactField> pageInfo, NameDisplayOrderSettingType nameDisplayOrderSettingType) {
        String fieldName = GlobalUtils.getFieldName(pageInfo, (NameDisplayOrderSettingType)nameDisplayOrderSettingType);
        ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
        if (pageInfo.isAscendingOrder()) {
            orders.add(new Sort.Order(Sort.Direction.ASC, fieldName));
        } else {
            orders.add(new Sort.Order(Sort.Direction.DESC, fieldName));
        }
        if (!((ContactField)pageInfo.getFieldOrderBy()).equals((Object)ContactField.CREATED_TIME)) {
            orders.add(new Sort.Order(Sort.Direction.DESC, FIELD_NAME_CREATED_TIME));
        }
        orders.add(new Sort.Order(Sort.Direction.ASC, FIELD_NAME_GUID));
        Sort sort = new Sort(orders);
        return sort;
    }

    public static final String getJsonString(Object obj) {
        Gson gson = new Gson();
        String jsonString = gson.toJson(obj);
        return jsonString;
    }

    public static final <T> T getObjectFromJson(String json, Class<T> classOfT) {
        if (StringUtil.IsStringNullorEmpty((String)json)) {
            return null;
        }
        Gson gson = new Gson();
        Object resultContent = gson.fromJson(json, classOfT);
        return (T)resultContent;
    }

    public static List<String> getGuidsFromBasicItems(List<ItemBasicVo> basicItems) {
        ArrayList<String> guids = CollectionUtils.isEmpty(basicItems) ? new ArrayList<String>() : basicItems.stream().map(c -> c.getGuid()).collect(Collectors.toList());
        return guids;
    }

    public static String[] getGuidArrayFromBasicItems(List<ItemBasicVo> basicItems) {
        List guids = GlobalUtils.getGuidsFromBasicItems(basicItems);
        String[] guidArray = new String[guids.size()];
        guids.toArray(guidArray);
        return guidArray;
    }

    public static CRMOperationService getCrmOperationService(CrmTargetType crmTargetType) {
        CRMOperationService crmOperationService = null;
        ApplicationContext context = ApplicationContextProvider.getApplicationContext();
        switch (1.$SwitchMap$com$penpower$worldcard$team$enums$CrmTargetType[crmTargetType.ordinal()]) {
            case 1: {
                crmOperationService = (CRMOperationService)context.getBean("SalesforceLeadOperation");
                break;
            }
            case 2: {
                crmOperationService = (CRMOperationService)context.getBean("SalesforceContactOperation");
                break;
            }
            case 3: {
                crmOperationService = (CRMOperationService)context.getBean("SugarCRMOperation");
                break;
            }
            default: {
                throw new ItemNotFoundException("There is no specified CRM target type.");
            }
        }
        return crmOperationService;
    }

    public static IntervalFilter checkIntervalFilter(IntervalFilter filter) {
        IntervalFilter intervalFilter = filter;
        DateTime earliestTime = new DateTime(1900, 1, 1, 0, 0);
        DateTime currentTime = new DateTime();
        if (intervalFilter == null) {
            intervalFilter = new IntervalFilter(earliestTime, currentTime);
        } else {
            if (intervalFilter.getTimeStart() == null) {
                intervalFilter.setTimeStart(earliestTime);
            }
            if (intervalFilter.getTimeEnd() == null) {
                intervalFilter.setTimeEnd(currentTime);
            }
            if (intervalFilter.getTimeEnd().isBefore((ReadableInstant)intervalFilter.getTimeStart())) {
                throw new RequestArgumentNotValidException("End time of interval filter is before start time");
            }
        }
        return intervalFilter;
    }

    public static DateTime getEarliestTime() {
        return new DateTime(1900, 1, 1, 0, 0, 0, DateTimeZone.UTC);
    }

    public static Optional<?> getFirstListItem(List<?> listItem) {
        List objects = Optional.ofNullable(listItem).orElse(Collections.emptyList());
        Optional firstObject = objects.stream().findFirst();
        return firstObject;
    }

    public static String getFieldString(String inputString, int maxLength) {
        if (inputString == null) {
            return "";
        }
        String retStr = inputString.substring(0, Math.min(inputString.length(), maxLength));
        return retStr;
    }

    public static boolean isExceptionCategoryHasContactDuplicate(Exception e) {
        String rootCauseString = ExceptionUtils.getRootCause((Throwable)e).getMessage();
        return rootCauseString.contains("idx_17010_primary");
    }

    public static String getFieldString(String inputString) {
        return inputString == null ? "" : inputString;
    }

    public static Map<NameDisplayOrderSettingType, String> getNameOrderString(String firstName, String lastName) {
        HashMap<NameDisplayOrderSettingType, String> nameOrder = new HashMap<NameDisplayOrderSettingType, String>();
        String first = GlobalUtils.getFieldString((String)firstName);
        String last = GlobalUtils.getFieldString((String)lastName);
        String fullnameFL = String.format("%s%s", first, last);
        String fullnameLF = String.format("%s%s", last, first);
        if (!GlobalUtils.stringContainsChineseWord((String)fullnameFL)) {
            fullnameFL = String.format("%s %s", first, last);
            fullnameLF = String.format("%s %s", last, first);
            fullnameFL = fullnameFL.trim().replaceAll(" +", " ");
            fullnameLF = fullnameLF.trim().replaceAll(" +", " ");
            nameOrder.put(NameDisplayOrderSettingType.EAST_LF_WEST_FL, fullnameFL);
            nameOrder.put(NameDisplayOrderSettingType.EAST_FL_WEST_LF, fullnameLF);
        } else {
            nameOrder.put(NameDisplayOrderSettingType.EAST_LF_WEST_FL, fullnameLF);
            nameOrder.put(NameDisplayOrderSettingType.EAST_FL_WEST_LF, fullnameFL);
        }
        nameOrder.put(NameDisplayOrderSettingType.EAST_FL_WEST_FL, fullnameFL);
        nameOrder.put(NameDisplayOrderSettingType.EAST_LF_WEST_LF, fullnameLF);
        return nameOrder;
    }

    public static Path getdkimPath() {
        ClassLoader classLoader = GlobalUtils.class.getClassLoader();
        File file = new File(classLoader.getResource("dkim.der").getFile());
        String fileDecode = null;
        try {
            fileDecode = URLDecoder.decode(file.getAbsolutePath(), "UTF-8");
            LOG.info("getdkimPath={}", (Object)file.toPath());
            LOG.info("getdkimDecodePath={}", (Object)Paths.get(fileDecode, new String[0]));
            return Paths.get(fileDecode, new String[0]);
        }
        catch (UnsupportedEncodingException ex) {
            LOG.info("getdkimPath={}", (Object)file.toPath());
            LOG.info("getdkimDecodePath={}", (Object)fileDecode);
            return file.toPath();
        }
    }

    public static MimeMessage getDkimSignMessage(MimeMessage message) throws MessagingException, NoSuchAlgorithmException, InvalidKeySpecException, DkimException, IOException {
        String from = "WorldCard Team Service<wctservice@mail.worldcardteam.com>";
        String signingDomain = "mail.worldcardteam.com";
        String selector = "mail";
        String senderMail = from.substring(from.indexOf("<") + 1, from.indexOf(">"));
        DkimSigner dkimSigner = new DkimSigner(signingDomain, selector, GlobalUtils.getdkimPath().toFile());
        dkimSigner.setIdentity(senderMail);
        dkimSigner.setHeaderCanonicalization(Canonicalization.RELAXED);
        dkimSigner.setBodyCanonicalization(Canonicalization.RELAXED);
        dkimSigner.setSigningAlgorithm(SigningAlgorithm.SHA256_WITH_RSA);
        dkimSigner.setLengthParam(false);
        dkimSigner.setZParam(false);
        return new DkimMessage(message, dkimSigner);
    }
}

