/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.Utils;

import com.penpower.worldcard.team.Utils.DiskInfos;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.software.os.FileSystem;
import oshi.software.os.OSFileStore;
import oshi.software.os.OperatingSystem;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileSystemUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemUtil.class);
    private static final List<String> SUPPORT_FILE_SYSTEM_TYPES = new ArrayList();
    private static final long K = 1024L;
    private static final long M = 0x100000L;
    private static final long G = 0x40000000L;
    private static final long T = 0x10000000000L;

    public static final String convertToStringRepresentation(long value) {
        long[] dividers = new long[]{0x10000000000L, 0x40000000L, 0x100000L, 1024L, 1L};
        String[] units = new String[]{"TB", "GB", "MB", "KB", "B"};
        if (value < 1L) {
            throw new IllegalArgumentException("Invalid file size: " + value);
        }
        String result = null;
        for (int i = 0; i < dividers.length; ++i) {
            long divider = dividers[i];
            if (value < divider) continue;
            result = FileSystemUtil.format((long)value, (long)divider, (String)units[i]);
            break;
        }
        return result;
    }

    private static String format(long value, long divider, String unit) {
        double result = divider > 1L ? (double)value / (double)divider : (double)value;
        return new DecimalFormat("#,##0.00").format(result) + " " + unit;
    }

    public static final DiskInfos getDiskInfos(Path path) {
        LOG.debug("path : {} ", (Object)path);
        File fileSystemRootFile = path.toFile();
        long totalSpaceBytes = fileSystemRootFile.getTotalSpace();
        long usableSpaceBytes = fileSystemRootFile.getFreeSpace();
        LOG.debug("fileSystemRootFile : {} ", (Object)fileSystemRootFile);
        LOG.debug("totalSpaceBytes : {} ", (Object)totalSpaceBytes);
        LOG.debug("usableSpaceBytes : {} ", (Object)usableSpaceBytes);
        return new DiskInfos(totalSpaceBytes, usableSpaceBytes);
    }

    public static final double getPercentageValue(long numerator, long denominator) {
        double percent = (double)numerator / (double)denominator;
        return percent * 100.0;
    }

    public static final boolean storageLessThan50GReadOnlyMode(DiskInfos diskInfos) {
        long usableSpaceBytes = diskInfos.getUsableSpaceBytes();
        LOG.debug("usableSpaceBytes : {}", (Object)usableSpaceBytes);
        LOG.debug("lessThanLimitBytes : {}", (Object)0xC80000000L);
        return usableSpaceBytes < 0xC80000000L;
    }

    public static final boolean storageLessThan100GSendNotice(DiskInfos diskInfos) {
        long usableSpaceBytes = diskInfos.getUsableSpaceBytes();
        return usableSpaceBytes < 0x1900000000L;
    }

    public static final void deleteDirectory(Path pathToDelete) throws IOException {
        LOG.debug("remove directory : {} ", (Object)pathToDelete);
        boolean pathToDeleteExists = Files.exists(pathToDelete, new LinkOption[0]);
        if (pathToDeleteExists) {
            try (Stream<Path> walkPathStream = Files.walk(pathToDelete, FileVisitOption.FOLLOW_LINKS);){
                walkPathStream.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
        }
    }

    public static boolean verifySupportFileSystem(Path backpPath) {
        LOG.debug("Verify the backup path file system.... , backpPath: {}", (Object)backpPath);
        SystemInfo si = new SystemInfo();
        OperatingSystem os = si.getOperatingSystem();
        FileSystem fs = os.getFileSystem();
        OSFileStore[] oSFileStores = fs.getFileStores();
        List OSFileStoresResult = Arrays.stream(oSFileStores).filter(osFileStore -> osFileStore.getMount().equals(backpPath.toString())).collect(Collectors.toList());
        if (OSFileStoresResult == null || OSFileStoresResult.size() <= 0) {
            return false;
        }
        OSFileStore oSFileStore = (OSFileStore)OSFileStoresResult.get(0);
        String type = oSFileStore.getType().toLowerCase();
        boolean supportFileSystem = SUPPORT_FILE_SYSTEM_TYPES.contains(type);
        LOG.debug("SUPPORT_FILE_SYSTEM_TYPES : {} ", (Object)SUPPORT_FILE_SYSTEM_TYPES);
        LOG.debug("type : {} ", (Object)type);
        LOG.debug("supportFileSystem : {} ", (Object)supportFileSystem);
        return supportFileSystem;
    }

    static {
        SUPPORT_FILE_SYSTEM_TYPES.add("ext4");
        SUPPORT_FILE_SYSTEM_TYPES.add("ufsd");
        SUPPORT_FILE_SYSTEM_TYPES.add("ntfs");
        SUPPORT_FILE_SYSTEM_TYPES.add("fuseblk.ntfs");
    }
}

