/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.Utils;

import com.fatboyindustrial.gsonjodatime.Converters;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.penpower.worldcard.team.Utils.DatabaseCreationTime;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DatabaseCreationTimeUtil {
    @Value(value="${SettingFilePath:NULL}")
    private String settingFilePath;
    private Gson gson = Converters.registerDateTime((GsonBuilder)new GsonBuilder()).create();

    public final boolean IsSettingFileExist() {
        Path filePath = Paths.get(this.settingFilePath, new String[0]);
        return Files.exists(filePath, new LinkOption[0]);
    }

    public final void writeCreationTime(DatabaseCreationTime databaseCreationTime) {
        Path filePath = Paths.get(this.settingFilePath, new String[0]);
        try (FileWriter writer = new FileWriter(filePath.toFile(), false);){
            this.gson.toJson((Object)databaseCreationTime, (Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException("Write json file failed.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final DatabaseCreationTime readDatabaseCreationTime() {
        Path filePath = Paths.get(this.settingFilePath, new String[0]);
        if (!Files.exists(filePath, new LinkOption[0])) throw new RuntimeException("DatabaseCreationTime file not found.");
        try (FileReader fr = new FileReader(filePath.toFile());){
            DatabaseCreationTime databaseCreationTime;
            DatabaseCreationTime databaseCreationTime2 = databaseCreationTime = (DatabaseCreationTime)this.gson.fromJson((Reader)fr, DatabaseCreationTime.class);
            return databaseCreationTime2;
        }
        catch (IOException ex) {
            throw new RuntimeException("Fail to read json filed.", ex);
        }
    }
}

