/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.Utils;

import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.crypto.RuntimeCryptoException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AesUtil {
    private static final Logger LOG = LoggerFactory.getLogger(AesUtil.class);
    private byte[] kAESKey = new byte[]{83, -6, -97, -79, -81, -112, 22, 73, 59, 50, 6, -31, -69, 100, 30, -12, 112, 104, 23, -18, -44, 69, 21, -121, -30, -79, 44, -111, 113, -122, -91, 97};
    private byte[] kAESIV = new byte[]{51, -118, -21, -124, -59, -112, -107, -79, -44, -24, 79, -39, -30, 82, -64, 58};
    private Cipher ecipher;
    private Cipher dcipher;

    public AesUtil() throws Exception {
        Security.setProperty("crypto.policy", "unlimited");
        AlgorithmParameters params = AlgorithmParameters.getInstance("AES");
        params.init(new IvParameterSpec(this.kAESIV));
        SecretKeySpec secret = new SecretKeySpec(this.kAESKey, "AES");
        LOG.debug("Aes key length : {}", (Object)this.kAESKey.length);
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.ecipher = Cipher.getInstance("AES/CBC/PKCS7Padding");
        this.ecipher.init(1, (Key)secret, params);
        this.dcipher = Cipher.getInstance("AES/CBC/PKCS7Padding");
        this.dcipher.init(2, (Key)secret, params);
    }

    public String encodeBase64(String value) {
        byte[] encodedByte = null;
        try {
            encodedByte = this.ecipher.doFinal(value.getBytes());
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            LOG.error("Fail to encode value.....", (Throwable)e);
            throw new RuntimeCryptoException(e.getMessage());
        }
        return Base64.encodeBase64String((byte[])encodedByte);
    }

    public byte[] encodeByte(String value) {
        byte[] encodedByte = null;
        try {
            encodedByte = this.ecipher.doFinal(value.getBytes());
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            LOG.error("Fail to encode value.....", (Throwable)e);
            throw new RuntimeCryptoException(e.getMessage());
        }
        return encodedByte;
    }

    public byte[] decodeFromBase64(String base64) {
        byte[] decodeByte = Base64.decodeBase64((String)base64);
        byte[] decoded = null;
        try {
            decoded = this.dcipher.doFinal(decodeByte);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            LOG.error("Fail to decode value.....", (Throwable)e);
            throw new RuntimeCryptoException(e.getMessage());
        }
        return decoded;
    }

    public byte[] decode(byte[] b) {
        byte[] decoded = null;
        try {
            decoded = this.dcipher.doFinal(b);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            LOG.error("Fail to decode value.....", (Throwable)e);
            throw new RuntimeCryptoException(e.getMessage());
        }
        return decoded;
    }
}

