﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Newtonsoft.Json;
using WctCustomerApiSample.Api;

namespace WctCustomerApiSample.Model
{
    class ContactsRequestModel : WctGetContactInfosRequest
    {
        ContactsRequestModel()
        {
            modifiedTimeFrom = null;
            isDeletedSkip = false;
            contactNumberGet = 50;
        }

        public static ContactsRequestModel Load()
        {
            var settings = Properties.Settings.Default;
            ContactsRequestModel model = JsonConvert.DeserializeObject<ContactsRequestModel>(settings.ContactsRequestModel);
            if (model == null)
            {
                return new ContactsRequestModel();
            }

            return model;
        }
        public static void Save(ContactsRequestModel model)
        {
            Properties.Settings.Default.ContactsRequestModel = JsonConvert.SerializeObject(model);
            Properties.Settings.Default.Save();
        }

        public static ContactsRequestModel GetFromConsole()
        {
            ContactsRequestModel model = Load();
            Console.WriteLine("\r\nPlease enter required parameters for getting contatcs, press Enter if you want to use current value.\n");

            Console.WriteLine("Start time for download? (Current value: {0})", model.modifiedTimeFrom);
            Console.WriteLine("(refer to contact modify time, input format is {0})", BaseService.WCT_DATE_TIME_FORMAT);
            string st = Console.ReadLine();
            if (!String.IsNullOrEmpty(st))
            {
                model.modifiedTimeFrom = st;
            }

            Console.WriteLine("Skip deleted contacts? (Current value: {0})", model.isDeletedSkip);
            Console.WriteLine("(Input options: \"true\" or \"false\")");
            st = Console.ReadLine();
            if (!String.IsNullOrEmpty(st))
            {
                if (st.Equals("true"))
                {
                    model.isDeletedSkip = true;
                }
                else
                {
                    model.isDeletedSkip = false;
                }
            }

            Console.WriteLine("How many contacts to be downloaded? (Current value: {0})", model.contactNumberGet);
            st = Console.ReadLine();
            if (!String.IsNullOrEmpty(st))
            {
                int contactNumGet;
                if (int.TryParse(st, out contactNumGet))
                {
                    model.contactNumberGet = contactNumGet;
                }
            }

            return model;
        }
        //public override string ToString()
        //{
        //    StringBuilder builder = new StringBuilder();
        //    builder.AppendLine("Get from TIME: " + modifiedTimeFrom);
        //    builder.AppendLine("Skip deletect? " + isDeletedSkip);
        //    builder.AppendLine("Number get: " + contactNumberGet);
        //    return builder.ToString();
        //}
    }
}
