﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace WctCustomerApiSample.Example
{
    class QueryHostInfo : IExample
    {
        public string Host
        {
            get
            {
                return Properties.Settings.Default.Host;
            }
            set
            {
                Properties.Settings.Default.Host = value;
                Properties.Settings.Default.Save();
            }
        }
        public string OutputDirectory
        {
            get
            {
                return Properties.Settings.Default.OutputDirectory;
            }
            set
            {
                Properties.Settings.Default.OutputDirectory = value;
                Properties.Settings.Default.Save();
            }
        }

        public QueryHostInfo()
        {
            if (System.IO.Directory.Exists(this.OutputDirectory) == false)
            {
                this.OutputDirectory = System.IO.Path.GetTempPath();
            }
        }

        public string Brief()
        {
            return "Query and set Host info";
        }

        public void RunIt()
        {
            // Prompt user input host url
            Console.Out.WriteLine("Current Host: " + this.Host);
            Console.Out.WriteLine("Please enter the Host url, or press Enter to continue...");
            var host = Console.In.ReadLine();
            if (string.IsNullOrEmpty(host) == false)
            {
                Host = host;
            }

            // Specify directory of output logs, that will be set by default value first.
            Console.Out.WriteLine("Current output directory: " + this.OutputDirectory);
            Console.Out.WriteLine("Enter new output directory path, or press Enter to continue...");
            string dir = Console.In.ReadLine();
            if (string.IsNullOrWhiteSpace(dir) == false && System.IO.Directory.Exists(dir))
            {
                this.OutputDirectory = dir;
            }
        }
    }
}
