﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using WctCustomerApiSample.Api;
using WctCustomerApiSample.Model;
using WctCustomerApiSample.Utility;
using System.Windows.Forms;

namespace WctCustomerApiSample.Example
{
    class GetContactsByAccountPrivate : IExample {
        public string Brief()
        {
            return "Get contacts from specified modify time (In private contacts of login account)";
        }

        public void RunIt()
        {
            var settings = Properties.Settings.Default;

            AccountApiService accountService = new AccountApiService(settings.Host);

            LoginInfo loginInfo = GetAccounts.LoginProcess(accountService);
            if (loginInfo == null)
            {
                return;
            }
            string token = loginInfo.tokenInfo.token;

            ContactsRequestModel model = ContactsRequestModel.GetFromConsole();

            ContactApiService contactService = new ContactApiService(settings.Host);
            List<ContactInfo> contactInfos = 
                contactService.getListByAccountPrivate(token, model.contactNumberGet, model.isDeletedSkip, model.modifiedTimeFrom, loginInfo.accountInfo.guid);

            if (contactInfos.IsNullOrEmpty())
            {
                MessageBox.Show("No contacts downloaded.");
            }

            ContactsRequestModel.Save(model);

            GetContacts.GetContactTextAndImagesByInfos(contactInfos, token);
        }
    }
}
