﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using WctCustomerApiSample.Api;
using WctCustomerApiSample.Model;
using WctCustomerApiSample.Utility;
using System.IO;
using Newtonsoft.Json;

namespace WctCustomerApiSample.Example
{
    class GetContacts : IExample
    {
        public string Brief()
        {
            return "Get contacts from specified modify time";
        }

        public void RunIt()
        {
            var settings = Properties.Settings.Default;

            AccountApiService accountService = new AccountApiService(settings.Host);

            LoginInfo loginInfo = GetAccounts.LoginProcess(accountService);
            if (loginInfo==null){
                return;
            }
            string token = loginInfo.tokenInfo.token;

            ContactsRequestModel model = ContactsRequestModel.GetFromConsole();

            ContactApiService contactService = new ContactApiService(settings.Host);
            List<ContactInfo> contactInfos = contactService.getList(token, model.contactNumberGet, model.isDeletedSkip, model.modifiedTimeFrom);

            if (contactInfos.IsNullOrEmpty())
            {
                MessageBox.Show("No contacts downloaded.");
            }

            ContactsRequestModel.Save(model);

            GetContactTextAndImagesByInfos(contactInfos, token);
        }
        static public void GetContactTextAndImagesByInfos(List<ContactInfo> contactInfos, string token)
        {
            if (contactInfos == null)
            { 
                Console.WriteLine("\r\nNo Contact Result");
                return;
            }
            var settings = Properties.Settings.Default;
            ContactApiService contactService = new ContactApiService(settings.Host);

            int index = 0;
            foreach (var info in contactInfos)
            {
                //如果這張名片之前已下載過,並且這次沒有修改文字內容,那文字的sha1值就不會變,可以不需要重複下載
                //if (info.contentSha1.Equals(XXX)) { }

                Console.WriteLine("\r\nContact No. {0}:", index++);
                WctContact contact = contactService.getContactText(token, info.contactGuid);
                string json = JsonConvert.SerializeObject(contact);
                Console.WriteLine(json);

                List<Image> images = info.images;
                if (info.images.IsNullOrEmpty())
                    continue;

                foreach (var image in images)
                {
                    //如果這張名片影像之前已下載過,並且這次沒有修改這張名片影像,那影像的sha1值就不會變,可以不需要重複下載
                    //if (image.sha1.Equals(XXX)) { }

                    string imageBase64 = contactService.getContactImage(token, info.contactGuid, image.type);
                    string timeString = contact.modifyTime.Replace(":", "");
                    timeString = timeString.Replace(".", "");
                    string filepath = String.Format("{0}{1}_{2}_{3}.jpg", settings.OutputDirectory, timeString, info.contactGuid, image.type);
                    var bytes = Convert.FromBase64String(imageBase64);
                    using (var imageFile = new FileStream(filepath, FileMode.Create))
                    {
                        imageFile.Write(bytes, 0, bytes.Length);
                        imageFile.Flush();
                    }
                    Console.WriteLine("---Write contact image to file: {0}", filepath);
                }
            }
        }
    }
}
