﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Web;
using WctCustomerApiSample.Model;

namespace WctCustomerApiSample.Api
{
    class AccountApiService : BaseService
    {
        const int WctResponseSuccessCode = 200;

        public AccountApiService(string host) : base(host) { 
        }

        public bool isConnectable() {
            var httpResponse = GetHttpResponse("system/IsAlive");

            return httpResponse.IsSuccessStatusCode;
        }

        public LoginInfo login(string email, string password) { 
            WctLoginRequest request = new WctLoginRequest();
            request.email = email;
            request.password = password;
            request.platform = Platform.PC;
            request.deviceId = "mypcid";
            request.deviceName = "mypcname";
            request.clientLocalTime = DateTime.UtcNow.ToString(WCT_DATE_TIME_FORMAT);

            WctLoginResponse response = Post<WctLoginRequest, WctLoginResponse>("auth/login_with_ad",request);

            if (!response.errorCode.Equals(WctResponseSuccessCode))
            {
                Console.WriteLine("login fail :" + response.errorCode.ToString());
                return null;
            }

            return response.data;
        }

        public List<AccountInfoLess> getAccounts(string token)
        {
            WctListResponse<AccountInfoLess> response =
                Post<WctListResponse<AccountInfoLess>>("customer/account/get_all", token);

            return response.data;
        }

    }
}
