﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using WctCustomerApiSample.Example;

namespace WctCustomerApiSample
{
    class Program
    {
        static void Main(string[] args)
        {
            new QueryHostInfo().RunIt();

            var examples = new List<IExample>()
            {
                new Exit(),
                new QueryHostInfo(),
                new GetAccounts(),
                new GetContacts(),
                new GetContactsByAccountPrivate(),
                new GetContactsByOwner(),
            };

            while (true)
            {
                Console.Clear();
                for (int i = 0; i < examples.Count; ++i)
                {
                    Console.WriteLine(i.ToString() + ": " + examples[i].Brief());
                }
                Console.WriteLine("\r\nPlease choose one to do: (0 ~ {0})", examples.Count - 1);

                //! Check chosen value
                int choose = 0;
                bool valid = int.TryParse(Console.In.ReadLine(), out choose);
                if (!valid)
                {
                    ShowInvailInputMessage();
                    continue;
                }
                if (choose < 0 || choose >= examples.Count)
                {
                    ShowInvailInputMessage();
                    continue;
                }

                Console.Clear();
                examples[choose].RunIt();

                Console.Write("\r\nPress Enter to back.");
                Console.ReadLine();
            }
        }

        private static void ShowInvailInputMessage()
        {
            Console.WriteLine("Invalid input");
            Console.ReadLine();
        }
    }
}
