﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace WctCustomerApiSample.Model
{
    public class WctLoginResponse : WctBaseResponse<LoginInfo>
    {
        public LoginCode loginCode { get; set; }
    }

    public class LoginInfo
    {
        public AccountInfo accountInfo { get; set; }
        public string serverId { get; set; }
        public string serverTime { get; set; }
        public string serverVersion { get; set; }
        public TokenInfo tokenInfo { get; set; }
    }

    public class TokenInfo
    {
        public string createdTime { get; set; }
        public string expiredTime { get; set; }
        public string invalidTime { get; set; }
        public Platform platform { get; set; }
        public PlatformCategory platformCategory { get; set; }
        public string token { get; set; }
    }

    public class LoginCode
    {
        public string code { get; set; }
        public string hwid1 { get; set; }
        public string hwid2 { get; set; }
    }

    public enum PlatformCategory
    {
        WEB, PC, MOBILE_PHONES, TABLET_IPADS
    }

}
