﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace WctCustomerApiSample.Model
{
    public class WctContact
    {
        public List<Address> addresses { get; set; }
        public bool beCorrected { get; set; }
        public string birthday { get; set; }
        public string contentSha1 { get; set; }
        public string createTime { get; set; }
        public string creatorGuid { get; set; }
        public List<CustomDataList> customDataList { get; set; }
        public List<Date> dates { get; set; }
        public string editorGuid { get; set; }
        public List<Email> emails { get; set; }
        public string guid { get; set; }
        public List<Image> images { get; set; }
        public List<Im> ims { get; set; }
        public List<Jobinfo> jobinfos { get; set; }
        public string modifyTime { get; set; }
        public List<Name> names { get; set; }
        public string nickname { get; set; }
        public string note { get; set; }
        public string ownerGuid { get; set; }
        public List<Phone> phones { get; set; }
        public int recogLanguageBack { get; set; }
        public int recogLanguageFront { get; set; }
        public List<Social> socials { get; set; }
        public string uniformNumber { get; set; }
        public List<Url> urls { get; set; }
    }
    public class Address
    {
        public int addressFormat { get; set; }
        public string city { get; set; }
        public string countryCode { get; set; }
        public string countryName { get; set; }
        public string guid { get; set; }
        public RecognizeSourceType recognizeSource { get; set; }
        public string state { get; set; }
        public string street { get; set; }
        public ContactFieldType type { get; set; }
        public string zip { get; set; }
    }

    public class CustomDataList
    {
        public string customfieldSettingGuid { get; set; }
        public string fieldCaption { get; set; }
        public CustomFieldContactAttribute fieldType { get; set; }
        public string guid { get; set; }
        public string textValue { get; set; }
    }

    public class Date
    {
        public string guid { get; set; }
        public ContactDateType type { get; set; }
        public string value { get; set; }
    }

    public class Email
    {
        public string guid { get; set; }
        public RecognizeSourceType recognizeSource { get; set; }
        public ContactFieldType type { get; set; }
        public string value { get; set; }
    }

    public class Im
    {
        public string guid { get; set; }
        public RecognizeSourceType recognizeSource { get; set; }
        public ContactIMType type { get; set; }
        public string value { get; set; }
    }

    public class Jobinfo
    {
        public string companyName { get; set; }
        public string companyPronunce { get; set; }
        public string department { get; set; }
        public string guid { get; set; }
        public string jobTitle { get; set; }
        public RecognizeSourceType recognizeSource { get; set; }
    }

    public class Name
    {
        public string firstName { get; set; }
        public string firstNamePronunce { get; set; }
        public string guid { get; set; }
        public string lastName { get; set; }
        public string lastNamePronunce { get; set; }
        public string middleName { get; set; }
        public string prefix { get; set; }
        public RecognizeSourceType recognizeSource { get; set; }
        public string suffix { get; set; }
    }

    public class Phone
    {
        public string guid { get; set; }
        public RecognizeSourceType recognizeSource { get; set; }
        public ContactPhoneType type { get; set; }
        public string value { get; set; }
    }

    public class Social
    {
        public string guid { get; set; }
        public RecognizeSourceType recognizeSource { get; set; }
        public ContactSocialType type { get; set; }
        public string value { get; set; }
    }

    public class Url
    {
        public string guid { get; set; }
        public RecognizeSourceType recognizeSource { get; set; }
        public ContactUrlType type { get; set; }
        public string value { get; set; }
    }

    public class Image
    {
        public string guid { get; set; }
        public string sha1 { get; set; }
        public ContactImageType type { get; set; }
    }

    public enum ContactImageType
    {
        FRONT,
        REAR,
        LOGO
    }
    public enum RecognizeSourceType
    {
        FRONT_CARD, BACK_CARD, MANUAL
    }
    public enum ContactFieldType
    {
        HOME,
        BUSINESS,
        OTHER
    }
    public enum ContactPhoneType
    {
        HOME_TEL,
        BUSINESS_TEL,
        HOME_FAX,
        BUSINESS_FAX,
        OTHER_TEL,
        OTHER_FAX,
        CELL,
        MAIN,
        BBCALL,
        GOOGLE_VOICE,
        IPHONE
    }
    public enum ContactUrlType
    {
        MAIN, HOME, BUSINESS, PERSONAL, BLOG, OTHER
    }
    public enum ContactIMType
    {
        MSN, SKYPE, QQ, YAHOO, ICQ, GOOGLE_TALK, JABBER, AIM, GADU_GADU, OTHER
    }
    public enum ContactSocialType
    {
        TWITTER, FACEBOOK, FLICKER, LINKEDIN, MYSPACE, WEIBO, OTHER
    }
    public enum ContactDateType
    {
        CELEBRATION,
        OTHER
    }
    public enum CustomFieldContactAttribute
    {
        TEXT, EMAIL, PICKLIST, NUMBER, FLOAT, DATE, DATE_TIME
    }

}
