﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Web;
using WctCustomerApiSample.Model;

namespace WctCustomerApiSample.Api
{
    class ContactApiService : BaseService
    {
        public ContactApiService(string host) : base(host) { }

        public List<ContactInfo> getList(string token, int contactNumberGet, bool isDeletedSkip, string modifiedTimeFrom)
        {
            WctGetContactInfosRequest request = new WctGetContactInfosRequest();
            request.contactNumberGet = contactNumberGet;
            request.isDeletedSkip = isDeletedSkip;
            request.modifiedTimeFrom = modifiedTimeFrom;

            WctListResponse<ContactInfo> response =
                Post<WctGetContactInfosRequest, WctListResponse<ContactInfo>>("customer/contact/get_list_from_time", token, request);

            return response.data;
        }

        public List<ContactInfo> getListByAccountPrivate(string token, int contactNumberGet, bool isDeletedSkip, string modifiedTimeFrom, string accountGuid)
        {
            WctGetContactInfosByAccountRequest request = new WctGetContactInfosByAccountRequest();
            request.contactNumberGet = contactNumberGet;
            request.isDeletedSkip = isDeletedSkip;
            request.modifiedTimeFrom = modifiedTimeFrom;
            request.accountGuid = accountGuid;

            WctListResponse<ContactInfo> response =
                Post<WctGetContactInfosByAccountRequest, WctListResponse<ContactInfo>>("customer/contact/get_list_from_time_by_account", token, request);

            return response.data;
        }

        public List<ContactInfo> getListByOwner(string token, int contactNumberGet, bool isDeletedSkip, string modifiedTimeFrom, string accountGuid)
        {
            WctGetContactInfosByAccountRequest request = new WctGetContactInfosByAccountRequest();
            request.contactNumberGet = contactNumberGet;
            request.isDeletedSkip = isDeletedSkip;
            request.modifiedTimeFrom = modifiedTimeFrom;
            request.accountGuid = accountGuid;

            WctListResponse<ContactInfo> response =
                Post<WctGetContactInfosByAccountRequest, WctListResponse<ContactInfo>>("customer/contact/get_list_from_time_by_owner", token, request);

            return response.data;
        }

        public WctContact getContactText(string token, string contactGuid)
        {
            var query = HttpUtility.ParseQueryString(string.Empty);
            query["contactGuid"] = contactGuid;
            string queryString = "?" + query.ToString();

            WctBaseResponse<WctContact> response = Post<WctBaseResponse<WctContact>>("customer/contact/get_content" + queryString, token);

            return response.data;
        }

        public string getContactImage(string token, string contactGuid, ContactImageType imageType)
        {
            var query = HttpUtility.ParseQueryString(string.Empty);
            query["contactGuid"] = contactGuid;
            query["imageType"] = imageType.ToString();
            string queryString = "?" + query.ToString();

            WctBaseResponse<string> response = Get<WctBaseResponse<string>>("customer/contact/get_image_base64" + queryString, token);

            return response.data;
        }

    }
}
