//
//  WCTLoginViewController.h
//  
//
//  Created by Howard on 16/3/28.
//  Copyright (c) 2016年 penpower. All rights reserved.
//

// Define
#import "WCTLoginViewController+ParameterDefine.h"
#import "WCTLoginViewController+ResourceDefine.h"
#import "TSMCRegisterViewController+ResourceDefine.h"
#import "TSMCRegisterViewController+SettingsKey.h"
#import "TSMCRegisterViewControllerDelegate.h"

// Controller
#import "PPEditableTableViewController.h"
#import "PPSectionController.h"

// View
#import "PPButton.h"
#import "PPTextFieldTableViewCell.h"

// Cateogry
#import "UIViewController+ShareApplication.h"
#import "NSError+Custom.h"
#import "UIView+Appearance.h"

typedef void(^TripleClickBlock)(UIView *view);
typedef NSError *(^RegisterHandler)(NSString *name, NSString *email, NSString *password);
typedef NSString *(^ErrroMessageHandler)(NSError *error);
////////////////////////////////////////////////////////////////////////////////////////////////////

@interface TSMCRegisterViewController : PPEditableTableViewController
<
PPButtonDelegate,
PPTextFieldTableViewCellDelegate,
UIAlertViewDelegate,
UIActionSheetDelegate,
UITableViewDataSource,
UITableViewDelegate
>

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property(nonatomic,assign)          id<TSMCRegisterViewControllerDelegate>  delegate;
@property(nonatomic,readonly)        UIImageView                      *logoImageView;
@property(nonatomic,retain)          NSString                      *versionString;

@property(nonatomic,retain,readonly)           UIView                  *tableFooterView;
@property(nonatomic,retain,readonly)           PPButton                *ppButtonCreate;
@property(nonatomic,retain,readonly)           PPButton                *ppButtonBack;

@property(nonatomic,readonly)         PPSectionController     *ppSectionController;

@property(nonatomic,copy) RegisterHandler registerHandler;
@property(nonatomic,copy) ErrroMessageHandler errorMessageHandler;

@end
