//
//  TSMCNoAccountSalesforceContactViewController.m
//  WorldCardMobile7
//
//  Created by sanhue on 2015/7/30.
//  Copyright (c) 2015年 penpower. All rights reserved.
//

#import "TSMCNoAccountSalesforceContactViewController.h"

//define
#import "ResourceDefine.h"
#import "WCDataControllerProtocol.h"

//categories
#import "PPButton+BarButton.h"
#import "NSObject+PPBusyView.h"
//views
#import "PPNavigationBarView.h"

// controllers
#import "WCCardModel.h"


////////////////////////////////////////////////////////////////////////////////////////////////////
typedef NS_ENUM(NSInteger, TSMCNoAccountSalesforceContactViewControllerButtonTag)
{
    TSMCNoAccountSalesforceContactViewControllerButtonTag_MultiSelect = 0,
    TSMCNoAccountSalesforceContactViewControllerButtonTag_Cancel,
};

////////////////////////////////////////////////////////////////////////////////////////////////////
@interface TSMCNoAccountSalesforceContactViewController ()
<
PPButtonDelegate
>

//views
@property (nonatomic, retain) PPNavigationBarView *ppNavigationBarView;
@property (nonatomic, retain) PPButton *ppButtonMultiSelect;
@property (nonatomic, retain) PPButton *ppButtonCancel;

@property (nonatomic, retain) NSArray *layoutConstraints;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation TSMCNoAccountSalesforceContactViewController





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
+ (void)initialize
{
}


//==============================================================================
//
//==============================================================================
- (instancetype)initWithMode:(PPSIC_Mode)mode
{
    self = [super initWithMode:mode];
    if (self)
    {
        self.titleString = TSMCNoAccountSalesfoceContactContactsViewController_Title;
        self.noResultString = Common_NoContacts_NoSalesforceAccount;
        
        NSNotificationCenter *nc = [NSNotificationCenter defaultCenter];
        [nc addObserver:self selector:@selector(recvDisplayDataChanged:) name:WCDC_NOTIFY_DisplayDataChanged object:nil];
    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    [[NSNotificationCenter defaultCenter] removeObserver:self ];
    [self removeLayoutConstraints];
    [self removeMainUI];

    self.titleString = nil;
    //////////////////////////////////////////////////
    [super dealloc];
}







////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - view controller life cycle


//==============================================================================
//
//==============================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////
    [self loadData];
    
    [self prepareMainUI];
}


//==============================================================================
//
//==============================================================================
- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    
    //////////////////////////////////////////////////
    if (UI_USER_INTERFACE_IDIOM()==UIUserInterfaceIdiomPad)
    {
        [self adjustCurrentSelectedIndexPath];
        [self selectCurrentCard];
        [self activeCurrentSelectCell];
    }
}


//==============================================================================
//
//==============================================================================
- (void)viewWillDisappear:(BOOL)animated
{
    //////////////////////////////////////////////////
    
    [super viewWillDisappear:animated];
}


//==============================================================================
//
//==============================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    [self removeMainUI];
    //////////////////////////////////////////////////
    
    [super viewDidDisappear:animated];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - prepare ui


//==============================================================================
//
//==============================================================================
- (void)prepareMainUI
{
    self.ppButtonMultiSelect = [PPButton ppButtonWithIconImageName:MainViewButtonIconName_MultiSelect
                                                               tag:TSMCNoAccountSalesforceContactViewControllerButtonTag_MultiSelect
                                                          delegate:self];
    
    //////////////////////////////////////////////////
    self.ppButtonCancel = [PPButton ppButtonWithIconImageName:CommonButtonName_Back
                                                          tag:TSMCNoAccountSalesforceContactViewControllerButtonTag_Cancel
                                                     delegate:self];

    //////////////////////////////////////////////////
    _ppNavigationBarView = [[PPNavigationBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds];
    
    if (self.ppNavigationBarView)
    {
        
        [self.ppNavigationBarView setStyle:PPBarViewStyle_CenteredAbsolute];

        [self.ppNavigationBarView.titleLabel setText:self.titleString];
        //////////////////////////////////////////////////
        if (self.ppButtonMultiSelect)
        {
            PPBarViewItemModel * itemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.ppButtonMultiSelect];
            itemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
            
            [self.ppNavigationBarView  setItemModels:@[itemModel] forBlockType:PPBarViewBlockType_Right];
        }
        
        if (self.ppButtonCancel)
        {
            PPBarViewItemModel * itemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.ppButtonCancel];
            itemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
            
            [self.ppNavigationBarView  setItemModels:@[itemModel] forBlockType:PPBarViewBlockType_Left];
        }
        
        //////////////////////////////////////////////////
        if (self.navigationController!=nil)
        {
            self.navigationItem.leftBarButtonItem = [[[UIBarButtonItem alloc] initWithCustomView:self.ppNavigationBarView] autorelease];
        }
    }

}


//==============================================================================
//
//==============================================================================
- (void)removeMainUI
{
    self.navigationItem.leftBarButtonItem = nil;
    
    self.ppButtonMultiSelect = nil;
    self.ppButtonCancel = nil;
    
    self.ppNavigationBarView = nil;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - layout constraints


//==============================================================================
//
//==============================================================================
- (void)resetLayoutConstraints
{
    [self removeLayoutConstraints];
    //////////////////////////////////////////////////
    NSMutableArray *layoutConstraints = [NSMutableArray array];
    
    
    //////////////////////////////////////////////////
    if ([layoutConstraints count])
    {
        self.layoutConstraints = [NSArray arrayWithArray:layoutConstraints];
        [self.view addConstraints:self.layoutConstraints];
        [self.view layoutIfNeeded];
    }
}


//==============================================================================
//
//==============================================================================
- (void)removeLayoutConstraints
{
    if (self.layoutConstraints)
    {
        [self.view removeConstraints:self.layoutConstraints];
        self.layoutConstraints = nil;
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - load data


//==============================================================================
//
//==============================================================================
- (void)loadData
{
    __block typeof(self) blockSelf = self;
    [self setBusy:@(YES)];
    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
        
        if ([blockSelf.delegate respondsToSelector:@selector(contactArrayWithNoAccountSalesforceContactViewController:error:)])
        {
            NSError *error = nil;
            NSMutableArray *allSection = [blockSelf.delegate contactArrayWithNoAccountSalesforceContactViewController:blockSelf error:&error];

            [error retain];
            //////////////////////////////////////////////////
            dispatch_async(dispatch_get_main_queue(), ^{
                
                if(error)
                {
                    
                }
                else
                {
                    blockSelf.allCardSectionArray = allSection;
                    [blockSelf.tableView reloadData];
                }
                if (UI_USER_INTERFACE_IDIOM()==UIUserInterfaceIdiomPad)
                {
                    [blockSelf adjustCurrentSelectedIndexPath];
                    
                    [blockSelf selectCurrentCard];
                    [blockSelf activeCurrentSelectCell];
                    
                }
                [blockSelf setBusy:@(NO)];
            });
        }
    });
}


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Method

//================================================================================
//
//================================================================================
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    WCCardHolderCell *cardHolderCell = (WCCardHolderCell *)[super tableView:tableView cellForRowAtIndexPath:indexPath];

    return cardHolderCell;
}




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - auto focus control


//==============================================================================
//
//==============================================================================
- (NSIndexPath *)defaultSelectedIndexPath
{
    NSInteger sectionIndex = 0;
    for (WCCardSectionModel *cardSectionModel in self.allCardSectionArray)
    {
        NSInteger rowIndex = 0;
        for (WCCardModel *cardModel in cardSectionModel.cardArray)
        {
            // !! ipad未校正也可以focus
            BOOL isPad = (UI_USER_INTERFACE_IDIOM()==UIUserInterfaceIdiomPad);
            if (isPad ||
                !((cardModel.tagMask&WC_TagMask_Unverified)==WC_TagMask_Unverified))
            {
                return [NSIndexPath indexPathForRow:rowIndex inSection:sectionIndex];
            }
            rowIndex++;
        }
        
        sectionIndex++;
    }
    
    return nil;
}


//==============================================================================
//
//==============================================================================
- (void)adjustCurrentSelectedIndexPath
{
    // 若紀錄點擊 indexPath 為未校正名片，則直接清空
    if(self.currentSelectedIndexPath!=nil)
    {
        NSInteger sectionIndex = [self.currentSelectedIndexPath section];
        NSInteger rowIndex = [self.currentSelectedIndexPath row];
        
        // !!  如果之前選取的已經不存在，也要重設
        if (sectionIndex>=[self.allCardSectionArray count])
        {
            self.currentSelectedIndexPath = nil;
//            self.selectedCardID = nil;
        }
        else
        {
            WCCardSectionModel *cardSectionModel = [self.allCardSectionArray objectAtIndex:sectionIndex];
            // !!  如果之前選取的row不存在，重設為section的最後一個item
            if (rowIndex>=[[cardSectionModel cardArray] count])
            {
                NSInteger newRowIndex = [[cardSectionModel cardArray] count]-1;
                if (newRowIndex>=0)
                {
                    self.currentSelectedIndexPath = [NSIndexPath indexPathForRow:newRowIndex inSection:sectionIndex];
                }
                else
                {
                    self.currentSelectedIndexPath = nil;
                }
                
//                WCCardModel *cardModel = [[cardSectionModel cardArray] lastObject];
//                self.selectedCardID = cardModel.ID;
            }
        }
    }
    
    //////////////////////////////////////////////////
    // 如果目前沒有選取且有名片，自動選取第一個
    if(self.currentSelectedIndexPath == nil)
    {
        // 預設不是未校正才能focus
        self.currentSelectedIndexPath = [self defaultSelectedIndexPath];
    }
    else if(![self.allCardSectionArray count]) // 如果沒有名片，設為沒有選取
    {
        self.currentSelectedIndexPath = nil;
    }
}




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PPButtonDelegate


//==============================================================================
//
//==============================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    __block typeof(self) blockSelf = self;
    
    dispatch_async(dispatch_get_main_queue(), ^{
        switch (ppButton.tag) {
            case TSMCNoAccountSalesforceContactViewControllerButtonTag_Cancel:
            {
                [blockSelf goBackAnimated:YES];
                break;
            }
            case TSMCNoAccountSalesforceContactViewControllerButtonTag_MultiSelect:
            {
                if ([self.delegate respondsToSelector:@selector(didClickMultiSelectWithNoAccountSalesforceContactViewController:)])
                {
                    [self.delegate didClickMultiSelectWithNoAccountSalesforceContactViewController:self];
                }
                break;
            }
            default:
                break;
        }
    });
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCTableViewControllerProtocol


//==============================================================================
//
//==============================================================================
- (UIImage *)cachedThumbnailImageWithCardID:(NSString *)cardID
{
    if ([self.delegate respondsToSelector:@selector(noAccountSalesforceContactViewController:cachedThumbnailImageWithCardID:)])
    {
        return [self.delegate noAccountSalesforceContactViewController:self cachedThumbnailImageWithCardID:cardID];
    }
    
    return nil;
}


//==============================================================================
//
//==============================================================================
- (UIImage *)thumbnailImageWithCardID:(NSString *)cardID
{
    if ([self.delegate respondsToSelector:@selector(noAccountSalesforceContactViewController:thumbnailImageWithCardID:)])
    {
        return [self.delegate noAccountSalesforceContactViewController:self thumbnailImageWithCardID:cardID];
    }
    
    return nil;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - UITableViewDelegate


//==============================================================================
//
//==============================================================================
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    self.currentSelectedIndexPath = indexPath;
    
    if ([self.delegate respondsToSelector:@selector(noAccountSalesforceContactViewController:showDetailFromViewController:cardID:atCardIDArray:)])
    {
        NSMutableArray *cardSectionArray = self.allCardSectionArray;
        
        WCCardSectionModel *cardSectionModel = [cardSectionArray objectAtIndex:indexPath.section];
        
        WCCardModel *cardModel = [cardSectionModel.cardArray objectAtIndex:indexPath.row];
        
        NSMutableArray *cardIDArray = [self cardIDArray];
        
        [self.delegate noAccountSalesforceContactViewController:self showDetailFromViewController:self cardID:cardModel.ID atCardIDArray:cardIDArray];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Notification receiver


//===============================================================================
//
//===============================================================================
- (void)recvDisplayDataChanged:(NSNotification *)notification
{
    [self loadData];
}






@end
