//
//  WCTCompanyContactGroupViewDelegateController.m
//  
//
//  Created by Howard on 2016/5/27.
//
//

#import "WCTNoSFAccountGroupSelectViewDelegateController.h"

// Define
#import "WCGroupDefine.h"
#import "WCTCompanyContactViewController+ResourceDefine.h"
#import "WCTCompanyContactViewController+ParameterDefine.h"
#import "WCTFieldLengthDefine.h"
#import "WCTSettingsKey.h"
#import "WCTHelpScanFlowController+SettingsKey.h"
#import "WCTHelpScanFlowController+ResourceDefine.h"

// Controller
#import "PPAlertController.h"
#import "PPNavigationController.h"
#import "WCTCompanyContactFetchDataController.h"
#import "WCToastController.h"
#import "WCTCompanyGroupSelectViewController.h"
#import "WCTDataController.h"
#import "WCTAccountRelationModel.h"
#import "PPSettingsController.h"
#import "WCTAccountDataController.h"
#import "PPSystemInfoController.h"
#import "WCTHelpScanHelper.h"

// Category
#import "NSObject+PPBusyView.h"
#import "UIViewController+ShareApplication.h"
#import "NSString+Additions.h"
#import "NSError+CustomMessage.h"
#import "WCGroupModel+WCTRCCategoryInfoMultiLayer.h"
#import "WCGroupModel+Sort.h"


@interface WCTNoSFAccountGroupSelectViewDelegateController ()<WCTCompanyGroupSelectViewControllerDelegate, WCTCompanyGroupSelectViewControllerEditCategoryDelegate>

@property (nonatomic,retain) PPViewController *superViewController;
@property (nonatomic,retain) NSArray *selectedGroupArray;
@end


@implementation WCTNoSFAccountGroupSelectViewDelegateController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_superViewController release];
    _superViewController = nil;
    
    [_categoryList release];
    _categoryList = nil;
    
    [_selectedGroupArray release];
    _selectedGroupArray = nil;
    //////////////////////////////////////////////////

    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method


//==============================================================================
//
//==============================================================================
- (WCGroupModel *)createGroupModelWithName:(NSString *)name
                          ownerAccountGuid:(NSString *)ownerAccountGuid
                                parentGuid:(NSString *)parentGuid
                                     error:(NSError **)error
{
    NSString *realOwnerAccountGuid = ([ownerAccountGuid length]>0)?ownerAccountGuid:[PPSettingsController stringValueWithKey:WCTSettingsKey_AccountGUID];
    NSError *returnError = nil;
    WCTRCMLCategoryCreationRequest *createRequest = [[WCTRCMLCategoryCreationRequest alloc] init];
    createRequest.name = name;
    createRequest.parentCategoryGuid = parentGuid;
    createRequest.ownerAccountGuid = realOwnerAccountGuid;
    WCTRCMLCategoryCreationResponseResult *result = [[WCTRestClientController shareRestClientController] createMultiLayerCategoryWithCreationRequest:createRequest
                                                                                                                                               error:&returnError];
    [createRequest release];
    
    if (returnError==nil)
    {
        // !! 取得WCGroupModel
        NSString *categoryGuid = result.data;
        __block WCGroupModel *groupModel = nil;
        WCTRCMLCategoryInfoListResponseResult *response1 = [[WCTRestClientController shareRestClientController] multiLayerCategoryListWithAccountGuid:realOwnerAccountGuid error:&returnError];
        
        
            if(returnError==nil)
        {
            // get all categories from server
            NSArray *allCategories = response1.data;
            
            for (WCTRCCategoryInfoMultiLayer *categoryInfo in allCategories)
            {
                if([categoryInfo.guid isEqualToString:categoryGuid])
                {
                    groupModel = [WCGroupModel modelWithWCTRCCategoryInfoMultiLayer:categoryInfo];
                    break;
                }
            }
            
            return groupModel;
        }
    }
//    else
//    {
//        if(error!=NULL)
//        {
//            *error = returnError;
//        }
//        return nil;
//    }
    
    if(error!=NULL)
    {
        *error = returnError;
    }
    return nil;
}



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCTCompanyGroupSelectViewControllerDelegate


//==============================================================================
//
//==============================================================================
- (NSMutableArray *)accountListWithError:(NSError **)error
{
    WCTDataController *dataController = [[WCTDataController alloc] initWithAccessMode:WCDC_AM_Text];
    
    NSArray *accounts = [dataController copyAllAccountList];
    
    [dataController release];
    
    NSError *returnError = nil;
    NSMutableArray *accountTree = nil;
    
    if (accounts!=nil)
    {
        NSMutableArray *viewAccounts = [NSMutableArray array];
        NSUInteger allCompanyContactCount = 0;
        NSString *selfAccountGuid = [PPSettingsController stringValueWithKey:WCTSettingsKey_AccountGUID];
        
        for (WCTAccountRelationModel *accountRelationModel in accounts)
        {
            if(accountRelationModel.isLimitedAccount==YES)
            {
                continue;
            }
            
            @autoreleasepool
            {
                // 用groupModel來放account
                WCGroupModel *accountModel = [[WCGroupModel alloc] init];
                accountModel.name = accountRelationModel.name;
                accountModel.owner = accountRelationModel.guid;
                // !!guid用空字串表示抓全部
                accountModel.guid = @"";
                accountModel.editable = NO;

                if ([accountRelationModel.guid isEqualToString:selfAccountGuid]==NO)
                {
                    [viewAccounts addObject:accountModel];
                }
                [accountModel release];
            }
        }
        
        
        [viewAccounts sortUsingComparator:^NSComparisonResult(WCGroupModel *obj1, WCGroupModel *obj2) {
            
            return [obj1.name unicodeCompare:obj2.name];
        }];
        
        
        //////////////////////////////////////////////////
        // 加入所有共享聯絡人
        WCGroupModel *rootModel = [[WCTCompanyContactFetchDataController shareInstance] allSharedContactGroupModel];
        rootModel.cardCount = allCompanyContactCount;
        [rootModel.subGroups addObjectsFromArray:viewAccounts];
        
        accountTree = [NSMutableArray arrayWithObject:rootModel];
        [accounts release];
    }
    
    if (error!=NULL)
    {
        *error = returnError;
    }
    return accountTree;
    
}


//==============================================================================
//
//==============================================================================
- (NSString *)preferredExpandToItemWithcompanyGroupSelectViewController:(WCTCompanyGroupSelectViewController *)companyGroupSelectViewController
{
    return [PPSettingsController stringValueWithKey:WCTHelpScanFlowControllerKey_SaveToCategory];
}


//==============================================================================
//
//==============================================================================
- (NSMutableArray *)groupArrayWithAccountGuid:(NSString *)accountGuid error:(NSError **)error
{
    NSError *returnErorr = nil;
    NSMutableArray *groupArray = [[WCTCompanyContactFetchDataController shareInstance] categoryListWithAccountGuid:accountGuid error:&returnErorr];
    
    if (returnErorr)
    {
        if (error!=nil)
        {
            *error = returnErorr;
        }
        return nil;
    }
    
    //////////////////////////////////////////////////
    // sort, 其他已sort, 只有這一層再sort一次就好
    BOOL forEnglish = YES;
    
    switch([PPSystemInfoController language])
    {
        case PPSystemInfoLanguage_ChineseTraditional:
        case PPSystemInfoLanguage_ChineseSimplified:
        case PPSystemInfoLanguage_Korean:
        case PPSystemInfoLanguage_Japanese:
            forEnglish = NO;
            break;
            
        default:
            break;
    }
    
    groupArray = [WCGroupModel defaultSortedGroupsWithCurrentGroups:groupArray forEnglish:forEnglish onlySortSystemGroup:NO];
    return groupArray;
}


//==============================================================================
//
//==============================================================================
- (NSDictionary <NSString*, NSNumber *> *)sharedContactNumberWithCategoryGuids:(NSArray <NSString *>*)categoryGuids ownerGuid:(NSString *)ownerGuid error:(NSError **)error
{
    return [[WCTCompanyContactFetchDataController shareInstance] sharedContactNumberWithCategoryGuids:categoryGuids ownerGuid:ownerGuid error:error];
}


//==============================================================================
//
//==============================================================================
- (void)companyGroupSelectViewController:(WCTCompanyGroupSelectViewController *)companyGroupSelectViewController
                didSelectWithAccountGuid:(NSString *)accountGuid
                             accountName:(NSString *)accountName
                            categoryGuid:(NSString *)categoryGuid
                        categoryFullName:(NSString *)categoryFullName
{
//    NSLog(@"%s", __PRETTY_FUNCTION__);
    // MARK: 選取完要檢視的帳號與群組
    // 帳號:@""，群組:@""，表示要取全部分享給我的
    // 帳號:有值，群組:@""，表示要取某個帳號分享給我的名片
    // 帳號:有值，群組:有值，表示要取某個帳號下的群組中分享給我的名片
    // 帳號:有值，群組:@"MLS_Undownload"，表示要取某個帳號未下載名片中分享給我的名片
    
    // 帳號:@""，群組:有值，應該不存在這個狀態，要清掉群組
    
    //////////////////////////////////////////////////
    // 取得類別名稱

        
//    //////////////////////////////////////////////////
//
    [PPSettingsController setStringValue:accountGuid withKey:WCTHelpScanFlowControllerKey_SaveToAccount];
    [PPSettingsController setStringValue:accountName withKey:WCTHelpScanFlowControllerKey_SaveToAccountName];
    [PPSettingsController setStringValue:categoryGuid withKey:WCTHelpScanFlowControllerKey_SaveToCategory];
    
    if(categoryFullName)
    {
        [PPSettingsController setStringValue:categoryFullName withKey:WCTHelpScanFlowControllerKey_SaveToCategoryName];
    }

}


//==============================================================================
//
//==============================================================================
- (NSString *)companyGroupSelectViewController:(WCTCompanyGroupSelectViewController *)companyGroupSelectViewController requestErrorMessageForError:(NSError *)error
{
    return [error customErrorMessageWithDefaultError:YES];
}



#pragma mark - for groupTreeViewController add


//==============================================================================
//
//==============================================================================
//- (BOOL)companyGroupSelectViewController:(WCTCompanyGroupSelectViewController *)companyGroupSelectViewController isExistGroupNamed:(NSString*)groupNamed
//{
//    // WCT改online所以永遠算不存在
//    return NO;
//}


//==============================================================================
//
//==============================================================================
- (WCGroupModel *)companyGroupSelectViewController:(WCTCompanyGroupSelectViewController *)companyGroupSelectViewController
                          groupModelByNewGroupName:(NSString *)groupName
                                         ownerGuid:(NSString *)ownerGuid
                                    superGroupGuid:(NSString *)superGroupGuid
                                             error:(NSError **)error
{
    return [self createGroupModelWithName:groupName ownerAccountGuid:ownerGuid parentGuid:superGroupGuid error:error];
}


#pragma mark - for groupTreeViewController edit style


//==============================================================================
//
//==============================================================================
- (NSError *)companyGroupSelectViewController:(WCTCompanyGroupSelectViewController *)companyGroupSelectViewController updateGroupModel:(WCGroupModel *)groupModel;
{
    NSError *error = nil;
    [[WCTRestClientController shareRestClientController] updateMultiLayerCategoryWithGuid:groupModel.guid categoryName:groupModel.name error:&error];
    

    return error;
}


//==============================================================================
//
//==============================================================================
- (void)companyGroupSelectViewController:(WCTCompanyGroupSelectViewController *)companyGroupSelectViewController
                 categoryChangedWithGuid:(NSString *)guid
                                fullName:(NSString *)fullName
{
    //////////////////////////////////////////////////
    NSString *groupGuid = [PPSettingsController stringValueWithKey:WCTHelpScanFlowControllerKey_SaveToCategory];
    NSString *accountGuid = [PPSettingsController stringValueWithKey:WCTHelpScanFlowControllerKey_SaveToAccount];
    NSString *fullCategoryName = [WCTHelpScanHelper fullCategoryNameWithAccountGuid:accountGuid categoryGuid:groupGuid];
    [PPSettingsController setStringValue:fullCategoryName withKey:WCTHelpScanFlowControllerKey_SaveToCategoryName];
}


//==============================================================================
//
//==============================================================================
- (NSError *)companyGroupSelectViewController:(WCTCompanyGroupSelectViewController *)companyGroupSelectViewController deleteGroupModel:(WCGroupModel *)groupModel
{
    NSError *error = nil;
    [[WCTRestClientController shareRestClientController] deleteMultiLayerCategoryWithCategoryGuid:groupModel.guid error:&error];
    
    // !! 刪除如果是404當成功
    NSInteger statusCode = [WCTRestClientController statusCodeFromAFRKNetworkingError:error];
    if (statusCode==WCTServer_Common_ErrorCode_DataNotFound)
    {
        error = nil;
    }
    
    //////////////////////////////////////////////////
    // 如果刪除的類別是目前選取類別，清除設定
    if(error==nil)
    {
        NSString *groupGuid = [PPSettingsController stringValueWithKey:WCTHelpScanFlowControllerKey_SaveToCategory];
        
        if([groupGuid isEqualToString:groupModel.guid])
        {
            [WCTHelpScanHelper resetHelpScanSettings];
        }
    }
    return error;
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (void)showFromViewController:(PPViewController *)viewController
{
    do
    {
        if(viewController==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        self.superViewController = viewController;
        
        //////////////////////////////////////////////////
        WCTCompanyGroupSelectViewController *groupSelectViewController = [[WCTCompanyGroupSelectViewController alloc] init];
        groupSelectViewController.enableEditCategoryUI = YES;
        groupSelectViewController.editCategoryDelegate = self;
        groupSelectViewController.delegate = self;
        groupSelectViewController.titleString = WCTHelpScanFlowController_MLS_HelpScanTitle;
        groupSelectViewController.currentAccountGuid = [PPSettingsController stringValueWithKey:WCTHelpScanFlowControllerKey_SaveToAccount];
        groupSelectViewController.currentGroupGuid = [PPSettingsController stringValueWithKey:WCTHelpScanFlowControllerKey_SaveToCategory];
        groupSelectViewController.hideRootNode = YES;
        
        //////////////////////////////////////////////////
        
        PPNavigationController *navigationController = [[PPNavigationController alloc] initWithRootViewController:groupSelectViewController];
        
        [groupSelectViewController release];
        
        if(navigationController==nil)
        {
            break;
        }
        
        [viewController presentViewController:navigationController animated:YES completion:nil];
        
        [navigationController release];

    }
    while (0);
    
}

@end
