//
//  WCNewCardFlowDelegateController.m
//  WorldCardMobile7
//
//  Created by sanhue on 2015/8/4.
//  Copyright (c) 2015年 penpower. All rights reserved.
//

#import "WCNoSFAccountNewCardFlowDelegateController.h"

// define
#import "WCCaptureViewController+SettingsKey.h"
#import "WCSettingsKey.h"
#import "ResourceDefine.h"
#import "WCTHelpScanFlowController+SettingsKey.h"
#import "WCTHelpScanFlowController+ResourceDefine.h"
#import "WCTHelpScanFlowController+ErrorCode.h"

// category
#import "WCRecognitionCardModel+WCCardModel.h"
#import "NSError+Custom.h"
#import "NSError+CustomErrorMessage.h"
#import "UIImage+Additions.h"
#import "NSThread+Additions.h"
#import "WCTHelpScanHelper.h"

// controllers
#import "WCRecognitionPreferenceController.h"
#import "WCRecognitionController.h"
#import "WCToolController.h"
#import "PPSettingsController.h"
#import "WCABDataController.h"
#import "WCABItemSelectFlowController.h"
#import "PPCloudController.h"
#import "WCCaptureViewController.h"
#import "WCPromotionADController.h"
#import "WCVCFDataController.h"


// WCT
#import "WCCardModel+WCTRCContactInfo.h"
#import "WCTSettingsKey.h"
#import "WCTAccountDataController.h"
#import "WCTAccountRelationModel.h"
#import "PPSettingsController+Additions.h"
#import "WCCloudSettings.h"
//#import "WCRegisterFlowController.h"
#import "WCDataTransferFlowController.h"
#import "WCTSyncActionModel.h"
#import "WCTCardSyncActionModel.h"
#import "WCTGroupAccessFlowDelegateController.h"
#import "WCTRestClientController.h"
#import "WCTMatomoController.h"

typedef void(^BelongToCategoriesHandler)(NSMutableArray *belongToCategories, NSError *error);
////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCNoSFAccountNewCardFlowDelegateController ()
@property (nonatomic, retain) DataController *dataController;
@property (nonatomic, copy) BelongToCategoriesHandler belongToCategoriesHandler;
@end



////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCNoSFAccountNewCardFlowDelegateController





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (instancetype)initWithDataController:(DataController *)dataController
{
    self = [super init];
    if (self)
    {
        self.dataController = dataController;
    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.belongToCategoriesHandler = nil;
    self.delegate = nil;
    
    self.userInfo = nil;
    self.dataController = nil;
    //////////////////////////////////////////////////
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - (Private)


//===============================================================================
//
//===============================================================================
- (void)mainThreadNotifyAddCard:(NSString *)cardID
{
#ifdef _DUMP_LOG_
    [DumpLog logByFormat:@"%s cardID:%@", __func__, cardID];
#endif
    
    NSDictionary *userInfo = [[NSDictionary alloc] initWithObjectsAndKeys:cardID ,WCNCFDC_NOTIFY_UserInfo_CardID, nil];
    [[NSNotificationCenter defaultCenter] postNotificationName:WCNCFDC_NOTIFY_AddCard object:nil userInfo:userInfo];
    [userInfo release];
}


//==============================================================================
//
//==============================================================================
- (BOOL)isGroupArray:(NSArray *)groupArray contantsGroupID:(NSInteger)groupID
{
    for (NSString * groupIDString in groupArray)
    {
        if ([groupIDString integerValue]==groupID)
        {
            return YES;
        }
    }
    
    return NO;
}


//==============================================================================
//
//==============================================================================
- (NSMutableArray *)belongToCategoriesWithOwnerGuid:(NSString *)ownerGuid categoryGuid:(NSString *)categoryGuid error:(NSError **)error
{
    NSError *returnError = nil;
    NSMutableArray *belongCategories = nil;
    do {
        WCTRCMLCategoryInfoListResponseResult *responseResult = [[WCTRestClientController shareRestClientController] multiLayerCategoryListWithAccountGuid:ownerGuid error:&returnError];
        
        if(responseResult==nil)
        {
            break;
        }
        
        for(WCTRCCategoryInfoMultiLayer *categoryInfo in responseResult.data)
        {
            if([categoryInfo.guid isEqualToString:categoryGuid] == YES)
            {
                WCTRCSimpleCategoryInfo *info = [[WCTRCSimpleCategoryInfo alloc] init];
                
                if(info != nil)
                {
                    if(belongCategories==nil)
                    {
                        belongCategories = [NSMutableArray array];
                    }
                    
                    info.guid = categoryInfo.guid;
                    info.name = categoryInfo.name;
                    
                    [belongCategories addObject:info];
                    [info release];
                }
                break;
            }
        }
        
        //////////////////////////////////////////////////
        // !! 沒有可用的category, 要自已產生
        if (belongCategories==nil)
        {
            returnError = PPErrorMake(WCTHSFC_ErrorCode_TargetCategoryDoesntExist, WCTHelpScanViewController_MLS_TargetCategoryDoesntExist, nil);
        }
    } while (0);
    
    if (returnError)
    {
        if(error)
        {
            *error = returnError;
        }
    }
    
    return belongCategories;
}


//==============================================================================
//
//==============================================================================
- (BOOL)sendHelpScanContactWithContactInfo:(WCTRCContactInfo *)contactInfo
                            frontSideImage:(UIImage *)frontSideImage
                             backSideImage:(UIImage *)backSideImage
                              idPhotoImage:(UIImage *)idPhotoImage
                                     error:(NSError **)error
{
    __block NSError *returnError = nil;

    
    WCTRestClientController *restClientController = [WCTRestClientController shareRestClientController];
    
    WCTRCContactCreationWithImageRequest *sendContactRequest = nil;
    WCTRCPrivateContactUploadImageResponseResult *uploadImageResponse = nil;
    
    BOOL retry = NO;
    
    do
    {
        //////////////////////////////////////////////////
        
        if(restClientController == nil)
        {
            returnError = PPErrorParameterInvalidity(@"Empty restClientController");
            break;
        }
        
        if(contactInfo == nil)
        {
            returnError = PPErrorParameterInvalidity(@"Empty contactInfo");
            break;
        }
        
        sendContactRequest = [[[WCTRCContactCreationWithImageRequest alloc] init] autorelease];
        
        if(sendContactRequest == nil)
        {
            PPErrorOperationFailed(@"WCTRCContactCreationWithImageRequest alloc failed");
            break;
        }
        
        
        //////////////////////////////////////////////////
        // 上傳影像
        
        if(frontSideImage != nil)
        {
            uploadImageResponse = [restClientController privateContactUploadImage:frontSideImage
                                                                         fileName:contactInfo.guid
                                                                         mineType:WCTRC_MineType_JPG
                                                                            error:&returnError];
            
            if(returnError != nil)
            {
                break;
            }
            
            sendContactRequest.frontImageFileGuid = uploadImageResponse.data;
        }
        
        if(backSideImage != nil)
        {
            uploadImageResponse = [restClientController privateContactUploadImage:backSideImage
                                                                         fileName:contactInfo.guid
                                                                         mineType:WCTRC_MineType_JPG
                                                                            error:&returnError];
            
            if(returnError != nil)
            {
                break;
            }
            
            sendContactRequest.rearImageFileGuid = uploadImageResponse.data;
        }
        
        if(idPhotoImage != nil)
        {
            uploadImageResponse = [restClientController privateContactUploadImage:idPhotoImage
                                                                         fileName:contactInfo.guid
                                                                         mineType:WCTRC_MineType_JPG
                                                                            error:&returnError];
            
            if(returnError != nil)
            {
                break;
            }
            
            sendContactRequest.logoImageFileGuid = uploadImageResponse.data;
        }
        
        
        //////////////////////////////////////////////////
        // 發送request
        
        sendContactRequest.addresses = contactInfo.addresses;
        sendContactRequest.beCorrected = contactInfo.beCorrected;
        sendContactRequest.belongingCategories = contactInfo.belongCategories;
        sendContactRequest.belongingCategoriesOwnerAccountGuid = contactInfo.ownerGuid;
        sendContactRequest.birthday = contactInfo.birthday;
        sendContactRequest.clientCreatedContactGuid = contactInfo.guid;
        sendContactRequest.clientCreatedTime = contactInfo.createTime;
        sendContactRequest.creatorAccountGuid = contactInfo.creatorGuid;
        sendContactRequest.customFields = contactInfo.customFields;
        sendContactRequest.dates = contactInfo.dates;
        sendContactRequest.emails = contactInfo.emails;
        sendContactRequest.ims = contactInfo.ims;
        sendContactRequest.jobinfos = contactInfo.jobinfos;
        sendContactRequest.names = contactInfo.names;
        sendContactRequest.nickname = contactInfo.nickname;
        sendContactRequest.note = contactInfo.note;
        sendContactRequest.ownerAccountGuid = contactInfo.ownerGuid;
        sendContactRequest.phones = contactInfo.phones;
        sendContactRequest.recogLanguageBack = contactInfo.recogLanguageBack;
        sendContactRequest.recogLanguageFront = contactInfo.recogLanguageFront;
        sendContactRequest.socials = contactInfo.socials;
        sendContactRequest.uniformNumber = contactInfo.uniformNumber;
        sendContactRequest.urls = contactInfo.urls;
        
        
        [restClientController scanUploadPrivateContactWithContactCreationWithImageRequest:sendContactRequest
                                                               contactReceiverAccountGuid:contactInfo.ownerGuid
                                                                                    error:&returnError];
        
        NSInteger statusCode = [WCTRestClientController statusCodeFromAFRKNetworkingError:returnError];
        if(statusCode == WCTServer_Common_ErrorCode_GuidHasBeenUsed)
        {
            retry = YES;
            contactInfo.guid = [NSString GUID];
        }
        else
        {
            // !! 被幫忙掃的人是暫停用戶要客制錯誤訊息
            if (statusCode==WCTServer_Common_ErrorCode_LimitedAccountAccessDenied)
            {
                WCTAccountRelationModel *accountModel = [self.dataController accountRelationWithAcountGuid:contactInfo.ownerGuid];
                
                NSString *errorMessage = [NSString stringWithFormat:WCTHelpScanViewController_MLS_TargetAccountIsLocked, accountModel.name, @(statusCode)];
                returnError = PPErrorMake(WCTHSFC_ErrorCode_LimitedAccount, errorMessage, nil);
            }
            retry = NO;
        }
    }
    while(retry == YES);

    if(returnError)
    {
        if(error)
        {
            *error = returnError;
        }
        return NO;
    }
    else
    {
        return YES;
    }

}


//==============================================================================
//
//==============================================================================
- (BOOL)saveCardModel:(WCCardModel *)cardModel
         idPhotoImage:(UIImage *)idPhotoImage
       frontSideImage:(UIImage *)frontSideImage
        backSideImage:(UIImage *)backSideImage
       needSendNotify:(BOOL)needSendNotify
                error:(NSError **)error
{

    BOOL result = NO;
    __block NSError *returnError = nil;

    do {

        NSString *selfAccount = [PPSettingsController stringValueWithKey:WCTSettingsKey_AccountGUID];
        NSString *ownerGuid = [PPSettingsController stringValueWithKey:WCTHelpScanFlowControllerKey_SaveToAccount];
        NSString *categoryGuid = [PPSettingsController stringValueWithKey:WCTHelpScanFlowControllerKey_SaveToCategory];
        
        // !! 先處理群組
        __block NSMutableArray *belongCategories = [self belongToCategoriesWithOwnerGuid:ownerGuid
                                                                            categoryGuid:categoryGuid
                                                                                   error:&returnError];
        if(belongCategories==nil)
        {
            // !! 如果選取類別不存在，清除設定值
            if(returnError.code==WCTHSFC_ErrorCode_TargetCategoryDoesntExist)
            {
                [WCTHelpScanHelper resetHelpScanSettings];
            }
            break;
        }
        //////////////////////////////////////////////////
        
        WCTRCContactInfo *contactInfo = [cardModel WCTRCContactInfo];
        
        // 設定擁有者
        contactInfo.creatorGuid = selfAccount;
        contactInfo.ownerGuid = ownerGuid;
        contactInfo.belongCategories = belongCategories;
        
        result = [self sendHelpScanContactWithContactInfo:contactInfo
                                           frontSideImage:frontSideImage
                                            backSideImage:backSideImage
                                             idPhotoImage:idPhotoImage
                                                    error:&returnError];
        
    } while (0);
    
    if(returnError)
    {
        if(error)
        {
            *error = returnError;
        }
    }
    return result;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCNewCardFlowDatasource


//==============================================================================
//
//==============================================================================
- (NSMutableArray *)newCardFlowRequestSpaceTypeArray
{
#if defined (PRODUCTLINE_WCE)
    return nil;
#else
    return [NSMutableArray arrayWithArray:[WCCloudSettings storageTypeArrayForNewCard]];
#endif
    
}


//================================================================================
//
//================================================================================
- (WCDisplayNameOrder)displayNameOrderWithEasternName:(BOOL)isEasternName
{
    if (isEasternName)
    {
        return [PPSettingsController integerValueWithKey:WCSC_IV_kEasternNameOrder];
    }
    return [PPSettingsController integerValueWithKey:WCSC_IV_kWesternNameOrder];
}


//================================================================================
//
//================================================================================
- (NSArray *)newCardFlowRequestRecogLangModels
{
    // !! 開放全部辨識語系
    return [[WCRecognitionPreferenceController copyKernelRecogLangArrayWithKernelVersion:WCRecognitionKernelVersion_All] autorelease];
}


//================================================================================
//
//================================================================================
- (NSArray *)newCardFlowRecognizeFieldTypes
{
    return [[WCRecognitionPreferenceController copyKernelClipRecogTypeArray] autorelease];
}


//==============================================================================
//
//==============================================================================
- (NSMutableArray *)newCardFlowRequestPhoneticArrayWithClickedPhonetic:(NSString *)phonetic
                                                           sourceValue:(NSString *)sourceValue
                                                     isCompanyPhonetic:(BOOL)isCompanyPhonetic
{
    NSMutableArray *resultPhonetics = nil;
    NSString *temp = sourceValue;
    if (isCompanyPhonetic)
    {
        temp = [WCRecognitionPreferenceController trimCompanyPrefix:sourceValue];
    }
    
    NSArray * phonetics = [PPIndexingController phoneticsOfString:temp forStyle:PPIndexingStyle_Hiragana];
    if ([phonetics count])
    {
        resultPhonetics = [NSMutableArray arrayWithArray:phonetics];
    }
    return resultPhonetics;
}


//================================================================================
//
//================================================================================
- (BOOL)newCardFlowControllerRequestEnableSaveToiPhoneContact;
{
    return (BOOL)[PPSettingsController integerValueWithKey:WCSC_IV_kEnableSaveToiPhone];
}

//================================================================================
//
//================================================================================
- (NSString *)newCardFlowControllerRequestDefaultABSourceID;
{
    return [PPSettingsController stringValueWithKey:WCSC_SV_kSaveToiPhoneSourceID];
}

//================================================================================
//
//================================================================================
- (NSString *)newCardFlowControllerRequestDefaultABGroupID
{
    return [PPSettingsController stringValueWithKey:WCSC_SV_kSaveToiPhoneGroupID];
}




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCNewCardFlowDelegate


//================================================================================
//
//================================================================================
- (BOOL)newCardFlowRequesetShowError:(NSError *)error
{
    
    if([error.domain isEqualToString:@"PPGoogleDriveOperation_Link"] == YES ||
       [error.domain isEqualToString:@"PPDropboxOperation_Link"] == YES ||
       [error.domain isEqualToString:@"PPHuaweiOperation_Link"] == YES)
    {
        if (error.code == PPCloudCommonError_CancelLogin)
        {
            return NO;
        }
    }
#if defined (PRODUCTLINE_WCT)
    else
    {
        NSHTTPURLResponse *apiResponse = [WCTRestClientController responseFromAFRKNetworkingError:error];
        if (apiResponse)
        {
            NSInteger statusCode = [apiResponse statusCode];
            switch (statusCode)
            {
                case NSNotFound: // 沒有包含http response的錯誤由這邊處理
                {
                    // WCTRestClientController的error可能被包住，所以這邊要另外取
                    NSError *restClientError = [error findErrorWithConditionDict:@{@"WCTRestClientController":@[@(WCTRestClientController_ErrorCode_ServerRestored)]}];
                    
                    if (restClientError)
                    {
                        return NO;
                    }
                    else
                    {
                        return YES;
                    }
                    
                    break;
                }
                case WCTServer_Common_ErrorCode_AuthenticationFailed:
                {
                    return NO;
                }
                default:
                {
                    return YES;
                }
            }
        }
    }
#endif
    return YES;
}



//================================================================================
//
//================================================================================
- (NSString *)newCardFlowRequestMessageWithError:(NSError *)error
{
    NSString *message = nil;
    
    if([error.domain isEqualToString:NSStringFromClass([WCABItemSelectFlowController class])] == YES)
    {
        if(error.code == WCABItemSelectFlowControllerErrorCode_NoAddressBookPermission)
        {
            message = error.localizedFailureReason;
        }
    }
#if defined (PRODUCTLINE_WCSF)||defined (PRODUCTLINE_WCO365)
    // !! salesforce試用到上限的訊息要客制
    else if([error.domain isEqualToString:NSStringFromClass([WCNewCardFlowController class])] == YES)
    {
        if(error.code == WCNewCardFlow_Error_ReachMaxNewCardCount)
        {
            message = Common_MLS_ReachTrialCount;
        }
    }
    else if([error.domain isEqualToString:NSStringFromClass([WCCaptureFlowController class])] == YES)
    {
        if(error.code == WCCaptureFlowControllerErrorCode_ReachMaximumCount)
        {
            message = Common_MLS_ReachTrialCount;
        }
    }
    else if([error.domain isEqualToString:NSStringFromClass([WCAlbumFlowController class])] == YES)
    {
        if(error.code == WCAlbumFlowControllerErrorCode_ReachMaximumCount)
        {
            message = Common_MLS_ReachTrialCount;
        }
    }
#else
    else if([error.domain isEqualToString:NSStringFromClass([WCNewCardFlowController class])] == YES)
    {
        if(error.code == WCNewCardFlow_Error_ReachMaxNewCardCount)
        {
            message = error.localizedFailureReason;
        }
    }
#endif
    else if([error.domain isEqualToString:NSStringFromClass([WCABDataController class])] == YES)
    {
        if(error.code == WCABDataController_Error_NoAccessPermission)
        {
            message = Common_NoAddressBookPermission;
        }
    }
#if defined (PRODUCTLINE_WCT)
    else
    {
        NSHTTPURLResponse *apiResponse = [WCTRestClientController responseFromAFRKNetworkingError:error];
        if (apiResponse)
        {
            NSInteger statusCode = [apiResponse statusCode];
            switch (statusCode)
            {
                    // !! 匯入建立類別時超過3層的訊息要另外處理
                case WCTServer_Category_ErrorCode_OverLayerCountLimitation:
                {
                    message = Common_CategoryLayerCountOverLimitationForImport;
                    break;
                }
                default:
                {
                    message = [error customErrorMessageWithDefaultError:YES];
                    break;
                }
            }
        }
        else
        {
            message = [error customErrorMessageWithDefaultError:YES];
        }


    }
#endif
    return message;
}


//==============================================================================
//
//==============================================================================
- (NSString *)requestSpecificString
{
#if defined (PRODUCTLINE_WCT)
    return WCExportLiteDataFlowControllerString_StorageSpecificTitle_WCT;
#elif defined (PRODUCTLINE_WCM)
    return WCExportLiteDataFlowControllerString_StorageSpecificTitle;
#else
    return nil;
#endif
}


//================================================================================
//
//================================================================================
- (void)newCardFlowRequestRecogTaskAtIndex:(NSUInteger)index totalCount:(NSUInteger)totalCount
{
#ifdef DEBUG
    NSLog(@"剩餘張數: %lu / %lu", (unsigned long)index, (unsigned long)totalCount);
#endif
    // 顯示剩餘辨識張數
 
//    if ([self.delegate respondsToSelector:@selector(newCardFlowDelegateReportRestCount:)])
//    {
//        [self.delegate newCardFlowDelegateReportRestCount:index];
//    }
}


//================================================================================
//
//================================================================================
- (NSString *)newCardFlowRequestGoogleSyncAccount
{
#if defined (PRODUCTLINE_WCM)
    return [WCMSyncFlowController currentAccount];
#else
    // WCT 不是gmail所以都不用傳
    return nil;
#endif
}




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - recognize handler


//================================================================================
// 單張
//================================================================================
- (WCCardModel *)newCardFlowRequestRecogWithSourceModel:(WCRecogSourceModel *)recogSourceModel
                                                  error:(NSError **)error
{
    WCCardModel *cardModel = [[[WCCardModel alloc] init] autorelease];
    cardModel.ID = recogSourceModel.cardID;
    
    WCRecognitionCardModel *recogCardModel = nil;
    WCRecognitionController *recognitionController = nil;
    
    do
    {
        recogCardModel = [[WCRecognitionCardModel alloc] init];
        
        if(recogCardModel==nil)
        {
            break;
        }
        
        recogCardModel.cardID = recogSourceModel.cardID;
        recogCardModel.sourceImageType = (recogSourceModel.imageType==WC_IT_FrontSide)?WCRecognitionImageType_FrontSide:WCRecognitionImageType_BackSide;
        recogCardModel.frontRecognitionLanguage = recogSourceModel.recogLang;
        
        //////////////////////////////////////////////////
        
        recognitionController = [[WCRecognitionController alloc] init];
        
        if(recognitionController==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        // 是否自動格式化電話
        [recognitionController setAutoFormatPhone:[PPSettingsController integerValueWithKey:WCSC_IV_kAutoFormatPhoneNumber]];
        // 設定辨識後電話是否需要加上國碼
        [recognitionController setAddCountryCodeToPhone:[PPSettingsController integerValueWithKey:WCSC_IV_kRecognPhoneCountryCode]];
        
        //////////////////////////////////////////////////
        // !! capture的imageSource是path，相簿load圖是URL，手刮，再辨識是圖片
        UIImage *image = [recognitionController imageFromRecogSource:recogSourceModel];

        if([recognitionController recognizeImage:image toCardModel:recogCardModel withRecogSource:recogSourceModel error:error])
        {
            cardModel = [recogCardModel cardModelTransform];
            // 辨識出來都是未校正
            cardModel.tagMask |= WC_TagMask_Unverified;

            // 首字大寫
            if([PPSettingsController integerValueWithKey:WCSC_IV_kCapitalizeRecogResult]==YES)
            {
                [cardModel capitalizedString];
            }
            
            // !! 辨識完的電話依照預設排序
            [cardModel sortPhoneFields];
        }
    }
    while (0);
    
    [recognitionController release];
    [recogCardModel release];

    return cardModel;
}


//================================================================================
// 多張辨識
//================================================================================
- (WCCardModel *)newCardFlowRequestRecogWithSourceModel:(WCRecogSourceModel *)recogSourceModel
                                                  image:(UIImage *)image
                                                  error:(NSError **)error
{
    // !!help scan應該不會進來
    WCCardModel *cardModel = [[[WCCardModel alloc] init] autorelease];
    cardModel.ID = recogSourceModel.cardID;

    WCRecognitionCardModel *recogCardModel = nil;
    WCRecognitionController *recognitionController = nil;
    
    do
    {
        recogCardModel = [[WCRecognitionCardModel alloc] init];
        
        if(recogCardModel==nil)
        {
            break;
        }
        
        recogCardModel.cardID = recogSourceModel.cardID;
        recogCardModel.sourceImageType = (recogSourceModel.imageType==WC_IT_FrontSide)?WCRecognitionImageType_FrontSide:WCRecognitionImageType_BackSide;        
        recogCardModel.frontRecognitionLanguage = recogSourceModel.recogLang;

        
        //////////////////////////////////////////////////
        
        recognitionController = [[WCRecognitionController alloc] init];
        
        if(recognitionController==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        // 是否自動格式化電話
        [recognitionController setAutoFormatPhone:[PPSettingsController integerValueWithKey:WCSC_IV_kAutoFormatPhoneNumber]];
        // 設定辨識後電話是否需要加上國碼
        [recognitionController setAddCountryCodeToPhone:[PPSettingsController integerValueWithKey:WCSC_IV_kRecognPhoneCountryCode]];

        //////////////////////////////////////////////////
        // !! capture的imageSource是path，相簿load圖是URL，手刮，再辨識是圖片
        UIImage *recogImage = image;
        
        if(recogImage==nil)
        {
            recogImage = [recognitionController imageFromRecogSource:recogSourceModel];
        }
        
        if([recognitionController recognizeImage:recogImage toCardModel:recogCardModel withRecogSource:recogSourceModel error:error])
        {
            cardModel = [recogCardModel cardModelTransform];
            // 辨識出來都是未校正
            cardModel.tagMask |= WC_TagMask_Unverified;

            // 首字大寫
            if([PPSettingsController integerValueWithKey:WCSC_IV_kCapitalizeRecogResult]==YES)
            {
                [cardModel capitalizedString];
            }

            // !! 辨識完的電話依照預設排序
            [cardModel sortPhoneFields];

            // !!背景辨識一定是unverified
            cardModel.tagMask |= WC_TagMask_Unverified;
        }
    }
    while (0);
    
    [recognitionController release];
    [recogCardModel release];
    
    return cardModel;
}


//==============================================================================
// vcard string轉 cardModel
//==============================================================================
- (WCCardModel *)newCardFlowRequestRecogWithQRCodeString:(NSString *)qrCodeString
                                             newCardMode:(WCNewCardFlowController_Mode)newCardMode
                                                   error:(NSError **)error
{
    // !!help scan應該不會進來
    //////////////////////////////////////////////////
    if([qrCodeString length]==0)
    {
        return nil;
    }
    
    //////////////////////////////////////////////////
    
    BOOL generateHiragana = NO;
    generateHiragana = YES;
    
    NSError *returnError = nil;
    
    WCVCFDataController *dataController = [[WCVCFDataController alloc] initWithError:&returnError];
    
    if(dataController==nil)
    {
        return nil;
    }
    
    //////////////////////////////////////////////////
    
    WCCardModel *cardModel = (WCCardModel *)[dataController cardModelFromVCardString:qrCodeString
                                                                            encoding:NSUTF8StringEncoding
                                                                    generateHiragana:generateHiragana
                                                                               error:&returnError];
    
    
    [dataController release];
    
    return cardModel;
}


//================================================================================
// 電子郵件簽名
//================================================================================
- (WCCardModel *)newCardFlowRequestRecogWithSourceString:(NSString *)sourceString
                                             newCardMode:(WCNewCardFlowController_Mode)newCardMode
                                                   error:(NSError **)error;
{
    // !!help scan應該不會進來
    //////////////////////////////////////////////////
    WCCardModel *cardModel = [[[WCCardModel alloc] init] autorelease];

    
    do
    {
        WCRecognitionController *cardRecognitionController = [[WCRecognitionController alloc] init];
        
        if(cardRecognitionController==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        WCRecognitionCardModel *recognitionCardModel = [cardRecognitionController cardModelWithSignatureRecogSourceString:sourceString error:nil];
        
        [cardRecognitionController release];
        
        if(recognitionCardModel==nil)
        {
            break;
        }
        
        cardModel = [recognitionCardModel cardModelTransform];
        // 辨識出來都是未校正
        cardModel.tagMask |= WC_TagMask_Unverified;

        // 首字大寫
        if([PPSettingsController integerValueWithKey:WCSC_IV_kCapitalizeRecogResult]==YES)
        {
            [cardModel capitalizedString];
        }

    }
    while (0);
    
    // !! 在這邊做，才能保証不管有沒有辨識成功，都會加到card ID
    if (cardModel)
    {
#if defined (PRODUCTLINE_WCM)
        cardModel.ID = [WCToolController generateCardID];
#else
        cardModel.ID =  [NSString GUID];
#endif
        
        cardModel.createdTime = [NSDate date];
        cardModel.modifiedTime = [NSDate date];
    }
    
    // !! 只有電子郵件簽名辨識時才要把字串加到note
    if (newCardMode==WCNewCardFlowController_Mode_TextSignature||
        (newCardMode==WCNewCardFlowController_Mode_Capture && [cardModel totalFieldCount]==0))
    {
        // 不管有沒有辨識成功，都會把字串加到note
        WCFieldModel *fieldModel = [WCFieldModel newFieldModel];
        fieldModel.type = WC_FT_Note;
        fieldModel.value = sourceString;
        [cardModel addField:fieldModel];
        [fieldModel release];
    }
    
    return cardModel;
}


//================================================================================
// 手刮
//================================================================================
- (WCCardModel *)newCardFlowRequestClipRecogWithSourceModel:(WCRecogSourceModel *)recogSourceModel
                                          originalCardModel:(WCCardModel *)originalCardModel
                                                      error:(NSError **)error
{
    WCCardModel *cardModel = nil;
    WCRecognitionCardModel *recogCardModel = nil;
    WCRecognitionController *recognitionController = nil;
    
    do
    {
        recogCardModel = [[WCRecognitionCardModel alloc] init];
        
        if(recogCardModel==nil)
        {
            break;
        }
        
        recogCardModel.sourceImageType = (recogSourceModel.imageType==WC_IT_FrontSide)?WCRecognitionImageType_FrontSide:WCRecognitionImageType_BackSide;
        
        if(recogSourceModel.imageType==WC_IT_FrontSide)
        {
            recogCardModel.frontRecognitionLanguage = recogSourceModel.recogLang;
        }
        else
        {
            recogCardModel.backRecognitionLanguage = recogSourceModel.recogLang;
        }
        
        //////////////////////////////////////////////////
        
        recognitionController = [[WCRecognitionController alloc] init];
        
        if(recognitionController==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        // 是否自動格式化電話
        [recognitionController setAutoFormatPhone:[PPSettingsController integerValueWithKey:WCSC_IV_kAutoFormatPhoneNumber]];
        // 設定辨識後電話是否需要加上國碼
        [recognitionController setAddCountryCodeToPhone:[PPSettingsController integerValueWithKey:WCSC_IV_kRecognPhoneCountryCode]];
        
        //////////////////////////////////////////////////
        // 手刮只會回傳一個欄位
        if([recognitionController clipRecogWithRecogSource:recogSourceModel card:recogCardModel error:error])
        {
            cardModel = [recogCardModel cardModelTransform];
            
            // 首字大寫
            if([PPSettingsController integerValueWithKey:WCSC_IV_kCapitalizeRecogResult]==YES)
            {
                [cardModel capitalizedString];
            }
        }
        
    }
    while (0);
    
    [recognitionController release];
    [recogCardModel release];
    
    return cardModel;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Group handler


//================================================================================
//
//================================================================================
- (NSArray *)newCardFlowRequestCardModelDefaultGroupIDArray
{
    WC_GroupID groupID = WC_GID_Unfiled;
#if defined (PRODUCTLINE_WCSF)||defined (PRODUCTLINE_WCO365)
    groupID = WC_GID_Salesforce_Unuploaded;
#else
    groupID = (WC_GroupID)[PPSettingsController integerValueWithKey:WCSC_IV_kTargetGroupID];
    
    if(groupID == WC_GID_All || groupID == WC_GID_Unverified)
        groupID = WC_GID_Unfiled;
#endif
    return [NSArray arrayWithObject:[NSString stringWithInteger:groupID]];
}


//================================================================================
//
//================================================================================
- (NSMutableArray *)newCardFlowhWithAllGroupModelsWithCardID:(NSString *)cardID
{
    // !! 幫同事掃描介面上不顯示群組了，

    return nil;
}


//================================================================================
//
//================================================================================
- (NSString *)newCardFlowWithGroupNamesWithGroupIDArray:(NSArray *)groupIDArray
{
    // !! 幫同事掃描不支援
    return nil;
}


//================================================================================
//
//================================================================================
- (BOOL)newCardFlowWithExistGroupNamed:(NSString *)groupNamed
{
    // !! 幫同事掃描不支援
    return YES;
}


//================================================================================
//
//================================================================================
- (WCGroupModel *)newCardFlowWithGroupModelByNewGroupName:(NSString *)groupName error:(NSError **)error
{
    // !! 幫同事掃描不支援
    return nil;
}


//================================================================================
//
//================================================================================
- (WCGroupModel *)newCardFlowWithGroupModelByExistGroupName:(NSString *)groupName
{
    // !! 幫同事掃描不支援
    return nil;
}




#if defined (PRODUCTLINE_WCT)
////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - 帳號資訊


//==============================================================================
//
//==============================================================================
- (NSString *)newCardFlowRequestSelfAccountGuid
{
    // !! 幫同事掃描不支援
    return nil;
}


//==============================================================================
//
//==============================================================================
- (NSString *)newCardFlowRequestBossAccountGuid
{
    // !! 幫同事掃描不支援
    return nil;
}


//==============================================================================
//
//==============================================================================
- (NSString *)newCardFlowRequestRelationWithGuid:(NSString *)guid
{
    // !! 幫同事掃描不支援
    return nil;
}


//==============================================================================
//
//==============================================================================
- (NSString *)newCardFlowRequestAccountNameWithGuid:(NSString *)guid;
{
    // !! 幫同事掃描不支援
    return nil;
}


//==============================================================================
//
//==============================================================================
- (BOOL)newCardFlowRequestAccountExportAbility
{
    return YES;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - 可檢視用戶


//==============================================================================
//
//==============================================================================
- (NSArray *)newCardFlowRequestAllAccounts
{
    // !! 幫同事掃描不支援
    return nil;
}


//==============================================================================
//
//==============================================================================
- (NSArray *)newCardFlowRequestDefaultSharedAccountGuidsWithCardID:(NSString *)cardID
{
    // !! 幫同事掃描不支援
    return nil;
}


#endif





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - 自訂欄位


//==============================================================================
//
//==============================================================================
- (NSArray *)newCardFlowControllerRequestCustomFieldInfos
{
#if defined (PRODUCTLINE_WCT)
    return [[self.dataController copyAllCustomFieldInfos] autorelease];
#else
    return nil;
#endif
}




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - save data


//==============================================================================
// 單張新增
//==============================================================================
- (BOOL)newCardFlowRequestSaveWithSingleWCCardModel:(WCCardModel *)cardModel
                                       idPhotoImage:(UIImage *)idPhotoImage
                                     frontSideImage:(UIImage *)frontSideImage
                                      backSideImage:(UIImage *)backSideImage
                                           sourceID:(NSString *)sourceID
                                            groupID:(NSString *)groupID
                                           personID:(NSString *)personID
                                              error:(NSError **)error
{

    
    //////////////////////////////////////////////////
#if defined (PRODUCTLINE_WCT)
    [WCTMatomoController sendLogWithFeature:WCTMatomoController_Feature_Add];
#endif
    //////////////////////////////////////////////////
    
    // 只有WCM，WCT才要
#if defined (PRODUCTLINE_WCM) ||defined (PRODUCTLINE_WCT)
//    [WCRegisterFlowController increaseNewCardCount];
#endif
    
    //////////////////////////////////////////////////
    
    return [self saveCardModel:cardModel
                  idPhotoImage:idPhotoImage
                frontSideImage:frontSideImage
                 backSideImage:backSideImage
                needSendNotify:NO
                         error:error];
}


//================================================================================
// 多張新增
//================================================================================
- (BOOL)newCardFlowRequestSaveWithWCCardModel:(WCCardModel *)cardModel
                                 idPhotoImage:(UIImage *)idPhotoImage
                               frontSideImage:(UIImage *)frontSideImage
                                backSideImage:(UIImage *)backSideImage
                                        error:(NSError **)error
{
// !! help scan一次一張
    return NO;
}


//================================================================================
//
//================================================================================
- (BOOL)newCardFlowRequestSaveWithImportWCCardModel:(WCCardModel *)cardModel
                                       idPhotoImage:(UIImage *)idPhotoImage
                                     frontSideImage:(UIImage *)frontSideImage
                                      backSideImage:(UIImage *)backSideImage
                                              error:(NSError **)error
{
    // !!沒有import
    return NO;
}


//================================================================================
//
//================================================================================
- (BOOL)newCardFlowRequestSaveWithWCABCardModel:(WCABCardModel *)cardModel error:(NSError **)error
{
    //!! 沒有匯入
    return NO;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - phone number auto format


//================================================================================
//
//================================================================================
- (BOOL)newCardFlowRequestAutoFormatPhoneNumber
{
    return [PPSettingsController integerValueWithKey:WCSC_IV_kAutoFormatPhoneNumber];
}


//================================================================================
//
//================================================================================
- (BOOL)newCardFlowRequestAppendCountryCode
{
    // !! 編輯介面不開國碼，只有辨識時才有用
    return NO;
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - promotion


//==============================================================================
//
//==============================================================================
- (void)newCardFlowControllerShowDockPromotionFromCaptureViewController:(WCCaptureViewController *)captureViewController
{

}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - import lite date

//==============================================================================
//
//==============================================================================
- (void)newCardFlowRequestDidSelectStorageSpaceSelectControllerSpaceType:(PPStorageSpaceSelectControllerSpaceType)storageSpaceSelectControllerSpaceType;
{

}

//==============================================================================
//
//==============================================================================
- (BOOL)newCardFlowRequesetEnableSpecificSpace
{
    BOOL result = NO;

    
    return result;
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - finish


//================================================================================
//
//================================================================================
- (void)newCardFlowDidFinishWithError:(NSError *)lastError
{
    // !! 修改做法，不需要release flow controller所以不用通知
#if defined (PRODUCTLINE_WCM)
    [WCReminderFlowController updateReminderLocalNotificationIfNeededWithForceUpdate:YES];
#endif
    
    if ([self.userInfo isKindOfClass:[NSNumber class]]==YES)
    {
        if([self.userInfo boolValue])
        {
            // !! 通知拍下一張
            if ([self.delegate respondsToSelector:@selector(newCardFlowDelegateAddNext)])
            {
                [self.delegate newCardFlowDelegateAddNext];
            }
        }
    }

}

@end
