//
//  WCNewCardFlowDelegateController.h
//  WorldCardMobile7
//
//  Created by sanhue on 2015/8/4.
//  Copyright (c) 2015年 penpower. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "WCNewCardFlowController.h"
#import "CommonDefine.h"


typedef NS_ENUM(NSInteger, WCNewCardFlowErrorCode)
{
    WCNewCardFlowErrorCode_None = 0,
    WCNewCardFlowErrorCode_FailedSaveToDB,
    WCNewCardFlowErrorCode_FailedSaveAddressBookToDB,
    WCNewCardFlowErrorCode_FailedSaveIDPhoto,
    WCNewCardFlowErrorCode_FailedSaveFrontSideImage,
    WCNewCardFlowErrorCode_FailedSaveBackSideImage,
    WCNewCardFlowErrorCode_FailedSaveToiPhoneContact,
    WCNewCardFlowErrorCode_CardNotExist,
};



/// 新增名片，儲存後會通知
#define WCNCFDC_NOTIFY_AddCard            @"WCNCFDC_NOTIFY_AddCard"
#define WCNCFDC_NOTIFY_UserInfo_CardID    @"WCNCFDC_NOTIFY_UserInfo_CardID"
#define WCNCFDC_NOTIFY_UserInfo_kUpdatedCardGroup    WCDC_NOTIFY_UserInfo_kUpdatedCardGroup

////////////////////////////////////////////////////////////////////////////////////////////////////
@protocol WCNoSFAccountNewCardFlowDelegateControllerDelegate <NSObject>
@optional
/// 回報剩餘張數
- (void)newCardFlowDelegateAddNext;

@end


////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCNoSFAccountNewCardFlowDelegateController : NSObject<WCNewCardFlowDatasource, WCNewCardFlowDelegate>

@property (nonatomic, assign) id<WCNoSFAccountNewCardFlowDelegateControllerDelegate> delegate;
@property (nonatomic, retain) id userInfo;

- (instancetype)initWithDataController:(DataController *)dataController;
@end
