//
//  TSMCNoSFAccountMultiSelectFlowController.m
//  WorldCardTeam_TSMC
//
//  Created by sanhue cheng on 2021/2/4.
//  Copyright © 2021 penpower. All rights reserved.
//

#import "TSMCNoSFAccountMultiSelectFlowController.h"
#import "PPButton+BarButton.h"
#import "ResourceDefine.h"

#import "WCToastController.h"
#import "WCTServerContactExportFlowController.h"
#import "PPAlertController.h"

#import "NSObject+PPBusyView.h"

// 直接用ExportFlowController的字串
#define TSMCNoSFAccountMultiSelectFlowController_MLS_ExportSuccess [@"MLS_ExportSuccess" localizedFromTable:@"WCExportFlowController"]

#define WCMultiSelectFlowController_ButtonTag_Export WCMultiSelectFlowController_ButtonTag_Delete+1
////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation TSMCNoSFAccountMultiSelectFlowController





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - init/dealloc methods



//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.tsmcDelegate = nil;
    //////////////////////////////////////////////////
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Private

//================================================================================
//
//================================================================================
- (void)deleteContactsWithGuids:(NSArray *)contactGuids
                progressHandler:(void(^)(CGFloat progress))progressHandler
                       complete:(void(^)(NSArray <WCTRCGuidWithData *> *errorDataList,NSError *error))complete
{
    __block NSError *returnError = nil;
    
    do
    {
        if([contactGuids count]<=0)
        {
            returnError = PPErrorParameterInvalidity(returnError);
            
            complete(nil,returnError);
            
            break;
        }
        
        //////////////////////////////////////////////////
        
        WCTRCContactSetCategoriesRequest *request = [[WCTRCContactSetCategoriesRequest alloc] init];
        
        if(request==nil)
        {
            break;
        }
        
        request.contactGuids = contactGuids;
        request.behavior = WCTRC_Behavior_RemoveAll;

        //////////////////////////////////////////////////
        
        dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
            
            WCTRCPrivateContactOperateCategoryResponseResult *result = [[WCTRestClientController shareRestClientController] privateContactOperateCategoryWithContactSetCategoriesRequest:request
                                                                                                                                                                         progressHandler:progressHandler
                                                                                                                                                                                   error:&returnError];
            
            NSArray *errorDataList = [result.data retain];
            
            [request release];
            
            [returnError retain];
            
            dispatch_async(dispatch_get_main_queue(), ^{
                
                complete(errorDataList,returnError);
                
                [errorDataList release];
                
                [returnError release];
            });
        });
    }
    while (0);
}

//================================================================================
//
//================================================================================
- (NSArray *)toolBarButtonArray
{
    NSMutableArray *normalButtons = [NSMutableArray array];
    if (normalButtons!=nil)
    {
        PPButton *ppButtonExport = [PPButton ppButtonWithIconImageName:MultiSelect_IconExport
                                                                   tag:WCMultiSelectFlowController_ButtonTag_Export
                                                              delegate:self];
        [normalButtons addObject:ppButtonExport];
        
        
        //////////////////////////////////////////////////
        
        PPButton *ppButtonDelete = [PPButton ppButtonWithIconImageName:MultiSelect_IconDelete
                                                                   tag:WCMultiSelectFlowController_ButtonTag_Delete
                                                              delegate:self];
        [normalButtons addObject:ppButtonDelete];
        
        //////////////////////////////////////////////////
        
    }
    
    return normalButtons;
}


//================================================================================
//
//================================================================================
- (NSArray *)bottomToolBarButtonArrayInWCMultiSelectViewController:(WCMultiSelectViewController *)wcMultiSelectViewController
{
    return [self toolBarButtonArray];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Button action


//==============================================================================
//
//==============================================================================
- (void)onClickExportContacts
{
    if(![self.multiSelectViewController.multiSelectCardIDSet count])
    {
        [WCToastController showMessageToastFromSuperView:self.multiSelectViewController.view withMessage:MultiSelect_NonSelection position:PPToastPositionCenter];
        return;
    }
    
    if([self.multiSelectViewController.multiSelectCardIDSet count] > WCMultiSelectViewController_MaxSelectCount)
    {
        NSString  *message = [NSString stringWithFormat:MultiSelect_MaxSelectCount, WCMultiSelectViewController_MaxSelectCount];
        [WCToastController showMessageToastFromSuperView:self.multiSelectViewController.view withMessage:message position:PPToastPositionCenter];
        return;
    }
    
    //////////////////////////////////////////////////
    __block typeof(self) blockSelf = self;
    
    dispatch_async(dispatch_get_main_queue(), ^{
        NSArray *cardIDArray = [blockSelf.multiSelectViewController.multiSelectCardIDSet allObjects];
        [WCTServerContactExportFlowController exportToTarget:WCTServerExportTarget_Salesforce
                                                withContacts:cardIDArray
                                          fromViewController:blockSelf.multiSelectViewController
                                             completeHandler:^(NSError *error) {
            NSString *message = nil;
            if(error)
            {
                if ([self.tsmcDelegate respondsToSelector:@selector(tsmcNoSFAccountMultiSelectFlowController:requestErrorMessageWithError:)])
                {
                    message = [self.tsmcDelegate tsmcNoSFAccountMultiSelectFlowController:self requestErrorMessageWithError:error];
                }
            }
            else
            {
                message = TSMCNoSFAccountMultiSelectFlowController_MLS_ExportSuccess;
            }
            
            if([message length]>0)
            {
                UIAlertAction *action = [UIAlertAction actionWithTitle:Common_Ok style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
                    
                    [blockSelf.multiSelectViewController goBackAnimated:YES];
                    [blockSelf closeMultiSelectFlowWithHandler:^{
                        [blockSelf sendEndWithSync:NO];
                        [blockSelf setBusy:@(NO)];
                    }];
                }];
                [PPAlertController showWithAlertControllerStyle:UIAlertControllerStyleAlert
                                                          title:@""
                                                        message:message
                                         showFromViewController:blockSelf.multiSelectViewController
                                                       animated:YES
                                                    alertAction:action, nil];

            }
        }];
    });
}


//==============================================================================
//
//==============================================================================
- (void)onClickDeleteConacts
{
    if(![self.multiSelectViewController.multiSelectCardIDSet count])
    {
        [WCToastController showMessageToastFromSuperView:self.multiSelectViewController.view withMessage:MultiSelect_NonSelection position:PPToastPositionCenter];
        return;
    }
    
    if([self.multiSelectViewController.multiSelectCardIDSet count] > WCMultiSelectViewController_MaxSelectCount)
    {
        NSString  *message = [NSString stringWithFormat:MultiSelect_MaxSelectCount, WCMultiSelectViewController_MaxSelectCount];
        [WCToastController showMessageToastFromSuperView:self.multiSelectViewController.view withMessage:message position:PPToastPositionCenter];
        return;
    }
    
    //////////////////////////////////////////////////
    __block typeof(self) blockSelf = self;
    
    [self setBusy:@(YES)];
    dispatch_async(dispatch_get_main_queue(), ^{
        NSArray *cardIDArray = [blockSelf.multiSelectViewController.multiSelectCardIDSet allObjects];
        [self deleteContactsWithGuids:cardIDArray
                      progressHandler:^(CGFloat progress) {
            
            [PPBusyView postMessage:[NSString stringWithFormat:@"%.02f%%", progress*100.0]];
        } complete:^(NSArray<WCTRCGuidWithData *> *errorDataList, NSError *error) {
            
//            [blockSelf.multiSelectViewController setNavigationBarTitleString:[NSString stringWithFormat:MultiSelect_Count ,[blockSelf.multiSelectViewController.multiSelectCardIDSet count]]];
//            [blockSelf.multiSelectViewController.tableView reloadData];
//            [blockSelf setBusy:@(NO)];
            // !! group完成後要回到card holder
            [blockSelf.multiSelectViewController goBackAnimated:YES];
            [blockSelf closeMultiSelectFlowWithHandler:^{
                [blockSelf sendEndWithSync:NO];
                [self setBusy:@(NO)];
            }];
        }];
    });
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PPButtonDelegate




//==============================================================================
//
//==============================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    switch (ppButton.tag)
    {
        case WCMultiSelectFlowController_ButtonTag_Export:
        {
            [self onClickExportContacts];
            break;
        }
        case WCMultiSelectFlowController_ButtonTag_Delete:
        {
            [self onClickDeleteConacts];
            break;
        }
        default:
            break;
    }
}
@end
