//
//  WCXFWrapper.m
//
//

#import "PPWcxfFile.h"
#import "WCXFWrapper.h"
#import "WCToolController.h"
#import "WCImageDefine.h"
#import "WCGroupModel.h"
#import "NSError+Custom.h"
#import "NSString+Additions.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#define PPWCXF_FormatVersion    105
#define PPWCXF_Tag_Favorite     "FAVOR"
#define PPWCXF_Tag_Unverified   "unVRF"

////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL g_isSetRandomSeedForFileID = NO;

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCXFWrapper ()
@property (nonatomic, assign) id<WCXFWrapperDelegate> delegate;
@property (nonatomic, assign) CPPWcxfFile *pWcxfFile;
@property (nonatomic, assign) void *pFileHandle;
@end

@implementation WCXFWrapper

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Life cycle methods

//================================================================================
//
//================================================================================
- (instancetype)initWithDelegate:(id<WCXFWrapperDelegate>)delegate
{
    if (self = [super init])
    {
        self.delegate = delegate;
        
        _pWcxfFile = new CPPWcxfFile;
        
        if(_pWcxfFile == nil)
        {
            [self dealloc];
            return nil;
        }
    }
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.delegate = nil;
    
    if(self.pWcxfFile)
    {
        delete _pWcxfFile;
        _pWcxfFile = nil;
    }
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Private methods

//================================================================================
//
//================================================================================
- (PPDate *)createPPDatePtrFromNSDate:(NSDate *)date
{
    PPDate *result = new PPDate();
    
    NSCalendar *calendar = [NSCalendar currentCalendar];
    calendar.timeZone = [NSTimeZone timeZoneForSecondsFromGMT:0];

    NSDateComponents *components = [calendar components:(NSCalendarUnitYear|NSCalendarUnitMonth|NSCalendarUnitDay|
                                                         NSCalendarUnitHour|NSCalendarUnitMinute|NSCalendarUnitSecond) fromDate:date];
    
    result->m_Year   = [@([components year]) intValue];
    result->m_Month  = [@([components month]) intValue];
    result->m_Day    = [@([components day]) intValue];
    result->m_Hour   = [@([components hour]) intValue];
    result->m_Minute = [@([components minute]) intValue];
    result->m_Second = [@([components second]) intValue];
    
    return result;
}

//================================================================================
//
//================================================================================
- (PPDate)PPDateFromNSDate:(NSDate *)date
{
    PPDate result;
    
    NSCalendar *calendar = [NSCalendar currentCalendar];
    calendar.timeZone = [NSTimeZone timeZoneForSecondsFromGMT:0];

    NSDateComponents *components = [calendar components:(NSCalendarUnitYear|NSCalendarUnitMonth|NSCalendarUnitDay|
                                                         NSCalendarUnitHour|NSCalendarUnitMinute|NSCalendarUnitSecond) fromDate:date];
    
    result.m_Year   = [@([components year]) intValue];
    result.m_Month  = [@([components month]) intValue];
    result.m_Day    = [@([components day]) intValue];
    result.m_Hour   = [@([components hour]) intValue];
    result.m_Minute = [@([components minute]) intValue];
    result.m_Second = [@([components second]) intValue];
    
    
    return result;
}


//================================================================================
//
//================================================================================
- (NSDate*)NSDateFromPPDate:(PPDate)date
{
    NSDate *resultDate;
    NSCalendar *calendar = [NSCalendar currentCalendar];
    calendar.timeZone = [NSTimeZone timeZoneForSecondsFromGMT:0];

    NSDateComponents *components = [[NSDateComponents alloc] init];
    [components setSecond:date.m_Second];
    [components setMinute:date.m_Minute];
    [components setHour:date.m_Hour];
    [components setDay:date.m_Day];
    [components setMonth:date.m_Month];
    [components setYear:date.m_Year];
    
    resultDate=[calendar dateFromComponents:components];
    [components release];
    
    return resultDate;
}


//================================================================================
//
//================================================================================
- (NSDate*)NSDateFromPPDatePtr:(PPDate*)date
{
    NSDate *resultDate;
    NSCalendar *calendar = [NSCalendar currentCalendar];
    calendar.timeZone = [NSTimeZone timeZoneForSecondsFromGMT:0];

    NSDateComponents *components = [[NSDateComponents alloc] init];
    [components setSecond:date->m_Second];
    [components setMinute:date->m_Minute];
    [components setHour:date->m_Hour];
    [components setDay:date->m_Day];
    [components setMonth:date->m_Month];
    [components setYear:date->m_Year];
    
    resultDate=[calendar dateFromComponents:components];
    [components release];
    
    return resultDate;
    
}


//================================================================================
//
//================================================================================
- (PPCStringW)PPCStringWFromNSString:(NSString *)string
{
    NSString        *inputString=[[NSString alloc] initWithFormat:@"%@",string];
    PPCStringW      result;
    
    NSInteger       stringLength=[inputString length];
    NSRange         range=NSMakeRange(0, stringLength);
    
    // TODO: !! 如果 string是空字串，這邊可能會heap-buffer-overflow需要找看有沒有其他做法
    // solve: alloc +1長度的buffer
    if (stringLength==0)
    {
        stringLength++;
    }
    
    unichar         *buffer=(unichar *)malloc(sizeof(unichar)*(stringLength)*2);
    memset(buffer, 0, sizeof(unichar)*(stringLength)*2);
    
    //get UTF string
    [inputString getCharacters:buffer range:range];
    
    PPWCHAR *utfString=buffer;
    result=(utfString);
    free(buffer);
    [inputString release];
    
    return result;
}


//================================================================================
// 特別注意，這邊的PPCStringWPtr是new出來的，外面要自己free掉
//================================================================================
- (PPCStringW*)createPPCStringWPtrFromNSString:(NSString *)string
{
    // !! 如果 string是空字串，這邊可能會heap-buffer-overflow需要找看有沒有其他做法
    // solve: 直接回傳空的PPCStringW
    if ([string length]==0)
    {
        return new PPCStringW();
    }
    
    NSString        *inputString=[[NSString alloc] initWithFormat:@"%@",string];
    
    NSInteger       stringLength=[inputString length];
    NSRange         range = NSMakeRange(0, stringLength);
    unichar         *buffer=(unichar *)malloc(sizeof(unichar)*(stringLength)*2);
    memset(buffer, 0, sizeof(unichar)*(stringLength)*2);
    
    //get UTF string
    [inputString getCharacters:buffer range:range];
    
    PPWCHAR *utfString=buffer;
    PPCStringW     *result= new PPCStringW(utfString);
    free(buffer);
    [inputString release];
    
    return result;
}


//================================================================================
//
//================================================================================
- (NSString *)NSStringFromPPCStringPtr:(PPCStringW *)string
{
    if(string->GetLength()<=0)
    {
        return nil;
    }
    else
    {
        NSString *resultString = [NSString stringWithCharacters:string->GetBuffer() length:string->GetLength()];
        return resultString;
    }
}


//================================================================================
//
//================================================================================
- (NSString *)NSStringFromPPCString:(PPCStringW)string
{
    if(string.GetLength()<=0)
    {
        return nil;
    }
    else
    {
        NSString *resultString=[NSString stringWithCharacters:string.GetBuffer() length:string.GetLength()];
        return resultString;
    }
}


//================================================================================
//
//================================================================================
- (NSString *)mainGroupStringFromPPCStringPtr:(PPCStringW *)string
{
    if(string->GetLength()<=0)
    {
        return nil;
    }
    else
    {
        NSString *resultString = [NSString stringWithCharacters:string->GetBuffer() length:string->GetLength()];
        //處理多層多類別的問題
        NSRange range = [resultString rangeOfString:@"/"];
        if (range.location != NSNotFound) {
            // ex: mainGroup/subGroup
            resultString = [[resultString componentsSeparatedByString:@"/"] objectAtIndex:0];
        }
        return resultString;
    }
}


//================================================================================
// !! write過程中建立記憶體的方式和read過程不同，需要自己用對應的方式釋放。
//================================================================================
- (void)freeWritingRecord:(WCXFRecord &)oneRecord
{
    int i,j;
    WCXFRecord_Name *oneNamePtr;
    WCXFRecord_Adrs  *oneAdrsPtr;
    WCXFRecord_AdrsL3 *tmpAdrsL3Ptr;
    WCXFRecord_Company *oneCompanyPtr;
    WCXFRecord_Email *oneEmailPtr;
    WCXFRecord_URL *oneURLPtr;
    WCXFRecord_IM *oneIMPtr;
    WCXFRecord_IML3 *oneIMPL3tr;
    WCXFRecord_Date *oneDatePtr;
    PPDate *onePPDatePtr;
    WCXFRecord_Phone *onePhonePtr;
    
    
    //////////////////////////////////////////////////
    // name

    for (i = 0;i < (int)oneRecord.m_NamePtrDQ.size();i++)
    {
        oneNamePtr = oneRecord.m_NamePtrDQ[i];
        if (oneNamePtr != 0)
        {
            delete oneNamePtr;
        }
    }
    oneRecord.m_NamePtrDQ.clear();
    

    //////////////////////////////////////////////////
    // company

    for (i = 0;i < (int)oneRecord.m_CompanyPtrDQ.size();i++)
    {
        oneCompanyPtr = oneRecord.m_CompanyPtrDQ[i];
        if (oneCompanyPtr != 0)
        {
            delete oneCompanyPtr;
        }
    }
    oneRecord.m_CompanyPtrDQ.clear();
    
    [self freePPCStringWDQ:oneRecord.m_DepartmentPtrDQ];
    [self freePPCStringWDQ:oneRecord.m_PositionPtrDQ];
    
    
    //////////////////////////////////////////////////
    // address

    for (i = 0;i < (int)oneRecord.m_AddressPtrDQ.size();i++)
    {
        oneAdrsPtr = oneRecord.m_AddressPtrDQ[i];
        if (oneAdrsPtr != 0)
        {
            //////////////////////////////////////////////////
            
            for (j = 0;j < (int)oneAdrsPtr->m_HomePtrDQ.size();j++)
            {
                tmpAdrsL3Ptr = oneAdrsPtr->m_HomePtrDQ[j];
                if (tmpAdrsL3Ptr != 0)
                {
                    delete tmpAdrsL3Ptr;
                }
            }
            oneAdrsPtr->m_HomePtrDQ.clear();
            
            //////////////////////////////////////////////////
            
            for (j = 0;j < (int)oneAdrsPtr->m_OtherPtrDQ.size();j++)
            {
                tmpAdrsL3Ptr = oneAdrsPtr->m_OtherPtrDQ[j];
                if (tmpAdrsL3Ptr != 0)
                {
                    delete tmpAdrsL3Ptr;
                }
            }
            oneAdrsPtr->m_OtherPtrDQ.clear();
            
            //////////////////////////////////////////////////
            
            for (j = 0;j < (int)oneAdrsPtr->m_WorkPtrDQ.size();j++)
            {
                tmpAdrsL3Ptr = oneAdrsPtr->m_WorkPtrDQ[j];
                if (tmpAdrsL3Ptr != 0)
                {
                    delete tmpAdrsL3Ptr;
                }
            }
            oneAdrsPtr->m_WorkPtrDQ.clear();
            
            //////////////////////////////////////////////////
            
            delete oneAdrsPtr;
        }
    }
    oneRecord.m_AddressPtrDQ.clear();
    
    
    //////////////////////////////////////////////////
    // phone
    
    for (i = 0;i < (int)oneRecord.m_PhonePtrDQ.size();i++)
    {
        onePhonePtr = oneRecord.m_PhonePtrDQ[i];
        if (onePhonePtr != 0)
        {
            [self freePPCStringWDQ:onePhonePtr->m_Phone_GoogleVoicePtrDQ];
            [self freePPCStringWDQ:onePhonePtr->m_Phone_HomeFaxPtrDQ];
            [self freePPCStringWDQ:onePhonePtr->m_Phone_HomePtrDQ];
            [self freePPCStringWDQ:onePhonePtr->m_Phone_iPhonePtrDQ];
            [self freePPCStringWDQ:onePhonePtr->m_Phone_MainPtrDQ];
            [self freePPCStringWDQ:onePhonePtr->m_Phone_MobilePtrDQ];
            [self freePPCStringWDQ:onePhonePtr->m_Phone_OtherFaxPtrDQ];
            [self freePPCStringWDQ:onePhonePtr->m_Phone_OtherPtrDQ];
            [self freePPCStringWDQ:onePhonePtr->m_Phone_PagerPtrDQ];
            [self freePPCStringWDQ:onePhonePtr->m_Phone_PrimaryPtrDQ];
            [self freePPCStringWDQ:onePhonePtr->m_Phone_WorkFaxPtrDQ];
            [self freePPCStringWDQ:onePhonePtr->m_Phone_WorkPtrDQ];
            
            delete onePhonePtr;
        }
    }
    oneRecord.m_PhonePtrDQ.clear();
    
    
    //////////////////////////////////////////////////
    // email

    for (i = 0;i < (int)oneRecord.m_EmailPtrDQ.size();i++)
    {
        oneEmailPtr = oneRecord.m_EmailPtrDQ[i];
        if (oneEmailPtr != 0)
        {
            [self freePPCStringWDQ:oneEmailPtr->m_WorkPtrDQ];
            [self freePPCStringWDQ:oneEmailPtr->m_HomePtrDQ];
            [self freePPCStringWDQ:oneEmailPtr->m_OtherPtrDQ];
            
            delete oneEmailPtr;
        }
    }
    oneRecord.m_EmailPtrDQ.clear();
    
    
    //////////////////////////////////////////////////
    // url
    
    for (i = 0;i < (int)oneRecord.m_URLPtrDQ.size();i++)
    {
        oneURLPtr = oneRecord.m_URLPtrDQ[i];
        if (oneURLPtr != 0)
        {
            [self freePPCStringWDQ:oneURLPtr->m_BlogPtrDQ];
            [self freePPCStringWDQ:oneURLPtr->m_FacebookPtrDQ];
            [self freePPCStringWDQ:oneURLPtr->m_HomePagePtrDQ];
            [self freePPCStringWDQ:oneURLPtr->m_HomePtrDQ];
            [self freePPCStringWDQ:oneURLPtr->m_LinkedInPtrDQ];
            [self freePPCStringWDQ:oneURLPtr->m_OtherPtrDQ];
            [self freePPCStringWDQ:oneURLPtr->m_PlurkPtrDQ];
            [self freePPCStringWDQ:oneURLPtr->m_ProfilePtrDQ];
            [self freePPCStringWDQ:oneURLPtr->m_TwitterPtrDQ];
            [self freePPCStringWDQ:oneURLPtr->m_WorkPtrDQ];
            
            delete oneURLPtr;
        }
    }
    oneRecord.m_URLPtrDQ.clear();
    
    
    //////////////////////////////////////////////////
    // Instant message
    
    for (i = 0;i < (int)oneRecord.m_InstantMessagePtrDQ.size();i++)
    {
        oneIMPtr = oneRecord.m_InstantMessagePtrDQ[i];
        if (oneIMPtr != 0)
        {
            //////////////////////////////////////////////////
            
            for (j = 0;j < (int)oneIMPtr->m_HomePtrDQ.size();j++)
            {
                oneIMPL3tr = oneIMPtr->m_HomePtrDQ[j];
                if (oneIMPL3tr != 0)
                {
                    [self freePPCStringWDQ:oneIMPL3tr->m_AIMPtrDQ];
                    [self freePPCStringWDQ:oneIMPL3tr->m_GoogleTalkPtrDQ];
                    [self freePPCStringWDQ:oneIMPL3tr->m_ICQPtrDQ];
                    [self freePPCStringWDQ:oneIMPL3tr->m_JabberPtrDQ];
                    [self freePPCStringWDQ:oneIMPL3tr->m_MSNPtrDQ];
                    [self freePPCStringWDQ:oneIMPL3tr->m_QQPtrDQ];
                    [self freePPCStringWDQ:oneIMPL3tr->m_YahooMessengerPtrDQ];
                    
                    delete oneIMPL3tr;
                }
            }
            oneIMPtr->m_HomePtrDQ.clear();
            
            //////////////////////////////////////////////////
            
            for (j = 0;j < (int)oneIMPtr->m_OtherPtrDQ.size();j++)
            {
                oneIMPL3tr = oneIMPtr->m_OtherPtrDQ[j];
                if (oneIMPL3tr != 0)
                {
                    [self freePPCStringWDQ:oneIMPL3tr->m_AIMPtrDQ];
                    [self freePPCStringWDQ:oneIMPL3tr->m_GoogleTalkPtrDQ];
                    [self freePPCStringWDQ:oneIMPL3tr->m_ICQPtrDQ];
                    [self freePPCStringWDQ:oneIMPL3tr->m_JabberPtrDQ];
                    [self freePPCStringWDQ:oneIMPL3tr->m_MSNPtrDQ];
                    [self freePPCStringWDQ:oneIMPL3tr->m_QQPtrDQ];
                    [self freePPCStringWDQ:oneIMPL3tr->m_YahooMessengerPtrDQ];
                    
                    delete oneIMPL3tr;
                }
            }
            oneIMPtr->m_OtherPtrDQ.clear();
            
            //////////////////////////////////////////////////
            
            for (j = 0;j < (int)oneIMPtr->m_WorkPtrDQ.size();j++)
            {
                oneIMPL3tr = oneIMPtr->m_WorkPtrDQ[j];
                if (oneIMPL3tr != 0)
                {
                    [self freePPCStringWDQ:oneIMPL3tr->m_AIMPtrDQ];
                    [self freePPCStringWDQ:oneIMPL3tr->m_GoogleTalkPtrDQ];
                    [self freePPCStringWDQ:oneIMPL3tr->m_ICQPtrDQ];
                    [self freePPCStringWDQ:oneIMPL3tr->m_JabberPtrDQ];
                    [self freePPCStringWDQ:oneIMPL3tr->m_MSNPtrDQ];
                    [self freePPCStringWDQ:oneIMPL3tr->m_QQPtrDQ];
                    [self freePPCStringWDQ:oneIMPL3tr->m_YahooMessengerPtrDQ];
                    
                    delete oneIMPL3tr;
                }
            }
            oneIMPtr->m_WorkPtrDQ.clear();
            
            //////////////////////////////////////////////////
            
            delete oneIMPtr;
        }
    }
    oneRecord.m_InstantMessagePtrDQ.clear();

    // !! skype要特別處理
    [self freePPCStringWDQ:oneRecord.m_SkypePtrDQ];

    
    
    //////////////////////////////////////////////////
    // date

    for (i = 0;i < (int)oneRecord.m_DatePtrDQ.size();i++)
    {
        oneDatePtr = oneRecord.m_DatePtrDQ[i];
        if (oneDatePtr != 0)
        {
            //////////////////////////////////////////////////
            
            for (j = 0;j < (int)oneDatePtr->m_AnniversaryPtrDQ.size();j++)
            {
                onePPDatePtr = oneDatePtr->m_AnniversaryPtrDQ[j];
                if (onePPDatePtr != 0)
                {
                    delete onePPDatePtr;
                }
            }
            oneDatePtr->m_AnniversaryPtrDQ.clear();
            
            //////////////////////////////////////////////////
            
            for (j = 0;j < (int)oneDatePtr->m_OtherPtrDQ.size();j++)
            {
                onePPDatePtr = oneDatePtr->m_OtherPtrDQ[j];
                if (onePPDatePtr != 0)
                {
                    delete onePPDatePtr;
                }
            }
            oneDatePtr->m_OtherPtrDQ.clear();
            
            //////////////////////////////////////////////////
            
            delete oneDatePtr;
        }
    }
    oneRecord.m_DatePtrDQ.clear();

    
    //////////////////////////////////////////////////
    // Nickname
    
    [self freePPCStringWDQ:oneRecord.m_NickNamePtrDQ];
    
    
    //////////////////////////////////////////////////
    // Unified Business Number
    
    [self freePPCStringWDQ:oneRecord.m_UnifiedBusinessNumberPtrDQ];
    
    
    //////////////////////////////////////////////////
    // UserDefine (reserved, not using in writing WCXF)

    for (i = 0;i < (int)oneRecord.m_UserDefinePtrDQ.size();i++)
    {
        WCXFRecord_UD_L1 *oneUDL1P = oneRecord.m_UserDefinePtrDQ[i];
        if (oneUDL1P != 0)
        {
            for (j = 0;j < (int)oneUDL1P->m_UserDefinePDQ.size();j++)
            {
                WCXFRecord_UD_L2 *oneUDL2P= oneUDL1P->m_UserDefinePDQ[j];
                if (oneUDL2P != 0)
                {
                    delete oneUDL2P;
                }
            }
            oneUDL1P->m_UserDefinePDQ.clear();
            delete oneUDL1P;
        }
    }
    oneRecord.m_UserDefinePtrDQ.clear();


    //////////////////////////////////////////////////
    // Tags

    for (i = 0;i < (int)oneRecord.m_TagPtrDQ.size();i++)
    {
        WCXFRecord_Tag_L1 *oneTag1P = oneRecord.m_TagPtrDQ[i];
        if (oneTag1P != 0)
        {
            for (j = 0;j < (int)oneTag1P->m_TagPDQ.size();j++)
            {
                WCXFRecord_Tag_L2 *oneTag2P= oneTag1P->m_TagPDQ[j];
                if (oneTag2P != 0)
                {
                    delete oneTag2P;
                }
            }
            oneTag1P->m_TagPDQ.clear();
            delete oneTag1P;
        }
    }
    oneRecord.m_TagPtrDQ.clear();
    
    
    //////////////////////////////////////////////////
    // image
    
    if(oneRecord.m_Image_Flag&DEF_WCXF_IMAGE_FLAG_FRONT)
    {
        free(oneRecord.m_Image_Front_Ptr);
    }
    if(oneRecord.m_Image_Flag&DEF_WCXF_IMAGE_FLAG_BACK)
    {
        free(oneRecord.m_Image_Back_Ptr);
    }
    if(oneRecord.m_Image_Flag&DEF_WCXF_IMAGE_FLAG_PHOTO)
    {
        free(oneRecord.m_Image_IDPhoto_Ptr);
    }
    
    
    //////////////////////////////////////////////////
    // group

    for (i = 0;i < (int)oneRecord.m_GroupV2PtrDQ.size();i++)
    {
        WCXFRecord_GroupV2 *oneGroupPtr = oneRecord.m_GroupV2PtrDQ[i];
        if (oneGroupPtr != 0)
        {
            [self freePPCStringWDQ:oneGroupPtr->m_DefaultPtrDQ];
            
            [self freePPCStringWDQ:oneGroupPtr->m_DefinedPtrDQ];
            
            delete oneGroupPtr;
        }
    }
    
    oneRecord.m_GroupPtrDQ.clear();
}


//================================================================================
//
//================================================================================
- (void)freePPCStringWDQ:(PPCStringWPtrDQ)stringDQ
{
    
    for (int i = 0;i < (int)stringDQ.size();i++)
    {
        PPCStringW *oneString = stringDQ[i];
        if (oneString != NULL)
        {
            delete oneString;
        }
    }
    stringDQ.clear();
    
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Private methods (Read WCXF)

//================================================================================
//
//================================================================================
- (WCFieldModel *)newAddressFieldModelFromAddressRecord:(WCXFRecord_AdrsL3 *)addressRecordL3 subType1:(WC_FieldSubType1)subType1
{
    WCFieldModel *fieldModel = [[WCFieldModel alloc] init];
    
    if(fieldModel==nil)
    {
        return nil;
    }
    
    fieldModel.type=WC_FT_Address;
    fieldModel.subType1=subType1;
    
    
    [fieldModel setSubType2FieldWithValue:[self NSStringFromPPCString:addressRecordL3->m_Street] recogRect:CGRectZero subType2:WC_FST2_Address_Street];
    
    [fieldModel setSubType2FieldWithValue:[self NSStringFromPPCString:addressRecordL3->m_City] recogRect:CGRectZero subType2:WC_FST2_Address_City];
    
    [fieldModel setSubType2FieldWithValue:[self NSStringFromPPCString:addressRecordL3->m_State] recogRect:CGRectZero subType2:WC_FST2_Address_State];
    
    [fieldModel setSubType2FieldWithValue:[self NSStringFromPPCString:addressRecordL3->m_ZIP] recogRect:CGRectZero subType2:WC_FST2_Address_ZIP];
    
    [fieldModel setSubType2FieldWithValue:[self NSStringFromPPCString:addressRecordL3->m_Country] recogRect:CGRectZero subType2:WC_FST2_Address_Country];
    
    [fieldModel setSubType2FieldWithValue:[self NSStringFromPPCString:addressRecordL3->m_CountryCode] recogRect:CGRectZero subType2:WC_FST2_Address_CountryCode];
    
    [fieldModel setSubType2FieldWithValue:[NSNumber numberWithInt:addressRecordL3->m_Format] recogRect:CGRectZero subType2:WC_FST2_Address_Format];
    
    [fieldModel setSubType2FieldWithValue:[self NSStringFromPPCString:addressRecordL3->m_GPS] recogRect:CGRectZero subType2:WC_FST2_Address_Location];
    
    return fieldModel;
}


//================================================================================
//
//================================================================================
- (void)parseDQDataIntoCardModel:(WCCardModel *)cardModel stringDQ:(PPCStringWPtrDQ)stringDQ type:(WC_FieldType)type subType1:(WC_FieldSubType1)subType1
{
    
    for (int i = 0;i < (int)stringDQ.size();i++)
    {
        PPCStringW *oneString=NULL;
        oneString= stringDQ[i];
        
        if (oneString != NULL)
        {
            WCFieldModel *fieldModel = [[WCFieldModel alloc] init];
            
            if(fieldModel==nil)
            {
                continue;
            }
            
            fieldModel.type=type;
            fieldModel.subType1=subType1;
            NSString *parsedString=[self NSStringFromPPCStringPtr:oneString];
            if(parsedString!=nil)
            {
                fieldModel.value=parsedString;
                [cardModel addField:fieldModel];
            }
            [fieldModel release];
        }
    }
    
}


//==============================================================================
//
//==============================================================================
- (WCFieldModel *)firstCompanyFieldModelFromCardModel:(WCCardModel *)cardModel
                                      withoutSubType2:(WC_FieldSubType2)subType2
                                              atIndex:(NSInteger)index
{
    NSMutableArray *companyArray = [cardModel fieldArrayWithType:WC_FT_Company];
    if([companyArray count]>index)
    {
        WCFieldModel *fieldModel = [companyArray objectAtIndex:index];
        if ([fieldModel fieldWithSubType2:subType2]==nil)
        {
            return fieldModel;
        }
    }
    return nil;
}


//================================================================================
//
//================================================================================
- (WCCardModel *)copyCardModelFromRecord:(WCXFRecord)oneRecord
{
    int i,j,k;
    
    WCCardModel *resultCardModel = [[WCCardModel alloc] init];
    
    if(oneRecord.m_UniqueID.GetLength() > 0)
    {
        resultCardModel.ID = [self NSStringFromPPCString:oneRecord.m_UniqueID];
    }
    else
    {
        // !!舊版有些沒有assign cardID，這裏補上。
        resultCardModel.ID = [WCToolController generateCardID];
    }
    
    
    //////////////////////////////////////////////////
    //處理createdTime
    
    if(oneRecord.m_CreateTime.m_Month > 0)
    {
        resultCardModel.createdTime = [self NSDateFromPPDate:oneRecord.m_CreateTime];
    }
    
    
    //////////////////////////////////////////////////
    //處理modifiedTime

    if(oneRecord.m_ModifiedTime.m_Month>0)
    {
        resultCardModel.modifiedTime=[self NSDateFromPPDate:oneRecord.m_ModifiedTime];
    }
    
    //////////////////////////////////////////////////
    //處理正反面辨識語系
    
    resultCardModel.frontRecogLang = oneRecord.m_RecogLang.m_Front;
    resultCardModel.backRecogLang = oneRecord.m_RecogLang.m_Back;
    
    //////////////////////////////////////////////////
    //姓名轉CardModel
    
    WCXFRecord_Name *oneNamePtr;
    for (i = 0;i < (int)oneRecord.m_NamePtrDQ.size();i++)
    {
        oneNamePtr = NULL;
        oneNamePtr = oneRecord.m_NamePtrDQ[i];
        
        if (oneNamePtr != NULL)
        {
            WCFieldModel *fieldModel = [[WCFieldModel alloc] init];
            
            if(fieldModel!=nil)
            {
                fieldModel.type=WC_FT_Name;
                
                NSString *firstName = [self NSStringFromPPCString:oneNamePtr->m_Name_First];
                [fieldModel setSubType2FieldWithValue:firstName recogRect:CGRectZero subType2:WC_FST2_Name_First];
                
                NSString *firstNamePhonetic = [self NSStringFromPPCString:oneNamePtr->m_Name_PhoneticFirst];
                [fieldModel setSubType2FieldWithValue:firstNamePhonetic recogRect:CGRectZero subType2:WC_FST2_Name_FirstPhonetic];
                
                NSString *lastName = [self NSStringFromPPCString:oneNamePtr->m_Name_Last];
                [fieldModel setSubType2FieldWithValue:lastName recogRect:CGRectZero subType2:WC_FST2_Name_Last];
                
                NSString *lastNamePhonetic = [self NSStringFromPPCString:oneNamePtr->m_Name_PhoneticLast];
                [fieldModel setSubType2FieldWithValue:lastNamePhonetic recogRect:CGRectZero subType2:WC_FST2_Name_LastPhonetic];
                
                [fieldModel setSubType2FieldWithValue:[self NSStringFromPPCString:oneNamePtr->m_Name_Middle] recogRect:CGRectZero subType2:WC_FST2_Name_Middle];
                
                [fieldModel setSubType2FieldWithValue:[self NSStringFromPPCString:oneNamePtr->m_Name_Prefix] recogRect:CGRectZero subType2:WC_FST2_Name_Prefix];
                
                [fieldModel setSubType2FieldWithValue:[self NSStringFromPPCString:oneNamePtr->m_Name_Suffix] recogRect:CGRectZero subType2:WC_FST2_Name_Suffix];
                
                //////////////////////////////////////////////////
                // !! 特殊處理，如果只有讀音沒有姓名，把讀音填入姓名欄位，不然google同步可能會失敗
                if([firstName length]==0 && [firstNamePhonetic length]!=0)
                {
                    [fieldModel setSubType2FieldWithValue:firstNamePhonetic recogRect:CGRectZero subType2:WC_FST2_Name_First];
                }
                
                if([lastName length]==0 && [lastNamePhonetic length]!=0)
                {
                    [fieldModel setSubType2FieldWithValue:lastNamePhonetic recogRect:CGRectZero subType2:WC_FST2_Name_Last];
                }
                
                //////////////////////////////////////////////////
                [resultCardModel addField:fieldModel];
                [fieldModel release];
            }
        }
    }
    
    
    //////////////////////////////////////////////////
    //公司轉CardModel
    
    for (i = 0;i < (int)oneRecord.m_CompanyPtrDQ.size();i++)
    {
        WCXFRecord_Company *oneCompanyPtr = oneRecord.m_CompanyPtrDQ[i];
        
        if (oneCompanyPtr!=NULL)
        {
            // 先看原本company中有沒有部門是空的
            WCFieldModel *fieldModel = [self firstCompanyFieldModelFromCardModel:resultCardModel
                                                                 withoutSubType2:WC_FST2_Company_Name
                                                                         atIndex:i];
            
            // 如果沒有要建一個新的
            if (fieldModel==nil)
            {
                fieldModel = [[WCFieldModel alloc] init];
                fieldModel.type=WC_FT_Company;
                
                [resultCardModel addField:fieldModel];
                [fieldModel release];
            }
            
            // 寫入值
            NSString *companyName = nil;
            if (oneCompanyPtr->m_Company_Name!=NULL)
            {
                companyName = [self NSStringFromPPCString:oneCompanyPtr->m_Company_Name];
                [fieldModel setSubType2FieldWithValue:companyName recogRect:CGRectZero subType2:WC_FST2_Company_Name];
            }
            
            
            if (oneCompanyPtr->m_Company_Phonetic!=NULL)
            {
                NSString *companyNamePhonetic = [self NSStringFromPPCString:oneCompanyPtr->m_Company_Phonetic];
                [fieldModel setSubType2FieldWithValue:companyNamePhonetic recogRect:CGRectZero subType2:WC_FST2_Company_Phonetic];
                
                //////////////////////////////////////////////////
                // !! 特殊處理，如果只有讀音沒有公司名，把讀音填入公司名，不然google同步可能會失敗
                if ([companyName length]==0 && [companyNamePhonetic length]!=0)
                {
                    [fieldModel setSubType2FieldWithValue:companyNamePhonetic recogRect:CGRectZero subType2:WC_FST2_Company_Name];
                }
            }
        }
    }
    
    //////////////////////////////////////////////////
    // 處理部門

    for (i = 0;i < (int)oneRecord.m_DepartmentPtrDQ.size();i++)
    {
        PPCStringW *valueString = oneRecord.m_DepartmentPtrDQ[i];

        if (valueString!=NULL)
        {
            // 先看原本company中有沒有部門是空的
            WCFieldModel *fieldModel = [self firstCompanyFieldModelFromCardModel:resultCardModel
                                                                 withoutSubType2:WC_FST2_Company_Department
                                                                         atIndex:i];
            
            // 如果沒有要建一個新的
            if (fieldModel==nil)
            {
                fieldModel = [[WCFieldModel alloc] init];
                fieldModel.type=WC_FT_Company;
                
                [resultCardModel addField:fieldModel];
                [fieldModel release];
            }

            // 寫入值
            [fieldModel setSubType2FieldWithValue:[self NSStringFromPPCStringPtr:valueString] recogRect:CGRectZero subType2:WC_FST2_Company_Department];
        }
    }
    
    //////////////////////////////////////////////////
    // 處理職稱
    
    for (i = 0;i < (int)oneRecord.m_PositionPtrDQ.size();i++)
    {
        PPCStringW *valueString = oneRecord.m_PositionPtrDQ[i];
        
        if (valueString!=NULL)
        {
            // 先看原本company中有沒有職稱是空的
            WCFieldModel *fieldModel = [self firstCompanyFieldModelFromCardModel:resultCardModel
                                                                 withoutSubType2:WC_FST2_Company_JobTitle
                                                                         atIndex:i];
            
            // 如果沒有要建一個新的
            if (fieldModel==nil)
            {
                fieldModel = [[WCFieldModel alloc] init];
                fieldModel.type=WC_FT_Company;
                
                [resultCardModel addField:fieldModel];
                [fieldModel release];
            }
            
            // 寫入值
            [fieldModel setSubType2FieldWithValue:[self NSStringFromPPCStringPtr:valueString] recogRect:CGRectZero subType2:WC_FST2_Company_JobTitle];
        }
    }

    
    //////////////////////////////////////////////////
    //地址轉CardModel
    WCXFRecord_Adrs  *oneAdrsPtr;
    WCXFRecord_AdrsL3 *tmpAdrsL3Ptr;
    
    for (i = 0;i < (int)oneRecord.m_AddressPtrDQ.size();i++)
    {
        oneAdrsPtr=NULL;
        oneAdrsPtr = oneRecord.m_AddressPtrDQ[i];
        
        if (oneAdrsPtr != 0)
        {
            for (j = 0;j < (int)oneAdrsPtr->m_HomePtrDQ.size();j++)
            {
                tmpAdrsL3Ptr=NULL;
                tmpAdrsL3Ptr = oneAdrsPtr->m_HomePtrDQ[j];
                if (tmpAdrsL3Ptr != NULL)
                {
                    WCFieldModel *fieldModel=[self newAddressFieldModelFromAddressRecord:tmpAdrsL3Ptr subType1:WC_FST1_Address_Home];
                    if (fieldModel!=nil)
                    {
                        [resultCardModel addField:fieldModel];
                        [fieldModel release];
                    }
                }
            }
            
            //---------------------------------------------------
            for (j = 0;j < (int)oneAdrsPtr->m_OtherPtrDQ.size();j++)
            {
                tmpAdrsL3Ptr=NULL;
                tmpAdrsL3Ptr = oneAdrsPtr->m_OtherPtrDQ[j];
                if (tmpAdrsL3Ptr != NULL)
                {
                    WCFieldModel *fieldModel=[self newAddressFieldModelFromAddressRecord:tmpAdrsL3Ptr subType1:WC_FST1_Address_Other];
                    if (fieldModel!=nil)
                    {
                        [resultCardModel addField:fieldModel];
                        [fieldModel release];
                    }
                }
            }
            //---------------------------------------------------
            for (j = 0;j < (int)oneAdrsPtr->m_WorkPtrDQ.size();j++)
            {
                tmpAdrsL3Ptr=NULL;
                tmpAdrsL3Ptr = oneAdrsPtr->m_WorkPtrDQ[j];
                if (tmpAdrsL3Ptr != NULL)
                {
                    WCFieldModel *fieldModel=[self newAddressFieldModelFromAddressRecord:tmpAdrsL3Ptr subType1:WC_FST1_Address_Work];
                    if (fieldModel!=nil)
                    {
                        [resultCardModel addField:fieldModel];
                        [fieldModel release];
                    }
                }
            }
        }
    }
    
    
    //////////////////////////////////////////////////
    //電話轉Cardmodel
    WCXFRecord_Phone *onePhonePtr;
    
    for (i = 0;i < (int)oneRecord.m_PhonePtrDQ.size();i++)
    {
        onePhonePtr = NULL;
        onePhonePtr = oneRecord.m_PhonePtrDQ[i];
        
        if (onePhonePtr != 0)
        {
            [self parseDQDataIntoCardModel:resultCardModel stringDQ:onePhonePtr->m_Phone_GoogleVoicePtrDQ type:WC_FT_Phone subType1:WC_FST1_Phone_GoogleVoice];
            
            
            [self parseDQDataIntoCardModel:resultCardModel stringDQ:onePhonePtr->m_Phone_HomeFaxPtrDQ type:WC_FT_Phone subType1:WC_FST1_Phone_HomeFax];
            
            
            [self parseDQDataIntoCardModel:resultCardModel stringDQ:onePhonePtr->m_Phone_HomePtrDQ type:WC_FT_Phone subType1:WC_FST1_Phone_Home];
            
            
            [self parseDQDataIntoCardModel:resultCardModel stringDQ:onePhonePtr->m_Phone_iPhonePtrDQ type:WC_FT_Phone subType1:WC_FST1_Phone_iPhone];
            
            
            [self parseDQDataIntoCardModel:resultCardModel stringDQ:onePhonePtr->m_Phone_MainPtrDQ type:WC_FT_Phone subType1:WC_FST1_Phone_Main];
            
            
            [self parseDQDataIntoCardModel:resultCardModel stringDQ:onePhonePtr->m_Phone_MobilePtrDQ type:WC_FT_Phone subType1:WC_FST1_Phone_Mobile];
            
            
            [self parseDQDataIntoCardModel:resultCardModel stringDQ:onePhonePtr->m_Phone_OtherFaxPtrDQ type:WC_FT_Phone subType1:WC_FST1_Phone_Other];
            
            
            [self parseDQDataIntoCardModel:resultCardModel stringDQ:onePhonePtr->m_Phone_OtherPtrDQ type:WC_FT_Phone subType1:WC_FST1_Phone_Other];
            
            
            [self parseDQDataIntoCardModel:resultCardModel stringDQ:onePhonePtr->m_Phone_PagerPtrDQ type:WC_FT_Phone subType1:WC_FST1_Phone_Pager];
            
            
            [self parseDQDataIntoCardModel:resultCardModel stringDQ:onePhonePtr->m_Phone_PrimaryPtrDQ type:WC_FT_Phone subType1:WC_FST1_Phone_Other];
            
            
            [self parseDQDataIntoCardModel:resultCardModel stringDQ:onePhonePtr->m_Phone_WorkFaxPtrDQ type:WC_FT_Phone subType1:WC_FST1_Phone_WorkFax];
            
            
            [self parseDQDataIntoCardModel:resultCardModel stringDQ:onePhonePtr->m_Phone_WorkPtrDQ type:WC_FT_Phone subType1:WC_FST1_Phone_Work];
            
        }
    }
    
    
    //////////////////////////////////////////////////
    //email轉Cardmodel
    WCXFRecord_Email *oneEmailPtr;
    for (i = 0;i < (int)oneRecord.m_EmailPtrDQ.size();i++)
    {
        oneEmailPtr = NULL;
        oneEmailPtr = oneRecord.m_EmailPtrDQ[i];
        
        if (oneEmailPtr != NULL)
        {
            
            [self parseDQDataIntoCardModel:resultCardModel stringDQ:oneEmailPtr->m_HomePtrDQ type:WC_FT_Email subType1:WC_FST1_Email_Home];
            
            
            [self parseDQDataIntoCardModel:resultCardModel stringDQ:oneEmailPtr->m_OtherPtrDQ type:WC_FT_Email subType1:WC_FST1_Email_Other];
            
            
            [self parseDQDataIntoCardModel:resultCardModel stringDQ:oneEmailPtr->m_WorkPtrDQ type:WC_FT_Email subType1:WC_FST1_Email_Work];
            
        }
    }
    
    
    //////////////////////////////////////////////////
    //URL轉Cardmodel
    WCXFRecord_URL *oneURLPtr;
    
    for (i = 0;i < (int)oneRecord.m_URLPtrDQ.size();i++)
    {
        oneURLPtr = NULL;
        oneURLPtr = oneRecord.m_URLPtrDQ[i];
        
        if (oneURLPtr != NULL)
        {
            
            [self parseDQDataIntoCardModel:resultCardModel stringDQ:oneURLPtr->m_BlogPtrDQ type:WC_FT_URL subType1:WC_FST1_URL_Blog];
            
            
            [self parseDQDataIntoCardModel:resultCardModel stringDQ:oneURLPtr->m_FacebookPtrDQ type:WC_FT_URL subType1:WC_FST1_URL_Other];
            
            
            [self parseDQDataIntoCardModel:resultCardModel stringDQ:oneURLPtr->m_HomePagePtrDQ type:WC_FT_URL subType1:WC_FST1_URL_HomePage];
            
            
            [self parseDQDataIntoCardModel:resultCardModel stringDQ:oneURLPtr->m_HomePtrDQ type:WC_FT_URL subType1:WC_FST1_URL_Home];
            
            
            [self parseDQDataIntoCardModel:resultCardModel stringDQ:oneURLPtr->m_LinkedInPtrDQ type:WC_FT_URL subType1:WC_FST1_URL_Other];
            
            
            [self parseDQDataIntoCardModel:resultCardModel stringDQ:oneURLPtr->m_OtherPtrDQ type:WC_FT_URL subType1:WC_FST1_URL_Other];
            
            
            [self parseDQDataIntoCardModel:resultCardModel stringDQ:oneURLPtr->m_PlurkPtrDQ type:WC_FT_URL subType1:WC_FST1_URL_Other];
            
            
            [self parseDQDataIntoCardModel:resultCardModel stringDQ:oneURLPtr->m_ProfilePtrDQ type:WC_FT_URL subType1:WC_FST1_URL_Profile];
            
            
            [self parseDQDataIntoCardModel:resultCardModel stringDQ:oneURLPtr->m_TwitterPtrDQ type:WC_FT_URL subType1:WC_FST1_URL_Other];
            
            
            [self parseDQDataIntoCardModel:resultCardModel stringDQ:oneURLPtr->m_WorkPtrDQ type:WC_FT_URL subType1:WC_FST1_URL_Work];
            
        }
    }
    
    
    //InstantMessage轉Cardmodel
    WCXFRecord_IM *oneIMPtr;
    WCXFRecord_IML3 *oneIMPL3tr;
    
    for (i = 0;i < (int)oneRecord.m_InstantMessagePtrDQ.size();i++)
    {
        oneIMPtr = NULL;
        oneIMPtr = oneRecord.m_InstantMessagePtrDQ[i];
        
        if (oneIMPtr != NULL)
        {
            oneIMPL3tr=NULL;
            
            for (j = 0;j < (int)oneIMPtr->m_HomePtrDQ.size();j++)
            {
                oneIMPL3tr = oneIMPtr->m_HomePtrDQ[j];
                
                if (oneIMPL3tr != NULL)
                {
                    
                    [self parseDQDataIntoCardModel:resultCardModel stringDQ:oneIMPL3tr->m_AIMPtrDQ type:WC_FT_InstantMessage subType1:WC_FST1_IM_AIM];
                    
                    
                    [self parseDQDataIntoCardModel:resultCardModel stringDQ:oneIMPL3tr->m_GoogleTalkPtrDQ type:WC_FT_InstantMessage subType1:WC_FST1_IM_GoogleTalk];
                    
                    
                    [self parseDQDataIntoCardModel:resultCardModel stringDQ:oneIMPL3tr->m_ICQPtrDQ type:WC_FT_InstantMessage subType1:WC_FST1_IM_ICQ];
                    
                    
                    [self parseDQDataIntoCardModel:resultCardModel stringDQ:oneIMPL3tr->m_JabberPtrDQ type:WC_FT_InstantMessage subType1:WC_FST1_IM_Jabber];
                    
                    
                    [self parseDQDataIntoCardModel:resultCardModel stringDQ:oneIMPL3tr->m_MSNPtrDQ type:WC_FT_InstantMessage subType1:WC_FST1_IM_MSN];
                    
                    
                    [self parseDQDataIntoCardModel:resultCardModel stringDQ:oneIMPL3tr->m_QQPtrDQ type:WC_FT_InstantMessage subType1:WC_FST1_IM_QQ];
                    
                    
                    [self parseDQDataIntoCardModel:resultCardModel stringDQ:oneIMPL3tr->m_YahooMessengerPtrDQ type:WC_FT_InstantMessage subType1:WC_FST1_IM_Yahoo];
                }
            }
            
            //---------------------------------------------------
            oneIMPL3tr=NULL;
            
            for (j = 0;j < (int)oneIMPtr->m_OtherPtrDQ.size();j++)
            {
                oneIMPL3tr = oneIMPtr->m_OtherPtrDQ[j];
                
                if (oneIMPL3tr != NULL)
                {
                    
                    [self parseDQDataIntoCardModel:resultCardModel stringDQ:oneIMPL3tr->m_AIMPtrDQ type:WC_FT_InstantMessage subType1:WC_FST1_IM_AIM];
                    
                    
                    [self parseDQDataIntoCardModel:resultCardModel stringDQ:oneIMPL3tr->m_GoogleTalkPtrDQ type:WC_FT_InstantMessage subType1:WC_FST1_IM_GoogleTalk];
                    
                    
                    [self parseDQDataIntoCardModel:resultCardModel stringDQ:oneIMPL3tr->m_ICQPtrDQ type:WC_FT_InstantMessage subType1:WC_FST1_IM_ICQ];
                    
                    
                    [self parseDQDataIntoCardModel:resultCardModel stringDQ:oneIMPL3tr->m_JabberPtrDQ type:WC_FT_InstantMessage subType1:WC_FST1_IM_Jabber];
                    
                    
                    [self parseDQDataIntoCardModel:resultCardModel stringDQ:oneIMPL3tr->m_MSNPtrDQ type:WC_FT_InstantMessage subType1:WC_FST1_IM_MSN];
                    
                    
                    [self parseDQDataIntoCardModel:resultCardModel stringDQ:oneIMPL3tr->m_QQPtrDQ type:WC_FT_InstantMessage subType1:WC_FST1_IM_QQ];
                    
                    
                    [self parseDQDataIntoCardModel:resultCardModel stringDQ:oneIMPL3tr->m_YahooMessengerPtrDQ type:WC_FT_InstantMessage subType1:WC_FST1_IM_Yahoo];
                    
                }
            }
            
            //---------------------------------------------------
            oneIMPL3tr=NULL;
            
            for (j = 0;j < (int)oneIMPtr->m_WorkPtrDQ.size();j++)
            {
                oneIMPL3tr = oneIMPtr->m_WorkPtrDQ[j];
                
                if (oneIMPL3tr != NULL)
                {
                    [self parseDQDataIntoCardModel:resultCardModel stringDQ:oneIMPL3tr->m_AIMPtrDQ type:WC_FT_InstantMessage subType1:WC_FST1_IM_AIM];
                    
                    
                    [self parseDQDataIntoCardModel:resultCardModel stringDQ:oneIMPL3tr->m_GoogleTalkPtrDQ type:WC_FT_InstantMessage subType1:WC_FST1_IM_GoogleTalk];
                    
                    
                    [self parseDQDataIntoCardModel:resultCardModel stringDQ:oneIMPL3tr->m_ICQPtrDQ type:WC_FT_InstantMessage subType1:WC_FST1_IM_ICQ];
                    
                    
                    [self parseDQDataIntoCardModel:resultCardModel stringDQ:oneIMPL3tr->m_JabberPtrDQ type:WC_FT_InstantMessage subType1:WC_FST1_IM_Jabber];
                    
                    
                    [self parseDQDataIntoCardModel:resultCardModel stringDQ:oneIMPL3tr->m_MSNPtrDQ type:WC_FT_InstantMessage subType1:WC_FST1_IM_MSN];
                    
                    
                    [self parseDQDataIntoCardModel:resultCardModel stringDQ:oneIMPL3tr->m_QQPtrDQ type:WC_FT_InstantMessage subType1:WC_FST1_IM_QQ];
                    
                    
                    [self parseDQDataIntoCardModel:resultCardModel stringDQ:oneIMPL3tr->m_YahooMessengerPtrDQ type:WC_FT_InstantMessage subType1:WC_FST1_IM_Yahoo];
                }
            }
        }
    }
    
    //////////////////////////////////////////////////
    //skype資料室另外一個DQ，需要獨立處理
    [self parseDQDataIntoCardModel:resultCardModel stringDQ:oneRecord.m_SkypePtrDQ type:WC_FT_InstantMessage subType1:WC_FST1_IM_Skype];
    
    
    //////////////////////////////////////////////////
    //Date轉Cardmodel
    WCXFRecord_Date *oneDatePtr;
    PPDate *onePPDatePtr;
    for (i = 0;i < (int)oneRecord.m_DatePtrDQ.size();i++)
    {
        oneDatePtr=NULL;
        oneDatePtr = oneRecord.m_DatePtrDQ[i];
        if (oneDatePtr != NULL)
        {
            for (j = 0;j < (int)oneDatePtr->m_AnniversaryPtrDQ.size();j++)
            {
                onePPDatePtr = oneDatePtr->m_AnniversaryPtrDQ[j];
                if (onePPDatePtr != 0)
                {
                    // !! 生日的時分秒要ingore, 怕有之前匯出錯誤的資料，所以這邊強制重設為0
                    onePPDatePtr->m_Hour = 0;
                    onePPDatePtr->m_Minute = 0;
                    onePPDatePtr->m_Second = 0;

                    WCFieldModel *fieldModel = [[WCFieldModel alloc] init];
                    fieldModel.type=WC_FT_Date;
                    fieldModel.subType1=WC_FST1_Date_Anniversary;
                    
                    NSDate *parsedDate=[self NSDateFromPPDatePtr:onePPDatePtr];
                    if(parsedDate!=nil)
                    {
                        fieldModel.value=parsedDate;
                        [resultCardModel addField:fieldModel];
                    }
                    [fieldModel release];
                    
                }
            }
            
            for (j = 0;j < (int)oneDatePtr->m_OtherPtrDQ.size();j++)
            {
                onePPDatePtr = oneDatePtr->m_OtherPtrDQ[j];
                if (onePPDatePtr != 0)
                {
                    // !! 生日的時分秒要ingore, 怕有之前匯出錯誤的資料，所以這邊強制重設為0
                    onePPDatePtr->m_Hour = 0;
                    onePPDatePtr->m_Minute = 0;
                    onePPDatePtr->m_Second = 0;

                    WCFieldModel *fieldModel = [[WCFieldModel alloc] init];
                    fieldModel.type=WC_FT_Date;
                    fieldModel.subType1=WC_FST1_Date_Other;
                    NSDate *parsedDate=[self NSDateFromPPDatePtr:onePPDatePtr];
                    if(parsedDate!=nil)
                    {
                        fieldModel.value=parsedDate;
                        [resultCardModel addField:fieldModel];
                    }
                    [fieldModel release];
                }
            }
        }
    }
    
    
    if (oneRecord.m_Birthday.m_Year>0&&oneRecord.m_Birthday.m_Month>0&&oneRecord.m_Birthday.m_Day>0)
    {
        WCFieldModel *fieldModel = [[WCFieldModel alloc] init];
        fieldModel.type=WC_FT_Date;
        fieldModel.subType1=WC_FST1_Date_Birthday;
        
        // !! 生日的時分秒要ingore, 怕有之前匯出錯誤的資料，所以這邊強制重設為0
        oneRecord.m_Birthday.m_Hour = 0;
        oneRecord.m_Birthday.m_Minute = 0;
        oneRecord.m_Birthday.m_Second = 0;

        NSDate *parsedDate=[self NSDateFromPPDate:oneRecord.m_Birthday];
        if(parsedDate!=nil)
        {
            fieldModel.value=parsedDate;
            [resultCardModel addField:fieldModel];
        }
        [fieldModel release];
    }
    
    //////////////////////////////////////////////////
    // 自訂欄位
    // WC自訂欄位透過WCUserDefinedFieldValueModel處理
    // WCT要把自訂欄位寫到note
    // WCM目前不處理
    
    NSMutableString *noteForUserDefine = [NSMutableString string];
    
    if(self.productLine == WCXFDataController_ProductLine_WC)
    {
        for (i = 0;i < (int)oneRecord.m_UserDefinePtrDQ.size();i++)
        {
            WCXFRecord_UD_L1 *oneUserDefine = NULL;
            oneUserDefine = oneRecord.m_UserDefinePtrDQ[i];
            
            if (oneUserDefine != NULL)
            {
                for (j = 0; j < (int)oneUserDefine->m_UserDefinePDQ.size(); j++)
                {
                    WCXFRecord_UD_L2 *oneUserDefineData = NULL;
                    
                    oneUserDefineData = oneUserDefine->m_UserDefinePDQ[j];
                    
                    NSString *label = [self NSStringFromPPCString:oneUserDefineData->m_Label];
                    NSString *content = [self NSStringFromPPCString:oneUserDefineData->m_Content];
                    
                    if ([label length]>0)
                    {
                        WCFieldModel *fieldModel = [[WCFieldModel alloc] init];
                        
                        if(fieldModel != nil)
                        {
                            WCUserDefinedFieldValueModel *valueModel = [[WCUserDefinedFieldValueModel alloc] init];
                            
                            if(valueModel != nil)
                            {
                                valueModel.label = label;
                                valueModel.value = content;
                                
                                fieldModel.type=WC_FT_UserDefine;
                                fieldModel.subType1=WC_FST1_None;
                                fieldModel.value = valueModel;
                                
                                [resultCardModel addField:fieldModel];
                                [valueModel release];
                            }
                            
                            [fieldModel release];
                        }
                    }
                }
            }
        }
    }
    else if(self.productLine == WCXFDataController_ProductLine_WCT)
    {
        for (i = 0;i < (int)oneRecord.m_UserDefinePtrDQ.size();i++)
        {
            WCXFRecord_UD_L1 *oneUserDefine = NULL;
            oneUserDefine = oneRecord.m_UserDefinePtrDQ[i];
            
            if (oneUserDefine != NULL)
            {
                for (j = 0; j < (int)oneUserDefine->m_UserDefinePDQ.size(); j++)
                {
                    WCXFRecord_UD_L2 *oneUserDefineData = NULL;
                    
                    oneUserDefineData = oneUserDefine->m_UserDefinePDQ[j];
                    
                    NSString *label = [self NSStringFromPPCString:oneUserDefineData->m_Label];
                    NSString *content = [self NSStringFromPPCString:oneUserDefineData->m_Content];
                    
                    if ([label length]>0)
                    {
                        if([content length]==0)
                        {
                            content = @"";
                        }
                        
                        if([noteForUserDefine length]>0)
                        {
                            [noteForUserDefine appendString:@"\n"];
                        }
                        
                        [noteForUserDefine appendFormat:@"%@:%@", label, content];
                    }
                }
            }
        }
    }
    
    //////////////////////////////////////////////////
    //Note轉Cardmodel
    if(oneRecord.m_Note.GetLength()>0)
    {
        WCFieldModel *fieldModel = [[WCFieldModel alloc] init];
        fieldModel.type=WC_FT_Note;
        
        NSString *parsedString = [self NSStringFromPPCString:oneRecord.m_Note];
        
        if(parsedString==nil)
        {
            parsedString = @"";
        }
        
        if([noteForUserDefine length]>0)
        {
            if([parsedString length]>0)
            {
                parsedString = [parsedString stringByAppendingString:@"\n"];
            }
            
            parsedString = [parsedString stringByAppendingString:noteForUserDefine];
        }

        if([parsedString length]>0)
        {
            fieldModel.value = parsedString;
            [resultCardModel addField:fieldModel];
        }
        [fieldModel release];
        
    }
    
    
    //////////////////////////////////////////////////
    //NickName轉Cardmodel
    for (k = 0;k < (int)oneRecord.m_NickNamePtrDQ.size();k++)
    {
        PPCStringW *oneString = oneRecord.m_NickNamePtrDQ[k];
        if (oneString != 0)
        {
            WCFieldModel *fieldModel = [[WCFieldModel alloc] init];
            fieldModel.type=WC_FT_Nickname;
            NSString *parsedString=[self NSStringFromPPCStringPtr:oneString];
            if(parsedString!=nil)
            {
                fieldModel.value=parsedString;
                [resultCardModel addField:fieldModel];
            }
            [fieldModel release];
        }
    }
    
    //////////////////////////////////////////////////
    //UnifiedBusinessNo轉Cardmodel
    
    for (k = 0;k < (int)oneRecord.m_UnifiedBusinessNumberPtrDQ.size();k++)
    {
        PPCStringW *oneString = oneRecord.m_UnifiedBusinessNumberPtrDQ[k];
        if (oneString != 0)
        {
            WCFieldModel *fieldModel = [[WCFieldModel alloc] init];
            fieldModel.type=WC_FT_UnifiedBusinessNo;
            NSString *parsedString=[self NSStringFromPPCStringPtr:oneString];
            if(parsedString!=nil)
            {
                fieldModel.value=parsedString;
                [resultCardModel addField:fieldModel];
            }
            [fieldModel release];
        }
    }
    
    //////////////////////////////////////////////////
    //tag轉Cardmodel
    
    for (int i=0; i<(int)oneRecord.m_TagPtrDQ.size(); i++)
    {
        WCXFRecord_Tag_L1 *tagL1 = oneRecord.m_TagPtrDQ[i];
    
        for (int j=0; j<(int)tagL1->m_TagPDQ.size(); j++)
        {
            WCXFRecord_Tag_L2 *tagL2 = tagL1->m_TagPDQ[j];
            
            if (tagL2->m_Name.Compare(PPWCXF_Tag_Favorite) == 0)
            {
                resultCardModel.tagMask |= WC_TagMask_Favorite;
            }

            if (tagL2->m_Name.Compare(PPWCXF_Tag_Unverified) == 0)
            {
                resultCardModel.tagMask |= WC_TagMask_Unverified;
            }
        }
    }
    
    //////////////////////////////////////////////////
    
    return resultCardModel;
}


//================================================================================
//
//================================================================================
- (void)parseImageDataFromRecord:(WCXFRecord)oneRecord cardID:(NSString *)cardID
{
    //////////////////////////////////////////////////
    if(oneRecord.m_Image_Flag & DEF_WCXF_IMAGE_FLAG_FRONT)
    {
        NSData *imageData = [[NSData alloc] initWithBytes:oneRecord.m_Image_Front_Ptr
                                                   length:oneRecord.m_Image_Front_size];
        
        if(imageData!=nil)
        {
            [self.delegate wrapper:self didReadImageData:imageData imageType:WC_IT_FrontSide cardID:cardID];
            [imageData release];
        }
    }
    
    //////////////////////////////////////////////////
    
    if(oneRecord.m_Image_Flag & DEF_WCXF_IMAGE_FLAG_BACK)
    {
        NSData *imageData = [[NSData alloc] initWithBytes:oneRecord.m_Image_Back_Ptr
                                                   length:oneRecord.m_Image_Back_size];
        
        if(imageData!=nil)
        {
            [self.delegate wrapper:self didReadImageData:imageData imageType:WC_IT_BackSide cardID:cardID];
            [imageData release];
        }
    }
    
    //////////////////////////////////////////////////
    
    if(oneRecord.m_Image_Flag&DEF_WCXF_IMAGE_FLAG_PHOTO)
    {
        NSData *imageData = [[NSData alloc] initWithBytes:oneRecord.m_Image_IDPhoto_Ptr
                                                   length:oneRecord.m_Image_IDPhoto_size];
        
        if(imageData!=nil)
        {
            [self.delegate wrapper:self didReadImageData:imageData imageType:WC_IT_IDPhoto cardID:cardID];
            [imageData release];
        }
    }
}


//================================================================================
//
//================================================================================
- (void)parseGroupDataFromRecord:(WCXFRecord)oneRecord cardModel:(WCCardModel *)cardModel error:(NSError **)error
{
    int i,j;
    NSMutableArray *recordGroupIDArray = [[NSMutableArray alloc] init];
    NSMutableDictionary *addedGroupIDDict = [[NSMutableDictionary alloc] init];
    BOOL isRecordHaveNewGroupData = NO;
    
    //////////////////////////////////////////////////
    //parse新版wcxf group
    
    for (i = 0;i < (int)oneRecord.m_GroupV2PtrDQ.size();i++)
    {
        WCXFRecord_GroupV2 *oneGroupPtr = oneRecord.m_GroupV2PtrDQ[i];
        if (oneGroupPtr != 0)
        {
            NSString *groupName      = nil;
            WC_GroupID groupID = WC_GID_None;
            
            for (j = 0;j < (int)oneGroupPtr->m_DefaultPtrDQ.size();j++)
            {
                PPCStringW *oneString = oneGroupPtr->m_DefaultPtrDQ[j];
                if (oneString != 0)
                {
                    isRecordHaveNewGroupData=YES;
                    
                    groupName = [self mainGroupStringFromPPCStringPtr:oneString];
                    groupID = [self.delegate wrapper:self groupIDWithGroupName:groupName error:error];
                    
                    if (groupID > WC_GID_None)
                    {
                        NSString *groupIDString = [NSString stringWithInteger:groupID];

                        if([addedGroupIDDict objectForKey:groupIDString] == nil)
                        {
                            [addedGroupIDDict setObject:groupName forKey:groupIDString];
                            [recordGroupIDArray addObject:groupIDString];
                        }
                        
                        groupName = nil;
                    }
                    else
                    {
                        // !! 發生錯誤要中斷
                        break;
                    }
                }
            }
            
            
            //處理使用者自行建立的群組
            for (j = 0;j < (int)oneGroupPtr->m_DefinedPtrDQ.size();j++)
            {
                PPCStringW *oneString = oneGroupPtr->m_DefinedPtrDQ[j];
                if (oneString != 0)
                {
                    isRecordHaveNewGroupData = YES;
                    
                    groupName = [self NSStringFromPPCStringPtr:oneString];
                    groupID = [self.delegate wrapper:self groupIDWithGroupName:groupName error:error];
                    
                    if (groupID > WC_GID_None)
                    {
                        NSString *groupIDString = [NSString stringWithInteger:groupID];
                        
                        if([addedGroupIDDict objectForKey:groupIDString] == nil)
                        {
                            [addedGroupIDDict setObject:groupName forKey:groupIDString];
                            [recordGroupIDArray addObject:groupIDString];
                        }
                        
                        groupName = nil;
                    }
                    else
                    {
                        // !! 發生錯誤要中斷
                        break;
                    }
                }
            }
        }
    }
    
    
    //////////////////////////////////////////////////
    //parse舊版wcxf group
    if(!isRecordHaveNewGroupData)
    {
        for (i = 0;i < (int)oneRecord.m_GroupPtrDQ.size();i++)
        {
            PPCStringW *oneString = oneRecord.m_GroupPtrDQ[i];
            if (oneString != 0)
            {
                NSString *groupName = nil;
                WC_GroupID groupID = WC_GID_None;
                
                groupName = [self NSStringFromPPCStringPtr:oneString];
                groupID = [self.delegate wrapper:self groupIDWithGroupName:groupName error:error];
                
                if (groupID > WC_GID_None)
                {
                    NSString *groupIDString = [NSString stringWithInteger:groupID];
                    
                    if([addedGroupIDDict objectForKey:groupIDString] == nil)
                    {
                        [addedGroupIDDict setObject:groupName forKey:groupIDString];
                        [recordGroupIDArray addObject:groupIDString];
                    }

                    groupName = nil;
                }
                else
                {
                    // !! 發生錯誤要中斷
                    break;
                }
            }
        }
    }
    
    [cardModel setGroupIDArray:recordGroupIDArray isInitCard:YES];
    [recordGroupIDArray release];
    [addedGroupIDDict release];
}







////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Private methods (Write WCXF)

//================================================================================
//
//================================================================================
- (NSString *)generateFileID
{
    NSMutableString		*cardID      = [[NSMutableString alloc] initWithString:@""];
    const int           length       = 8;
    unsigned char       tmpUUID[8]   = {0};
    unsigned int        checkSum     = 0;
    NSTimeInterval      timeInterval = [[NSDate date] timeIntervalSince1970];
    uint                timeSeed     = ((int64_t)(timeInterval * 1000000))%1000000; // !!取出小數點後的數字
    
    
    // 取得時間作為random seed (設定一次就可以)
    if(g_isSetRandomSeedForFileID == NO)
    {
        srand(timeSeed);
        g_isSetRandomSeedForFileID = YES;
    }
    
    // 建立CardID
    tmpUUID[0] = (timeSeed >> 8) % 0xFF;
    tmpUUID[1] = timeSeed % 0xFF;
    tmpUUID[2] = rand() % 0xFF;
    tmpUUID[3] = rand() % 0xFF;
    tmpUUID[4] = rand() % 0xFF;
    tmpUUID[5] = rand() % 0xFF;
    
    // check sum
    for(int i=0; i<length-2; i++)
        checkSum += tmpUUID[i];
    
    tmpUUID[6] = (checkSum >> 8) % 0xFF;
    tmpUUID[7] = checkSum % 0xFF;
    
    for(int i=0; i<length; i++)
        [cardID appendFormat:@"%02x", tmpUUID[i]];
    
    return [cardID autorelease];
    
}


//================================================================================
//
//================================================================================
- (NSString *)appName
{
    NSString *bundleName = [[NSBundle mainBundle] objectForInfoDictionaryKey:@"CFBundleName"];
    
    return bundleName;
}


//================================================================================
//
//================================================================================
-(BOOL)parseAddressFieldModelToRecord:(WCFieldModel *)fieldModel record:(WCXFRecord_AdrsL3 *)addressRecordL3
{
    BOOL hasAddressData=NO;
    
    if([fieldModel hasFieldWithSubType2:WC_FST2_Address_Location])
    {
        addressRecordL3->m_GPS=[self PPCStringWFromNSString:[fieldModel valueWithSubType2:WC_FST2_Address_Location]];
        hasAddressData=YES;
    }
    
    if([fieldModel hasFieldWithSubType2:WC_FST2_Address_Country])
    {
        addressRecordL3->m_Country=[self PPCStringWFromNSString:[fieldModel valueWithSubType2:WC_FST2_Address_Country]];
        hasAddressData=YES;
    }
    
    
    if([fieldModel hasFieldWithSubType2:WC_FST2_Address_CountryCode])
    {
        addressRecordL3->m_CountryCode=[self PPCStringWFromNSString:[fieldModel valueWithSubType2:WC_FST2_Address_CountryCode]];
        hasAddressData=YES;
    }
    
    
    if([fieldModel hasFieldWithSubType2:WC_FST2_Address_State])
    {
        addressRecordL3->m_State=[self PPCStringWFromNSString:[fieldModel valueWithSubType2:WC_FST2_Address_State]];
        hasAddressData=YES;
    }
    
    
    if([fieldModel hasFieldWithSubType2:WC_FST2_Address_City])
    {
        addressRecordL3->m_City=[self PPCStringWFromNSString:[fieldModel valueWithSubType2:WC_FST2_Address_City]];
        hasAddressData=YES;
    }
    
    
    if([fieldModel hasFieldWithSubType2:WC_FST2_Address_Street])
    {
        addressRecordL3->m_Street=[self PPCStringWFromNSString:[fieldModel valueWithSubType2:WC_FST2_Address_Street]];
        hasAddressData=YES;
    }
    
    
    if([fieldModel hasFieldWithSubType2:WC_FST2_Address_ZIP])
    {
        addressRecordL3->m_ZIP=[self PPCStringWFromNSString:[fieldModel valueWithSubType2:WC_FST2_Address_ZIP]];
        hasAddressData=YES;
    }
    
    
    
    addressRecordL3->m_Format=[[fieldModel valueWithSubType2:WC_FST2_Address_Format] intValue];
    
    
    return hasAddressData;
    
}


//================================================================================
//oneRecord:直接從外面帶入指標，parse資料的時候直接塞資料進去
//================================================================================
- (void)writeFieldDataToRecord:(WCXFRecord *)oneRecord withCardModel:(WCCardModel *)cardModel
{
    oneRecord->clear();
    
    
    //////////////////////////////////////////////////
    //處理unique ID
    if([cardModel.ID length] > 0)
    {
        PPCStringW uniqueID=[self PPCStringWFromNSString:cardModel.ID];
        oneRecord->m_UniqueID=uniqueID;
    }
    
    
    //////////////////////////////////////////////////
    //處理createdTime
    if(cardModel.createdTime!=nil)
    {
        oneRecord->m_CreateTime=[self PPDateFromNSDate:cardModel.createdTime];
    }
    
    //處理modifiedTime
    if(cardModel.modifiedTime!=nil)
    {
        oneRecord->m_ModifiedTime=[self PPDateFromNSDate:cardModel.modifiedTime];
    }
    
    //////////////////////////////////////////////////
    //處理正反面辨識語系
    // !!正反面語系的值為0~25一定小於int，所以強制轉為int
    oneRecord->m_RecogLang.m_Front = (int)cardModel.frontRecogLang;
    oneRecord->m_RecogLang.m_Back = (int)cardModel.backRecogLang;
    

    //////////////////////////////////////////////////
    // name
    
    NSArray *nameArray = [cardModel fieldArrayWithType:WC_FT_Name];
    
    for(WCFieldModel *fieldModel in nameArray)
    {
        WCXFRecord_Name *cardName = new WCXFRecord_Name();
        BOOL hasName              = NO;
        
        if(cardName==NULL)
        {
            continue;
        }
        
        if([cardModel displayName].length>0)
        {
            cardName->m_Name_Full=[self PPCStringWFromNSString:[cardModel displayName]];
            hasName=YES;
        }
        
        if([fieldModel hasFieldWithSubType2:WC_FST2_Name_First])
        {
            cardName->m_Name_First=[self PPCStringWFromNSString:[fieldModel valueWithSubType2:WC_FST2_Name_First]];
            hasName=YES;
        }
        
        if([fieldModel hasFieldWithSubType2:WC_FST2_Name_FirstPhonetic])
        {
            cardName->m_Name_PhoneticFirst=[self PPCStringWFromNSString:[fieldModel valueWithSubType2:WC_FST2_Name_FirstPhonetic]];
            hasName=YES;
        }
        
        if([fieldModel hasFieldWithSubType2:WC_FST2_Name_Last])
        {
            cardName->m_Name_Last=[self PPCStringWFromNSString:[fieldModel valueWithSubType2:WC_FST2_Name_Last]];
            hasName=YES;
        }
        
        if([fieldModel hasFieldWithSubType2:WC_FST2_Name_LastPhonetic])
        {
            cardName->m_Name_PhoneticLast=[self PPCStringWFromNSString:[fieldModel valueWithSubType2:WC_FST2_Name_LastPhonetic]];
            hasName=YES;
        }
        
        if([fieldModel hasFieldWithSubType2:WC_FST2_Name_Middle])
        {
            cardName->m_Name_Middle=[self PPCStringWFromNSString:[fieldModel valueWithSubType2:WC_FST2_Name_Middle]];
            hasName=YES;
        }
        
        if([fieldModel hasFieldWithSubType2:WC_FST2_Name_Prefix])
        {
            cardName->m_Name_Prefix=[self PPCStringWFromNSString:[fieldModel valueWithSubType2:WC_FST2_Name_Prefix]];
            hasName=YES;
        }
        
        if([fieldModel hasFieldWithSubType2:WC_FST2_Name_Suffix])
        {
            cardName->m_Name_Suffix=[self PPCStringWFromNSString:[fieldModel valueWithSubType2:WC_FST2_Name_Suffix]];
            hasName=YES;
        }
        
        //最後在判斷名字中是否有任何資料，有的話才push到deque中
        if(hasName)
        {
            oneRecord->m_NamePtrDQ.push_back(cardName);
        }
        else
        {
            free(cardName);
        }
    }
    
    
    //////////////////////////////////////////////////
    // company
    
    NSArray *companyArray = [cardModel fieldArrayWithType:WC_FT_Company];
    
    for(WCFieldModel *fieldModel in companyArray)
    {
        WCXFRecord_Company  *companyName    = new WCXFRecord_Company();
        NSString            *valueString = nil;
        
        if(companyName == NULL)
        {
            // 記憶體不夠直接結束
            return;
        }
    
        //MARK: company/department/jobTitle順序要對應，所以空字串也要寫入。
        
        valueString = [fieldModel valueWithSubType2:WC_FST2_Company_Name];
        valueString = (valueString == nil) ? @"" : valueString;
        companyName->m_Company_Name=[self PPCStringWFromNSString:valueString];

        //--------------------------------------------------
        
        valueString = [fieldModel valueWithSubType2:WC_FST2_Company_Phonetic];
        valueString = (valueString == nil) ? @"" : valueString;
        companyName->m_Company_Phonetic=[self PPCStringWFromNSString:valueString];
        oneRecord->m_CompanyPtrDQ.push_back(companyName);
        
        //--------------------------------------------------

        valueString = [fieldModel valueWithSubType2:WC_FST2_Company_Department];
        valueString = (valueString == nil) ? @"" : valueString;
        oneRecord->m_DepartmentPtrDQ.push_back([self createPPCStringWPtrFromNSString:valueString]);
        
        //--------------------------------------------------

        valueString = [fieldModel valueWithSubType2:WC_FST2_Company_JobTitle];
        valueString = (valueString == nil) ? @"" : valueString;
        oneRecord->m_PositionPtrDQ.push_back([self createPPCStringWPtrFromNSString:valueString]);
    }
    
    
    //////////////////////////////////////////////////
    // address
    
    NSArray *addressArray = [cardModel fieldArrayWithType:WC_FT_Address];
    WCXFRecord_Address *addressRecord = new WCXFRecord_Address();
    
    for(WCFieldModel *fieldModel in addressArray)
    {
        WCXFRecord_AdrsL3   *address = new WCXFRecord_AdrsL3();
        
        if(address==NULL)
        {
            continue;
        }
        
        BOOL hasAddress=NO;
        
        
        hasAddress=[self parseAddressFieldModelToRecord:fieldModel record:address];
        
        
        if(hasAddress)
        {
            switch (fieldModel.subType1)
            {
                case WC_FST1_Address_Work:
                {
                    addressRecord->m_WorkPtrDQ.push_back(address);
                    break;
                }
                case WC_FST1_Address_Home:
                {
                    addressRecord->m_HomePtrDQ.push_back(address);
                    break;
                }
                case WC_FST1_Address_Other:
                {
                    addressRecord->m_OtherPtrDQ.push_back(address);
                    break;
                }
                default:
                    break;
            }
        }
        else
        {
            free(address);
        }
        
    }
    
    oneRecord->m_AddressPtrDQ.push_back(addressRecord);
    
    
    //////////////////////////////////////////////////
    // phone
    
    NSArray *phoneArray           = [cardModel fieldArrayWithType:WC_FT_Phone];
    WCXFRecord_Phone *phoneRecord = new WCXFRecord_Phone();
    
    for(WCFieldModel *fieldModel in phoneArray)
    {
        PPCStringW  *phone = NULL;
        BOOL hasPhone      = NO;
        
        if(((NSString *)fieldModel.value).length>0)
        {
            phone=[self createPPCStringWPtrFromNSString:fieldModel.value];
            
            if(phone!=NULL)
            {
                hasPhone=YES;
            }
        }
        
        if(hasPhone)
        {
            switch (fieldModel.subType1)
            {
                case WC_FST1_Phone_Work:
                {
                    phoneRecord->m_Phone_WorkPtrDQ.push_back(phone);
                    break;
                }
                case WC_FST1_Phone_Home:
                {
                    phoneRecord->m_Phone_HomePtrDQ.push_back(phone);
                    break;
                }
                case WC_FST1_Phone_Mobile:
                {
                    phoneRecord->m_Phone_MobilePtrDQ.push_back(phone);
                    break;
                }
                case WC_FST1_Phone_Main:
                {
                    phoneRecord->m_Phone_MainPtrDQ.push_back(phone);
                    break;
                }
                case WC_FST1_Phone_WorkFax:
                {
                    phoneRecord->m_Phone_WorkFaxPtrDQ.push_back(phone);
                    break;
                }
                case WC_FST1_Phone_HomeFax:
                {
                    phoneRecord->m_Phone_HomeFaxPtrDQ.push_back(phone);
                    break;
                }
                case WC_FST1_Phone_Pager:
                {
                    phoneRecord->m_Phone_PagerPtrDQ.push_back(phone);
                    break;
                }
                case WC_FST1_Phone_GoogleVoice:
                {
                    phoneRecord->m_Phone_GoogleVoicePtrDQ.push_back(phone);
                    break;
                }
                case WC_FST1_Phone_iPhone:
                {
                    phoneRecord->m_Phone_iPhonePtrDQ.push_back(phone);
                    break;
                }
                case WC_FST1_Phone_Other:
                {
                    phoneRecord->m_Phone_OtherPtrDQ.push_back(phone);
                    break;
                }
                default:
                    break;
            }
        }
    }
    
    oneRecord->m_PhonePtrDQ.push_back(phoneRecord);
    
    
    //////////////////////////////////////////////////
    // Email
    
    NSArray *emailArray = [cardModel fieldArrayWithType:WC_FT_Email];
    WCXFRecord_Email  *emailRecord = new WCXFRecord_Email();
    
    for(WCFieldModel *fieldModel in emailArray)
    {
        PPCStringW *email = NULL;
        BOOL hasEmail     = NO;
        
        if(((NSString *)fieldModel.value).length>0)
        {
            email=[self createPPCStringWPtrFromNSString:(NSString *)fieldModel.value];
            if(email!=NULL)
            {
                hasEmail=YES;
            }
        }
        
        if(hasEmail)
        {
            switch (fieldModel.subType1)
            {
                case WC_FST1_Email_Work:
                {
                    emailRecord->m_WorkPtrDQ.push_back(email);
                    break;
                }
                case WC_FST1_Email_Home:
                {
                    emailRecord->m_HomePtrDQ.push_back(email);
                    break;
                }
                case WC_FST1_Email_Other:
                {
                    emailRecord->m_OtherPtrDQ.push_back(email);
                    break;
                }
                default:
                    break;
            }
        }
    }
    oneRecord->m_EmailPtrDQ.push_back(emailRecord);
    
    
    //////////////////////////////////////////////////
    //URL
    
    NSArray *urlArray          = [cardModel fieldArrayWithType:WC_FT_URL];
    WCXFRecord_URL  *urlRecord = new WCXFRecord_URL();
    
    for(WCFieldModel *fieldModel in urlArray)
    {
        PPCStringW *url = NULL;
        BOOL     hasURL = NO;
        
        if(((NSString *)fieldModel.value).length>0)
        {
            url=[self createPPCStringWPtrFromNSString:(NSString *)fieldModel.value];
            if(url!=NULL)
            {
                hasURL=YES;
            }
        }
        
        if(hasURL)
        {
            switch (fieldModel.subType1)
            {
                case WC_FST1_URL_HomePage:
                {
                    urlRecord->m_HomePagePtrDQ.push_back(url);
                    break;
                }
                case WC_FST1_URL_Work:
                {
                    urlRecord->m_WorkPtrDQ.push_back(url);
                    break;
                }
                case WC_FST1_URL_Home:
                {
                    urlRecord->m_HomePtrDQ.push_back(url);
                    break;
                }
                case WC_FST1_URL_Profile:
                {
                    urlRecord->m_ProfilePtrDQ.push_back(url);
                    break;
                }
                case WC_FST1_URL_Blog:
                {
                    urlRecord->m_BlogPtrDQ.push_back(url);
                    break;
                }
                case WC_FST1_URL_Other:
                {
                    urlRecord->m_OtherPtrDQ.push_back(url);
                    break;
                }
                default:
                    break;
            }
        }
    }
    
    oneRecord->m_URLPtrDQ.push_back(urlRecord);
    

    //////////////////////////////////////////////////
    // Instant Message
    
    NSArray *instantMessageArray         = [cardModel fieldArrayWithType:WC_FT_InstantMessage];
    WCXFRecord_IM  *instantMessageRecord = new WCXFRecord_IM();
    WCXFRecord_IML3 *imRecordBytype      = new WCXFRecord_IML3();
    
    for(WCFieldModel *fieldModel in instantMessageArray)
    {
        PPCStringW *instantMessage = NULL;
        BOOL hasIM                 = NO;
        
        if(((NSString *)fieldModel.value).length>0)
        {
            instantMessage = [self createPPCStringWPtrFromNSString:(NSString *)fieldModel.value];
            if(instantMessage!=NULL)
            {
                hasIM=YES;
            }
        }
        
        if(hasIM)
        {
            switch (fieldModel.subType1)
            {
                case WC_FST1_IM_MSN:
                {
                    imRecordBytype->m_MSNPtrDQ.push_back(instantMessage);
                    break;
                }
                case WC_FST1_IM_Skype:
                {
                    oneRecord->m_SkypePtrDQ.push_back(instantMessage);
                    break;
                }
                case WC_FST1_IM_QQ:
                {
                    imRecordBytype->m_QQPtrDQ.push_back(instantMessage);
                    break;
                }
                case WC_FST1_IM_ICQ:
                {
                    imRecordBytype->m_ICQPtrDQ.push_back(instantMessage);
                    break;
                }
                case WC_FST1_IM_GoogleTalk:
                {
                    imRecordBytype->m_GoogleTalkPtrDQ.push_back(instantMessage);
                    break;
                }
                case WC_FST1_IM_Jabber:
                {
                    imRecordBytype->m_JabberPtrDQ.push_back(instantMessage);
                    break;
                }
                case WC_FST1_IM_AIM:
                {
                    imRecordBytype->m_AIMPtrDQ.push_back(instantMessage);
                    break;
                }
                case WC_FST1_IM_Yahoo:
                {
                    imRecordBytype->m_YahooMessengerPtrDQ.push_back(instantMessage);
                    break;
                }
                default:
                    break;
            }
        }
    }
    
    instantMessageRecord->m_WorkPtrDQ.push_back(imRecordBytype);
    oneRecord->m_InstantMessagePtrDQ.push_back(instantMessageRecord);
    
    
    //////////////////////////////////////////////////
    // date
    
    NSArray *dateArray = [cardModel fieldArrayWithType:WC_FT_Date];
    WCXFRecord_Date *dateRecord = new WCXFRecord_Date();
    
    for(WCFieldModel *fieldModel in dateArray)
    {
        NSDate *fieldDate = nil;
        BOOL hasDate      = NO;
        PPDate *datePtr   = NULL;
        PPDate birthdayDate;
        
        
        fieldDate=(NSDate *)fieldModel.value;
        
        if(fieldDate!=nil)
        {
            hasDate=YES;
        }
        
        if(hasDate)
        {
            switch (fieldModel.subType1)
            {
                case WC_FST1_Date_Birthday:
                {
                    birthdayDate = [self PPDateFromNSDate:fieldDate];
                    oneRecord->m_Birthday = birthdayDate;
                    break;
                }
                case WC_FST1_Date_Anniversary:
                {
                    datePtr = [self createPPDatePtrFromNSDate:fieldDate];
                    dateRecord->m_AnniversaryPtrDQ.push_back(datePtr);
                    break;
                }
                case WC_FST1_Date_Other:
                {
                    datePtr = [self createPPDatePtrFromNSDate:fieldDate];
                    dateRecord->m_OtherPtrDQ.push_back(datePtr);
                    break;
                }
                default:
                    break;
            }
        }
    }
    
    oneRecord->m_DatePtrDQ.push_back(dateRecord);
    
    
    //////////////////////////////////////////////////
    // Nickname
    
    NSArray *nickNameArray = [cardModel fieldArrayWithType:WC_FT_Nickname];
    
    for(WCFieldModel *fieldModel in nickNameArray)
    {
        if(((NSString *)fieldModel.value).length>0)
        {
            PPCStringW  *nickName = NULL;
            nickName = [self createPPCStringWPtrFromNSString:(NSString *)fieldModel.value];
            
            if(nickName!=NULL)
            {
                oneRecord->m_NickNamePtrDQ.push_back(nickName);
            }
        }
    }
    
    
    //////////////////////////////////////////////////
    // Unified Business No
    
    NSArray *unifiedBusinessNoArray = [cardModel fieldArrayWithType:WC_FT_UnifiedBusinessNo];
    
    for(WCFieldModel *fieldModel in unifiedBusinessNoArray)
    {
        if(((NSString *)fieldModel.value).length>0)
        {
            PPCStringW  *unifiedBusinessNo = NULL;
            unifiedBusinessNo = [self createPPCStringWPtrFromNSString:(NSString *)fieldModel.value];
            if(unifiedBusinessNo!=NULL)
            {
                oneRecord->m_UnifiedBusinessNumberPtrDQ.push_back(unifiedBusinessNo);
            }
        }
    }
    
    
    //////////////////////////////////////////////////
    // Note
    
    NSArray *noteArray=[cardModel fieldArrayWithType:WC_FT_Note];
    for(WCFieldModel *fieldModel in noteArray)
    {
        if(((NSString *)fieldModel.value).length>0)
        {
            PPCStringW note;
            note=[self PPCStringWFromNSString:(NSString *)fieldModel.value];
            oneRecord->m_Note=note;
        }
    }
    
    
    //////////////////////////////////////////////////
    // UserDefine
    
    if(self.productLine == WCXFDataController_ProductLine_WC)
    {
        NSArray *userDefineArray = [cardModel fieldArrayWithType:WC_FT_UserDefine];
        
        if([userDefineArray count] > 0)
        {
            WCXFRecord_UD_L1 *oneUserDefine = new WCXFRecord_UD_L1();
            
            if(oneUserDefine != NULL)
            {
                for(WCFieldModel *fieldModel in userDefineArray)
                {
                    WCXFRecord_UD_L2 *oneUserDefineData = new WCXFRecord_UD_L2();
                    
                    if(oneUserDefineData != NULL)
                    {
                        WCUserDefinedFieldValueModel *valueModel = (WCUserDefinedFieldValueModel *)fieldModel.value;
                        
                        oneUserDefineData->m_Label = [self PPCStringWFromNSString:valueModel.label];
                        oneUserDefineData->m_Content = [self PPCStringWFromNSString:valueModel.value];
                        
                        oneUserDefine->m_UserDefinePDQ.push_back(oneUserDefineData);
                    }
                }
                
                oneRecord->m_UserDefinePtrDQ.push_back(oneUserDefine);
            }
        }    
    }

    
    //////////////////////////////////////////////////
    // Tag
    
    WCXFRecord_Tag_L1 *tagL1 = new WCXFRecord_Tag_L1;
    
    if(tagL1 != NULL)
    {
        if(cardModel.tagMask & WC_TagMask_Favorite)
        {
            WCXFRecord_Tag_L2 *tagL2 = new WCXFRecord_Tag_L2;
            
            if(tagL2 != NULL)
            {
                tagL2->m_Name = PPWCXF_Tag_Favorite;
                tagL2->m_Data = "";
                tagL1->m_TagPDQ.push_back(tagL2);
            }
        }
        
        if(cardModel.tagMask & WC_TagMask_Unverified)
        {
            WCXFRecord_Tag_L2 *tagL2 = new WCXFRecord_Tag_L2;
            
            if(tagL2 != NULL)
            {
                tagL2->m_Name = PPWCXF_Tag_Unverified;
                tagL2->m_Data = "";
                tagL1->m_TagPDQ.push_back(tagL2);
            }
        }
        
        oneRecord->m_TagPtrDQ.push_back(tagL1);
    }
}


//================================================================================
//
//================================================================================
- (void)writeGroupDataToRecord:(WCXFRecord *)oneRecord withDefaultGroupNames:(NSArray *)defaultGroupNames definedGroupNames:(NSArray *)definedGroupNames
{
//    *1.新增欄位		kWCXF_CDL1_GroupV2	(只會有一個)
//    *					//(群組會有多個, 各自獨立)
//    *					kWCXF_CDL2_GroupV2_Default
//    *                 kWCXF_CDL2_GroupV2_Defined
//    *                 // kWCXF_CDL2_GroupV2_Default 區域是放置預設的群組種類, 105定義如下:
//    *					// My Contacts(Gmail), Friends(Gmail), Family(Gmail), Coworkers(Gmail)
//    *					// 型態為 <string>
    
    // !! 空的表示是未分類，不用塞
    if([defaultGroupNames count]==0 && [definedGroupNames count]==0)
    {
        return ;
    }
    
    WCXFRecord_GroupV2 *groupRecord = new WCXFRecord_GroupV2();
    
    if(groupRecord != nil)
    {
        for(NSString *groupName in defaultGroupNames)
        {
            PPCStringW *groupString = [self createPPCStringWPtrFromNSString:groupName];
            groupRecord->m_DefaultPtrDQ.push_back(groupString);
            oneRecord->m_GroupPtrDQ.push_back(groupString);
        }
        
        for(NSString *groupName in definedGroupNames)
        {
            PPCStringW *groupString = [self createPPCStringWPtrFromNSString:groupName];
            groupRecord->m_DefinedPtrDQ.push_back(groupString);
            oneRecord->m_GroupPtrDQ.push_back(groupString);
        }
        
        oneRecord->m_GroupV2PtrDQ.push_back(groupRecord);
    }
}


//================================================================================
//
//================================================================================
- (void)writeImageDataToRecord:(WCXFRecord *)oneRecord withImageDataDict:(NSDictionary *)imageDataDict
{
    NSData *imageData;
    
    //////////////////////////////////////////////////

    imageData = [imageDataDict objectForKey:@(WC_IT_FrontSide)];
    
    if (imageData != nil)
    {
        NSUInteger dataLength = [imageData length];
        unsigned char* imageBytes = (unsigned char*)malloc(dataLength);
        
        if(imageBytes)
        {
            memset(imageBytes, 0, dataLength);
            
            [imageData getBytes:imageBytes length:dataLength];
            
            oneRecord->m_Image_Front_Ptr  = imageBytes;
            oneRecord->m_Image_Front_size = (int)dataLength;
            oneRecord->m_Image_Flag       = oneRecord->m_Image_Flag|DEF_WCXF_IMAGE_FLAG_FRONT;
        }
    }
    
    //////////////////////////////////////////////////
    
    imageData = [imageDataDict objectForKey:@(WC_IT_BackSide)];
    
    if (imageData != nil)
    {
        NSUInteger dataLength = [imageData length];
        unsigned char* imageBytes = (unsigned char*)malloc(dataLength);
        
        if(imageBytes)
        {
            memset(imageBytes, 0, dataLength);
            
            [imageData getBytes:imageBytes length:dataLength];
            
            oneRecord->m_Image_Back_Ptr  = imageBytes;
            oneRecord->m_Image_Back_size = (int)dataLength;
            oneRecord->m_Image_Flag      = oneRecord->m_Image_Flag|DEF_WCXF_IMAGE_FLAG_BACK;
        }
    }
    
    //////////////////////////////////////////////////
    
    imageData = [imageDataDict objectForKey:@(WC_IT_IDPhoto)];
    
    if (imageData != nil)
    {
        NSUInteger dataLength = [imageData length];
        unsigned char* imageBytes = (unsigned char*)malloc(dataLength);
        
        if(imageBytes)
        {
            memset(imageBytes, 0, dataLength);
            
            [imageData getBytes:imageBytes length:dataLength];
            
            oneRecord->m_Image_IDPhoto_Ptr  = imageBytes;
            oneRecord->m_Image_IDPhoto_size = (int)dataLength;
            oneRecord->m_Image_Flag         = oneRecord->m_Image_Flag|DEF_WCXF_IMAGE_FLAG_PHOTO;
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Instance methods (Read WCXF)

//================================================================================
//
//================================================================================
- (BOOL)openFileForReadingWithPath:(NSString *)filePath
{
    self.pFileHandle = self.pWcxfFile->OpenWCXFFile((char*)[filePath UTF8String], DEF_WCXF_OPENFILE_MODE_READ);
    
    return (self.pFileHandle != NULL);
    
}


//================================================================================
//
//================================================================================
- (WCXFRootInfoModel *)copyRootInfo
{
    WCXFRootInfoModel *rootInfoModel = nil;
    
    if((self.pWcxfFile->GetRootInfo(self.pFileHandle) == PPTRUE))
    {
        rootInfoModel = [[WCXFRootInfoModel alloc] init];
        
        rootInfoModel.generator = [self NSStringFromPPCString:self.pWcxfFile->m_kWCXF_R_Generator];
        rootInfoModel.formatVersion = self.pWcxfFile->m_kWCXF_R_FormatVersion;
        rootInfoModel.fileID = [self NSStringFromPPCString:self.pWcxfFile->m_kWCXF_R_FileID];
        rootInfoModel.createTime = [self NSDateFromPPDate:self.pWcxfFile->m_kWCXF_R_FileCreateTime];
        rootInfoModel.cardCount = self.pWcxfFile->m_kWCXF_R_CardCount;
    }
    
    return rootInfoModel;
}


//================================================================================
//
//================================================================================
- (BOOL)readCardInfoWithTotalCount:(NSInteger)totalCount error:(NSError **)error
{
    BOOL result = NO;
    NSError *returnError = nil;
    int eofFlag, errCode, index = 0;
    void *cbData = nil;
    PPINT64 nowPos = self.pWcxfFile->m_kWCXF_R_CardArrayPos;
    WCXFRecord contactRecord;
    
    
    while (true)
    {
        @autoreleasepool
        {
            //////////////////////////////////////////////////
            
            if([self.delegate wrapper:self shouldReadCardWithIndex:index totalCount:totalCount] == NO)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            cbData = self.pWcxfFile->ParseOneCardData(self.pFileHandle, nowPos, eofFlag, errCode);
            
            if((cbData == 0) || (eofFlag == 1))
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            contactRecord.clear();
            
            // MARK: [測項] 更新元件後，出現問題，同一個記憶體位置，但解釋內容時不一樣，所以需要所以機器都測一次，以確保正確，可用簡單的WCXF測試就好
            self.pWcxfFile->Convert2WcxfRecord(cbData, contactRecord);
            
            //parse record的內容到CardModel
            WCCardModel *cardModel = [self copyCardModelFromRecord:contactRecord];
            
            //建立群組
            [self parseGroupDataFromRecord:contactRecord cardModel:cardModel error:&returnError];
            
            if (returnError!=nil)
            {
                //free record和data
                self.pWcxfFile->FreeOneRecord(contactRecord);
                self.pWcxfFile->FreeOneCard(cbData);
                [cardModel release];
                
                // for @autoreleasepool
                [returnError retain];                
                break;
            }
            
            // 先處理完群組再通知出去，不然接delegate的人要先把傳出去的cardModel存下來
            // 等group資訊傳出去後再更新，最後才能儲存
            // 先處理群組，就不用
            [self.delegate wrapper:self didReadCardInfo:cardModel];
            
            //建立名片圖
            [self parseImageDataFromRecord:contactRecord cardID:cardModel.ID];
            
            //free record和data
            self.pWcxfFile->FreeOneRecord(contactRecord);
            self.pWcxfFile->FreeOneCard(cbData);
            [cardModel release];
            
            //////////////////////////////////////////////////
            
            [self.delegate wrapper:self didReadCardWithIndex:index++ totalCount:totalCount];
        }
    }
    
    // for @autoreleasepool
    if(returnError != nil)
    {
        [returnError autorelease];
    }
    
    if (errCode != 0)
    {
        returnError = PPErrorMake(errCode, nil, nil);
    }
    
    // 沒有erroCode也沒有returnError才算成功
    if (errCode == 0&&returnError==nil)
    {
        result = YES;
    }
    
    if(error != nil)
    {
        *error = returnError;
    }
    
    return result;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Instance methods (Write WCXF)

//================================================================================
//
//================================================================================
- (BOOL)openFileForWritingWithPath:(NSString *)filePath
{
    self.pFileHandle = self.pWcxfFile->OpenWCXFFile((char*)[filePath UTF8String], DEF_WCXF_OPENFILE_MODE_WRITE);
    
    return (self.pFileHandle != NULL);
    
}


//================================================================================
//直接把CPPWcxfFile指標帶進來，這邊會直接塞資料
//================================================================================
- (BOOL)writeRootInfoWithFilePath:(NSString *)filePath cardCount:(NSInteger)cardCount
{
    NSString *fileID = [self generateFileID];
    NSString *generator = [NSString stringWithFormat:@"%@ %@",[self appName], [WCToolController appVersion]];
    NSDate *fileCreateDate = nil;
    PPCStringW generatorName;
    PPCStringW wcxfFileID;
    PPDate date;
    

    //////////////////////////////////////////////////
    // 取得建立時間
    
    NSDictionary* fileDict = [[NSFileManager defaultManager] attributesOfItemAtPath:filePath error:nil];
    
    if([[fileDict objectForKey:NSFileCreationDate] isKindOfClass:[NSDate class]])
    {
        fileCreateDate = (NSDate*)[fileDict objectForKey:NSFileCreationDate];
    }

    NSCalendar *calendar = [NSCalendar currentCalendar];
    
    NSDateComponents *components = nil;
    
    if(fileCreateDate!=nil)
    {
        components = [calendar components:(NSCalendarUnitYear|NSCalendarUnitMonth|NSCalendarUnitDay|NSCalendarUnitHour | NSCalendarUnitMinute|NSCalendarUnitSecond) fromDate:fileCreateDate];
    }
    
    date.m_Year   = (PPINT)[components year];
    date.m_Month  = (PPINT)[components month];
    date.m_Day    = (PPINT)[components day];
    date.m_Hour   = (PPINT)[components hour];
    date.m_Minute = (PPINT)[components minute];
    date.m_Second = (PPINT)[components second];
    

    //////////////////////////////////////////////////
    //取得generator
    generatorName = [self PPCStringWFromNSString:generator];
    

    //////////////////////////////////////////////////
    //取得fileID，目前是16位
    wcxfFileID = [self PPCStringWFromNSString:fileID];
    
    self.pWcxfFile->m_kWCXF_R_CardCount      = (int)cardCount;
    self.pWcxfFile->m_kWCXF_R_FormatVersion  = PPWCXF_FormatVersion;
    self.pWcxfFile->m_kWCXF_R_Generator      = generatorName;
    self.pWcxfFile->m_kWCXF_R_FileID         = wcxfFileID;
    self.pWcxfFile->m_kWCXF_R_FileCreateTime = date;
    
    return (self.pWcxfFile->WriteRootInfo(self.pFileHandle) > 0);
}


//================================================================================
//
//================================================================================
- (BOOL)writeCardInfoWithCardModel:(WCCardModel *)cardModel defaultGroupNames:(NSArray *)defaultGroupNames definedGroupNames:(NSArray *)definedGroupNames imageDataDict:(NSDictionary *)imageDataDict
{
    BOOL result = NO;
    WCXFRecord contactRecord;

    //parse card 的內容到record
    [self writeFieldDataToRecord:&contactRecord withCardModel:cardModel];
    
    //parse card group
    [self writeGroupDataToRecord:&contactRecord withDefaultGroupNames:defaultGroupNames definedGroupNames:definedGroupNames];

    //parse image
    [self writeImageDataToRecord:&contactRecord withImageDataDict:imageDataDict];
    
    if (self.pWcxfFile->WriteOneRecord(self.pFileHandle, contactRecord) > 0)
    {
        result = YES;
    }
    
    // !! write過程中建立記憶體的方式和read過程不同，需要自己用對應的方式釋放。
    [self freeWritingRecord:contactRecord];

    return result;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Instance methods

//================================================================================
//
//================================================================================
- (void)closeFile
{
    if(self.pFileHandle)
    {
        self.pWcxfFile->CloseWCXFFile(_pFileHandle);
        _pFileHandle = nil;
    }
}



@end
