//#include "stdafx.h"
#include "PPWcxfFile.h"

void *CPPWcxfFile::ParseOneCardData(void *hf,PPINT64 &iPos,int &eofFlag,int &errCode)
{
    CPPWcxfFInfo *oneInfoP = (CPPWcxfFInfo*)hf;
    PPCStringW tmpStr;
    PPCStringW tmpStr1;
    WCXFNode *rootNodePtr = 0;
    WCXFNode *nowNodePtr = 0;
    WCXFNode *tmpNodePtr = 0;
    WCXFNode *parentNodePtr = 0;
    PPINT64 iSPos,iEPos;
    PPCStringW *tmpCStrPtr;
    PPCStringW nextKeyValue;
    WCXFNodePtrDQ *onePtrDQP;
    WCXFNode *firstDict = 0;
    int blockEndFlag = 0;
    int iEofFlag = 0;
    int ErrMem;
    int ErrMem1;
    int tmpNum;
    int *tmpNumPtr;
    unsigned char *tmpDTPtr;
    WCXFData *tmpWFDataPtr;
    unsigned int dataLen;
    int		iErrCode = 0;
    
    
    if ((oneInfoP != 0) && (oneInfoP->m_Mode == DEF_WCXF_OPENFILE_MODE_READ))
    {
        nextKeyValue = "";
        errCode = 0;
        eofFlag = 0;
        rootNodePtr = new WCXFNode;
        if (rootNodePtr != 0)
        {
            
            rootNodePtr->m_Type = DEF_WCXF_NODE_ARRAY;
            rootNodePtr->m_Key = "kWCXF_R_CardArray";
            rootNodePtr->m_PNode = 0;
            rootNodePtr->m_Data = new WCXFNodePtrDQ;
            if (rootNodePtr->m_Data == 0)
            {
                //Exception
                iErrCode = DEF_WCXF_ERR_MEMORY;
                goto Error000;
            }else
            {
                nowNodePtr = rootNodePtr;
            }
        }else
        {
            iErrCode = DEF_WCXF_ERR_MEMORY;
            goto Error000;
        }
        
        blockEndFlag = 0;
        while ((GetNextToken(oneInfoP->m_FileH,iPos,tmpStr) == 1))
        {
            tmpStr.TrimLeft(" \t\r\n");
            tmpStr.TrimRight(" \t\r\n");
            
            if (tmpStr.Compare("array") == 0)
            {
                tmpNodePtr = new WCXFNode;
                if (tmpNodePtr != 0)
                {
                    tmpNodePtr->m_Key = nextKeyValue;
                    tmpNodePtr->m_Type = DEF_WCXF_NODE_ARRAY;
                    tmpNodePtr->m_PNode = nowNodePtr;
                    tmpNodePtr->m_Data = new WCXFNodePtrDQ;
                    if (tmpNodePtr->m_Data == 0)
                    {
                        //Exception
                        iErrCode = DEF_WCXF_ERR_MEMORY;
                        goto Error000;
                    }else
                    {
                        
                        nowNodePtr = tmpNodePtr;
                        ErrMem = 0;
                    }
                    if (ErrMem == 1)
                    {
                        delete tmpNodePtr;
                    }
                }
                nextKeyValue = "";
            }else if (tmpStr.Compare("dict") == 0)
            {
                tmpNodePtr = new WCXFNode;
                if (tmpNodePtr != 0)
                {
                    tmpNodePtr->m_Key = nextKeyValue;
                    tmpNodePtr->m_Type = DEF_WCXF_NODE_DICT;
                    tmpNodePtr->m_PNode = nowNodePtr;
                    tmpNodePtr->m_Data = new WCXFNodePtrDQ;
                    if (tmpNodePtr->m_Data == 0)
                    {
                        iErrCode = DEF_WCXF_ERR_MEMORY;
                        goto Error000;
                    }else
                    {
                        
                        nowNodePtr = tmpNodePtr;
                        ErrMem = 0;
                    }
                    if (ErrMem == 1)
                    {
                        delete tmpNodePtr;
                    }
                }
                if (firstDict == 0)
                {
                    firstDict = nowNodePtr;
                }
                nextKeyValue = "";
                
            }else if (tmpStr.Compare("key") == 0)
            {
                iSPos = iPos;
                if (GetNextToken(oneInfoP->m_FileH,iPos,tmpStr1) == 1)
                {
                    tmpStr1.TrimLeft(" \t\r\n");
                    tmpStr1.TrimRight(" \t\r\n");
                    if (tmpStr1.Compare("/key") == 0)
                    {
                        iEPos = iPos - strlen("</key>");
                        
                        nextKeyValue = ReadFilePos_UTF8(oneInfoP->m_FileH,iSPos,iEPos - iSPos);
                        nextKeyValue.TrimLeft(" \t\r\n");
                        nextKeyValue.TrimRight(" \t\r\n");
                        
                    }else
                    {
                        iErrCode = DEF_WCXF_ERR_PARSEING;
                        goto Error000;
                    }
                }
            }else if (tmpStr.Compare("string") == 0)
            {
                iSPos = iPos;
                if (GetNextStringToken(oneInfoP->m_FileH,iPos,tmpStr1) == 1)
                {
                    tmpStr1.TrimLeft(" \t\r\n");
                    tmpStr1.TrimRight(" \t\r\n");
                    if (tmpStr1.Compare("/string") == 0)
                    {
                        iEPos = iPos - strlen("</string>");
                        
                        tmpStr1 = ReadFilePos_UTF8(oneInfoP->m_FileH,iSPos,iEPos - iSPos);
                        tmpStr1.TrimLeft(" \t\r\n");
                        tmpStr1.TrimRight(" \t\r\n");
                        
                        tmpStr1 = ChangeXMLString(tmpStr1);
                        tmpNodePtr = new WCXFNode;
                        if (tmpNodePtr != 0)
                        {
                            ErrMem = 1;
                            
                            tmpNodePtr->m_Type = DEF_WCXF_NODE_STRING;
                            tmpNodePtr->m_Key = nextKeyValue;
                            tmpNodePtr->m_PNode = nowNodePtr;
                            tmpNodePtr->m_Data = new PPCStringW;
                            if (tmpNodePtr->m_Data == 0)
                            {
                                iErrCode = DEF_WCXF_ERR_MEMORY;
                                goto Error000;
                            }else
                            {
                                ErrMem1 = 1;
                                
                                tmpCStrPtr = (PPCStringW*)tmpNodePtr->m_Data;
                                *tmpCStrPtr = tmpStr1;
                                parentNodePtr = (WCXFNode*)tmpNodePtr->m_PNode;
                                if (parentNodePtr != 0)
                                {
                                    if ((parentNodePtr->m_Type == DEF_WCXF_NODE_ARRAY) ||
                                        (parentNodePtr->m_Type == DEF_WCXF_NODE_DICT))
                                    {
                                        onePtrDQP = (WCXFNodePtrDQ*)parentNodePtr->m_Data;
                                        if (onePtrDQP != 0)
                                        {
                                            (*onePtrDQP).push_back(tmpNodePtr);
                                            ErrMem = 0;
                                            ErrMem1 = 0;
                                        }
                                    }else
                                    {
                                        iErrCode = DEF_WCXF_ERR_PARSEING;
                                        goto Error000;
                                    }
                                }
                                if (ErrMem1 == 1)
                                {
                                    tmpCStrPtr = (PPCStringW*)tmpNodePtr->m_Data;
                                    delete tmpCStrPtr;
                                }
                            }
                            if (ErrMem == 1)
                            {
                                delete tmpNodePtr;
                            }
                        }
                    }else
                    {
                        iErrCode = DEF_WCXF_ERR_PARSEING;
                        goto Error000;
                    }
                }
                nextKeyValue = "";
            }else if (tmpStr.Compare("integer") == 0)
            {
                iSPos = iPos;
                if (GetNextToken(oneInfoP->m_FileH,iPos,tmpStr1) == 1)
                {
                    tmpStr1.TrimLeft(" \t\r\n");
                    tmpStr1.TrimRight(" \t\r\n");
                    if (tmpStr1.Compare("/integer") == 0)
                    {
                        iEPos = iPos - strlen("</integer>");
                        
                        tmpStr1 = ReadFilePos_UTF8(oneInfoP->m_FileH,iSPos,iEPos - iSPos);
                        tmpStr1.TrimLeft(" \t\r\n");
                        tmpStr1.TrimRight(" \t\r\n");
                        tmpNum = tmpStr1.ToValue();
                        
                        tmpNodePtr = new WCXFNode;
                        if (tmpNodePtr != 0)
                        {
                            ErrMem = 1;
                            
                            tmpNodePtr->m_Type = DEF_WCXF_NODE_INTEGER;
                            tmpNodePtr->m_Key = nextKeyValue;
                            tmpNodePtr->m_PNode = nowNodePtr;
                            tmpNodePtr->m_Data = new int;
                            if (tmpNodePtr->m_Data == 0)
                            {
                                iErrCode = DEF_WCXF_ERR_MEMORY;
                                goto Error000;
                            }else
                            {
                                ErrMem1 = 1;
                                
                                tmpNumPtr = (int*)tmpNodePtr->m_Data;
                                *tmpNumPtr = tmpNum;
                                parentNodePtr = (WCXFNode*)tmpNodePtr->m_PNode;
                                if (parentNodePtr != 0)
                                {
                                    if ((parentNodePtr->m_Type == DEF_WCXF_NODE_ARRAY) ||
                                        (parentNodePtr->m_Type == DEF_WCXF_NODE_DICT))
                                    {
                                        onePtrDQP = (WCXFNodePtrDQ*)parentNodePtr->m_Data;
                                        if (onePtrDQP != 0)
                                        {
                                            (*onePtrDQP).push_back(tmpNodePtr);
                                            ErrMem = 0;
                                            ErrMem1 = 0;
                                        }
                                    }else
                                    {
                                        iErrCode = DEF_WCXF_ERR_PARSEING;
                                        goto Error000;
                                    }
                                }
                                if (ErrMem1 == 1)
                                {
                                    tmpNumPtr = (int*)tmpNodePtr->m_Data;
                                    delete tmpNumPtr;
                                }
                            }
                            if (ErrMem == 1)
                            {
                                delete tmpNodePtr;
                            }
                        }
                    }else
                    {
                        iErrCode = DEF_WCXF_ERR_PARSEING;
                        goto Error000;
                    }
                }
                nextKeyValue = "";
            }else if (tmpStr.Compare("date") == 0)
            {
                iSPos = iPos;
                if (GetNextToken(oneInfoP->m_FileH,iPos,tmpStr1) == 1)
                {
                    tmpStr1.TrimLeft(" \t\r\n");
                    tmpStr1.TrimRight(" \t\r\n");
                    if (tmpStr1.Compare("/date") == 0)
                    {
                        iEPos = iPos - strlen("</date>");
                        
                        tmpStr1 = ReadFilePos_UTF8(oneInfoP->m_FileH,iSPos,iEPos - iSPos);
                        tmpStr1.TrimLeft(" \t\r\n");
                        tmpStr1.TrimRight(" \t\r\n");
                        
                        tmpNodePtr = new WCXFNode;
                        if (tmpNodePtr != 0)
                        {
                            ErrMem = 1;
                            
                            tmpNodePtr->m_Type = DEF_WCXF_NODE_DATE;
                            tmpNodePtr->m_Key = nextKeyValue;
                            tmpNodePtr->m_PNode = nowNodePtr;
                            tmpNodePtr->m_Data = new PPCStringW;
                            if (tmpNodePtr->m_Data == 0)
                            {
                                iErrCode = DEF_WCXF_ERR_MEMORY;
                                goto Error000;
                            }else
                            {
                                ErrMem1 = 1;
                                
                                tmpCStrPtr = (PPCStringW*)tmpNodePtr->m_Data;
                                *tmpCStrPtr = tmpStr1;
                                parentNodePtr = (WCXFNode*)tmpNodePtr->m_PNode;
                                if (parentNodePtr != 0)
                                {
                                    if ((parentNodePtr->m_Type == DEF_WCXF_NODE_ARRAY) ||
                                        (parentNodePtr->m_Type == DEF_WCXF_NODE_DICT))
                                    {
                                        onePtrDQP = (WCXFNodePtrDQ*)parentNodePtr->m_Data;
                                        if (onePtrDQP != 0)
                                        {
                                            (*onePtrDQP).push_back(tmpNodePtr);
                                            ErrMem = 0;
                                            ErrMem1 = 0;
                                        }
                                    }else
                                    {
                                        //Exception
                                        iErrCode = DEF_WCXF_ERR_PARSEING;
                                        goto Error000;
                                    }
                                }
                                if (ErrMem1 == 1)
                                {
                                    tmpCStrPtr = (PPCStringW*)tmpNodePtr->m_Data;
                                    delete tmpCStrPtr;
                                }
                            }
                            if (ErrMem == 1)
                            {
                                delete tmpNodePtr;
                            }
                        }
                    }else
                    {
                        //Exception
                        iErrCode = DEF_WCXF_ERR_PARSEING;
                        goto Error000;
                    }
                }
                nextKeyValue = "";
            }else if (tmpStr.Compare("data") == 0)
            {
                iSPos = iPos;
                if (GetNextToken(oneInfoP->m_FileH,iPos,tmpStr1) == 1)
                {
                    tmpStr1.TrimLeft(" \t\r\n");
                    tmpStr1.TrimRight(" \t\r\n");
                    if (tmpStr1.Compare("/data") == 0)
                    {
                        iEPos = iPos - strlen("</data>");
                        
                        tmpStr1 = ReadFilePos(oneInfoP->m_FileH,iSPos,iEPos - iSPos);
                        tmpStr1.TrimLeft(" \t\r\n");
                        tmpStr1.TrimRight(" \t\r\n");
                        
                        tmpNodePtr = new WCXFNode;
                        if (tmpNodePtr != 0)
                        {
                            ErrMem = 1;
                            
                            tmpDTPtr = (unsigned char*)ConvertFromBase64(tmpStr1,&dataLen);
                            if (tmpDTPtr != 0)
                            {
                                tmpWFDataPtr = new WCXFData;
                                if (tmpWFDataPtr != 0)
                                {
                                    tmpWFDataPtr->m_dataLen = dataLen;
                                    tmpWFDataPtr->m_dataPtr = tmpDTPtr;
                                    
                                    tmpNodePtr->m_Type = DEF_WCXF_NODE_DATA;
                                    tmpNodePtr->m_Key = nextKeyValue;
                                    tmpNodePtr->m_PNode = nowNodePtr;
                                    tmpNodePtr->m_Data = tmpWFDataPtr;
                                    
                                    ErrMem1 = 1;
                                    
                                    parentNodePtr = (WCXFNode*)tmpNodePtr->m_PNode;
                                    if (parentNodePtr != 0)
                                    {
                                        if ((parentNodePtr->m_Type == DEF_WCXF_NODE_ARRAY) ||
                                            (parentNodePtr->m_Type == DEF_WCXF_NODE_DICT))
                                        {
                                            onePtrDQP = (WCXFNodePtrDQ*)parentNodePtr->m_Data;
                                            if (onePtrDQP != 0)
                                            {
                                                (*onePtrDQP).push_back(tmpNodePtr);
                                                ErrMem = 0;
                                                ErrMem1 = 0;
                                            }
                                        }else
                                        {
                                            //Exception
                                            iErrCode = DEF_WCXF_ERR_PARSEING;
                                            goto Error000;
                                        }
                                    }
                                    if (ErrMem1 == 1)
                                    {
                                        delete tmpWFDataPtr;
                                        delete [] tmpDTPtr;
                                        
                                    }
                                }else
                                {
                                    //Exception
                                    iErrCode = DEF_WCXF_ERR_MEMORY;
                                    goto Error000;
                                }
                            }
                            if (ErrMem == 1)
                            {
                                delete tmpNodePtr;
                            }
                            
                        }else
                        {
                            //Exception
                            iErrCode = DEF_WCXF_ERR_MEMORY;
                            goto Error000;
                        }
                    }else
                    {
                        //Exception
                        iErrCode = DEF_WCXF_ERR_PARSEING;
                        goto Error000;
                    }
                }
                nextKeyValue = "";
            }else if (tmpStr.Compare("/dict") == 0)
            {
                if (firstDict == nowNodePtr)	//end of block!
                {
                    blockEndFlag = 1;
                }
                if (nowNodePtr->m_Type == DEF_WCXF_NODE_DICT)
                {
                    parentNodePtr = (WCXFNode*)nowNodePtr->m_PNode;
                    if (parentNodePtr != 0)
                    {
                        if ((parentNodePtr->m_Type == DEF_WCXF_NODE_ARRAY) ||
                            (parentNodePtr->m_Type == DEF_WCXF_NODE_DICT))
                        {
                            onePtrDQP = (WCXFNodePtrDQ*)parentNodePtr->m_Data;
                            if (onePtrDQP != 0)
                            {
                                (*onePtrDQP).push_back(nowNodePtr);
                                nowNodePtr = parentNodePtr;
                            }
                        }
                    }
                }else
                {
                    //exception
                    iErrCode = DEF_WCXF_ERR_PARSEING;
                    goto Error000;
                }
                nextKeyValue = "";
            }else if (tmpStr.Compare("/array") == 0)
            {
                
                parentNodePtr = (WCXFNode*)nowNodePtr->m_PNode;
                if (parentNodePtr != 0)
                {
                    if (nowNodePtr != rootNodePtr)
                    {
                        if (nowNodePtr->m_Type != DEF_WCXF_NODE_ARRAY)
                        {
                            //Exception
                            iErrCode = DEF_WCXF_ERR_PARSEING;
                            goto Error000;
                        }
                    }
                    if ((parentNodePtr->m_Type == DEF_WCXF_NODE_ARRAY) ||
                        (parentNodePtr->m_Type == DEF_WCXF_NODE_DICT))
                    {
                        onePtrDQP = (WCXFNodePtrDQ*)parentNodePtr->m_Data;
                        if (onePtrDQP != 0)
                        {
                            (*onePtrDQP).push_back(nowNodePtr);
                            nowNodePtr = parentNodePtr;
                        }
                    }
                    
                }else
                {
                    blockEndFlag = 1;
                    iEofFlag = 1;
                }
                
                nextKeyValue = "";
            }else if (tmpStr.Compare("/string") == 0)
            {
                //Exception
                iErrCode = DEF_WCXF_ERR_PARSEING;
                goto Error000;
            }else if (tmpStr.Compare("/integer") == 0)
            {
                //Exception
                iErrCode = DEF_WCXF_ERR_PARSEING;
                goto Error000;
            }else if (tmpStr.Compare("/date") == 0)
            {
                //Exception
                iErrCode = DEF_WCXF_ERR_PARSEING;
                goto Error000;
            }else if (tmpStr.Compare("/data") == 0)
            {
                //Exception
                iErrCode = DEF_WCXF_ERR_PARSEING;
                goto Error000;
            }
            
            if (blockEndFlag == 1)
            {
                break;
            }
        }
        
        if (iEofFlag == 1)
        {
            eofFlag = 1;
        }
        
        if (rootNodePtr != 0)
        {
            if (rootNodePtr->m_Data != 0)
            {
                onePtrDQP = (WCXFNodePtrDQ*)rootNodePtr->m_Data;
                if (onePtrDQP != 0)
                {
                    delete onePtrDQP;
                }
            }
            delete rootNodePtr;
            rootNodePtr = 0;
        }
        return firstDict;
    Error000:
        if (rootNodePtr != 0)
        {
            if (rootNodePtr->m_Data != 0)
            {
                onePtrDQP = (WCXFNodePtrDQ*)rootNodePtr->m_Data;
                if (onePtrDQP != 0)
                {
                    delete onePtrDQP;
                }
            }
            delete rootNodePtr;
            rootNodePtr = 0;
        }
        if (firstDict != 0)
        {
            FreeOneCard(firstDict);
        }
        
        errCode = iErrCode;				
    }
    return 0;
}

int CPPWcxfFile::GetNextStringToken(void *hf,PPINT64 &inPos,PPCStringW &retStr)
{
    PPINT64 findPos = inPos;
    PPINT64 iSPos,iEPos;
    PPCStringW tokenStr;
    
    
    tokenStr = "";
    while(true)
    {
        int rtn = FindInFile(hf,"<",&findPos,0);
        if (rtn > 0)
        {
            iSPos = findPos + strlen("<");
            findPos = iSPos;
            rtn = FindInFile(hf,">",&findPos,0);
            if (rtn > 0)
            {
                iSPos = findPos - 7;
                iEPos = findPos;
                if((iEPos - iSPos) == 7)
                {
                    tokenStr = ReadFilePos_UTF8(hf,iSPos,iEPos - iSPos);
                    if(tokenStr.Compare("/string") == 0)
                    {
                        retStr = tokenStr;
                        inPos = iEPos + + strlen(">");
                        return 1;
                    }
                }
            }
            
            if(rtn == -1)
            {
                break;
            }
        }
        if(rtn == -1)
        {
            break;
        }
    }
    return 0;
}

int CPPWcxfFile::GetNextToken(void *hf,PPINT64 &inPos,PPCStringW &retStr)
{
    PPINT64 findPos = inPos;
    PPINT64 iSPos,iEPos;
    PPCStringW tokenStr;
    
    
    tokenStr = "";
    if (FindInFile(hf,"<",&findPos,0) != 0)
    {
        iSPos = findPos + strlen("<");
        findPos = iSPos;
        if (FindInFile(hf,">",&findPos,0) != 0)
        {
            iEPos = findPos;
            tokenStr = ReadFilePos_UTF8(hf,iSPos,iEPos - iSPos);
            retStr = tokenStr;
            inPos = iEPos + + strlen(">");
            return 1;
        }
    }
    return 0;
    
}

int CPPWcxfFile::CollectOneCard(void *oneDict,int &rCount,WCXFRecord &oneRecord,PPCStringW &lastKey)
{
    WCXFNode *oneNode;
    WCXFNodePtrDQ *oneDQPtr;
    int i,iNum;
    WCXFNode *oneChildP;
    //	PPCStringW *tmpCStrPtr;
    //	PPWCHAR Buffer[2048];
    //	int *tmpNumPtr;
    //	WCXFData *tmpDataPtr;
    CPPFileIo oneFileIo;
    PPWString oneWStr;
    PPCStringW oldLastKey;
    
    oldLastKey = "";
    rCount++;
    if (oneDict != 0)
    {
        oneNode = (WCXFNode *)oneDict;
        if (oneNode != 0)
        {
            if (oneNode->m_Type == DEF_WCXF_NODE_ARRAY)
            {
                if (oneNode->m_Key.GetLength() > 0)
                {
                    
                    lastKey = oneNode->m_Key.GetBuffer();
                }
                oneDQPtr = (WCXFNodePtrDQ*)oneNode->m_Data;
                if (oneDQPtr != 0)
                {
                    iNum = (int)(*oneDQPtr).size();
                    if (iNum > 0)
                    {
                        oldLastKey = lastKey;
                        PutField2Record(oneRecord,lastKey,oneDict,1);
                        oneRecord.m_inArray = 1;
                        for (i = 0;i < iNum;i++)
                        {
                            oneChildP = (WCXFNode*)((*oneDQPtr)[i]);
                            CollectOneCard(oneChildP,rCount,oneRecord,lastKey);
                        }
                        lastKey = oldLastKey;
                        oneRecord.m_inArray = 0;
                        PutField2Record(oneRecord,lastKey,oneDict,2);
                    }
                }
            }else if (oneNode->m_Type == DEF_WCXF_NODE_DICT)
            {
                if (oneNode->m_Key.GetLength() > 0)
                {
                    lastKey = oneNode->m_Key.GetBuffer();
                }
                
                oneDQPtr = (WCXFNodePtrDQ*)oneNode->m_Data;
                if (oneDQPtr != 0)
                {
                    iNum = (int)(*oneDQPtr).size();
                    if (iNum > 0)
                    {
                        oldLastKey = lastKey;
                        PutField2Record(oneRecord,lastKey,oneDict,1);
                        if (lastKey.CompareNoCase(kWCXF_CDL1_UserDefine) == 0) {
                            PutField2Record(oneRecord,lastKey,oneDict,1);
                        }
                        for (i = 0;i < iNum;i++)
                        {
                            oneChildP = (WCXFNode*)((*oneDQPtr)[i]);
                            CollectOneCard(oneChildP,rCount,oneRecord,lastKey);
                        }
                        lastKey = oldLastKey;
                        if (lastKey.CompareNoCase(kWCXF_CDL1_UserDefine) == 0) {
                            PutField2Record(oneRecord,lastKey,oneDict,2);
                        }
                        PutField2Record(oneRecord,lastKey,oneDict,2);
                    }
                }
            }else if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
            {
                if (oneNode->m_Key.GetLength() > 0)
                {
                    lastKey = oneNode->m_Key.GetBuffer();
                }
                PutField2Record(oneRecord,lastKey,oneDict,0);
                
            }else if (oneNode->m_Type == DEF_WCXF_NODE_INTEGER)
            {
                if (oneNode->m_Key.GetLength() > 0)
                {
                    lastKey = oneNode->m_Key.GetBuffer();
                }
                
                PutField2Record(oneRecord,lastKey,oneDict,0);
            }else if (oneNode->m_Type == DEF_WCXF_NODE_DATE)
            {
                if (oneNode->m_Key.GetLength() > 0)
                {
                    lastKey = oneNode->m_Key.GetBuffer();
                }
                
                PutField2Record(oneRecord,lastKey,oneDict,0);
                
            }else if (oneNode->m_Type == DEF_WCXF_NODE_DATA)
            {
                if (oneNode->m_Key.GetLength() > 0)
                {
                    lastKey = oneNode->m_Key.GetBuffer();
                }
                
                PutField2Record(oneRecord,lastKey,oneDict,0);
                
            }
            
            
        }
    }
    rCount--;
    if (rCount == 0)
    {
    }
    return rCount; 
}




int CPPWcxfFile::DumpOneCard(void *oneDict,int &rCount)
{
    WCXFNode *oneNode;
    WCXFNodePtrDQ *oneDQPtr;
    int i,iNum;
    WCXFNode *oneChildP;
    PPCStringW *tmpCStrPtr;
    PPWCHAR Buffer[2048];
    int *tmpNumPtr;
    WCXFData *tmpDataPtr;
    CPPFileIo oneFileIo;
    PPWString oneWStr;
    
    oneFileIo.m_outputDebugFileName = m_outputDebugFileName;
    
    rCount++;
    if (oneDict != 0)
    {
        oneNode = (WCXFNode *)oneDict;
        if (oneNode != 0)
        {
            if (oneNode->m_Type == DEF_WCXF_NODE_ARRAY)
            {
                oneFileIo.PPOutputDebugString("<array>\r\n");
                
                oneDQPtr = (WCXFNodePtrDQ*)oneNode->m_Data;
                if (oneDQPtr != 0)
                {
                    iNum = (int)(*oneDQPtr).size();
                    for (i = 0;i < iNum;i++)
                    {
                        oneChildP = (WCXFNode*)((*oneDQPtr)[i]);
                        DumpOneCard(oneChildP,rCount);
                    }
                }
                oneFileIo.PPOutputDebugString("</array>\r\n");
            }else if (oneNode->m_Type == DEF_WCXF_NODE_DICT)
            {
                if (oneNode->m_Key.GetLength() > 0)
                {
                    oneWStr.swprintf_fromAnsi(Buffer,"key:%s",oneNode->m_Key.GetBuffer());
                    oneFileIo.PPOutputDebugString(Buffer);
                    oneFileIo.PPOutputDebugString("\r\n");
                }
                oneFileIo.PPOutputDebugString("<dict>\r\n");
                
                oneDQPtr = (WCXFNodePtrDQ*)oneNode->m_Data;
                if (oneDQPtr != 0)
                {
                    iNum = (int)(*oneDQPtr).size();
                    for (i = 0;i < iNum;i++)
                    {
                        oneChildP = (WCXFNode*)((*oneDQPtr)[i]);
                        DumpOneCard(oneChildP,rCount);
                    }
                }
                
                oneFileIo.PPOutputDebugString("</dict>\r\n");
            }else if (oneNode->m_Type == DEF_WCXF_NODE_STRING)
            {
                if (oneNode->m_Key.GetLength() > 0)
                {
                    oneWStr.swprintf_fromAnsi(Buffer,"key:%s",oneNode->m_Key.GetBuffer());
                    oneFileIo.PPOutputDebugString(Buffer);
                    oneFileIo.PPOutputDebugString("\r\n");
                }
                oneFileIo.PPOutputDebugString("<string>\r\n");
                
                tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                if (tmpCStrPtr != 0)
                {
                    oneFileIo.PPOutputDebugString(*tmpCStrPtr);
                    oneFileIo.PPOutputDebugString("\r\n");
                }
                oneFileIo.PPOutputDebugString("</string>");
                oneFileIo.PPOutputDebugString("\r\n");
            }else if (oneNode->m_Type == DEF_WCXF_NODE_INTEGER)
            {
                if (oneNode->m_Key.GetLength() > 0)
                {
                    oneWStr.swprintf_fromAnsi(Buffer,"key:%s",oneNode->m_Key.GetBuffer());
                    oneFileIo.PPOutputDebugString(Buffer);
                    oneFileIo.PPOutputDebugString("\r\n");
                }
                oneFileIo.PPOutputDebugString("<integer>\r\n");
                
                tmpNumPtr = (int*)oneNode->m_Data;
                if (tmpNumPtr != 0)
                {
                    oneWStr.swprintf_fromAnsi(Buffer,"%d\r\n",*tmpNumPtr);
                    oneFileIo.PPOutputDebugString(Buffer);
                }
                
                oneFileIo.PPOutputDebugString("</integer>\r\n");
            }else if (oneNode->m_Type == DEF_WCXF_NODE_DATE)
            {
                if (oneNode->m_Key.GetLength() > 0)
                {
                    oneWStr.swprintf_fromAnsi(Buffer,"key:%s",oneNode->m_Key.GetBuffer());
                    oneFileIo.PPOutputDebugString(Buffer);
                    oneFileIo.PPOutputDebugString("\r\n");
                }
                oneFileIo.PPOutputDebugString("<date>\r\n");
                tmpCStrPtr = (PPCStringW*)oneNode->m_Data;
                if (tmpCStrPtr != 0)
                {
                    oneFileIo.PPOutputDebugString(*tmpCStrPtr);
                    oneFileIo.PPOutputDebugString("\r\n");
                }
                oneFileIo.PPOutputDebugString("</date>\r\n");
            }else if (oneNode->m_Type == DEF_WCXF_NODE_DATA)
            {
                if (oneNode->m_Key.GetLength() > 0)
                {
                    oneWStr.swprintf_fromAnsi(Buffer,"key:%s",oneNode->m_Key.GetBuffer());
                    oneFileIo.PPOutputDebugString(Buffer);
                    oneFileIo.PPOutputDebugString("\r\n");
                }
                oneFileIo.PPOutputDebugString("<data>\r\n");
                tmpDataPtr = (WCXFData*)oneNode->m_Data;
                if (tmpDataPtr != 0)
                {
                    oneWStr.swprintf_fromAnsi(Buffer,"DataLen:%lu",tmpDataPtr->m_dataLen);
                    
                    oneFileIo.PPOutputDebugString(Buffer);
                    oneFileIo.PPOutputDebugString("\r\n");
                }
                oneFileIo.PPOutputDebugString("</data>\r\n");
            }
        }
    }
    rCount--;
    if (rCount == 0)
    {
        oneFileIo.PPOutputDebugString("--------------------------------\r\n");
    }
    return rCount; 
}
