#ifndef PPWcxfFile_0000000
#define PPWcxfFile_0000000

#include <deque>
#include "PPCStringW.h"
#include "UBase64.h"
#include "PPFileIo.h"
#include "PPCode.h"

// root keys
#define kWCXF_R_Generator					"kWCXF_R_Generator"		
											// integer format (currently is "102")
#define kWCXF_R_FormatVersion				"kWCXF_R_FormatVersion"			
											// 160~Fr
#define kWCXF_R_FileID						"kWCXF_R_FileID"
											// date format						
#define kWCXF_R_FileCreateTime				"kWCXF_R_FileCreateTime"
											// integer format			
#define kWCXF_R_CardCount					"kWCXF_R_CardCount"				
#define kWCXF_R_CardArray					"kWCXF_R_CardArray"

// CDL1 (card data level 1) keys
#define kWCXF_CDL1_Group					"kWCXF_CDL1_Group"
#define kWCXF_CDL1_UniqueID					"kWCXF_CDL1_UniqueID"				// string format (160~Fr)
#define kWCXF_CDL1_Image					"kWCXF_CDL1_Image"
#define kWCXF_CDL1_RecogLang				"kWCXF_CDL1_RecogLang"		
#define kWCXF_CDL1_Name						"kWCXF_CDL1_Name"
#define kWCXF_CDL1_NickName					"kWCXF_CDL1_NickName"
#define kWCXF_CDL1_Position					"kWCXF_CDL1_Position"
#define kWCXF_CDL1_Department				"kWCXF_CDL1_Department"
#define kWCXF_CDL1_Company					"kWCXF_CDL1_Company"
#define kWCXF_CDL1_Phone					"kWCXF_CDL1_Phone"
#define kWCXF_CDL1_Skype					"kWCXF_CDL1_Skype"
#define kWCXF_CDL1_Address					"kWCXF_CDL1_Address"
#define kWCXF_CDL1_Email					"kWCXF_CDL1_Email"
#define kWCXF_CDL1_URL						"kWCXF_CDL1_URL"
#define kWCXF_CDL1_InstantMessage			"kWCXF_CDL1_InstantMessage"
#define kWCXF_CDL1_Date						"kWCXF_CDL1_Date"
#define kWCXF_CDL1_Other					"kWCXF_CDL1_Other"
#define kWCXF_CDL1_Note						"kWCXF_CDL1_Note"
#define kWCXF_CDL1_UnifiedBusinessNumber		"kWCXF_CDL1_UnifiedBusinessNumber"	// Τ@s
#define kWCXF_CDL1_Birthday					"kWCXF_CDL1_Birthday"				// date format
#define kWCXF_CDL1_Children					"kWCXF_CDL1_Children"
#define kWCXF_CDL1_Spouse					"kWCXF_CDL1_Spouse"
#define kWCXF_CDL1_BloodType				"kWCXF_CDL1_BloodType"				// refer to blood type value definition
#define kWCXF_CDL1_Sex						"kWCXF_CDL1_Sex"					// refer to sex value definition
#define kWCXF_CDL1_Horoscope				"kWCXF_CDL1_Horoscope"				// refer to horoscope value definition
#define kWCXF_CDL1_Education				"kWCXF_CDL1_Education"				// refer to education value definition
#define kWCXF_CDL1_CreateTime				"kWCXF_CDL1_CreateTime"			// date format
#define kWCXF_CDL1_ModifiedTime				"kWCXF_CDL1_ModifiedTime"			// date format
#define kWCXF_CDL1_RecognizedTime			"kWCXF_CDL1_RecognizedTime"		// date format (ver101 added)
//-- 105 sW ------------------------------------------------------------------------------v---
#define kWCXF_CDL1_GroupV2			"kWCXF_CDL1_GroupV2"
#define kWCXF_CDL1_UserDefine		"kWCXF_CDL1_UserDefine"
#define kWCXF_CDL1_Tag				"kWCXF_CDL1_Tag"
#define kWCXF_CDL1_PPAccountID		"kWCXF_CDL1_PPAccountID"
//-- 105 sW ------------------------------------------------------------------------------^---

// subtype for CDL1_Image
#define kWCXF_CDL2_Image_Front				"kWCXF_CDL2_Image_Front"			// data format
#define kWCXF_CDL2_Image_Back				"kWCXF_CDL2_Image_Back"			// data format
#define kWCXF_CDL2_Image_IDPhoto			"kWCXF_CDL2_Image_IDPhoto"			// data format

// subtype for CDL1_RecogLang
#define kWCXF_CDL2_RecogLang_Front			"kWCXF_CDL2_RecogLang_Front"		// integer format (֤߿ѻytintwq)
#define kWCXF_CDL2_RecogLang_Back			"kWCXF_CDL2_RecogLang_Back"		// integer format (֤߿ѻytintwq)

// subtype for CDL1_Name
#define kWCXF_CDL2_Name_Full				"kWCXF_CDL2_Name_Full"
#define kWCXF_CDL2_Name_First				"kWCXF_CDL2_Name_First"
#define kWCXF_CDL2_Name_Middle				"kWCXF_CDL2_Name_Middle"
#define kWCXF_CDL2_Name_Last				"kWCXF_CDL2_Name_Last"
#define kWCXF_CDL2_Name_PhoneticFull		"kWCXF_CDL2_Name_PhoneticFull"
#define kWCXF_CDL2_Name_PhoneticFirst		"kWCXF_CDL2_Name_PhoneticFirst"
#define kWCXF_CDL2_Name_PhoneticMiddle		"kWCXF_CDL2_Name_PhoneticMiddle"
#define kWCXF_CDL2_Name_PhoneticLast		"kWCXF_CDL2_Name_PhoneticLast"
#define kWCXF_CDL2_Name_Prefix				"kWCXF_CDL2_Name_Prefix"
#define kWCXF_CDL2_Name_Suffix				"kWCXF_CDL2_Name_Suffix"

// subtype for CDL1_Company
#define kWCXF_CDL2_Company_Name				"kWCXF_CDL2_Company_Name"
#define kWCXF_CDL2_Company_Phonetic			"kWCXF_CDL2_Company_Phonetic"

// subtype for CDL1_Phone
#define kWCXF_CDL2_Phone_Work				"kWCXF_CDL2_Phone_Work"
#define kWCXF_CDL2_Phone_Home				"kWCXF_CDL2_Phone_Home"
#define kWCXF_CDL2_Phone_Other				"kWCXF_CDL2_Phone_Other"
#define kWCXF_CDL2_Phone_Mobile				"kWCXF_CDL2_Phone_Mobile"
#define kWCXF_CDL2_Phone_Main				"kWCXF_CDL2_Phone_Main"
#define kWCXF_CDL2_Phone_Primary			"kWCXF_CDL2_Phone_Primary"
#define kWCXF_CDL2_Phone_GoogleVoice		"kWCXF_CDL2_Phone_GoogleVoice"
#define kWCXF_CDL2_Phone_iPhone				"kWCXF_CDL2_Phone_iPhone"
#define kWCXF_CDL2_Phone_Pager				"kWCXF_CDL2_Phone_Pager"
#define kWCXF_CDL2_Phone_WorkFax			"kWCXF_CDL2_Phone_WorkFax"
#define kWCXF_CDL2_Phone_HomeFax			"kWCXF_CDL2_Phone_HomeFax"
#define kWCXF_CDL2_Phone_OtherFax			"kWCXF_CDL2_Phone_OtherFax"

// subtype for CDL1_Address
#define kWCXF_CDL2_Address_Work				"kWCXF_CDL2_Address_Work"
#define kWCXF_CDL2_Address_Home				"kWCXF_CDL2_Address_Home"
#define kWCXF_CDL2_Address_Other			"kWCXF_CDL2_Address_Other"

// subtype for CD2_Address
#define kWCXF_CDL3_Address_Street			"kWCXF_CDL3_Address_Street"
#define kWCXF_CDL3_Address_City				"kWCXF_CDL3_Address_City"
#define kWCXF_CDL3_Address_State			"kWCXF_CDL3_Address_State"
#define kWCXF_CDL3_Address_ZIP				"kWCXF_CDL3_Address_ZIP"
#define kWCXF_CDL3_Address_Country			"kWCXF_CDL3_Address_Country"
#define kWCXF_CDL3_Address_CountryCode		"kWCXF_CDL3_Address_CountryCode"		// string format (refer to Mac AddressBook country code definition)
#define kWCXF_CDL3_Address_Format			"kWCXF_CDL3_Address_Format"			// integer format (refer to address format definition)
#define kWCXF_CDL3_Address_GPS				"kWCXF_CDL3_Address_GPS"				// string format

// subtype for CDL1_Email
#define kWCXF_CDL2_Email_Work				"kWCXF_CDL2_Email_Work"
#define kWCXF_CDL2_Email_Home				"kWCXF_CDL2_Email_Home"
#define kWCXF_CDL2_Email_Other				"kWCXF_CDL2_Email_Other"

// subtype for CDL1_URL
#define kWCXF_CDL2_URL_HomePage				"kWCXF_CDL2_URL_HomePage"
#define kWCXF_CDL2_URL_Work					"kWCXF_CDL2_URL_Work"
#define kWCXF_CDL2_URL_Home					"kWCXF_CDL2_URL_Home"
#define kWCXF_CDL2_URL_Facebook				"kWCXF_CDL2_URL_Facebook"
#define kWCXF_CDL2_URL_Twitter				"kWCXF_CDL2_URL_Twitter"
#define kWCXF_CDL2_URL_Plurk				"kWCXF_CDL2_URL_Plurk"
#define kWCXF_CDL2_URL_LinkedIn				"kWCXF_CDL2_URL_LinkedIn"
#define kWCXF_CDL2_URL_Profile				"kWCXF_CDL2_URL_Profile"
#define kWCXF_CDL2_URL_Blog					"kWCXF_CDL2_URL_Blog"
#define kWCXF_CDL2_URL_Other				"kWCXF_CDL2_URL_Other"

// subtype for CDL1_InstantMessage
#define kWCXF_CDL2_IM_Work					"kWCXF_CDL2_IM_Work"
#define kWCXF_CDL2_IM_Home					"kWCXF_CDL2_IM_Home"
#define kWCXF_CDL2_IM_Other					"kWCXF_CDL2_IM_Other"

// subtype for CD2_InstantMessage
#define kWCXF_CDL3_IM_AIM					"kWCXF_CDL3_IM_AIM"
#define kWCXF_CDL3_IM_YahooMessenger		"kWCXF_CDL3_IM_YahooMessenger"
#define kWCXF_CDL3_IM_MSN					"kWCXF_CDL3_IM_MSN"
#define kWCXF_CDL3_IM_ICQ					"kWCXF_CDL3_IM_ICQ"
#define kWCXF_CDL3_IM_Jabber				"kWCXF_CDL3_IM_Jabber"
#define kWCXF_CDL3_IM_QQ					"kWCXF_CDL3_IM_QQ"
#define kWCXF_CDL3_IM_GoogleTalk			"kWCXF_CDL3_IM_GoogleTalk"

// subtype for CDL1_Date
#define kWCXF_CDL2_Date_Anniversary			"kWCXF_CDL2_Date_Anniversary"		// date format
#define kWCXF_CDL2_Date_Other				"kWCXF_CDL2_Date_Other"			// date format

//-- 105 sW ------------------------------------------------------------------------------v---
// subtype for kWCXF_CDL1_GroupV2
#define kWCXF_CDL2_GroupV2_Default		"kWCXF_CDL2_GroupV2_Default"	//w]s
#define kWCXF_CDL2_GroupV2_Defined		"kWCXF_CDL2_GroupV2_Defined"	//ۭqs

// subtype for kWCXF_CDL1_UserDefine
#define kWCXF_CDL2_UserDefine_Label		"kWCXF_CDL2_UserDefine_Label"	//ۭq label
#define kWCXF_CDL2_UserDefine_Content	"kWCXF_CDL2_UserDefine_Content"	//ۭq e

// subtype for kWCXF_CDL1_Tag
#define kWCXF_CDL2_Tag_Name		"kWCXF_CDL2_Tag_Name"				//Tag Name
#define kWCXF_CDL2_Tag_Data		"kWCXF_CDL2_Tag_Data"				//Tag Data

//-- 105 sW ------------------------------------------------------------------------------^---

//----------------------------------------------------------------
// special value definition
//----------------------------------------------------------------

// address format value definition (value for kWCXF_CDL3_Address_Format)
typedef enum
{
	vWCXF_AF_None = 0,	
	vWCXF_AF_Taiwan,	// country + state + city + street + " ," + zip
	vWCXF_AF_USA,		// street + ", " + city + ", " + state + " " + zip + " " + country 	(ver103 updated)
	vWCXF_AF_Europe,	// street + ", " + zip + " " + city + " " + state + " " + country 	(ver103 updated)
	vWCXF_AF_Japan,		// "E" + zip + " " + country + state + city + street
	vWCXF_AF_Korea		// ZIP + " " + country + state + city + street						(ver102 added)
}
vWCXF_AddressFormat;


// blood type value definition (value for kWCXF_CDL1_BloodType)
#define vWCXF_BLOOD_A				L"vWCXF_BLOOD_A"
#define vWCXF_BLOOD_B				L"vWCXF_BLOOD_B"
#define vWCXF_BLOOD_AB				L"vWCXF_BLOOD_AB"
#define vWCXF_BLOOD_O				L"vWCXF_BLOOD_O"


// sex value definition (value for kWCXF_CDL1_Sex)
#define vWCXF_SEX_Male				L"vWCXF_SEX_Male"
#define vWCXF_SEX_Female			L"vWCXF_SEX_Female"


// education value definition (value for kWCXF_CDL1_Education)
#define vWCXF_EDU_PrimarySchool		L"vWCXF_EDU_PrimarySchool"	//p
#define vWCXF_EDU_JuniorSchool		L"vWCXF_EDU_JuniorSchool"	//
#define vWCXF_EDU_SeniorSchool		L"vWCXF_EDU_SeniorSchool"	//(¾)
#define vWCXF_EDU_College			L"vWCXF_EDU_College"		//MBǰ|Buj
#define vWCXF_EDU_University		L"vWCXF_EDU_University"		//j
#define vWCXF_EDU_Master			L"vWCXF_EDU_Master"			//Ӥh
#define vWCXF_EDU_Doctor			L"vWCXF_EDU_Doctor"			//դh


// Horoscope value definition (value for kWCXF_CDL1_Horoscope)
#define vWCXF_HORO_AQUARIUS			L"vWCXF_HORO_AQUARIUS"		//~y
#define vWCXF_HORO_PIECES			L"vWCXF_HORO_PIECES"		//y
#define vWCXF_HORO_ARIES			L"vWCXF_HORO_ARIES"			//զϮy
#define vWCXF_HORO_TAURUS			L"vWCXF_HORO_TAURUS"		//y
#define vWCXF_HORO_GEMINI			L"vWCXF_HORO_GEMINI"		//ly
#define vWCXF_HORO_CANCER			L"vWCXF_HORO_CANCER"		//ɮy
#define vWCXF_HORO_LEO				L"vWCXF_HORO_LEO"			//ly
#define vWCXF_HORO_VIRGO			L"vWCXF_HORO_VIRGO"			//Bky
#define vWCXF_HORO_LIBRA			L"vWCXF_HORO_LIBRA"			//ѯy
#define vWCXF_HORO_SCORPIO			L"vWCXF_HORO_SCORPIO"		//Ȯy
#define vWCXF_HORO_SAGITTARIUS		L"vWCXF_HORO_SAGITTARIUS"	//gy
#define vWCXF_HORO_CAPRICORN		L"vWCXF_HORO_CAPRICORN"		//~y




#define		DEF_WCXF_NODE_ARRAY		1
#define		DEF_WCXF_NODE_DICT		2
#define		DEF_WCXF_NODE_STRING	3
#define		DEF_WCXF_NODE_INTEGER	4
#define		DEF_WCXF_NODE_DATE		5
#define		DEF_WCXF_NODE_DATA		6


#define DEF_WCXF_ERR_MEMORY		1
#define DEF_WCXF_ERR_PARSEING	2
#define DEF_WCXF_ERR_WRITING	3
#define DEF_WCXF_ERR_UNKNOW		4
#define DEF_WCXF_ERR_UniqueID	20


#define DEF_WCXF_IMAGE_FLAG_FRONT		1
#define DEF_WCXF_IMAGE_FLAG_BACK		2
#define DEF_WCXF_IMAGE_FLAG_PHOTO		4



#define DEF_WCXF_STATE_NONE				0
#define DEF_WCXF_STATE_NAME_INIT		1
#define DEF_WCXF_STATE_COMPANY_INIT		2
#define DEF_WCXF_STATE_PHONE_INIT		3
#define DEF_WCXF_STATE_ADDRESS_INIT_L1	4
#define DEF_WCXF_STATE_ADDRESS_INIT_L2	5
#define DEF_WCXF_STATE_EMAIL_INIT		6
#define DEF_WCXF_STATE_URL_INIT			7
#define DEF_WCXF_STATE_IM_INIT_L1		8
#define DEF_WCXF_STATE_IM_INIT_L2		9
#define DEF_WCXF_STATE_DATE_INIT		10
//-- 105 sW ------------------------------------------------------------------------------v---
#define DEF_WCXF_STATE_GROUPV2_INIT			11
#define DEF_WCXF_STATE_USERDEFINE_INIT_L1	12
#define DEF_WCXF_STATE_TAG_INIT_L1			13
//-- 105 sW ------------------------------------------------------------------------------^---

#define DEF_WCXF_OPENFILE_MODE_READ		0
#define DEF_WCXF_OPENFILE_MODE_WRITE	1



#define DEF_WCXF_XMLHEADER1		(char*)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\xa"
#define DEF_WCXF_XMLHEADER2		(char*)"<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">\xa"
#define DEF_WCXF_XMLHEADER3		(char*)"<plist version=\"1.0\">\xa"


typedef class WCXFRecord_RecogLang
{
	public:
		WCXFRecord_RecogLang(){
		};
		void clear()
		{	
			m_Front = 0;
			m_Back = 0;
		};
		int m_Front;
		int m_Back;
}WCXFRecord_RecogLang;
typedef std::deque <WCXFRecord_RecogLang*> WCXFRecord_RecogLangPtrDQ;

typedef class WCXFRecord_Name
{
	public:
		PPCStringW m_Name_Full;
		PPCStringW m_Name_First;
		PPCStringW m_Name_Middle;
		PPCStringW m_Name_Last;
		PPCStringW m_Name_PhoneticFull;
		PPCStringW m_Name_PhoneticFirst;
		PPCStringW m_Name_PhoneticMiddle;
		PPCStringW m_Name_PhoneticLast;
		PPCStringW m_Name_Prefix;
		PPCStringW m_Name_Suffix;
}WCXFRecord_Name;
typedef std::deque <WCXFRecord_Name*> WCXFRecord_NamePtrDQ;
//--------------------------------------------------------------------
typedef class WCXFRecord_Company
{
	public:
		PPCStringW m_Company_Name;
		PPCStringW m_Company_Phonetic;
}WCXFRecord_Company;
typedef std::deque <WCXFRecord_Company*> WCXFRecord_CompanyPtrDQ;
//--------------------------------------------------------------------
typedef class WCXFRecord_Phone
{
	public:
		PPCStringWPtrDQ m_Phone_WorkPtrDQ;
		PPCStringWPtrDQ m_Phone_HomePtrDQ;
		PPCStringWPtrDQ m_Phone_OtherPtrDQ;
		PPCStringWPtrDQ m_Phone_MobilePtrDQ;
		PPCStringWPtrDQ m_Phone_MainPtrDQ;
		PPCStringWPtrDQ m_Phone_PrimaryPtrDQ;
		PPCStringWPtrDQ m_Phone_GoogleVoicePtrDQ;
		PPCStringWPtrDQ m_Phone_iPhonePtrDQ;
		PPCStringWPtrDQ m_Phone_PagerPtrDQ;
		PPCStringWPtrDQ m_Phone_WorkFaxPtrDQ;
		PPCStringWPtrDQ m_Phone_HomeFaxPtrDQ;
		PPCStringWPtrDQ m_Phone_OtherFaxPtrDQ;
}WCXFRecord_Phone;
typedef std::deque <WCXFRecord_Phone*> WCXFRecord_PhonePtrDQ;
//--------------------------------------------------------------------
typedef class WCXFRecord_AdrsL3
{
	public:
		WCXFRecord_AdrsL3()
		{
			clear();
		};
		void clear()
		{
			m_Street = "";
			m_City = "";
			m_State = "";
			m_ZIP = "";
			m_Country = "";
			m_CountryCode = "";
			m_Format=vWCXF_AF_None;
			m_GPS = "";
		};
		PPCStringW m_Street;
		PPCStringW m_City;
		PPCStringW m_State;
		PPCStringW m_ZIP;
		PPCStringW m_Country;
		PPCStringW m_CountryCode;					// string format (refer to Mac AddressBook country code definition)
		int m_Format;								// integer format (refer to address format definition)
		PPCStringW m_GPS;							// string format
}WCXFRecord_AdrsL3;
typedef std::deque <WCXFRecord_AdrsL3*> WCXFRecord_AdrsL3PtrDQ;

//--------------------------------------------------------------------
typedef class WCXFRecord_Adrs
{
	public:
		WCXFRecord_AdrsL3PtrDQ m_WorkPtrDQ;
		WCXFRecord_AdrsL3PtrDQ m_HomePtrDQ;
		WCXFRecord_AdrsL3PtrDQ m_OtherPtrDQ;
}WCXFRecord_Address;
typedef std::deque <WCXFRecord_Adrs*> WCXFRecord_AdrsPtrDQ;

typedef class WCXFRecord_AdrsTmp
{
	public:
		WCXFRecord_Adrs*	m_AdrsL1;
		WCXFRecord_AdrsL3*	m_AdrsL3;
}WCXFRecord_AdrsTmp;

//--------------------------------------------------------------------
typedef class WCXFRecord_Email
{
	public:
		PPCStringWPtrDQ m_WorkPtrDQ;
		PPCStringWPtrDQ m_HomePtrDQ;
		PPCStringWPtrDQ m_OtherPtrDQ;
}WCXFRecord_Email;
typedef std::deque <WCXFRecord_Email*> WCXFRecord_EmailPtrDQ;
//--------------------------------------------------------------------
typedef class WCXFRecord_URL
{
	public:
		PPCStringWPtrDQ m_HomePagePtrDQ;
		PPCStringWPtrDQ m_WorkPtrDQ;
		PPCStringWPtrDQ m_HomePtrDQ;
		PPCStringWPtrDQ m_FacebookPtrDQ;
		PPCStringWPtrDQ m_TwitterPtrDQ;
		PPCStringWPtrDQ m_PlurkPtrDQ;
		PPCStringWPtrDQ m_LinkedInPtrDQ;
		PPCStringWPtrDQ m_ProfilePtrDQ;
		PPCStringWPtrDQ m_BlogPtrDQ;
		PPCStringWPtrDQ m_OtherPtrDQ;
}WCXFRecord_URL;
typedef std::deque <WCXFRecord_URL*> WCXFRecord_URLPtrDQ;
//--------------------------------------------------------------------
typedef class WCXFRecord_IML3
{
	public:
		WCXFRecord_IML3()
		{
		};
		void clear()
		{
			m_AIMPtrDQ.clear();
			m_YahooMessengerPtrDQ.clear();
			m_MSNPtrDQ.clear();
			m_ICQPtrDQ.clear();
			m_JabberPtrDQ.clear();
			m_QQPtrDQ.clear();
			m_GoogleTalkPtrDQ.clear();
		};
	PPCStringWPtrDQ m_AIMPtrDQ;
	PPCStringWPtrDQ m_YahooMessengerPtrDQ;
	PPCStringWPtrDQ m_MSNPtrDQ;
	PPCStringWPtrDQ m_ICQPtrDQ;
	PPCStringWPtrDQ m_JabberPtrDQ;
	PPCStringWPtrDQ m_QQPtrDQ;
	PPCStringWPtrDQ m_GoogleTalkPtrDQ;
}WCXFRecord_IML3;
typedef std::deque <WCXFRecord_IML3*> WCXFRecord_IML3PtrDQ;

typedef class WCXFRecord_IM
{
	public:
		WCXFRecord_IML3PtrDQ m_WorkPtrDQ;
		WCXFRecord_IML3PtrDQ m_HomePtrDQ;
		WCXFRecord_IML3PtrDQ m_OtherPtrDQ;
}WCXFRecord_IM;
typedef std::deque <WCXFRecord_IM*> WCXFRecord_IMPtrDQ;

typedef class WCXFRecord_IMTmp
{
	public:
		WCXFRecord_IM*		m_L1;
		WCXFRecord_IML3*	m_L3;

		WCXFRecord_IMTmp()
		{
			m_L1 = 0;
			m_L3 = 0;
		};
		
}WCXFRecord_IMTmp;
//--------------------------------------------------------------------

typedef std::deque <PPDate*> PPDatePtrDQ;

typedef class WCXFRecord_Date
{
	public:
		WCXFRecord_Date()
		{
			clear();
		};
		void clear()
		{
			m_AnniversaryPtrDQ.clear();
			m_OtherPtrDQ.clear();
		};
		PPDatePtrDQ m_AnniversaryPtrDQ;
		PPDatePtrDQ m_OtherPtrDQ;
		
}WCXFRecord_Date;
typedef std::deque <WCXFRecord_Date*> WCXFRecord_DatePtrDQ;
//--------------------------------------------------------------------
//-- 105 sW ------------------------------------------------------------------------------v---
//kWCXF_CDL1_GroupV2
typedef class WCXFRecord_GroupV2
{
	public:
		PPCStringWPtrDQ m_DefaultPtrDQ;
		PPCStringWPtrDQ m_DefinedPtrDQ;
}WCXFRecord_GroupV2;
typedef std::deque <WCXFRecord_GroupV2*> WCXFRecord_GroupV2PtrDQ;

//kWCXF_CDL1_UserDefine
typedef class WCXFRecord_UD_L2
{
	public:
		WCXFRecord_UD_L2(){
			clear();
		}
		
		~WCXFRecord_UD_L2()
		{
		};

		PPCStringW m_Label;
		PPCStringW m_Content;

		void clear()
		{
			m_Label = "";
			m_Content = "";
		};
}WCXFRecord_UD_L2;
typedef std::deque <WCXFRecord_UD_L2*> PPUD_L2PtrDQ;

typedef class WCXFRecord_UD_L1
{
	public:
		WCXFRecord_UD_L1()
		{
			clear();
		}
		void clear()
		{
			m_UserDefinePDQ.clear();
		};
		
		PPUD_L2PtrDQ m_UserDefinePDQ;
}WCXFRecord_UD_L1;
typedef std::deque <WCXFRecord_UD_L1*> WCXFRecord_UD_L1PtrDQ;

typedef class WCXFRecord_UD_Tmp
{
	public:
		WCXFRecord_UD_L1*	m_UD_L1;
		WCXFRecord_UD_L2*	m_UD_L2;
		int	m_State;
}WCXFRecord_UD_Tmp;


//----------------------------------------------------------------------------
//kWCXF_CDL1_Tag
typedef class WCXFRecord_Tag_L2
{
	public:
		WCXFRecord_Tag_L2(){
			clear();
		}
		
		~WCXFRecord_Tag_L2()
		{
		};

		PPCStringW m_Name;
		PPCStringW m_Data;

		void clear()
		{
			m_Name = "";
			m_Data = "";
		};
}WCXFRecord_Tag_L2;
typedef std::deque <WCXFRecord_Tag_L2*> WCXFRecord_Tag_L2PtrDQ;

typedef class WCXFRecord_Tag_L1
{
	public:
		WCXFRecord_Tag_L1()
		{
			clear();
		}
		void clear()
		{
			m_TagPDQ.clear();
		};
		
		WCXFRecord_Tag_L2PtrDQ m_TagPDQ;
}WCXFRecord_Tag_L1;
typedef std::deque <WCXFRecord_Tag_L1*> WCXFRecord_Tag_L1PtrDQ;

typedef class WCXFRecord_Tag_Tmp
{
	public:
		WCXFRecord_Tag_L1*	m_L1;
		WCXFRecord_Tag_L2*	m_L2;
		int	m_State;
}WCXFRecord_Tag_Tmp;

//-- 105 sW ------------------------------------------------------------------------------^---

typedef class WCXFRecord
{
	public:
		WCXFRecord()
		{
			clear();
		}
		void clear()
		{
			m_GroupPtrDQ.clear();
			m_UniqueID = "";
			m_Image_Flag = 0;
			m_RecogLang.clear();
			m_NamePtrDQ.clear();
			m_NickNamePtrDQ.clear();
			m_PositionPtrDQ.clear();
			m_DepartmentPtrDQ.clear();
			m_CompanyPtrDQ.clear();
			m_PhonePtrDQ.clear();
			m_SkypePtrDQ.clear();
			m_AddressPtrDQ.clear();
			m_EmailPtrDQ.clear();
			m_URLPtrDQ.clear();
			m_InstantMessagePtrDQ.clear();
			m_DatePtrDQ.clear();
			m_OtherPtrDQ.clear();
			m_Note = "";
			m_UnifiedBusinessNumberPtrDQ.clear();
			m_Birthday.clear();
			m_ChildrenPtrDQ.clear();
			m_SpousePtrDQ.clear();
			m_BloodType = "";
			m_Sex= "";
			m_Horoscope = "";	
			m_Education = "";	
			m_CreateTime.clear();
			m_ModifiedTime.clear();
			m_RecognizedTime.clear();
			m_Image_Front_size = 0;
			m_Image_Front_Ptr = 0;
			m_Image_Back_size = 0;
			m_Image_Back_Ptr = 0;
			m_Image_IDPhoto_size = 0;
			m_Image_IDPhoto_Ptr = 0;
			m_varDataPtr = 0;
			m_nowState = DEF_WCXF_STATE_NONE;
//-- 105 sW ------------------------------------------------------------------------------v---
			m_UserDefinePtrDQ.clear();
			m_GroupV2PtrDQ.clear();
			m_TagPtrDQ.clear();
			m_PPAccountIDDQ.clear();
			m_inArray = 0;
//-- 105 sW ------------------------------------------------------------------------------^---

		};
		PPCStringWPtrDQ m_GroupPtrDQ;
		PPCStringW m_UniqueID;
		int m_Image_Flag;
		WCXFRecord_RecogLang m_RecogLang;
		WCXFRecord_NamePtrDQ m_NamePtrDQ;						//L2
		PPCStringWPtrDQ m_NickNamePtrDQ;
		PPCStringWPtrDQ m_PositionPtrDQ;
		PPCStringWPtrDQ m_DepartmentPtrDQ;
		WCXFRecord_CompanyPtrDQ m_CompanyPtrDQ;					//L2
		WCXFRecord_PhonePtrDQ m_PhonePtrDQ;						//L2
		PPCStringWPtrDQ m_SkypePtrDQ;
		WCXFRecord_AdrsPtrDQ m_AddressPtrDQ;
		WCXFRecord_EmailPtrDQ m_EmailPtrDQ;
		WCXFRecord_URLPtrDQ m_URLPtrDQ;
		WCXFRecord_IMPtrDQ m_InstantMessagePtrDQ;
		WCXFRecord_DatePtrDQ m_DatePtrDQ;

		PPCStringWPtrDQ m_OtherPtrDQ;

		PPCStringW m_Note;
		PPCStringWPtrDQ m_UnifiedBusinessNumberPtrDQ;				// Τ@s
		PPDate m_Birthday;								// date format
		PPCStringWPtrDQ m_ChildrenPtrDQ;
		PPCStringWPtrDQ m_SpousePtrDQ;
		PPCStringW m_BloodType;							// refer to blood type value definition
		PPCStringW m_Sex;									// refer to sex value definition
		PPCStringW m_Horoscope;							// refer to horoscope value definition
		PPCStringW m_Education;							// refer to education value definition
		PPDate m_CreateTime;							// date format
		PPDate m_ModifiedTime;						// date format
		PPDate m_RecognizedTime;						// date format (ver101 added)
		int m_Image_Front_size;
		PPBYTE *m_Image_Front_Ptr;
		int m_Image_Back_size;
		PPBYTE *m_Image_Back_Ptr;
		int m_Image_IDPhoto_size;
		PPBYTE *m_Image_IDPhoto_Ptr;
//-- 105 sW ------------------------------------------------------------------------------v---
		WCXFRecord_UD_L1PtrDQ m_UserDefinePtrDQ;
		WCXFRecord_GroupV2PtrDQ	m_GroupV2PtrDQ;
		WCXFRecord_Tag_L1PtrDQ	m_TagPtrDQ;
		PPCStringWPtrDQ m_PPAccountIDDQ;				// PenPower Account ID
//-- 105 sW ------------------------------------------------------------------------------^---
		//------------------------------------------------------
		void *m_varDataPtr;
		int m_nowState;
		int m_inArray;
		
}WCXFRecord;



typedef class WCXFNode
{
	public:
		WCXFNode()
		{
			m_Type = DEF_WCXF_NODE_ARRAY;
			m_Key = "";
			m_PNode = 0;
			m_Data = 0;
		}
		int	m_Type;
		PPCStringW m_Key;
		void *m_PNode;
		void *m_Data;
}WCXFNode;

typedef std::deque <WCXFNode*> WCXFNodePtrDQ;
typedef std::deque <void*> FreeMemDQ;

typedef class WCXFData
{
	public:
	WCXFData()
	{
		m_dataLen = 0;
		m_dataPtr = 0;
	}
	long m_dataLen;
	unsigned char *m_dataPtr;

}WCXFData;

class CPPWcxfFInfo
{
	public:
		CPPWcxfFInfo()
		{
			m_FileNameP = 0;
		}
		void *m_FileH;
		int m_Mode;
#ifdef PPWCXF_IFACE_UNICODE
		PPWCHAR *m_FileNameP;
#endif

#ifdef PPWCXF_IFACE_ANSI
		char *m_FileNameP;
#endif

};

class CPPWcxfFile
{
public:
	CPPWcxfFile();
	~CPPWcxfFile();

	PPINT64 m_kWCXF_R_CardArrayPos;

	int m_kWCXF_R_CardCount;
	int m_kWCXF_R_FormatVersion;
	PPCStringW m_kWCXF_R_Generator;
	PPCStringW m_kWCXF_R_FileID;
	PPDate m_kWCXF_R_FileCreateTime;
    
    char *m_outputDebugFileName;

	//---------------------------------------------------------------------
#ifdef PPWCXF_IFACE_UNICODE
	void *OpenWCXFFile(PPWCHAR *fileName,PPDWORD mode);
#endif
#ifdef PPWCXF_IFACE_ANSI
	void *OpenWCXFFile(char *fileName,PPDWORD mode);
#endif
	int  CloseWCXFFile(void *fileH);
	int  GetRootInfo(void *fileH);
		
	void *ParseOneCardData(void *hf,PPINT64 &iPos,int &eofFlag,int &errCode);
	int DumpOneCard(void *oneDict,int &rCount);
	void FreeOneCard(void *oneDict);
	void FreeOneRecord(WCXFRecord &oneRecord);

	int Convert2WcxfRecord(void *oneDict,WCXFRecord &oneRecord);
	int DumpOneRecord(WCXFRecord &oneRecord);
	// ----write------------------------------------------------------------
	int WriteRootInfo(void *fileH);
	int WriteOneRecord(void *fileH, WCXFRecord &oneRecord);
	

	
	
	
private:
	//FreeMemDQ m_FreeMemDQ;
	
	CPPFileIo m_FileIo;
	CPPCode m_Code;

	int FindInFile(void *fpH,const char *findString,PPINT64 *offset,PPINT64 endOffset);
	
	PPINT64 GetRootKeyPos(void *hf,const char *keyName,PPINT64 fileLen);
	PPCStringW ReadFilePos(void *hf,PPINT64 startPos,PPINT64 iLen);
	PPCStringW ReadFilePos_UTF8(void *hf,PPINT64 startPos,PPINT64 iLen);
	void *ReadFilePosMem(void *hf,PPINT64 startPos,PPINT64 iLen,PPDWORD *retLen);

	PPCStringW ChangeXMLString(PPCStringW tmpStr);
	PPCStringW ChangeXMLString_Write(PPCStringW tmpStr);
	void *ConvertFromBase64(PPCStringW base64Code,unsigned int *outSize);

	int PutField2Record(WCXFRecord &oneRecord,PPCStringW &lastKey,void *oneDict,int bAction);
	
	int CollectOneCard(void *oneDict,int &rCount,WCXFRecord &oneRecord,PPCStringW &lastKey);

	void DumpAddressL3(WCXFRecord_AdrsL3 *tmpAdrsL3Ptr,CPPFileIo &oneFileIo);
	void DumpDate(PPDate *oneDatePtr,const char *preChar,CPPFileIo &oneFileIo);
	void DumpIML3(WCXFRecord_IML3 *tmpIML3Ptr,CPPFileIo &oneFileIo);
	void DumpNameL2(WCXFRecord_Name *tmpNamePtr,CPPFileIo &oneFileIo);
	void DumpPhoneL2(WCXFRecord_Phone *tmpPhonePtr,CPPFileIo &oneFileIo);
	void DumpURLL2(WCXFRecord_URL *tmpURLPtr,CPPFileIo &oneFileIo);
	void DumpInt(int iNum,CPPFileIo &oneFileIo);


	CBase64 m_Base64;
	

	
	int GetNextToken(void *hf,PPINT64 &inPos,PPCStringW &retStr);
    int GetNextStringToken(void *hf,PPINT64 &inPos,PPCStringW &retStr);

	int ConvertString2PPDate(PPCStringW srcString,PPDate &oneDate);
	int pp_itoa(int val, char* buf,unsigned int radix = 10);

	int WriteTokenLine(void *fileH,int tabNum,const char *tokenString,const char *keyString);
	char *GetDateStringA(PPDate &oneDate);
	int WriteTokenLine(void *fileH,int tabNum,const char *tokenString,PPCStringW &keyString);
	int WriteToken(void *fileH, int tabNum, const char *tokenString);
	char *Unicode2UTF8(PPCStringW &oneStringW);
	int ConvertString2PPDate_Fix1(PPCStringW srcString,PPDate &oneDate);

	void FilterFields(WCXFRecord &oneRecord);
	
	
	//PPCStringW m_kWCXF_R_CardArray;
	
	PPINT64 m_kWCXF_R_CardCountPos;
	PPINT64 m_kWCXF_R_FormatVersionPos;
	PPINT64 m_kWCXF_R_GeneratorPos;
	PPINT64 m_kWCXF_R_FileCreateTimePos;

	PPDate m_kWCXF_R_FileCreateTime_Old;

	int m_LastError;



	
};


#endif
