//
//  WCTServerContactExportHelper.m
//  WCTServerContactExportFlowController
//
//  Created by sanhue on 2019/12/9.
//

#import "WCTServerContactExportHelper.h"
#import "WCTServerContactExportFlowController+SettingsKey.h"
#import "WCTServerContactExportFlowController+ResourceDefine.h"
#import "WCTRestClientController+ParameterDefine.h"
#import "WCTRestObject+ParameterDefine.h"

#import "WCTRestClientController+Version.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCTServerContactExportHelper





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - String methods


//==============================================================================
//
//==============================================================================
+ (WCTServerExportTarget)targetFromServerType:(NSString *)serverType
{
    WCTServerExportTarget target = WCTServerExportTarget_None;
    if([serverType isEqualToString:WCTRC_ExportType_Office365])
    {
        target = WCTServerExportTarget_Exchange_Office365;
    }
    else if([serverType isEqualToString:WCTRC_ExportType_Exchange])
    {
        target = WCTServerExportTarget_Exchange_MS;
    }
    else if([serverType isEqualToString:WCTRC_ExportType_Salesforce])
    {
        target = WCTServerExportTarget_Salesforce;
    }
    else if([serverType isEqualToString:WCTRC_ExportType_SugarCRM])
    {
        target = WCTServerExportTarget_SugarCRM;
    }
    else if([serverType isEqualToString:WCTRC_ExportType_Qcontactz])
    {
        target = WCTServerExportTarget_Exchange_QContactz;
    }

    return target;
}


//==============================================================================
//
//==============================================================================
+ (NSString *)stringFromTarget:(WCTServerExportTarget)target
{
    switch (target)
    {
        case WCTServerExportTarget_Salesforce:
        {
            return WCTServerContactExportFlowControllerString_Target_Salesforce;
        }
        case WCTServerExportTarget_SugarCRM:
        {
            return WCTServerContactExportFlowControllerString_Target_SugarCRM;
        }
        case WCTServerExportTarget_Exchange_MS:
        {
            return WCTServerContactExportFlowControllerString_Target_MS;
        }
        case WCTServerExportTarget_Exchange_Office365:
        {
            return WCTServerContactExportFlowControllerString_Target_Office365;
        }
        case WCTServerExportTarget_Exchange_QContactz:
        {
            return WCTServerContactExportFlowControllerString_Target_QContactz;
        }
        default:
            return @"";
    }
}


//==============================================================================
//
//==============================================================================
+ (NSString *)loginToTarget:(WCTServerExportTarget)target
{
    return [NSString stringWithFormat:WCTServerContactExportFlowControllerString_LoginToTarget, [self stringFromTarget:target]];
}


//==============================================================================
//
//==============================================================================
+ (NSString *)settingTitleWithTarget:(WCTServerExportTarget)target
{
    switch (target)
    {
        case WCTServerExportTarget_SugarCRM:
        case WCTServerExportTarget_Salesforce:
        {
            return WCTServerContactExportFlowControllerString_CRMSettingTitle;
        }
        case WCTServerExportTarget_Exchange_MS:
        case WCTServerExportTarget_Exchange_Office365:
        case WCTServerExportTarget_Exchange_QContactz:
        {
            return WCTServerContactExportFlowControllerString_ExchangeSettingTitle;
        }
        default:
            return @"";
    }}


//==============================================================================
//
//==============================================================================
+ (NSString *)disabledByManagerMessage
{
    return WCTServerContactExportFlowControllerString_ErrorDisabledByManager;
}


//==============================================================================
//
//==============================================================================
+ (NSString *)alreadyLoginMessageWithTarget:(WCTServerExportTarget)target
{
    return [NSString stringWithFormat:WCTServerContactExportFlowControllerString_ErrorAlreadyLogin, [self stringFromTarget:target]];
}


//==============================================================================
//
//==============================================================================
+ (NSString *)setExportModeFailedMessageWithTarget:(WCTServerExportTarget)target
{
    return [NSString stringWithFormat:WCTServerContactExportFlowControllerString_ErrorSetExportModeFailed, [self stringFromTarget:target]];
}


//==============================================================================
//
//==============================================================================
+ (NSString *)mustLoginBeforeUseMessageWithTarget:(WCTServerExportTarget)target
{
    return [NSString stringWithFormat:WCTServerContactExportFlowControllerString_ErrorMustLoginBeforeUse, [self stringFromTarget:target]];
}


//==============================================================================
//
//==============================================================================
+ (NSString *)serverDisplayNameFromSupportContactServer:(NSString *)supportContactServer
{
    if ([supportContactServer isEqualToString:WCTRC_ExportType_Exchange])
    {
        return WCTServerContactExportFlowControllerString_Target_MS;
    }
    else if ([supportContactServer isEqualToString:WCTRC_ExportType_Office365])
    {
        return WCTServerContactExportFlowControllerString_Target_Office365;
    }
    else if ([supportContactServer isEqualToString:WCTRC_ExportType_Qcontactz])
    {
        return WCTServerContactExportFlowControllerString_Target_QContactz;
    }
    return @"";
}


//==============================================================================
//
//==============================================================================
+ (WCTServerExportTarget)targetFromSupportContactServer:(NSString *)supportContactServer
{
    if ([supportContactServer isEqualToString:WCTRC_ExportType_Exchange])
    {
        return WCTServerExportTarget_Exchange_MS;
    }
    else if ([supportContactServer isEqualToString:WCTRC_ExportType_Office365])
    {
        return WCTServerExportTarget_Exchange_Office365;
    }
    else if ([supportContactServer isEqualToString:WCTRC_ExportType_Qcontactz])
    {
        return WCTServerExportTarget_Exchange_QContactz;
    }
    else if ([supportContactServer isEqualToString:WCTRC_ExportType_Salesforce])
    {
        return WCTServerExportTarget_Salesforce;
    }
    else if ([supportContactServer isEqualToString:WCTRC_ExportType_SugarCRM])
    {
        return WCTServerExportTarget_SugarCRM;
    }

    return WCTServerExportTarget_None;
}


//==============================================================================
//
//==============================================================================
+ (NSString *)tryToExportUnSyncDataToTarget:(WCTServerExportTarget)target
{
    return [NSString stringWithFormat:WCTServerContactExportFlowControllerString_ErrorTryToExportUnSyncData, [self stringFromTarget:target]];
}




//==============================================================================
// must be called in background thread
//==============================================================================
+ (WCTRCCRMSystem *)CRMSystemTypeWithError:(NSError**)error
{
    NSError *returnError = nil;
    WCTRCCRMSystem *CRMSystem = nil;
    
    //////////////////////////////////////////////////

    WCTRCCRMSystemResponseResult *responseResult =  [[WCTRestClientController shareRestClientController] CRMSystemWithError:&returnError];
    
    if(responseResult)
    {
        CRMSystem = responseResult.data;
    }

    if(CRMSystem==nil)
    {
        if(error!=nil)
        {
            *error = PPErrorMake(WCTServerExportFlowErrorCode_GetSystemTypeFailed, @"取得CRM系統設定失敗", returnError);
        }
    }
    
    return CRMSystem;
}
@end
