//
//  WCTServerContactExportHelper.h
//  WCTServerContactExportFlowController
//
//  Created by sanhue on 2019/12/9.
//

#import <Foundation/Foundation.h>
#import "WCTRestClientController.h"
#import "WCTServerExportFlowController+Define.h"

typedef NS_ENUM(NSInteger, WCTServerExportTarget)
{
    WCTServerExportTarget_None = 0,
    WCTServerExportTarget_Salesforce,
    WCTServerExportTarget_SugarCRM,
    WCTServerExportTarget_Exchange_MS,
    WCTServerExportTarget_Exchange_Office365,
    WCTServerExportTarget_Exchange_QContactz
};


@interface WCTServerContactExportHelper : NSObject

+ (WCTServerExportTarget)targetFromServerType:(NSString *)serverType;

+ (NSString *)stringFromTarget:(WCTServerExportTarget)target;

+ (NSString *)loginToTarget:(WCTServerExportTarget)target;

+ (NSString *)settingTitleWithTarget:(WCTServerExportTarget)target;

+ (NSString *)disabledByManagerMessage;

+ (NSString *)alreadyLoginMessageWithTarget:(WCTServerExportTarget)target;

+ (NSString *)setExportModeFailedMessageWithTarget:(WCTServerExportTarget)target;

+ (NSString *)mustLoginBeforeUseMessageWithTarget:(WCTServerExportTarget)target;

+ (NSString *)serverDisplayNameFromSupportContactServer:(NSString *)supportContactServer;

+ (WCTServerExportTarget)targetFromSupportContactServer:(NSString *)supportContactServer;

+ (NSString *)tryToExportUnSyncDataToTarget:(WCTServerExportTarget)target;


/**
 取得目前設定的CRM系統
 
 !!must be called in background thread
 @return string of WCTRC_CRMType, WCTRC_CRMType_None表示沒有開啟CRM功能, nil 表示執行失敗
 */
+ (WCTRCCRMSystem *)CRMSystemTypeWithError:(NSError**)error;

@end
