//
//  WCTCRMFlowController.h
//  Pods
//
//  Created by sanhue on 2016/9/19.
//
//

#import <Foundation/Foundation.h>
#import "WCTExportSettingsViewController.h"
#import "WCTRCExchangeServerSystemDetail.h"
#import "WCTServerContactExportHelper.h"
#import "WCTRestClientController.h"
#import "WCTServerExportFlowController+Define.h"

// 需先在info.plist中設定以下設定才可以用
//
/* vvvvvvvv 複製以下程式碼，到info.plist貼上, key改為 |NSAppTransportSecurity| vvvvvvvv
 
 <?xml version="1.0" encoding="UTF-8"?>
 <!DOCTYPE plist PUBLIC "-//Apple//DTD PLIST 1.0//EN" "http://www.apple.com/DTDs/PropertyList-1.0.dtd">
 <plist version="1.0">
 <dict>
	<key>NSExceptionDomains</key>
	<dict>
 <key>force.com</key>
 <dict>
 <key>NSExceptionRequiresForwardSecrecy</key>
 <false/>
 <key>NSIncludesSubdomains</key>
 <true/>
 </dict>
 <key>salesforce.com</key>
 <dict>
 <key>NSExceptionRequiresForwardSecrecy</key>
 <false/>
 <key>NSIncludesSubdomains</key>
 <true/>
 </dict>
	</dict>
 </dict>
 </plist>

 ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*/


////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCTServerContactExportFlowController : NSObject

/**
 登入匯出目的地

 @param target             export target
 @param viewController  parent view controller
 @param clientID        salesforce clientID
 @param secret        salesforce clientSecret
 @param completeHandler callback when login complete
 */
+ (void)showLoginTarget:(WCTServerExportTarget)target
     fromViewController:(UIViewController *)viewController
               clientID:(NSString *)clientID
                 secret:(NSString *)secret
        completeHandler:(void(^)(NSDictionary *params, NSError *error))completeHandler;

/**
 * 登出匯出目的地
 * 這邊是直接call WCT server上的登出
 * @param completeHandler completeHandler 會與logoutWithCompleteHaldler同一個thread callback
 */
+ (void)logoutTarget:(WCTServerExportTarget)target
 withCompleteHaldler:(void(^)(NSError *error))completeHandler;

/**
 * 顯示匯出設定
 *
 * @param viewController  parent view controller

 * @param completeHandler 匯出流程結束後的通知
 */
+ (void)showExportSettingsForTarget:(WCTServerExportTarget)target
                 fromViewController:(UIViewController *)viewController
                    completeHandler:(ExportSelectItemCompletion)completeHandler;
/**
* 顯示登入並顯示匯出設定
*
 @param target             export target
 @param viewController  parent view controller
 @param clientID        salesforce clientID
 @param secret        salesforce clientSecret
 @param completeHandler callback when login complete

* @param completeHandler 匯出流程結束後的通知
*/
+ (void)showLoginAndSettingsWithTarget:(WCTServerExportTarget)target
                    fromViewController:(UIViewController *)viewController
                              clientID:(NSString *)clientID
                                secret:(NSString *)secret
                       completeHandler:(void(^)(NSDictionary *params, NSError *error))completeHandler;

/**
 * 通知server要把指定名片GUID，匯出到CRM
 *
 * 如果未登入，會先登入，並設定CRM匯出設定，如已登入，直接執行匯出
 *
 * @param contactGuids 要匯出的guid
 * @param completeHandler 匯出流程結束後的通知
 */
+ (void)exportToTarget:(WCTServerExportTarget)target
          withContacts:(NSArray *)contactGuids
    fromViewController:(UIViewController *)viewController
       completeHandler:(WCTServerExportCompleteHandler)completeHandler;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - TSMC method

/**
 * 使用TSMC匯出流程, 預設NO
 *
 * @param tsmcVersion 是否TSMC版本
 */
+ (void)setTSMCVersion:(BOOL)tsmcVersion;

/**
 * 是否為TSMC版本
 *
 * @return 是否TSMC版本
 */
+ (BOOL)isTSMCVersion;


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - help methods


/**
 * 取得server是否已有CRM設定
 *
 * !!must be called in background thread
 * @return BOOL YES:已有CRM設定；NO:沒有CRM設定
 */
+ (BOOL)checkCRMLoginStatusWithError:(NSError **)error;


/// 取得server exchange setting
+ (WCTRCExchangeServerSystemDetail *)exchangeSystemWithError:(NSError **)error;

/// 是否有登入資訊
+ (BOOL)isLoginExchangeServer;

/// 匯出到exchange流程
- (void)exchangeExportProcessWithTarget:(WCTServerExportTarget)target;
@end
