//
//  WCSalesforceLoginViewController.m
//  Example
//
//  Created by sanhue on 2016/9/19.
//  Copyright © 2016年 penpower. All rights reserved.
//

#import "WCTSalesforceLoginViewController.h"
#import "PPNavigationBarView.h"
#import "PPButton+Factory.h"
#import "WCAppearanceDefine.h"
#import "PPNavigationController.h"


typedef NS_ENUM(NSInteger, WCTSalesforceLoginViewControllerButtonTag)
{
    WCTSalesforceLoginViewControllerButtonTag_Back = 10,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCTSalesforceLoginViewController () <PPButtonDelegate>

@property (nonatomic, retain) PPSalesforceLoginView *loginView;
@property (nonatomic, retain) PPButton *ppButtonBack;
@property (nonatomic, retain) PPNavigationBarView *ppNavigationBarView;

@property (nonatomic, retain) NSArray *layoutConstraints;

/// block methods
@property (nonatomic, copy) PPSFLoginCompleteHandler completeHandler;
@end


////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation WCTSalesforceLoginViewController





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (instancetype)init
{
    self = [super init];
    if (self)
    {
        
    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.completeHandler = nil;
    self.requestAuthTokenHandler = nil;
    self.clientID = nil;
    self.clientSecret = nil;
    self.customDomain = nil;
    
    [self removeMainUI];
    
    //////////////////////////////////////////////////
    [super dealloc];
}







////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - view controller life cycle


//==============================================================================
//
//==============================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////
    
    [self prepareMainUI];

    //////////////////////////////////////////////////
    __block typeof(self) blockSelf = self;
    
    blockSelf.loginView.customDomain = self.customDomain;
    [blockSelf.loginView showOAuthViewWithCompleteHandler:^(NSDictionary *params, NSError *error) {
        
        if (blockSelf.completeHandler)
        {
            blockSelf.completeHandler(params, error);
        }
   }];
}


//==============================================================================
//
//==============================================================================
- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    
    //////////////////////////////////////////////////
}


//==============================================================================
//
//==============================================================================
- (void)viewWillDisappear:(BOOL)animated
{
    //////////////////////////////////////////////////
    
    [super viewWillDisappear:animated];
}


//==============================================================================
//
//==============================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    [self removeMainUI];
    //////////////////////////////////////////////////
    
    [super viewDidDisappear:animated];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - prepare ui


//==============================================================================
//
//==============================================================================
- (void)prepareMainUI
{
    self.ppButtonBack = [PPButton ppButtonWithIconImageName:ImageNamePPButtonIconForSystemBackImitation
                                                        tag:WCTSalesforceLoginViewControllerButtonTag_Back
                                                   delegate:self
                                      normalBackgroundColor:nil
                                 highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                            imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];
    //////////////////////////////////////////////////
    _ppNavigationBarView = [[PPNavigationBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds];
    
    if (self.ppNavigationBarView)
    {
        
        [self.ppNavigationBarView setStyle:PPBarViewStyle_CenteredAbsolute];
        
        [self.ppNavigationBarView.titleLabel setText:self.title];
        self.title = nil;
        //////////////////////////////////////////////////
        if (self.ppButtonBack)
        {
            PPBarViewItemModel * itemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.ppButtonBack];
            itemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
            
            [self.ppNavigationBarView  setItemModels:@[itemModel] forBlockType:PPBarViewBlockType_Left];
        }
        
        //////////////////////////////////////////////////
        if (self.navigationController!=nil)
        {
            self.navigationItem.leftBarButtonItem = [[[UIBarButtonItem alloc] initWithCustomView:self.ppNavigationBarView] autorelease];
        }
    }

    //////////////////////////////////////////////////
    self.loginView = [[[PPSalesforceLoginView alloc] initWithClientID:self.clientID secret:self.clientSecret] autorelease];
    self.loginView.requestAuthTokenHandler = self.requestAuthTokenHandler;
    [self.loginView setTranslatesAutoresizingMaskIntoConstraints:NO];
    
    [self.view addSubview:self.loginView];
    //////////////////////////////////////////////////
    [self resetLayoutConstraints];
}


//==============================================================================
//
//==============================================================================
- (void)removeMainUI
{
    [self removeLayoutConstraints];
    
    //////////////////////////////////////////////////
    
    [self.loginView removeFromSuperview];
    self.loginView = nil;
    
    //////////////////////////////////////////////////
    self.navigationItem.leftBarButtonItem = nil;
    
    self.ppNavigationBarView = nil;
    self.ppButtonBack = nil;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - layout constraints


//==============================================================================
//
//==============================================================================
- (void)resetLayoutConstraints
{
    if(self.loginView==nil)
    {
        return ;
    }
    
    [self removeLayoutConstraints];
    //////////////////////////////////////////////////
    NSDictionary *views = @{@"loginView":self.loginView};
    NSDictionary *metrics = nil;
    
    NSMutableArray *layoutConstraints = [NSMutableArray array];
    
    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"H:|[loginView]|"
                                                                                   options:NSLayoutFormatDirectionLeftToRight
                                                                                   metrics:metrics
                                                                                     views:views]];
    
    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"V:|[loginView]|"
                                                                                   options:NSLayoutFormatDirectionLeadingToTrailing
                                                                                   metrics:metrics
                                                                                     views:views]];
    
    //////////////////////////////////////////////////
    if ([layoutConstraints count])
    {
        self.layoutConstraints = [NSArray arrayWithArray:layoutConstraints];
        [self.view addConstraints:self.layoutConstraints];
        [self.view layoutIfNeeded];
    }
}


//==============================================================================
//
//==============================================================================
- (void)removeLayoutConstraints
{
    if (self.layoutConstraints)
    {
        [self.view removeConstraints:self.layoutConstraints];
        self.layoutConstraints = nil;
    }
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PPButtonDelegate


//==============================================================================
//
//==============================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    switch (ppButton.tag)
    {
        case WCTSalesforceLoginViewControllerButtonTag_Back:
        {
            [self goBackAnimated:YES];
            break;
        }
        default:
            break;
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - public methods


//==============================================================================
//
//==============================================================================
- (void)showFromViewController:(UIViewController *)viewController completeHandler:(PPSFLoginCompleteHandler)completeHandler
{
    self.completeHandler = completeHandler ;
    if(viewController.navigationController)
    {
        [viewController.navigationController pushViewController:self animated:YES];
    }
    else
    {
        PPNavigationController *navigationController = [[PPNavigationController alloc] initWithRootViewController:self];
        [viewController presentViewController:navigationController animated:YES completion:nil];
        [navigationController release];
    }
}


@end
