//
//  WCTSalesforceContactSearchViewController.m
//  WCTServerContactExportFlowController
//
//  Created by sanhue cheng on 2020/5/24.
//

#import "WCTSalesforceContactSearchViewController.h"

//define
#import "WCAppearanceDefine.h"
#import "WCTServerContactExportFlowController+ResourceDefine.h"

//category
#import "PPButton+Factory.h"
#import "NSObject+PPBusyView.h"
#import "NSTimer+Additions.h"
#import "NSError+Custom.h"

// views
#import "PPNavigationBarView.h"
#import "PPTableView.h"
#import "PPTableViewCell.h"

// controllers
#import "PPSectionController.h"
#import "WCToastController.h"
#import "PPAlertController.h"

static NSString *const WCTSalesforceContactSearchViewController_RecentContactsIdentifier = @"WCTSalesforceContactSearchViewController_RecentContactsIdentifier";
static NSString *const WCTSalesforceContactSearchViewController_SearchResultIdentifier = @"WCTSalesforceContactSearchViewController_SearchResultIdentifier";

static NSString *const WCTSalesforceContactSearchViewController_ImageName_Done = @"Done";
static NSString *const WCTSalesforceContactSearchViewController_ImageName_SearchIcon = @"WCSearchViewControllerButton_SearchIcon@3x";
static NSString *const WCTSalesforceContactSearchViewController_ImageName_SearchClear_Normal = @"WCSearchViewControllerButton_SearchClear-Normal@3x";

#define WCTSalesforceContactSearchViewController_SearchAreaEdgeInsets UIEdgeInsetsMake(7, 3, 7, 3)

#define WCTSalesforceContactSearchViewController_SearchFieldTextColor [UIColor colorWithHexString:@"#3f78cf"]
#define WCTSalesforceContactSearchViewController_NoResultTextColor [UIColor grayColor]

static NSInteger WCTSalesforceContactSearchViewController_NoResultFontSize = 16;
static NSInteger WCTSalesforceContactSearchViewController_NoRecentlyViewedContactFontSize = 20;

static double WCTSalesforceContactSearchViewController_Length0Waiting = 0.0;
static double WCTSalesforceContactSearchViewController_Length1Waiting = 1.0;
static double WCTSalesforceContactSearchViewController_OtherLengthWaiting = 0.5;

typedef NS_ENUM(NSInteger, WCTSalesforceContactSearchViewButtonTag)
{
    WCTSalesforceContactSearchViewButtonTag_Back,
    WCTSalesforceContactSearchViewButtonTag_Done
};
////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCTSalesforceContactSearchViewController () <UITableViewDelegate, UITableViewDataSource, UISearchBarDelegate, PPButtonDelegate>
@property (nonatomic, retain) NSArray *layoutConstraints;
@property (nonatomic, retain) PPNavigationBarView *ppNavigationBarView;
@property (nonatomic, retain) PPButton *ppButtonBack;
@property (nonatomic, retain) PPButton *ppButtonDone;
@property (nonatomic, retain) UISearchBar *searchBar;

@property (nonatomic, retain) PPTableView *ppRecentContactTableView;
@property (nonatomic, retain) UILabel *noRecentContactsLabel;

@property (nonatomic, retain) PPTableView *ppSearchResultTableView;
@property (nonatomic, retain) UILabel *noResultLabel;

@property (nonatomic, retain) PPSectionController *ppSectionController;

// 是否要focus在search bar上，預設YES
@property (nonatomic, assign) BOOL focusOnSearchBar;

@property (nonatomic, retain) NSString *lastSelectedGuid;
@property (nonatomic, retain) NSString *lastSearchText;
@property (nonatomic, retain) NSTimer *timerForLaunchedSearch;

@property (nonatomic, retain) NSOperationQueue *operationQueue;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation WCTSalesforceContactSearchViewController





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (instancetype)init
{
    self = [super init];
    if (self)
    {
        self.operationQueue = [[[NSOperationQueue alloc] init] autorelease];
        if (self.operationQueue)
        {
            [self.operationQueue setMaxConcurrentOperationCount:1];
        }

        self.ppSectionController = [[[PPSectionController alloc] init] autorelease];
    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.requestRecentContactsHandler = nil;
    self.requestSearchResultHandler = nil;
    self.completeHandler = nil;
    
    self.ppSectionController = nil;

    [self.timerForLaunchedSearch invalidate];
    self.timerForLaunchedSearch = nil;

    [self.operationQueue cancelAllOperations];
    self.operationQueue = nil;
    
    self.lastSelectedGuid = nil;
    self.lastSearchText = nil;
    
    [self removeMainUI];
    //////////////////////////////////////////////////
    [super dealloc];
}








////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - view controller life cycle


//==============================================================================
//
//==============================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////
    
    // 讀取最近聯絡人
    [self prepateRecentData];
    
    [self prepareMainUI];
    
    [self registerForKeyboardNotifications];
}


//==============================================================================
//
//==============================================================================
- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    
    //////////////////////////////////////////////////
    // 設定focus
    if(self.focusOnSearchBar)
    {
        [self.searchBar becomeFirstResponder];
    }
}


//==============================================================================
//
//==============================================================================
- (void)viewWillDisappear:(BOOL)animated
{
    //////////////////////////////////////////////////
    
    [super viewWillDisappear:animated];
}


//==============================================================================
//
//==============================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    [self removeMainUI];
    [self unRegisterForKeyboardNotifications];
    //////////////////////////////////////////////////
    
    [super viewDidDisappear:animated];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - prepare ui


//==============================================================================
//
//==============================================================================
- (void)prepareMainUI
{
    if(self.ppButtonBack==nil)
    {
        self.ppButtonBack = [PPButton ppButtonWithIconImageName:ImageNamePPButtonIconForSystemBackImitation
                                                              tag:WCTSalesforceContactSearchViewButtonTag_Back
                                                         delegate:self
                                            normalBackgroundColor:nil
                                       highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                                  imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];
    }

    if(self.ppButtonDone==nil)
    {
        self.ppButtonDone = [PPButton ppButtonWithIconImageName:WCTSalesforceContactSearchViewController_ImageName_Done
                                                            tag:WCTSalesforceContactSearchViewButtonTag_Done
                                                       delegate:self
                                          normalBackgroundColor:nil
                                     highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                                imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];
    }
    
    //////////////////////////////////////////////////
    CGRect searchBarFrame = [self searchBarFrame];
    if(self.searchBar==nil)
    {
        self.searchBar = [[[UISearchBar alloc] initWithFrame:searchBarFrame] autorelease];
    }
    
    if (self.searchBar)
    {
        [self.searchBar setDelegate:self];
        [self.searchBar setSearchBarStyle:UISearchBarStyleDefault];
        if([self.searchBar respondsToSelector:@selector(setReturnKeyType:)])
        {
            [self.searchBar setReturnKeyType:UIReturnKeyDone];
        }
        
        //設定背景
        UIImage *searchFieldBGImage = [UIImage imageWithColor:[UIColor whiteColor] size:CGSizeMake(searchBarFrame.size.width, 30)];
        [self.searchBar setSearchFieldBackgroundImage:searchFieldBGImage forState:UIControlStateNormal];
        
        //////////////////////////////////////////////////
        // 設定search bar icon
        UIImage *searchIcon = [UIImage imageWithName:WCTSalesforceContactSearchViewController_ImageName_SearchIcon];
        [self.searchBar setImage:searchIcon forSearchBarIcon:UISearchBarIconSearch state:UIControlStateNormal];

        UIImage *clearIcon = [UIImage imageWithName:WCTSalesforceContactSearchViewController_ImageName_SearchClear_Normal];
        [self.searchBar setImage:clearIcon forSearchBarIcon:UISearchBarIconClear state:UIControlStateNormal];
        
        //////////////////////////////////////////////////
        
        [self.searchBar setBackgroundColor:[UIColor whiteColor]];
        
        if(@available(iOS 13, *))
        {
            // 設定 游標顏色
            [[self.searchBar searchTextField] setTintColor:WCTSalesforceContactSearchViewController_SearchFieldTextColor];

            // 設定text field字型
            [[self.searchBar searchTextField] setTextColor:WCTSalesforceContactSearchViewController_SearchFieldTextColor];
            [[self.searchBar searchTextField] setFont:[UIFont systemFontOfSize:18]];
        }
        if ([self.lastSearchText length]>0)
        {
            [self.searchBar setText:self.lastSearchText];
        }
    }
    
    //////////////////////////////////////////////////
    
    if(_ppNavigationBarView==nil)
    {
        _ppNavigationBarView = [[PPNavigationBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds];
    }
    
    if (self.ppNavigationBarView)
    {
        [self.ppNavigationBarView setStyle:PPBarViewStyle_CenteredAbsolute];
        [self.ppNavigationBarView.titleLabel setEnabled:NO];
        [self.ppNavigationBarView.titleLabel setHidden:YES];
        [self.ppNavigationBarView setIgnoreEdgeInset:NO];
        
        //////////////////////////////////////////////////
        NSMutableArray *centerViews = [NSMutableArray array];
        
        if (self.searchBar)
        {
            PPBarViewItemModel *itemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.searchBar];
            itemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
            itemModel.edgeInsetsForMiniBar = UIEdgeInsetsZero;
            
            [centerViews addObject:itemModel];
        }
        

        if([centerViews count]>0)
        {
            PPBarViewBlockModel *blockModel = [[PPBarViewBlockModel alloc] init];
            blockModel.edgeInsetsForNormalBar = WCTSalesforceContactSearchViewController_SearchAreaEdgeInsets;
            blockModel.edgeInsetsForMiniBar = WCTSalesforceContactSearchViewController_SearchAreaEdgeInsets;
            [blockModel.itemModels addObjectsFromArray:centerViews];
            
            [self.ppNavigationBarView setBlockModel:blockModel forType:PPBarViewBlockType_Center];
            [blockModel release];
        }
        
        
        //////////////////////////////////////////////////
        if (self.ppButtonBack)
        {
            PPBarViewItemModel *itemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.ppButtonBack];
            itemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
            itemModel.edgeInsetsForMiniBar = UIEdgeInsetsZero;
            
            PPBarViewBlockModel *blockModel = [[PPBarViewBlockModel alloc] init];
            blockModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
            blockModel.edgeInsetsForMiniBar = UIEdgeInsetsZero;
            [blockModel.itemModels addObject:itemModel];
            
            [self.ppNavigationBarView setBlockModel:blockModel forType:PPBarViewBlockType_Left];
            [blockModel release];
        }
        
        if (self.ppButtonDone)
        {
            PPBarViewItemModel *itemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.ppButtonDone];
            itemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
            itemModel.edgeInsetsForMiniBar = UIEdgeInsetsZero;
            
            PPBarViewBlockModel *blockModel = [[PPBarViewBlockModel alloc] init];
            blockModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
            blockModel.edgeInsetsForMiniBar = UIEdgeInsetsZero;
            [blockModel.itemModels addObject:itemModel];
            
            [self.ppNavigationBarView setBlockModel:blockModel forType:PPBarViewBlockType_Right];
            [blockModel release];
        }
        //////////////////////////////////////////////////
        if (self.navigationController!=nil)
        {
            self.navigationItem.leftBarButtonItem = [[[UIBarButtonItem alloc] initWithCustomView:self.ppNavigationBarView] autorelease];
        }
        
    }
    
    //////////////////////////////////////////////////
    if(self.ppSearchResultTableView==nil)
    {
        self.ppSearchResultTableView = [[[PPTableView alloc] initWithFrame:self.view.bounds style:UITableViewStylePlain] autorelease];
    }
    
    if(self.ppSearchResultTableView)
    {
        self.ppSearchResultTableView.delegate = self;
        self.ppSearchResultTableView.dataSource = self;
        [self.ppSearchResultTableView setTranslatesAutoresizingMaskIntoConstraints:NO];
        
        self.ppSearchResultTableView.estimatedSectionHeaderHeight = WCAppearanceDefine_SectionHeaderHeight;
        self.ppSearchResultTableView.estimatedRowHeight = WCAppearanceDefine_CellHeight;
        [self.ppSearchResultTableView setTableFooterView:[[[UIView alloc] init] autorelease]];
        //////////////////////////////////////////////////
        [self.view addSubview:self.ppSearchResultTableView];
        
        [self.ppSearchResultTableView registerClass:[UITableViewCell class] forCellReuseIdentifier:[self cellIdentifierForSearching:YES]];
        self.ppSearchResultTableView.hidden = YES;
    }
    //////////////////////////////////////////////////
    
    if(self.noResultLabel==nil)
    {
        self.noResultLabel = [[[UILabel alloc] initWithFrame:CGRectZero] autorelease];
    }
    
    [self.noResultLabel setTranslatesAutoresizingMaskIntoConstraints:NO];
    [self.noResultLabel setTextColor:WCTSalesforceContactSearchViewController_NoResultTextColor];
    [self.noResultLabel setFont:[UIFont systemFontOfSize:WCTSalesforceContactSearchViewController_NoResultFontSize]];
    [self.noResultLabel setText:WCTServerContactExportFlowControllerString_NoAccont];
    [self.noResultLabel setLineBreakMode:NSLineBreakByWordWrapping];
    [self.noResultLabel setNumberOfLines:0];
    
    [self.ppSearchResultTableView addSubview:self.noResultLabel];
    [self.noResultLabel setHidden:YES];
    
    //////////////////////////////////////////////////
    if(self.ppRecentContactTableView==nil)
    {
        self.ppRecentContactTableView = [[[PPTableView alloc] initWithFrame:self.view.bounds style:UITableViewStylePlain] autorelease];
    }
    
    if(self.ppRecentContactTableView)
    {
        self.ppRecentContactTableView.delegate = self;
        self.ppRecentContactTableView.dataSource = self;
        [self.ppRecentContactTableView setTranslatesAutoresizingMaskIntoConstraints:NO];
        
        self.ppRecentContactTableView.estimatedSectionHeaderHeight = WCAppearanceDefine_SectionHeaderHeight;
        self.ppRecentContactTableView.estimatedRowHeight = WCAppearanceDefine_CellHeight;
        [self.ppRecentContactTableView setTableFooterView:[[[UIView alloc] init] autorelease]];
        //////////////////////////////////////////////////
        [self.view addSubview:self.ppRecentContactTableView];

        [self.ppRecentContactTableView registerClass:[UITableViewCell class] forCellReuseIdentifier:[self cellIdentifierForSearching:NO]];

    }
    //////////////////////////////////////////////////
    
    if(self.noRecentContactsLabel==nil)
    {
        self.noRecentContactsLabel = [[[UILabel alloc] initWithFrame:CGRectZero] autorelease];
    }
    
    [self.noRecentContactsLabel setTranslatesAutoresizingMaskIntoConstraints:NO];
    [self.noRecentContactsLabel setTextAlignment:NSTextAlignmentCenter];
    [self.noRecentContactsLabel setTextColor:WCTSalesforceContactSearchViewController_NoResultTextColor];
    [self.noRecentContactsLabel setFont:[UIFont systemFontOfSize:WCTSalesforceContactSearchViewController_NoRecentlyViewedContactFontSize]];
    [self.noRecentContactsLabel setText:WCTServerContactExportFlowControllerString_NoRecentlyAccount];
    [self.noRecentContactsLabel setLineBreakMode:NSLineBreakByWordWrapping];
    
    [self.ppRecentContactTableView addSubview:self.noRecentContactsLabel];
    [self.noRecentContactsLabel setHidden:YES];
    
    //////////////////////////////////////////////////
    [self resetLayoutConstraintsWithKeyboardHeight:0];
}


//==============================================================================
//
//==============================================================================
- (void)removeMainUI
{
    [self removeLayoutConstraints];
    
    [self.noResultLabel removeFromSuperview];
    self.noResultLabel = nil;
    
    [self.noRecentContactsLabel removeFromSuperview];
    self.noRecentContactsLabel = nil;
    
    [self.ppSearchResultTableView removeFromSuperview];
    self.ppSearchResultTableView = nil;

    [self.ppRecentContactTableView removeFromSuperview];
    self.ppRecentContactTableView = nil;
    
    self.navigationItem.leftBarButtonItem = nil;
    
    self.searchBar = nil;
    self.ppButtonBack = nil;
    self.ppButtonDone = nil;
    
    self.ppNavigationBarView = nil;
}


//==============================================================================
// 需在ui都建立後才能使用
//==============================================================================
- (CGRect)searchBarFrame
{
    NSInteger searchBarLeftMargin = self.ppButtonBack.bounds.size.width+WCTSalesforceContactSearchViewController_SearchAreaEdgeInsets.left;
    NSInteger searchBarRightMargin = WCTSalesforceContactSearchViewController_SearchAreaEdgeInsets.right;
    
    CGRect viewFrame = self.navigationController.navigationBar.bounds;
    CGFloat searchBarHeight = viewFrame.size.height-(WCTSalesforceContactSearchViewController_SearchAreaEdgeInsets.top+WCTSalesforceContactSearchViewController_SearchAreaEdgeInsets.bottom);
    
    return CGRectMake(searchBarLeftMargin,
                      (viewFrame.size.height-searchBarHeight)/2,
                      viewFrame.size.width-(searchBarLeftMargin+searchBarRightMargin),
                      searchBarHeight);
}




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - layout constraints


//==============================================================================
//
//==============================================================================
- (void)resetLayoutConstraintsWithKeyboardHeight:(CGFloat)keyboardHeight
{
    if(self.ppSearchResultTableView==nil||
       self.ppRecentContactTableView==nil)
    {
        return;
    }
    
    //////////////////////////////////////////////////
    
    [self removeLayoutConstraints];
    //////////////////////////////////////////////////
    NSDictionary *views = @{@"ppSearchResultTableView":self.ppSearchResultTableView,
                            @"ppRecentContactTableView":self.ppRecentContactTableView
    };
    NSDictionary *metrics = @{@"BottomSpace":@(keyboardHeight)};
    
    NSMutableArray *layoutConstraints = [NSMutableArray array];
    
    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"H:|[ppSearchResultTableView]|"
                                                                                   options:NSLayoutFormatDirectionLeftToRight
                                                                                   metrics:metrics
                                                                                     views:views]];
    
    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"V:|[ppSearchResultTableView]-(BottomSpace)-|"
                                                                                   options:NSLayoutFormatDirectionLeadingToTrailing
                                                                                   metrics:metrics
                                                                                     views:views]];

    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"H:|[ppRecentContactTableView]|"
                                                                                   options:NSLayoutFormatDirectionLeftToRight
                                                                                   metrics:metrics
                                                                                     views:views]];
    
    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"V:|[ppRecentContactTableView]-(BottomSpace)-|"
                                                                                   options:NSLayoutFormatDirectionLeadingToTrailing
                                                                                   metrics:metrics
                                                                                     views:views]];

    //////////////////////////////////////////////////
    [layoutConstraints addObject:[NSLayoutConstraint constraintWithItem:self.noResultLabel
                                                              attribute:NSLayoutAttributeCenterX
                                                              relatedBy:NSLayoutRelationEqual
                                                                 toItem:self.ppSearchResultTableView
                                                              attribute:NSLayoutAttributeCenterX
                                                             multiplier:1.0
                                                               constant:0]];
    
    [layoutConstraints addObject:[NSLayoutConstraint constraintWithItem:self.noResultLabel
                                                              attribute:NSLayoutAttributeTop
                                                              relatedBy:NSLayoutRelationEqual
                                                                 toItem:self.ppSearchResultTableView
                                                              attribute:NSLayoutAttributeTop
                                                             multiplier:1.0
                                                               constant:WCAppearanceDefine_SectionHeaderHeight]];

    [layoutConstraints addObject:[NSLayoutConstraint constraintWithItem:self.noResultLabel
                                                              attribute:NSLayoutAttributeWidth
                                                              relatedBy:NSLayoutRelationEqual
                                                                 toItem:self.ppSearchResultTableView
                                                              attribute:NSLayoutAttributeWidth
                                                             multiplier:1.0
                                                               constant:0]];
    
    [layoutConstraints addObject:[NSLayoutConstraint constraintWithItem:self.noResultLabel
                                                              attribute:NSLayoutAttributeHeight
                                                              relatedBy:NSLayoutRelationEqual
                                                                 toItem:nil
                                                              attribute:NSLayoutAttributeHeight
                                                             multiplier:1.0
                                                               constant:150]];

    //////////////////////////////////////////////////
    [layoutConstraints addObject:[NSLayoutConstraint constraintWithItem:self.noRecentContactsLabel
                                                              attribute:NSLayoutAttributeCenterX
                                                              relatedBy:NSLayoutRelationEqual
                                                                 toItem:self.ppRecentContactTableView
                                                              attribute:NSLayoutAttributeCenterX
                                                             multiplier:1.0
                                                               constant:0]];
    
    [layoutConstraints addObject:[NSLayoutConstraint constraintWithItem:self.noRecentContactsLabel
                                                              attribute:NSLayoutAttributeTop
                                                              relatedBy:NSLayoutRelationEqual
                                                                 toItem:self.ppRecentContactTableView
                                                              attribute:NSLayoutAttributeTop
                                                             multiplier:1.0
                                                               constant:WCAppearanceDefine_SectionHeaderHeight]];
    
    [layoutConstraints addObject:[NSLayoutConstraint constraintWithItem:self.noRecentContactsLabel
                                                              attribute:NSLayoutAttributeWidth
                                                              relatedBy:NSLayoutRelationEqual
                                                                 toItem:self.ppRecentContactTableView
                                                              attribute:NSLayoutAttributeWidth
                                                             multiplier:1.0
                                                               constant:0]];
    
    [layoutConstraints addObject:[NSLayoutConstraint constraintWithItem:self.noRecentContactsLabel
                                                              attribute:NSLayoutAttributeHeight
                                                              relatedBy:NSLayoutRelationEqual
                                                                 toItem:nil
                                                              attribute:NSLayoutAttributeHeight
                                                             multiplier:1.0
                                                               constant:WCAppearanceDefine_SectionHeaderHeight]];
    //////////////////////////////////////////////////
    if ([layoutConstraints count])
    {
        self.layoutConstraints = [NSArray arrayWithArray:layoutConstraints];
        [self.view addConstraints:self.layoutConstraints];
        [self.view layoutIfNeeded];
    }
    
    //////////////////////////////////////////////////
    
    self.searchBar.frame = [self searchBarFrame];
}


//==============================================================================
//
//==============================================================================
- (void)removeLayoutConstraints
{
    if (self.layoutConstraints)
    {
        [self.view removeConstraints:self.layoutConstraints];
        self.layoutConstraints = nil;
    }
}


//==============================================================================
//
//==============================================================================
- (void)updateViewConstraints
{
    [super updateViewConstraints];
    //////////////////////////////////////////////////
    [self resetLayoutConstraintsWithKeyboardHeight:0];
}


//==============================================================================
//
//==============================================================================
- (void)viewSafeAreaInsetsDidChange
{
    [super viewSafeAreaInsetsDidChange];
    //////////////////////////////////////////////////
    [self resetLayoutConstraintsWithKeyboardHeight:0];
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Private prepare data


//==============================================================================
//
//==============================================================================
- (NSString *)cellIdentifierForSearching:(BOOL)searching
{
    if (searching==YES)
    {
        return WCTSalesforceContactSearchViewController_SearchResultIdentifier;
    }
    else
    {
        return WCTSalesforceContactSearchViewController_RecentContactsIdentifier;
    }
}


//==============================================================================
//
//==============================================================================
- (void)prepateRecentData
{
    __block typeof(self) blockSelf = self;
    __block NSError *error  = nil;

    [self setBusy:@(YES)];
    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
        
        NSArray *recentContactList = nil;
        if(blockSelf.requestRecentContactsHandler)
        {
            recentContactList = blockSelf.requestRecentContactsHandler(&error);
        }
        
        [recentContactList retain];
        [error retain];
        //////////////////////////////////////////////////
        dispatch_async(dispatch_get_main_queue(), ^{
            
            if(error)
            {
                
                [self setBusy:@(NO)];
                if (self.completeHandler)
                {
                    self.completeHandler(nil, error);
                }
                
//                [self goBackAnimated:YES];
//                NSError *networkError = [error findNetworkError];
//                
//                NSString *errorMessage = nil;
//                NSError *networkError = [error findNetworkError];
//                if(networkError)
//                {
//                    errorMessage = Common_FailedToConnectInternet;
//                }
//                else
//                {
//                    errorMessage = [error alertMessage];
//                }
//                __block typeof(self) blockSelf = self;
//                
//                [blockSelf showAlertWithViewController:blockSelf message:errorMessage action:^(UIAlertAction *action) {
//                    [blockSelf goBackAnimated:YES];
//                }];
//                [PPAlertController showWithAlertControllerStyle:UIAlertControllerStyleAlert
//                                                          title:@""
//                                                        message:[error alertMessage]
//                                         showFromViewController:self
//                                                       animated:YES
//                                                    alertAction:[UIAlertAction actionWithTitle:@"Ok"
//                                                                                         style:UIAlertActionStyleDefault
//                                                                                       handler:^(UIAlertAction * _Nonnull action) {
//
//                }], nil];

            }
            else
            {
                if([recentContactList count]>0)
                {
                    [blockSelf.ppSectionController replaceSectionModels:recentContactList forSearching:NO];
                    
                    [blockSelf.ppRecentContactTableView reloadData];
                    
                }
                
                
                [UIView animateWithDuration:0.1 animations:^{
                    
                } completion:^(BOOL finished) {
                    blockSelf.ppSearchResultTableView.hidden = YES;
                    blockSelf.ppRecentContactTableView.hidden = NO;
                }];
                [self setBusy:@(NO)];
            }
            [error release];
            [recentContactList release];
        });
    });

}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Search Text Method


//==============================================================================
//
//==============================================================================
- (void)searchText:(NSString*)text
{
    self.focusOnSearchBar = YES;
    
    __block BOOL isSearching = NO;
    __block typeof(self) blockSelf = self;
    [self.operationQueue cancelAllOperations];
    [self setBusy:@(NO)];
    
    
    __block NSBlockOperation *blockOperation = [NSBlockOperation blockOperationWithBlock:^{
        
        if (self.requestSearchResultHandler)
        {
            NSArray *searchedResult = nil;
            
            if ([blockOperation isCancelled]==NO)
            {
                dispatch_async(dispatch_get_main_queue(), ^{
                    isSearching = YES;
                    [blockSelf setBusy:@(YES)];
                });
                
                if ([text length]>0)
                {
                    searchedResult = self.requestSearchResultHandler(text);
                }
                else
                {
                    self.lastSelectedGuid = nil;
                }
            }
            
            //////////////////////////////////////////////////
            // !!這邊要用同步的方式，不然非同步更新會造成當機
            
            if ([blockOperation isCancelled]==NO)
            {
                [searchedResult retain];
                
                dispatch_sync(dispatch_get_main_queue(), ^{
                        
                    [self.ppSectionController replaceSectionModels:searchedResult forSearching:YES];
                    [searchedResult release];
                    //////////////////////////////////////////////////
                    
                    if (isSearching)
                    {
                        [blockSelf.ppSearchResultTableView reloadData];
                        
                        blockSelf.ppSearchResultTableView.hidden = ([text length]!=0);
                        blockSelf.ppRecentContactTableView.hidden = ([text length]==0);
                        
                        [UIView animateWithDuration:0.1 animations:^{
                            blockSelf.ppSearchResultTableView.hidden = ([text length]==0);
                            blockSelf.ppRecentContactTableView.hidden = ([text length]!=0);
                            
                        } completion:^(BOOL finished) {
                            
                            blockSelf.ppSearchResultTableView.hidden = ([text length]==0);
                            blockSelf.ppRecentContactTableView.hidden = ([text length]!=0);
                        }];
                        
                        [blockSelf setBusy:@(NO)];
                        isSearching = NO;
                    }
                });
            }
            else
            {
                dispatch_async(dispatch_get_main_queue(), ^{
                    [blockSelf setBusy:@(NO)];
                    isSearching = NO;
                });
            }
        }
    }];
    
    [self.operationQueue addOperation:blockOperation];
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Keyboard show/hide


//================================================================================
//
//================================================================================
- (void)registerForKeyboardNotifications
{
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(recvKeyboardWillShow:)
                                                 name:UIKeyboardWillShowNotification object:nil];
    
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(recvKeyboardWillHidden:)
                                                 name:UIKeyboardWillHideNotification object:nil];
    
}


//================================================================================
//
//================================================================================
- (void)unRegisterForKeyboardNotifications
{
    
    [[NSNotificationCenter defaultCenter] removeObserver:self name:UIKeyboardWillShowNotification object:nil];
    
    [[NSNotificationCenter defaultCenter] removeObserver:self name:UIKeyboardWillHideNotification object:nil];
    
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - recv Keyboard notifivation


//==============================================================================
//
//==============================================================================
- (void)recvKeyboardWillShow:(NSNotification*)notification
{
    NSValue * rectValue = [notification.userInfo objectForKey:UIKeyboardFrameEndUserInfoKey];
    
    if(rectValue!=nil)
    {
        CGRect keyboardRect = [rectValue CGRectValue];
        [self resetLayoutConstraintsWithKeyboardHeight:MIN(keyboardRect.size.width,keyboardRect.size.height)];
    }
}


//==============================================================================
//
//==============================================================================
- (void)recvKeyboardWillHidden:(NSNotification*)notification
{
    [self resetLayoutConstraintsWithKeyboardHeight:0];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - UITableViewDataSource


//==============================================================================
//
//==============================================================================
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    BOOL isSearching = (tableView==self.ppSearchResultTableView);
    
    return [self.ppSectionController numberOfSectionsForSearching:isSearching];
}


//==============================================================================
//
//==============================================================================
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    BOOL isSearching = (tableView==self.ppSearchResultTableView);
    
    NSInteger numberOfRow = [self.ppSectionController numberOfRowsInSection:section forSearching:isSearching];
    
    if (isSearching)
    {
        [self.ppSearchResultTableView setScrollEnabled:(numberOfRow!=0)];
        [self.noResultLabel setHidden:(numberOfRow!=0)];
    }
    else
    {
        [self.ppRecentContactTableView setScrollEnabled:(numberOfRow!=0)];
        [self.noRecentContactsLabel setHidden:(numberOfRow!=0)];
    }
    
    return numberOfRow;
}



//==============================================================================
//
//==============================================================================
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    BOOL isSearching = (tableView==self.ppSearchResultTableView);
    
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:[self cellIdentifierForSearching:isSearching] forIndexPath:indexPath];
    [cell.textLabel setTextColor:WCAppearanceDefine_CellTitleColor];
    
    PPRowModel *rowModel = [self.ppSectionController rowModelAtIndexPath:indexPath forSearching:isSearching];
    cell.textLabel.text = rowModel.text;
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    
    if([self.lastSelectedGuid isEqualToString:rowModel.detailText])
    {
        cell.accessoryType = UITableViewCellAccessoryCheckmark;
    }
    else
    {
        cell.accessoryType = UITableViewCellAccessoryNone;
    }
    return cell;
}


//==============================================================================
//
//==============================================================================
- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    BOOL isSearching = (tableView==self.ppSearchResultTableView);
    PPSectionHeaderView *sectionHeaderView = [self.ppSectionController viewForHeaderInSection:section forSearching:isSearching];
    sectionHeaderView.backgroundColor = WCAppearanceDefine_SectionHeaderBGColor;
    [sectionHeaderView.textLabel setTextColor:WCAppearanceDefine_SectionHeaderTitleColor];
    [sectionHeaderView.textLabel setFont:[UIFont systemFontOfSize:WCAppearanceDefine_SectionHeaderFontSize]];
    return sectionHeaderView;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - UITableViewDelegate


//==============================================================================
//
//==============================================================================
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    
    BOOL isSearching = (tableView==self.ppSearchResultTableView);
    
    PPRowModel *rowModel = [self.ppSectionController rowModelAtIndexPath:indexPath forSearching:isSearching];

    self.lastSelectedGuid = rowModel.detailText;
    
    [tableView reloadData];
}


//==============================================================================
//
//==============================================================================
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return WCAppearanceDefine_SectionHeaderHeight;
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PPButtonDelegate


//==============================================================================
//
//==============================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    switch (ppButton.tag)
    {
        case WCTSalesforceContactSearchViewButtonTag_Done:
        {
            if ([self.lastSelectedGuid length]==0)
            {
                [WCToastController showMessageToastFromSuperView:self.view
                                                     withMessage:WCTServerContactExportFlowControllerString_PlzSelectAnAccount
                                                        position:PPToastPositionCenter];
            }
            else
            {
                if(self.completeHandler)
                {
                    self.completeHandler(self.lastSelectedGuid, nil);
                }
                [self goBackAnimated:YES];
            }
            break;
        }
        case WCTSalesforceContactSearchViewButtonTag_Back:
        default:
        {
            [self goBackAnimated:YES];
            if(self.completeHandler)
            {
                self.completeHandler(nil, nil);
            }
            break;
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UISearchBarDelegate


//==============================================================================
//
//==============================================================================
- (void)searchBarTextDidBeginEditing:(UISearchBar *)searchBar
{
    self.focusOnSearchBar = YES;
}


//==============================================================================
//
//==============================================================================
- (void)searchBarTextDidEndEditing:(UISearchBar *)searchBar
{
    
}


//==============================================================================
//
//==============================================================================
- (void)searchBar:(UISearchBar *)searchBar textDidChange:(NSString *)searchText
{
    
    //    NSLog(@"%s - %@", __PRETTY_FUNCTION__, searchText);
    // 改為不過濾前後空白字元
    //    if ([searchText length]>0)
    //    {
    //        // 去掉空白字元
    //        searchText = [searchText stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceAndNewlineCharacterSet]];
    //    }
    
    self.lastSearchText = searchText;
        
    [self.timerForLaunchedSearch invalidate];
    NSTimeInterval timeInterval = 0.0;
    
    if ([searchText length]==0)
    {
        timeInterval = WCTSalesforceContactSearchViewController_Length0Waiting;
    }
    else if ([searchText length]==1)
    {
        timeInterval = WCTSalesforceContactSearchViewController_Length1Waiting;
    }
    else
    {
        timeInterval = WCTSalesforceContactSearchViewController_OtherLengthWaiting;
    }
    
    self.timerForLaunchedSearch = [NSTimer pp_scheduledTimerWithTimeInterval:timeInterval repeats:NO block:^(NSTimer * _Nonnull timer) {
        
        [self searchText:searchText];
    }];
    
}


//==============================================================================
//
//==============================================================================
- (void)searchBarSearchButtonClicked:(UISearchBar *)searchBar
{
    [searchBar resignFirstResponder];
    
    //////////////////////////////////////////////////
    
//    if([self.delegate respondsToSelector:@selector(searchViewController:didEndSearchWithKeyword:)]==YES)
//    {
//        // 改為不過濾前後空白字元
//        NSString *searchText = self.searchBar.text;//[self.searchBar.text stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceAndNewlineCharacterSet]];
//
//        [self.delegate searchViewController:self
//                    didEndSearchWithKeyword:searchText];
//    }
}

@end
