//
//  WCTQNapQuestionViewController.m
//  WCTServerContactExportFlowController
//
//  Created by sanhue cheng on 2020/9/29.
//

#import "WCTQNapQuestionViewController.h"
#import "WCAppearanceDefine.h"
#import "WCTServerContactExportFlowController+ResourceDefine.h"

#import "PPButton+Factory.h"
#import "WCTServerContactExportHelper.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCTQNapQuestionViewController () <PPButtonDelegate>

@property(nonatomic, retain, readwrite) PPNavigationBarView *ppNavigationBarView;
@property(nonatomic, retain, readwrite) PPButton *ppButtonBack;

@property(nonatomic, retain) IBOutlet NSLayoutConstraint *descriptionHeight;
@property(nonatomic, retain) IBOutlet NSLayoutConstraint *questionHeight;

@property(nonatomic, copy) QuestionCompletion completeHandler;

@end




////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCTQNapQuestionViewController





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (instancetype)init
{
    self = [super init];
    if (self)
    {
        
    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.completeHandler = nil;
    
    [self removeMainUI];
    
    self.loginButton = nil;
    self.titleLabel = nil;
    self.descriptionLabel = nil;
    self.answerTextField = nil;
    self.questionLabel = nil;
    
    self.descriptionHeight = nil;
    self.questionHeight = nil;
    //////////////////////////////////////////////////
    [super dealloc];
}


//==============================================================================
//
//==============================================================================
- (void)viewDidLoad
{
    [super viewDidLoad];
    // Do any additional setup after loading the view from its nib.
    self.titleLabel.text = WCTQQLV_MLS_2FA;
    self.descriptionLabel.text = WCTQQLV_MLS_2FA_QUESTION;

    [self.loginButton setTitleText:WCTQQLV_MLS_Login];
    [self.loginButton setBackgroundImage:[UIImage imageWithColor:[UIColor systemGrayColor]] forState:UIControlStateDisabled];

}








////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - view controller life cycle


//==============================================================================
//
//==============================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////
    // !!    PPViewController在viewWillAppear才設背景色與建立backgroundImageView，所以這邊才能設定顏色
    self.backgroundImageView.backgroundColor = WCTServerContactExportFlowController_QNapLoginBackgroundColor;

    //////////////////////////////////////////////////
    
    [self prepareMainUI];
    
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(textFieldDidChanged:) name:UITextFieldTextDidChangeNotification object:nil];

}


//==============================================================================
//
//==============================================================================
- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    
    //////////////////////////////////////////////////
    
//    CGRect descriptionRect = [self.descriptionLabel.text boundingRectWithSize:CGSizeMake(ceil(self.descriptionLabel.bounds.size.width+5), 200) options:NSStringDrawingUsesLineFragmentOrigin attributes:@{NSFontAttributeName:self.descriptionLabel.font} context:nil];
//    
//    self.descriptionHeight.constant = ceil(descriptionRect.size.height);
    
}


//==============================================================================
//
//==============================================================================
- (void)viewWillDisappear:(BOOL)animated
{
    //////////////////////////////////////////////////
    
    [super viewWillDisappear:animated];
}


//==============================================================================
//
//==============================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    [[NSNotificationCenter defaultCenter] removeObserver:self name:UITextFieldTextDidChangeNotification object:nil];

    [self removeMainUI];
    //////////////////////////////////////////////////
    
    [super viewDidDisappear:animated];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - prepare ui


//==============================================================================
//
//==============================================================================
- (void)prepareMainUI
{
    if(self.ppButtonBack==nil)
    {
        self.ppButtonBack = [PPButton ppButtonWithIconImageName:ImageNamePPButtonIconForSystemBackImitation
                                                            tag:0
                                                       delegate:self
                                          normalBackgroundColor:nil
                                     highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                                imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];
    }
    
    if (self.ppNavigationBarView==nil)
    {
        self.ppNavigationBarView = [[[PPNavigationBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds] autorelease];
    }
    
    [self.ppNavigationBarView setStyle:PPBarViewStyle_CenteredAbsolute];
    
    [self.ppNavigationBarView.titleLabel setText:[WCTServerContactExportHelper loginToTarget:WCTServerExportTarget_Exchange_QContactz]];
    //////////////////////////////////////////////////
    if (self.ppButtonBack)
    {
        PPBarViewItemModel * itemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.ppButtonBack];
        itemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
        
        [self.ppNavigationBarView  setItemModels:@[itemModel] forBlockType:PPBarViewBlockType_Left];
    }
    
    //////////////////////////////////////////////////
    if (self.navigationController!=nil)
    {
        self.navigationItem.leftBarButtonItem = [[[UIBarButtonItem alloc] initWithCustomView:self.ppNavigationBarView] autorelease];
    }
}


//==============================================================================
//
//==============================================================================
- (void)removeMainUI
{
    self.ppNavigationBarView = nil;
    self.ppButtonBack = nil;
    self.navigationItem.leftBarButtonItem = nil;
    
}


//==============================================================================
//
//==============================================================================
- (void)setQuestionText:(NSString *)questionText
{
    self.questionLabel.text = questionText;
    
    if([self.questionLabel.text length]>0)
    {
        CGRect questionRect = [self.questionLabel.text boundingRectWithSize:CGSizeMake(self.questionLabel.bounds.size.width, 200) options:NSStringDrawingUsesLineFragmentOrigin attributes:@{NSFontAttributeName:self.questionLabel.font} context:nil];
        
        self.questionHeight.constant = ceil(questionRect.size.height);
    }
    else
    {
        self.questionHeight.constant = 0;
    }
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PPButtonDelegate


//==============================================================================
//
//==============================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    [self goBackAnimated:YES];
}


//==============================================================================
//
//==============================================================================
- (IBAction)onClickLogin
{
    if(self.completeHandler)
    {
        self.completeHandler(self);
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - UITextFieldDelegate


//==============================================================================
//
//==============================================================================
- (void)textFieldDidChanged:(UITextField*)textfield
{
    if ([self.answerTextField.text length]!=0)
    {
        self.loginButton.enabled = YES;
    }
    else
    {
        self.loginButton.enabled = NO;
    }
}




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Public


//==============================================================================
//
//==============================================================================
+ (void)showFromViewController:(UIViewController *)viewController
                      question:(NSString *)question
               completeHandler:(QuestionCompletion)completeHandler
{
    WCTQNapQuestionViewController *questionCodeViewController = [[WCTQNapQuestionViewController alloc] init];
    
    [questionCodeViewController setQuestionText:question];
    questionCodeViewController.completeHandler = completeHandler;
    
    [viewController.navigationController pushViewController:questionCodeViewController animated:YES];
    [questionCodeViewController release];
}
@end
