//
//  WCTQNapLoginViewController.m
//  WCTServerContactExportFlowController
//
//  Created by sanhue cheng on 2020/9/29.
//

#import "WCTQNapLoginViewController.h"
#import "WCAppearanceDefine.h"
#import "WCTServerContactExportFlowController+ResourceDefine.h"

#import "PPButton+Factory.h"
#import "NSObject+PPBusyView.h"
#import "UIView+Appearance.h"

#import "WCTRestClientController.h"
#import "WCToastController.h"
#import "WCTQNapSecurityCodeViewController.h"
#import "WCTQNapQuestionViewController.h"
#import "PPAlertController.h"
#import "WCTServerContactExportHelper.h"

typedef NS_ENUM(NSInteger, WCTQNapLoginViewControllerButtonTag)
{
    WCTQNapLoginViewControllerButtonTag_Back = 0,
    WCTQNapLoginViewControllerButtonTag_Login,
    WCTQNapLoginViewControllerButtonTag_ShowPassword,
    WCTQNapLoginViewControllerButtonTag_HidePassword,
};

//////////////////////////////////////////////////

static NSString * const ImageNameWCTQNapLoginViewControllerButtonShowPassword  = @"WCTLoginViewControllerButtonShowPassword";
static NSString * const ImageNameWCTQNapLoginViewControllerButtonHidePassword  = @"WCTLoginViewControllerButtonHidePassword";

//////////////////////////////////////////////////
@interface WCTQNapLoginViewController () <PPButtonDelegate, CustomRectTextFieldDataSource>

@property(nonatomic, retain, readwrite) PPNavigationBarView *ppNavigationBarView;
@property(nonatomic, retain, readwrite) PPButton *ppButtonBack;
@property(nonatomic, assign) BOOL isSecutiryEntry;
@end

@implementation WCTQNapLoginViewController





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (instancetype)initWithCoder:(NSCoder *)coder
{
    self = [super initWithCoder:coder];
    if (self)
    {
    }
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.loginComplete = nil;
    self.errorMessageHandler = nil;
    
    self.accountTextField = nil;
    self.passwordTextField = nil;
    
    self.loginButton = nil;
    
    [self removeMainUI];
    //////////////////////////////////////////////////
    [super dealloc];
}


//==============================================================================
//
//==============================================================================
- (void)viewDidLoad
{
    [super viewDidLoad];
    
    //////////////////////////////////////////////////
    self.isSecutiryEntry = YES;

    // Do any additional setup after loading the view from its nib.
    
    [self.loginButton setTitleText:WCTQLV_MLS_Login];
//    [self.loginButton setBackgroundImage:[UIImage imageWithColor:[UIColor systemGrayColor]] forState:UIControlStateDisabled];
    
    //////////////////////////////////////////////////
    self.accountTextField.placeholder = WCTQLV_MLS_User;
    [self.accountTextField setBorderWidth:1.0];
//    [self.accountTextField setCornerRadius:5.0];
    [self.accountTextField setBorderColor:WCTServerContactExportFlowController_TextFieldBolderColor];
    
    self.passwordTextField.textField.placeholder = WCTQLV_MLS_Password;
    self.passwordTextField.textField.dataSource = self;
    [self.passwordTextField setBorderWidth:1.0];
//    [self.passwordTextField setCornerRadius:5.0];
    [self.passwordTextField setBorderColor:WCTServerContactExportFlowController_TextFieldBolderColor];
    
    [self.passwordTextField.ppButtonDetail addControlEvents:UIControlEventTouchUpInside];
    [self.passwordTextField.ppButtonDetail setDelegate:self];
    
    [self refreshPasswordTextFieldButton];
}







////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - view controller life cycle


//==============================================================================
//
//==============================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////
    // !!	PPViewController在viewWillAppear才設背景色與建立backgroundImageView，所以這邊才能設定顏色
    self.backgroundImageView.backgroundColor = WCTServerContactExportFlowController_QNapLoginBackgroundColor;

    //////////////////////////////////////////////////
    [self prepareMainUI];
    
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(textFieldDidChanged:) name:UITextFieldTextDidChangeNotification object:nil];

}


//==============================================================================
//
//==============================================================================
- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    
    //////////////////////////////////////////////////
}


//==============================================================================
//
//==============================================================================
- (void)viewWillDisappear:(BOOL)animated
{
    //////////////////////////////////////////////////
    
    [super viewWillDisappear:animated];
}


//==============================================================================
//
//==============================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    [[NSNotificationCenter defaultCenter] removeObserver:self name:UITextFieldTextDidChangeNotification object:nil];
    
    [self removeMainUI];
    //////////////////////////////////////////////////
    
    [super viewDidDisappear:animated];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - prepare ui


//==============================================================================
//
//==============================================================================
- (void)prepareMainUI
{
    if(self.ppButtonBack==nil)
    {
        self.ppButtonBack = [PPButton ppButtonWithIconImageName:ImageNamePPButtonIconForSystemBackImitation
                                                            tag:WCTQNapLoginViewControllerButtonTag_Back
                                                       delegate:self
                                          normalBackgroundColor:nil
                                     highlightedBackgroundColor:WCAppearanceDefine_ButtonBackgroundColor
                                                imageEdgeInsets:WCAppearanceDefine_ButtonImageEdgeInset];
    }
    
    if (self.ppNavigationBarView==nil)
    {
        self.ppNavigationBarView = [[[PPNavigationBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds] autorelease];
    }
    
    [self.ppNavigationBarView setStyle:PPBarViewStyle_CenteredAbsolute];
    [self.ppNavigationBarView.titleLabel setText:[WCTServerContactExportHelper loginToTarget:WCTServerExportTarget_Exchange_QContactz]];

    //////////////////////////////////////////////////
    if (self.ppButtonBack)
    {
        PPBarViewItemModel * itemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.ppButtonBack];
        itemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
        
        [self.ppNavigationBarView  setItemModels:@[itemModel] forBlockType:PPBarViewBlockType_Left];
    }
    
    //////////////////////////////////////////////////
    if (self.navigationController!=nil)
    {
        self.navigationItem.leftBarButtonItem = [[[UIBarButtonItem alloc] initWithCustomView:self.ppNavigationBarView] autorelease];
    }
    
}


//==============================================================================
//
//==============================================================================
- (void)removeMainUI
{
    self.ppNavigationBarView = nil;
    self.ppButtonBack = nil;
    self.navigationItem.leftBarButtonItem = nil;
}


//==============================================================================
//
//==============================================================================
- (void)refreshPasswordTextFieldButton
{
    self.passwordTextField.textField.secureTextEntry = self.isSecutiryEntry;

    if(self.isSecutiryEntry==YES)
    {
        self.passwordTextField.ppButtonDetail.tag = WCTQNapLoginViewControllerButtonTag_HidePassword;
        [self.passwordTextField.ppButtonDetail setImageWithName:ImageNameWCTQNapLoginViewControllerButtonShowPassword];
    }
    else
    {
        self.passwordTextField.ppButtonDetail.tag = WCTQNapLoginViewControllerButtonTag_ShowPassword;
        [self.passwordTextField.ppButtonDetail setImageWithName:ImageNameWCTQNapLoginViewControllerButtonHidePassword];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Private


//==============================================================================
//
//==============================================================================
- (BOOL)canLogin
{
    if([self.accountTextField.text length]==0)
    {
        return NO;
    }
    
    if([self.passwordTextField.textField.text length]==0)
    {
        return NO;
    }

    return YES;
}


//==============================================================================
////
////==============================================================================
//- (void)showSecurityCodeFromViewController:(UIViewController*)viewController completeion:(void(^)(void))completion
//{
//    WCTQNapSecurityCodeViewController *securityCodeViewController = [[WCTQNapSecurityCodeViewController alloc] init];
//
//    [self.navigationController pushViewController:securityCodeViewController animated:YES];
//    [securityCodeViewController release];
//}


//==============================================================================
//
//==============================================================================
- (void)showQuestionFromViewController:(UIViewController*)viewController authToken:(WCTRCQContactzAuthTokenVo *)authToken question:(NSString *)question
{
    if(authToken==nil||
       question==nil)
    {
        // 不應該是nil
        return ;
    }
    
    //////////////////////////////////////////////////
    __block typeof(self) blockSelf = self;
    
    [WCTQNapQuestionViewController showFromViewController:viewController
                                                 question:question
                                          completeHandler:^(WCTQNapQuestionViewController *questionViewController) {
        
        authToken.securityValue =  questionViewController.answerTextField.text;
        authToken.securityType = WCTRCQContactzAuthTokenVo_SecurityType_Question;
        
        dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
            
            NSError *error = nil;
            WCTRCQContactzAuthInfoResponseResult *result = [[WCTRestClientController shareRestClientController] qContactzLoginWithTokenVo:authToken error:&error];
            
            //////////////////////////////////////////////////
            
            [result retain];
            [error retain];
            dispatch_async(dispatch_get_main_queue(), ^{
                
                if (error)
                {
                    NSInteger statusCode = [WCTRestClientController statusCodeFromAFRKNetworkingError:error];
                    NSString *errorMessage = [WCTServerContactExportFlowControllerString_MLS_QNAP_2FA_AnswerWrong stringByAppendingFormat:@" (%@)", @(statusCode)];

                    if([errorMessage length]>0)
                    {
                        [WCToastController showMessageToastFromSuperView:questionViewController.view
                                                             withMessage:errorMessage
                                                                position:PPToastPositionCenter];
                    }
                }
                else
                {
                    if(result.data.authPassed)
                    {
                        [self dismissAnimated:YES completion:nil];
                        if(blockSelf.loginComplete)
                        {
                            blockSelf.loginComplete(authToken.account, error);
                        }
                    }
                }
                
                [result release];
                [error release];
            });
        });
        
        
        
    }];

}


//==============================================================================
//
//==============================================================================
- (void)showSendEmailWithAuthInfo:(WCTRCAuthInfo *)authInfo fromViewController:(UIViewController *)viewController
{
    __block typeof(self) blockSelf = self;

    PPAlertController *alertController = [PPAlertController alertControllerWithTitle:@"" message:WCTServerContactExportFlowControllerString_MLS_QNAP_2FA_ConfirmSendEmail preferredStyle:UIAlertControllerStyleAlert];

    [alertController addAction:[UIAlertAction actionWithTitle:WCTServerContactExportFlowControllerString_OK
                                                        style:UIAlertActionStyleDefault
                                                      handler:^(UIAlertAction * _Nonnull action) {
        //
        [self setBusy:@(YES)];
        
        dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
            
            NSError *error = nil;
            WCTRCQContactzEmailResponseResult *result = [[WCTRestClientController shareRestClientController] setQContactzEmailSecurityCodeWithBasicInfo:authInfo error:&error];
            [result retain];
            [error retain];
            //////////////////////////////////////////////////
            dispatch_async(dispatch_get_main_queue(), ^{
                
                NSString * sentMailMessage = WCTServerContactExportFlowControllerString_MLS_QNAP_2FA_EmailSent;
                if(error)
                {

                }
                [PPAlertController showWithAlertControllerStyle:UIAlertControllerStyleAlert
                                                          title:@""
                                                        message:sentMailMessage
                                               alertActionStyle:UIAlertActionStyleDefault
                                         showFromViewController:viewController
                                                       animated:YES];
                [blockSelf setBusy:@(NO)];

                [result release];
                [error release];
            });
        });

    }]];

    [alertController addAction:[UIAlertAction actionWithTitle:WCTServerContactExportFlowControllerString_Cancel
                                                        style:UIAlertActionStyleCancel
                                                      handler:nil]];
    [viewController presentViewController:alertController animated:YES completion:nil];
}



//==============================================================================
//
//==============================================================================
- (void)loginProcessWithCompleteHandler:(QNapLoginComplete)completeHandler
{
    if([self canLogin])
    {
        [self setBusy:@(YES)];
        
        __block typeof(self) blockSelf = self;
        NSString *account = [self.accountTextField.text retain];
        NSString *password = [self.passwordTextField.textField.text retain];
        
        // 這個結構2次驗証是共用的，所以在外面先建
        WCTRCQContactzAuthTokenVo *authToken = [[WCTRCQContactzAuthTokenVo alloc] init];
        authToken.securityType = WCTRCQContactzAuthTokenVo_SecurityType_User;
        authToken.account = account;
        authToken.password = password;
        
        dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
            
            NSError *error = nil;

            WCTRCQContactzAuthInfoResponseResult *result = [[WCTRestClientController shareRestClientController] qContactzLoginWithTokenVo:authToken error:&error];
            
            //////////////////////////////////////////////////
            [error retain];
            [result retain];
            dispatch_async(dispatch_get_main_queue(), ^{
                
                if(error)
                {
                    NSString *errorMessage = [blockSelf messageWithError:error];

                    if([errorMessage length]>0)
                    {
                        [WCToastController showMessageToastFromSuperView:self.view
                                                             withMessage:errorMessage
                                                                position:PPToastPositionCenter];
                    }

                    [result release];
                }
                else
                {
                    WCTRCQContactzSecurityInfo *securityInfo = result.data;
                    if (securityInfo.authPassed)
                    {
                        // 沒有二次驗証, 直接登入成功
                        [self dismissAnimated:YES completion:nil];
                        if(blockSelf.loginComplete)
                        {
                            blockSelf.loginComplete(account, error);
                        }
                    }
                    else
                    {
                        
                        // 需要二次驗証
                        BOOL showAlternativeButton = [securityInfo.anotherVerification length]>0;
                        BOOL isAlternativeUsingEmail = ([securityInfo.anotherVerification isEqualToString:WCTRCQContactzAuthTokenVo_SecurityType_Email]);
                        NSString *question = [securityInfo.securityQuestionText retain];
                        [WCTQNapSecurityCodeViewController showFromViewController:self
                                                            showAlternativeButton:showAlternativeButton
                                                    clickAlternativeButtonHandler:^(WCTQNapSecurityCodeViewController *securityCodeViewController) {
                            
                            if (isAlternativeUsingEmail)
                            {
                                // 送驗証信
                                WCTRCAuthInfo *authInfo = [[WCTRCAuthInfo alloc] init];
                                authInfo.account = authToken.account;
                                authInfo.password = authToken.password;
                                
                                [self showSendEmailWithAuthInfo:authInfo fromViewController:securityCodeViewController];
                            }
                            else
                            {
                                // 回答問題
                                [self showQuestionFromViewController:securityCodeViewController authToken:authToken question:question];
                            }
                            
                            [question release];
                            
                        } completeHandler:^(WCTQNapSecurityCodeViewController *securityCodeViewController) {
                            
                            authToken.securityValue = securityCodeViewController.securityCodeTextField.text;
                            authToken.securityType = WCTRCQContactzAuthTokenVo_SecurityType_Phone;

                            dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
                                
                                NSError *error = nil;
                                WCTRCQContactzAuthInfoResponseResult *result = [[WCTRestClientController shareRestClientController] qContactzLoginWithTokenVo:authToken error:&error];
                                
                                //////////////////////////////////////////////////
                                [result retain];
                                [error retain];
                                dispatch_async(dispatch_get_main_queue(), ^{
                                    
                                    if (error)
                                    {
                                        NSInteger statusCode = [WCTRestClientController statusCodeFromAFRKNetworkingError:error];
                                        NSString *errorMessage = [WCTServerContactExportFlowControllerString_MLS_QNAP_2FA_CodeWrong stringByAppendingFormat:@" (%@)", @(statusCode)];
                                        if([errorMessage length]>0)
                                        {
                                            [WCToastController showMessageToastFromSuperView:securityCodeViewController.view
                                                                                 withMessage:errorMessage
                                                                                    position:PPToastPositionCenter];
                                        }
                                    }
                                    else
                                    {
                                        if(result.data.authPassed)
                                        {
                                            [self dismissAnimated:YES completion:nil];
                                            if(blockSelf.loginComplete)
                                            {
                                                blockSelf.loginComplete(authToken.account, error);
                                            }
                                        }
                                    }
                                    
                                    [result release];
                                    [error release];
                                });
                            });
                        }];
                        
                    }
                    
                    [result release];
                }
                [blockSelf setBusy:@(NO)];
                
                [account release];
                [password release];
                [error release];
            }); // end of dispatch_async(dispatch_get_main_queue()
        }); //end of dispatch_async(dispatch_get_global_queue()

    }
    else
    {
        [WCToastController showMessageToastFromSuperView:self.view
                                             withMessage:WCTServerContactExportFlowControllerString_MLS_ErrorExchangeLoginFailed
                                                position:PPToastPositionCenter];
    }
}


//==============================================================================
//
//==============================================================================
- (NSString *)messageWithError:(NSError *)error
{
    NSString *errorMessage = nil;

    if (self.errorMessageHandler)
    {
        errorMessage = self.errorMessageHandler(error);
        
        if([errorMessage length]==0)
        {
            NSInteger statusCode = [WCTRestClientController statusCodeFromAFRKNetworkingError:error];
            errorMessage = [WCTServerContactExportFlowControllerString_MLS_ErrorExchangeLoginFailed stringByAppendingFormat:@" (%@)", @(statusCode)];
        }
    }
    else
    {
        NSInteger statusCode = [WCTRestClientController statusCodeFromAFRKNetworkingError:error];
        errorMessage = [WCTServerContactExportFlowControllerString_MLS_ErrorExchangeLoginFailed stringByAppendingFormat:@" (%@)", @(statusCode)];
        switch (statusCode) {
            case WCTServer_QcontactzLogin_ErrorCode_NotInstallQcontactzService:
            {
                errorMessage = WCTServerContactExportFlowControllerString_MLS_ErrorQcontactzNotFound;
                break;
            }
            case WCTServer_QcontactzLogin_ErrorCode_NotAllowedIP:
            {
                errorMessage = WCTServerContactExportFlowControllerString_NotAllowedIP;
                break;
            }
            case WCTServer_QcontactzLogin_ErrorCode_PermissionDenied:
            {
                errorMessage = WCTServerContactExportFlowControllerString_PermissionDenied;
                break;
            }
            default:
                break;
        }
    }
    
    return errorMessage;
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PPButtonDelegate


//==============================================================================
//
//==============================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    switch (ppButton.tag)
    {
        case WCTQNapLoginViewControllerButtonTag_HidePassword:
        case WCTQNapLoginViewControllerButtonTag_ShowPassword:
        {
            self.isSecutiryEntry = !self.isSecutiryEntry;
            [self refreshPasswordTextFieldButton];
            break;
        }
        case WCTQNapLoginViewControllerButtonTag_Back:
        default:
        {
            [self goBackAnimated:YES];

//            if(self.loginComplete)
//            {
//                self.loginComplete(nil, nil);
//            }
            break;
        }
    }
}


//==============================================================================
//
//==============================================================================
- (IBAction)onClickLogin
{
    [self loginProcessWithCompleteHandler:^(NSString *account, NSError *error) {
        
        
        
    }];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - UITextFieldDelegate


//==============================================================================
//
//==============================================================================
- (void)textFieldDidChanged:(UITextField*)textfield
{
    if ([self.accountTextField.text length]!=0 &&
        [self.passwordTextField.textField.text length]!=0)
    {
        self.loginButton.enabled = YES;
    }
    else
    {
        self.loginButton.enabled = NO;
    }
}



////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - CustomRectTextFieldDataSource

//================================================================================
//
//================================================================================
- (CGRect)placeholderRectForBounds:(CGRect)bounds withCustomRectTextField:(CustomRectTextField *)customRectTextField
{
    return CGRectInset(CGRectMake(bounds.origin.x, bounds.origin.y, bounds.size.width-10, bounds.size.height), 5, 0);
}


//================================================================================
//
//================================================================================
- (CGRect)textRectForBounds:(CGRect)bounds withCustomRectTextField:(CustomRectTextField *)customRectTextField;
{
    return CGRectInset(CGRectMake(bounds.origin.x, bounds.origin.y, bounds.size.width-10, bounds.size.height), 5, 0);
}


//================================================================================
//
//================================================================================
- (CGRect)editingRectForBounds:(CGRect)bounds withCustomRectTextField:(CustomRectTextField *)customRectTextField;
{
    return  CGRectInset(CGRectMake(bounds.origin.x, bounds.origin.y, bounds.size.width-20, bounds.size.height), 5, 0);
}



@end
