//
//  WCTExportSettingsViewController.h
//  Pods
//
//  Created by sanhue on 2016/9/23.
//
//

#import "PPSelectItemViewController.h"
#import "WCTServerContactExportHelper.h"


@class WCTExportSettingsViewController;

typedef NS_ENUM(NSInteger, WCTExportSettingsViewControllerErrorCode)
{
    WCTExportSettingsViewControllerErrorCode_UserBack = 100,
    WCTExportSettingsViewControllerErrorCode_DisabledByManager,
    WCTExportSettingsViewControllerErrorCode_MustLoginBeforeUse,
};

/**
 * 匯出選項
 * CRM, MS, Office365 : WCTExportMode_ContactSyncAuto,WCTExportMode_Manual
 * Qcontactz: WCTExportMode_Manual, WCTExportMode_Auto
 *
 */
typedef NS_ENUM(NSInteger, WCTExportMode)
{
    WCTExportMode_ContactSyncAuto = 1<<0,          // AUTO_SYNC_CONTACT
    WCTExportMode_Manual = 1<<1,                // MANUAL_EXPORT
    WCTExportMode_Auto = 1<<2,                  // AUTO_EXPORT
};

typedef NS_ENUM (NSInteger, WCTCompnayAssignmentMode)
{
    WCTCompnayAssignmentMode_Manual=0,
    WCTCompnayAssignmentMode_Auto,
    WCTCompnayAssignmentMode_None,
};

typedef void(^ExportSelectItemCompletion)(WCTExportSettingsViewController *viewController, NSInteger itemIndex, NSString *itemString, NSError *error);


////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCTExportSettingsViewController : PPSelectItemViewController

@property (nonatomic, assign) WCTServerExportTarget target;

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - public methods

- (void)showFromViewController:(UIViewController *)viewController completeHandler:(ExportSelectItemCompletion)completeHandler;


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - class methods
+ (NSString *)serverDefinedStringFromWCTExportMode:(WCTExportMode)exportMode;


@end
