//
//  WCTLoginTextFieldButtonTableViewCell.m
//  
//
//  Created by Howard on 2016/8/11.
//
//

#import "WCTExchangeTextFieldButtonTableViewCell.h"


@implementation WCTExchangeTextFieldButtonTableViewCell

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if((self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]))
    {
        _textFieldButtonView = [[PPTextFieldButtonView alloc] init];
        
        if(_textFieldButtonView!=nil)
        {
//            _textFieldButtonView.ppButtonDetail.tag = WCTLoginViewControllerButtonTag_DropServerList;
//            [_textFieldButtonView.ppButtonDetail setImageWithName:ImageNameWCTLoginViewControllerButtonDrop];
            
            self.textFieldButtonView.textField.dataSource = self;
            [self.contentView addSubview:_textFieldButtonView];
        }
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_textFieldButtonView release];
    _textFieldButtonView = nil;
    
    //////////////////////////////////////////////////

    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Layout of subView

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////

    _textFieldButtonView.frame = CGRectMake(self.textFieldButtoViewContentInset.left,
                                            self.textFieldButtoViewContentInset.top,
                                            self.contentView.bounds.size.width-self.textFieldButtoViewContentInset.left-self.textFieldButtoViewContentInset.right,
                                            self.contentView.bounds.size.height-self.textFieldButtoViewContentInset.top-self.textFieldButtoViewContentInset.bottom);
}



////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - CustomRectTextFieldDataSource

//================================================================================
//
//================================================================================
- (CGRect)placeholderRectForBounds:(CGRect)bounds withCustomRectTextField:(CustomRectTextField *)customRectTextField
{
    return CGRectInset(CGRectMake(bounds.origin.x, bounds.origin.y, bounds.size.width-10, bounds.size.height), 5, 0);
}


//================================================================================
//
//================================================================================
- (CGRect)textRectForBounds:(CGRect)bounds withCustomRectTextField:(CustomRectTextField *)customRectTextField;
{
    return CGRectInset(CGRectMake(bounds.origin.x, bounds.origin.y, bounds.size.width-10, bounds.size.height), 5, 0);
}


//================================================================================
//
//================================================================================
- (CGRect)editingRectForBounds:(CGRect)bounds withCustomRectTextField:(CustomRectTextField *)customRectTextField;
{
    return  CGRectInset(CGRectMake(bounds.origin.x, bounds.origin.y, bounds.size.width-20, bounds.size.height), 5, 0);
}

@end
