//
//  WCTExchangeLoginViewController.h
//  WorldCardTeam
//
//  Created by sanhue on 2019/11/29.
//  Copyright © 2019 penpower. All rights reserved.
//

#import "PPViewController.h"
#import "PPNavigationBarView.h"
#import "PPButton+Factory.h"


typedef NS_ENUM(NSInteger, WCTServerLoginErrorCode)
{
    WCTServerLoginErrorCode_UpdateTokenFailed = 1000,
    WCTServerLoginErrorCode_DisabledByManager,
    WCTServerLoginErrorCode_MSExchangeServerLoginFailed,
};

typedef void(^ExchangeLoginComplete)(NSString *account, NSError *error);

@interface WCTExchangeLoginViewController : PPViewController

@property(nonatomic, copy) ExchangeLoginComplete loginComplete;

@property(nonatomic, retain, readonly) PPNavigationBarView *ppNavigationBarView;
@property(nonatomic, retain, readonly) PPButton *ppButtonBack;

@end
