//
//  WCTServerVersionController.m
//  Pods
//
//  Created by sanhue on 2017/5/23.
//
//

#import "WCTRestClientController+Version.h"

// Controller
#import "PPSettingsController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
//@interface WCTRestClientController (Version)
//
/////// 登入的server版號
////@property (atomic, retain) PPVersionInfo *serverVersionInfo;
////@property (atomic, retain) PPVersionInfo *clientSupportedVersionInfo;
//
//@end
////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCTRestClientController (Version)


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method


//==============================================================================
//
//==============================================================================
+ (void)setClientSupportedMinServerVersion:(NSString*)minServerVersion maxServerVersion:(NSString*)maxServerVersion
{
    if ([minServerVersion length]>0)
    {
        [PPSettingsController setStringValue:minServerVersion withKey:WCTRestClientController_SettingsKey_MinSupportedServerVersion];
    }

    if ([maxServerVersion length]>0)
    {
        [PPSettingsController setStringValue:maxServerVersion withKey:WCTRestClientController_SettingsKey_MaxSupportedServerVersion];
    }
}



//================================================================================
//
//================================================================================
+ (void)setCurLastMininumSupportedVersion:(NSString *)supportedVersion
{
    if([supportedVersion length]>0)
    {
        [PPSettingsController setStringValue:supportedVersion withKey:WCTRestClientController_SettingsKey_SupportedMinimumVersion];
    }
    else
    {
        [PPSettingsController removeValueWithKey:WCTRestClientController_SettingsKey_SupportedMinimumVersion];
    }
}


//================================================================================
//
//================================================================================
+ (NSString *)curLastMinumSupportedVersion
{
    return [PPSettingsController stringValueWithKey:WCTRestClientController_SettingsKey_SupportedMinimumVersion];
}


//==============================================================================
//
//==============================================================================
+ (void)setLastLoginServerVersion:(NSString *)serverVersion
{
    if([serverVersion length]>0)
    {
        [PPSettingsController setStringValue:serverVersion withKey:WCTRestClientController_SettingsKey_LastServerVersion];
    }
    else
    {
        [PPSettingsController removeValueWithKey:WCTRestClientController_SettingsKey_LastServerVersion];
    }
}


//================================================================================
//
//================================================================================
+ (NSString *)lastLoginServerVersion
{
    return [PPSettingsController stringValueWithKey:WCTRestClientController_SettingsKey_LastServerVersion];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - private methods

//==============================================================================
//
//==============================================================================
- (WCTServerCanLoginResult)canLoginWithError:(NSError **)error;
{
    WCTServerCanLoginResult result = WCTServerCanLoginResult_YES;
    NSError *returnedError = nil;
    
    WCTRCVersionInfoResponseResult *versionInfoResult = [[WCTRestClientController shareRestClientController] serverVersionWithError:&returnedError];
    
    if (returnedError==nil)
    {
        NSString *versionString = [NSString stringWithFormat:@"%d.%d", (int)versionInfoResult.data.major, (int)versionInfoResult.data.minor];
        self.serverVersionInfo = [PPVersionInfo versionInfoWithVersionString:versionString];
    }
    else
    {
        if (error!=nil)
        {
            *error = returnedError;
        }
    }
    
    // server版號大於或相等向下相容版號，才可以登入
    if (self.serverVersionInfo.majorVersion<self.maxBackwardCompatibleVersionInfo.majorVersion)
    {
        result = WCTServerCanLoginResult_NO_UnsupportedServerVersion;
        return result;
    }
    
    // client大版號比較新或相等，就可以登入，
    if (self.serverVersionInfo.majorVersion<=self.clientSupportedVersionInfo.majorVersion)
    {
        result = WCTServerCanLoginResult_YES;
    }
    else
    {
        result = WCTServerCanLoginResult_NO_ServerIsNewer;
    }
    return result;
}


//==============================================================================
//
//==============================================================================
- (WCTServerCanLoginResult)canLogin
{
    return [self canLoginWithError:nil];
}

//==============================================================================
//
//==============================================================================
- (NSString *)minSupportedVersion
{
    if ([self.serverVersionInfo compare:self.clientSupportedVersionInfo]==PPComparisonResult_LessThan)
    {
        return [self.serverVersionInfo versionString];
    }
    else
    {
        return [self.clientSupportedVersionInfo versionString];
    }
}

@end
