//
//  WCTRestClientController+Retry.m
//  Pods
//
//  Created by sanhue on 2017/5/17.
//
//

#import "WCTRestClientController+Retry.h"

@implementation WCTRestClientController (Retry)

+ (void)executeProcessHandler:(NSError *(^)(NSInteger retryCount))processHandler
              withShouldRetry:(BOOL(^)(NSInteger retryCount, NSError *error))shouldRetry
{
    NSError * error = nil;
    NSInteger retryCount = 0;
    BOOL isContinue = NO;
    
    do {
        
        retryCount ++;

        if (processHandler!=NULL)
        {
            error = processHandler (retryCount);
        }
        
        isContinue = shouldRetry(retryCount, error);
        
        if(isContinue == YES)
        {
            @autoreleasepool
            {
                [[NSRunLoop currentRunLoop] runUntilDate:[NSDate dateWithTimeIntervalSinceNow:0.5]];
            }
        }
    }
    while (isContinue);
}
@end
